/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.cloudprofiler.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.devtools.cloudprofiler.v2.CreateOfflineProfileRequest;
import com.google.devtools.cloudprofiler.v2.CreateProfileRequest;
import com.google.devtools.cloudprofiler.v2.Profile;
import com.google.devtools.cloudprofiler.v2.UpdateProfileRequest;
import com.google.devtools.cloudprofiler.v2.stub.GrpcProfilerServiceCallableFactory;
import com.google.devtools.cloudprofiler.v2.stub.ProfilerServiceStub;
import com.google.devtools.cloudprofiler.v2.stub.ProfilerServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcProfilerServiceStub
extends ProfilerServiceStub {
    private static final MethodDescriptor<CreateProfileRequest, Profile> createProfileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudprofiler.v2.ProfilerService/CreateProfile").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateProfileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Profile.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateOfflineProfileRequest, Profile> createOfflineProfileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudprofiler.v2.ProfilerService/CreateOfflineProfile").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateOfflineProfileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Profile.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateProfileRequest, Profile> updateProfileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.devtools.cloudprofiler.v2.ProfilerService/UpdateProfile").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateProfileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Profile.getDefaultInstance())).build();
    private final UnaryCallable<CreateProfileRequest, Profile> createProfileCallable;
    private final UnaryCallable<CreateOfflineProfileRequest, Profile> createOfflineProfileCallable;
    private final UnaryCallable<UpdateProfileRequest, Profile> updateProfileCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcProfilerServiceStub create(ProfilerServiceStubSettings settings) throws IOException {
        return new GrpcProfilerServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcProfilerServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcProfilerServiceStub(ProfilerServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcProfilerServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcProfilerServiceStub(ProfilerServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcProfilerServiceStub(ProfilerServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcProfilerServiceCallableFactory());
    }

    protected GrpcProfilerServiceStub(ProfilerServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createProfileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createProfileMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createOfflineProfileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createOfflineProfileMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateProfileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateProfileMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("profile.name", String.valueOf(request.getProfile().getName()));
            return builder.build();
        }).build();
        this.createProfileCallable = callableFactory.createUnaryCallable(createProfileTransportSettings, settings.createProfileSettings(), clientContext);
        this.createOfflineProfileCallable = callableFactory.createUnaryCallable(createOfflineProfileTransportSettings, settings.createOfflineProfileSettings(), clientContext);
        this.updateProfileCallable = callableFactory.createUnaryCallable(updateProfileTransportSettings, settings.updateProfileSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateProfileRequest, Profile> createProfileCallable() {
        return this.createProfileCallable;
    }

    @Override
    public UnaryCallable<CreateOfflineProfileRequest, Profile> createOfflineProfileCallable() {
        return this.createOfflineProfileCallable;
    }

    @Override
    public UnaryCallable<UpdateProfileRequest, Profile> updateProfileCallable() {
        return this.updateProfileCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

