/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.cloudprofiler.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.devtools.cloudprofiler.v2.ExportServiceSettings;
import com.google.devtools.cloudprofiler.v2.ListProfilesRequest;
import com.google.devtools.cloudprofiler.v2.ListProfilesResponse;
import com.google.devtools.cloudprofiler.v2.Profile;
import com.google.devtools.cloudprofiler.v2.stub.ExportServiceStub;
import com.google.devtools.cloudprofiler.v2.stub.ExportServiceStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ExportServiceClient
implements BackgroundResource {
    private final ExportServiceSettings settings;
    private final ExportServiceStub stub;

    public static final ExportServiceClient create() throws IOException {
        return ExportServiceClient.create(ExportServiceSettings.newBuilder().build());
    }

    public static final ExportServiceClient create(ExportServiceSettings settings) throws IOException {
        return new ExportServiceClient(settings);
    }

    public static final ExportServiceClient create(ExportServiceStub stub) {
        return new ExportServiceClient(stub);
    }

    protected ExportServiceClient(ExportServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ExportServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ExportServiceClient(ExportServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ExportServiceSettings getSettings() {
        return this.settings;
    }

    public ExportServiceStub getStub() {
        return this.stub;
    }

    public final ListProfilesPagedResponse listProfiles(ListProfilesRequest request) {
        return (ListProfilesPagedResponse)((Object)this.listProfilesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProfilesRequest, ListProfilesPagedResponse> listProfilesPagedCallable() {
        return this.stub.listProfilesPagedCallable();
    }

    public final UnaryCallable<ListProfilesRequest, ListProfilesResponse> listProfilesCallable() {
        return this.stub.listProfilesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListProfilesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProfilesRequest, ListProfilesResponse, Profile, ListProfilesPage, ListProfilesFixedSizeCollection> {
        private ListProfilesFixedSizeCollection(List<ListProfilesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProfilesFixedSizeCollection createEmptyCollection() {
            return new ListProfilesFixedSizeCollection(null, 0);
        }

        protected ListProfilesFixedSizeCollection createCollection(List<ListProfilesPage> pages, int collectionSize) {
            return new ListProfilesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProfilesPage
    extends AbstractPage<ListProfilesRequest, ListProfilesResponse, Profile, ListProfilesPage> {
        private ListProfilesPage(PageContext<ListProfilesRequest, ListProfilesResponse, Profile> context, ListProfilesResponse response) {
            super(context, (Object)response);
        }

        private static ListProfilesPage createEmptyPage() {
            return new ListProfilesPage(null, null);
        }

        protected ListProfilesPage createPage(PageContext<ListProfilesRequest, ListProfilesResponse, Profile> context, ListProfilesResponse response) {
            return new ListProfilesPage(context, response);
        }

        public ApiFuture<ListProfilesPage> createPageAsync(PageContext<ListProfilesRequest, ListProfilesResponse, Profile> context, ApiFuture<ListProfilesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProfilesPagedResponse
    extends AbstractPagedListResponse<ListProfilesRequest, ListProfilesResponse, Profile, ListProfilesPage, ListProfilesFixedSizeCollection> {
        public static ApiFuture<ListProfilesPagedResponse> createAsync(PageContext<ListProfilesRequest, ListProfilesResponse, Profile> context, ApiFuture<ListProfilesResponse> futureResponse) {
            ApiFuture<ListProfilesPage> futurePage = ListProfilesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListProfilesPagedResponse((ListProfilesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListProfilesPagedResponse(ListProfilesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProfilesFixedSizeCollection.createEmptyCollection());
        }
    }
}

