/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.cloudprofiler.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.devtools.cloudprofiler.v2.ExportServiceClient;
import com.google.devtools.cloudprofiler.v2.ListProfilesRequest;
import com.google.devtools.cloudprofiler.v2.ListProfilesResponse;
import com.google.devtools.cloudprofiler.v2.Profile;
import com.google.devtools.cloudprofiler.v2.stub.ExportServiceStub;
import com.google.devtools.cloudprofiler.v2.stub.GrpcExportServiceStub;
import com.google.devtools.cloudprofiler.v2.stub.HttpJsonExportServiceStub;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ExportServiceStubSettings
extends StubSettings<ExportServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/monitoring").add((Object)"https://www.googleapis.com/auth/monitoring.write").build();
    private final PagedCallSettings<ListProfilesRequest, ListProfilesResponse, ExportServiceClient.ListProfilesPagedResponse> listProfilesSettings;
    private static final PagedListDescriptor<ListProfilesRequest, ListProfilesResponse, Profile> LIST_PROFILES_PAGE_STR_DESC = new PagedListDescriptor<ListProfilesRequest, ListProfilesResponse, Profile>(){

        public String emptyToken() {
            return "";
        }

        public ListProfilesRequest injectToken(ListProfilesRequest payload, String token) {
            return ListProfilesRequest.newBuilder((ListProfilesRequest)payload).setPageToken(token).build();
        }

        public ListProfilesRequest injectPageSize(ListProfilesRequest payload, int pageSize) {
            return ListProfilesRequest.newBuilder((ListProfilesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListProfilesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListProfilesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Profile> extractResources(ListProfilesResponse payload) {
            return payload.getProfilesList() == null ? ImmutableList.of() : payload.getProfilesList();
        }
    };
    private static final PagedListResponseFactory<ListProfilesRequest, ListProfilesResponse, ExportServiceClient.ListProfilesPagedResponse> LIST_PROFILES_PAGE_STR_FACT = new PagedListResponseFactory<ListProfilesRequest, ListProfilesResponse, ExportServiceClient.ListProfilesPagedResponse>(){

        public ApiFuture<ExportServiceClient.ListProfilesPagedResponse> getFuturePagedResponse(UnaryCallable<ListProfilesRequest, ListProfilesResponse> callable, ListProfilesRequest request, ApiCallContext context, ApiFuture<ListProfilesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PROFILES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ExportServiceClient.ListProfilesPagedResponse.createAsync((PageContext<ListProfilesRequest, ListProfilesResponse, Profile>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListProfilesRequest, ListProfilesResponse, ExportServiceClient.ListProfilesPagedResponse> listProfilesSettings() {
        return this.listProfilesSettings;
    }

    public ExportServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcExportServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonExportServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "cloudprofiler";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudprofiler.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudprofiler.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ExportServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ExportServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ExportServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ExportServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ExportServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listProfilesSettings = settingsBuilder.listProfilesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ExportServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListProfilesRequest, ListProfilesResponse, ExportServiceClient.ListProfilesPagedResponse> listProfilesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listProfilesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PROFILES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listProfilesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ExportServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listProfilesSettings = settings.listProfilesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listProfilesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ExportServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ExportServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ExportServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ExportServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ExportServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ExportServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ExportServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ExportServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ExportServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ExportServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listProfilesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListProfilesRequest, ListProfilesResponse, ExportServiceClient.ListProfilesPagedResponse> listProfilesSettings() {
            return this.listProfilesSettings;
        }

        public ExportServiceStubSettings build() throws IOException {
            return new ExportServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)130000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)130000L)).setTotalTimeout(Duration.ofMillis((long)130000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

