/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.cloudprofiler.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.devtools.cloudprofiler.v2.CreateOfflineProfileRequest;
import com.google.devtools.cloudprofiler.v2.CreateProfileRequest;
import com.google.devtools.cloudprofiler.v2.Profile;
import com.google.devtools.cloudprofiler.v2.UpdateProfileRequest;
import com.google.devtools.cloudprofiler.v2.stub.HttpJsonProfilerServiceCallableFactory;
import com.google.devtools.cloudprofiler.v2.stub.ProfilerServiceStub;
import com.google.devtools.cloudprofiler.v2.stub.ProfilerServiceStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonProfilerServiceStub
extends ProfilerServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateProfileRequest, Profile> createProfileMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudprofiler.v2.ProfilerService/CreateProfile").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*}/profiles", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Profile.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateOfflineProfileRequest, Profile> createOfflineProfileMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudprofiler.v2.ProfilerService/CreateOfflineProfile").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*}/profiles:createOffline", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("profile", (Message)request.getProfile(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Profile.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateProfileRequest, Profile> updateProfileMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.devtools.cloudprofiler.v2.ProfilerService/UpdateProfile").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{profile.name=projects/*/profiles/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "profile.name", (Object)request.getProfile().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("profile", (Message)request.getProfile(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Profile.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateProfileRequest, Profile> createProfileCallable;
    private final UnaryCallable<CreateOfflineProfileRequest, Profile> createOfflineProfileCallable;
    private final UnaryCallable<UpdateProfileRequest, Profile> updateProfileCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonProfilerServiceStub create(ProfilerServiceStubSettings settings) throws IOException {
        return new HttpJsonProfilerServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonProfilerServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonProfilerServiceStub(ProfilerServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonProfilerServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonProfilerServiceStub(ProfilerServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonProfilerServiceStub(ProfilerServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonProfilerServiceCallableFactory());
    }

    protected HttpJsonProfilerServiceStub(ProfilerServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createProfileTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createProfileMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createOfflineProfileTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createOfflineProfileMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateProfileTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateProfileMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("profile.name", String.valueOf(request.getProfile().getName()));
            return builder.build();
        }).build();
        this.createProfileCallable = callableFactory.createUnaryCallable(createProfileTransportSettings, settings.createProfileSettings(), clientContext);
        this.createOfflineProfileCallable = callableFactory.createUnaryCallable(createOfflineProfileTransportSettings, settings.createOfflineProfileSettings(), clientContext);
        this.updateProfileCallable = callableFactory.createUnaryCallable(updateProfileTransportSettings, settings.updateProfileSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createProfileMethodDescriptor);
        methodDescriptors.add(createOfflineProfileMethodDescriptor);
        methodDescriptors.add(updateProfileMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateProfileRequest, Profile> createProfileCallable() {
        return this.createProfileCallable;
    }

    @Override
    public UnaryCallable<CreateOfflineProfileRequest, Profile> createOfflineProfileCallable() {
        return this.createOfflineProfileCallable;
    }

    @Override
    public UnaryCallable<UpdateProfileRequest, Profile> updateProfileCallable() {
        return this.updateProfileCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

