/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.privilegedaccessmanager.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.privilegedaccessmanager.v1.ApproveGrantRequest;
import com.google.cloud.privilegedaccessmanager.v1.CheckOnboardingStatusRequest;
import com.google.cloud.privilegedaccessmanager.v1.CheckOnboardingStatusResponse;
import com.google.cloud.privilegedaccessmanager.v1.CreateEntitlementRequest;
import com.google.cloud.privilegedaccessmanager.v1.CreateGrantRequest;
import com.google.cloud.privilegedaccessmanager.v1.DeleteEntitlementRequest;
import com.google.cloud.privilegedaccessmanager.v1.DenyGrantRequest;
import com.google.cloud.privilegedaccessmanager.v1.Entitlement;
import com.google.cloud.privilegedaccessmanager.v1.EntitlementName;
import com.google.cloud.privilegedaccessmanager.v1.FolderLocationName;
import com.google.cloud.privilegedaccessmanager.v1.GetEntitlementRequest;
import com.google.cloud.privilegedaccessmanager.v1.GetGrantRequest;
import com.google.cloud.privilegedaccessmanager.v1.Grant;
import com.google.cloud.privilegedaccessmanager.v1.GrantName;
import com.google.cloud.privilegedaccessmanager.v1.ListEntitlementsRequest;
import com.google.cloud.privilegedaccessmanager.v1.ListEntitlementsResponse;
import com.google.cloud.privilegedaccessmanager.v1.ListGrantsRequest;
import com.google.cloud.privilegedaccessmanager.v1.ListGrantsResponse;
import com.google.cloud.privilegedaccessmanager.v1.LocationName;
import com.google.cloud.privilegedaccessmanager.v1.OperationMetadata;
import com.google.cloud.privilegedaccessmanager.v1.OrganizationLocationName;
import com.google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManagerSettings;
import com.google.cloud.privilegedaccessmanager.v1.RevokeGrantRequest;
import com.google.cloud.privilegedaccessmanager.v1.SearchEntitlementsRequest;
import com.google.cloud.privilegedaccessmanager.v1.SearchEntitlementsResponse;
import com.google.cloud.privilegedaccessmanager.v1.SearchGrantsRequest;
import com.google.cloud.privilegedaccessmanager.v1.SearchGrantsResponse;
import com.google.cloud.privilegedaccessmanager.v1.UpdateEntitlementRequest;
import com.google.cloud.privilegedaccessmanager.v1.stub.PrivilegedAccessManagerStub;
import com.google.cloud.privilegedaccessmanager.v1.stub.PrivilegedAccessManagerStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class PrivilegedAccessManagerClient
implements BackgroundResource {
    private final PrivilegedAccessManagerSettings settings;
    private final PrivilegedAccessManagerStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final PrivilegedAccessManagerClient create() throws IOException {
        return PrivilegedAccessManagerClient.create(PrivilegedAccessManagerSettings.newBuilder().build());
    }

    public static final PrivilegedAccessManagerClient create(PrivilegedAccessManagerSettings settings) throws IOException {
        return new PrivilegedAccessManagerClient(settings);
    }

    public static final PrivilegedAccessManagerClient create(PrivilegedAccessManagerStub stub) {
        return new PrivilegedAccessManagerClient(stub);
    }

    protected PrivilegedAccessManagerClient(PrivilegedAccessManagerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PrivilegedAccessManagerStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected PrivilegedAccessManagerClient(PrivilegedAccessManagerStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final PrivilegedAccessManagerSettings getSettings() {
        return this.settings;
    }

    public PrivilegedAccessManagerStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final CheckOnboardingStatusResponse checkOnboardingStatus(CheckOnboardingStatusRequest request) {
        return (CheckOnboardingStatusResponse)this.checkOnboardingStatusCallable().call((Object)request);
    }

    public final UnaryCallable<CheckOnboardingStatusRequest, CheckOnboardingStatusResponse> checkOnboardingStatusCallable() {
        return this.stub.checkOnboardingStatusCallable();
    }

    public final ListEntitlementsPagedResponse listEntitlements(FolderLocationName parent) {
        ListEntitlementsRequest request = ListEntitlementsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEntitlements(request);
    }

    public final ListEntitlementsPagedResponse listEntitlements(LocationName parent) {
        ListEntitlementsRequest request = ListEntitlementsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEntitlements(request);
    }

    public final ListEntitlementsPagedResponse listEntitlements(OrganizationLocationName parent) {
        ListEntitlementsRequest request = ListEntitlementsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEntitlements(request);
    }

    public final ListEntitlementsPagedResponse listEntitlements(String parent) {
        ListEntitlementsRequest request = ListEntitlementsRequest.newBuilder().setParent(parent).build();
        return this.listEntitlements(request);
    }

    public final ListEntitlementsPagedResponse listEntitlements(ListEntitlementsRequest request) {
        return (ListEntitlementsPagedResponse)((Object)this.listEntitlementsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEntitlementsRequest, ListEntitlementsPagedResponse> listEntitlementsPagedCallable() {
        return this.stub.listEntitlementsPagedCallable();
    }

    public final UnaryCallable<ListEntitlementsRequest, ListEntitlementsResponse> listEntitlementsCallable() {
        return this.stub.listEntitlementsCallable();
    }

    public final SearchEntitlementsPagedResponse searchEntitlements(SearchEntitlementsRequest request) {
        return (SearchEntitlementsPagedResponse)((Object)this.searchEntitlementsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchEntitlementsRequest, SearchEntitlementsPagedResponse> searchEntitlementsPagedCallable() {
        return this.stub.searchEntitlementsPagedCallable();
    }

    public final UnaryCallable<SearchEntitlementsRequest, SearchEntitlementsResponse> searchEntitlementsCallable() {
        return this.stub.searchEntitlementsCallable();
    }

    public final Entitlement getEntitlement(EntitlementName name) {
        GetEntitlementRequest request = GetEntitlementRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEntitlement(request);
    }

    public final Entitlement getEntitlement(String name) {
        GetEntitlementRequest request = GetEntitlementRequest.newBuilder().setName(name).build();
        return this.getEntitlement(request);
    }

    public final Entitlement getEntitlement(GetEntitlementRequest request) {
        return (Entitlement)this.getEntitlementCallable().call((Object)request);
    }

    public final UnaryCallable<GetEntitlementRequest, Entitlement> getEntitlementCallable() {
        return this.stub.getEntitlementCallable();
    }

    public final OperationFuture<Entitlement, OperationMetadata> createEntitlementAsync(FolderLocationName parent, Entitlement entitlement, String entitlementId) {
        CreateEntitlementRequest request = CreateEntitlementRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEntitlement(entitlement).setEntitlementId(entitlementId).build();
        return this.createEntitlementAsync(request);
    }

    public final OperationFuture<Entitlement, OperationMetadata> createEntitlementAsync(LocationName parent, Entitlement entitlement, String entitlementId) {
        CreateEntitlementRequest request = CreateEntitlementRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEntitlement(entitlement).setEntitlementId(entitlementId).build();
        return this.createEntitlementAsync(request);
    }

    public final OperationFuture<Entitlement, OperationMetadata> createEntitlementAsync(OrganizationLocationName parent, Entitlement entitlement, String entitlementId) {
        CreateEntitlementRequest request = CreateEntitlementRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEntitlement(entitlement).setEntitlementId(entitlementId).build();
        return this.createEntitlementAsync(request);
    }

    public final OperationFuture<Entitlement, OperationMetadata> createEntitlementAsync(String parent, Entitlement entitlement, String entitlementId) {
        CreateEntitlementRequest request = CreateEntitlementRequest.newBuilder().setParent(parent).setEntitlement(entitlement).setEntitlementId(entitlementId).build();
        return this.createEntitlementAsync(request);
    }

    public final OperationFuture<Entitlement, OperationMetadata> createEntitlementAsync(CreateEntitlementRequest request) {
        return this.createEntitlementOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEntitlementRequest, Entitlement, OperationMetadata> createEntitlementOperationCallable() {
        return this.stub.createEntitlementOperationCallable();
    }

    public final UnaryCallable<CreateEntitlementRequest, Operation> createEntitlementCallable() {
        return this.stub.createEntitlementCallable();
    }

    public final OperationFuture<Entitlement, OperationMetadata> deleteEntitlementAsync(EntitlementName name) {
        DeleteEntitlementRequest request = DeleteEntitlementRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteEntitlementAsync(request);
    }

    public final OperationFuture<Entitlement, OperationMetadata> deleteEntitlementAsync(String name) {
        DeleteEntitlementRequest request = DeleteEntitlementRequest.newBuilder().setName(name).build();
        return this.deleteEntitlementAsync(request);
    }

    public final OperationFuture<Entitlement, OperationMetadata> deleteEntitlementAsync(DeleteEntitlementRequest request) {
        return this.deleteEntitlementOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteEntitlementRequest, Entitlement, OperationMetadata> deleteEntitlementOperationCallable() {
        return this.stub.deleteEntitlementOperationCallable();
    }

    public final UnaryCallable<DeleteEntitlementRequest, Operation> deleteEntitlementCallable() {
        return this.stub.deleteEntitlementCallable();
    }

    public final OperationFuture<Entitlement, OperationMetadata> updateEntitlementAsync(Entitlement entitlement, FieldMask updateMask) {
        UpdateEntitlementRequest request = UpdateEntitlementRequest.newBuilder().setEntitlement(entitlement).setUpdateMask(updateMask).build();
        return this.updateEntitlementAsync(request);
    }

    public final OperationFuture<Entitlement, OperationMetadata> updateEntitlementAsync(UpdateEntitlementRequest request) {
        return this.updateEntitlementOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateEntitlementRequest, Entitlement, OperationMetadata> updateEntitlementOperationCallable() {
        return this.stub.updateEntitlementOperationCallable();
    }

    public final UnaryCallable<UpdateEntitlementRequest, Operation> updateEntitlementCallable() {
        return this.stub.updateEntitlementCallable();
    }

    public final ListGrantsPagedResponse listGrants(EntitlementName parent) {
        ListGrantsRequest request = ListGrantsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGrants(request);
    }

    public final ListGrantsPagedResponse listGrants(String parent) {
        ListGrantsRequest request = ListGrantsRequest.newBuilder().setParent(parent).build();
        return this.listGrants(request);
    }

    public final ListGrantsPagedResponse listGrants(ListGrantsRequest request) {
        return (ListGrantsPagedResponse)((Object)this.listGrantsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGrantsRequest, ListGrantsPagedResponse> listGrantsPagedCallable() {
        return this.stub.listGrantsPagedCallable();
    }

    public final UnaryCallable<ListGrantsRequest, ListGrantsResponse> listGrantsCallable() {
        return this.stub.listGrantsCallable();
    }

    public final SearchGrantsPagedResponse searchGrants(SearchGrantsRequest request) {
        return (SearchGrantsPagedResponse)((Object)this.searchGrantsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchGrantsRequest, SearchGrantsPagedResponse> searchGrantsPagedCallable() {
        return this.stub.searchGrantsPagedCallable();
    }

    public final UnaryCallable<SearchGrantsRequest, SearchGrantsResponse> searchGrantsCallable() {
        return this.stub.searchGrantsCallable();
    }

    public final Grant getGrant(GrantName name) {
        GetGrantRequest request = GetGrantRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGrant(request);
    }

    public final Grant getGrant(String name) {
        GetGrantRequest request = GetGrantRequest.newBuilder().setName(name).build();
        return this.getGrant(request);
    }

    public final Grant getGrant(GetGrantRequest request) {
        return (Grant)this.getGrantCallable().call((Object)request);
    }

    public final UnaryCallable<GetGrantRequest, Grant> getGrantCallable() {
        return this.stub.getGrantCallable();
    }

    public final Grant createGrant(EntitlementName parent, Grant grant) {
        CreateGrantRequest request = CreateGrantRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGrant(grant).build();
        return this.createGrant(request);
    }

    public final Grant createGrant(String parent, Grant grant) {
        CreateGrantRequest request = CreateGrantRequest.newBuilder().setParent(parent).setGrant(grant).build();
        return this.createGrant(request);
    }

    public final Grant createGrant(CreateGrantRequest request) {
        return (Grant)this.createGrantCallable().call((Object)request);
    }

    public final UnaryCallable<CreateGrantRequest, Grant> createGrantCallable() {
        return this.stub.createGrantCallable();
    }

    public final Grant approveGrant(ApproveGrantRequest request) {
        return (Grant)this.approveGrantCallable().call((Object)request);
    }

    public final UnaryCallable<ApproveGrantRequest, Grant> approveGrantCallable() {
        return this.stub.approveGrantCallable();
    }

    public final Grant denyGrant(DenyGrantRequest request) {
        return (Grant)this.denyGrantCallable().call((Object)request);
    }

    public final UnaryCallable<DenyGrantRequest, Grant> denyGrantCallable() {
        return this.stub.denyGrantCallable();
    }

    public final OperationFuture<Grant, OperationMetadata> revokeGrantAsync(RevokeGrantRequest request) {
        return this.revokeGrantOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RevokeGrantRequest, Grant, OperationMetadata> revokeGrantOperationCallable() {
        return this.stub.revokeGrantOperationCallable();
    }

    public final UnaryCallable<RevokeGrantRequest, Operation> revokeGrantCallable() {
        return this.stub.revokeGrantCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchGrantsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchGrantsRequest, SearchGrantsResponse, Grant, SearchGrantsPage, SearchGrantsFixedSizeCollection> {
        private SearchGrantsFixedSizeCollection(List<SearchGrantsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchGrantsFixedSizeCollection createEmptyCollection() {
            return new SearchGrantsFixedSizeCollection(null, 0);
        }

        protected SearchGrantsFixedSizeCollection createCollection(List<SearchGrantsPage> pages, int collectionSize) {
            return new SearchGrantsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchGrantsPage
    extends AbstractPage<SearchGrantsRequest, SearchGrantsResponse, Grant, SearchGrantsPage> {
        private SearchGrantsPage(PageContext<SearchGrantsRequest, SearchGrantsResponse, Grant> context, SearchGrantsResponse response) {
            super(context, (Object)response);
        }

        private static SearchGrantsPage createEmptyPage() {
            return new SearchGrantsPage(null, null);
        }

        protected SearchGrantsPage createPage(PageContext<SearchGrantsRequest, SearchGrantsResponse, Grant> context, SearchGrantsResponse response) {
            return new SearchGrantsPage(context, response);
        }

        public ApiFuture<SearchGrantsPage> createPageAsync(PageContext<SearchGrantsRequest, SearchGrantsResponse, Grant> context, ApiFuture<SearchGrantsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchGrantsPagedResponse
    extends AbstractPagedListResponse<SearchGrantsRequest, SearchGrantsResponse, Grant, SearchGrantsPage, SearchGrantsFixedSizeCollection> {
        public static ApiFuture<SearchGrantsPagedResponse> createAsync(PageContext<SearchGrantsRequest, SearchGrantsResponse, Grant> context, ApiFuture<SearchGrantsResponse> futureResponse) {
            ApiFuture<SearchGrantsPage> futurePage = SearchGrantsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchGrantsPagedResponse((SearchGrantsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchGrantsPagedResponse(SearchGrantsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchGrantsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGrantsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGrantsRequest, ListGrantsResponse, Grant, ListGrantsPage, ListGrantsFixedSizeCollection> {
        private ListGrantsFixedSizeCollection(List<ListGrantsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGrantsFixedSizeCollection createEmptyCollection() {
            return new ListGrantsFixedSizeCollection(null, 0);
        }

        protected ListGrantsFixedSizeCollection createCollection(List<ListGrantsPage> pages, int collectionSize) {
            return new ListGrantsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGrantsPage
    extends AbstractPage<ListGrantsRequest, ListGrantsResponse, Grant, ListGrantsPage> {
        private ListGrantsPage(PageContext<ListGrantsRequest, ListGrantsResponse, Grant> context, ListGrantsResponse response) {
            super(context, (Object)response);
        }

        private static ListGrantsPage createEmptyPage() {
            return new ListGrantsPage(null, null);
        }

        protected ListGrantsPage createPage(PageContext<ListGrantsRequest, ListGrantsResponse, Grant> context, ListGrantsResponse response) {
            return new ListGrantsPage(context, response);
        }

        public ApiFuture<ListGrantsPage> createPageAsync(PageContext<ListGrantsRequest, ListGrantsResponse, Grant> context, ApiFuture<ListGrantsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGrantsPagedResponse
    extends AbstractPagedListResponse<ListGrantsRequest, ListGrantsResponse, Grant, ListGrantsPage, ListGrantsFixedSizeCollection> {
        public static ApiFuture<ListGrantsPagedResponse> createAsync(PageContext<ListGrantsRequest, ListGrantsResponse, Grant> context, ApiFuture<ListGrantsResponse> futureResponse) {
            ApiFuture<ListGrantsPage> futurePage = ListGrantsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGrantsPagedResponse((ListGrantsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGrantsPagedResponse(ListGrantsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGrantsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchEntitlementsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchEntitlementsRequest, SearchEntitlementsResponse, Entitlement, SearchEntitlementsPage, SearchEntitlementsFixedSizeCollection> {
        private SearchEntitlementsFixedSizeCollection(List<SearchEntitlementsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchEntitlementsFixedSizeCollection createEmptyCollection() {
            return new SearchEntitlementsFixedSizeCollection(null, 0);
        }

        protected SearchEntitlementsFixedSizeCollection createCollection(List<SearchEntitlementsPage> pages, int collectionSize) {
            return new SearchEntitlementsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchEntitlementsPage
    extends AbstractPage<SearchEntitlementsRequest, SearchEntitlementsResponse, Entitlement, SearchEntitlementsPage> {
        private SearchEntitlementsPage(PageContext<SearchEntitlementsRequest, SearchEntitlementsResponse, Entitlement> context, SearchEntitlementsResponse response) {
            super(context, (Object)response);
        }

        private static SearchEntitlementsPage createEmptyPage() {
            return new SearchEntitlementsPage(null, null);
        }

        protected SearchEntitlementsPage createPage(PageContext<SearchEntitlementsRequest, SearchEntitlementsResponse, Entitlement> context, SearchEntitlementsResponse response) {
            return new SearchEntitlementsPage(context, response);
        }

        public ApiFuture<SearchEntitlementsPage> createPageAsync(PageContext<SearchEntitlementsRequest, SearchEntitlementsResponse, Entitlement> context, ApiFuture<SearchEntitlementsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchEntitlementsPagedResponse
    extends AbstractPagedListResponse<SearchEntitlementsRequest, SearchEntitlementsResponse, Entitlement, SearchEntitlementsPage, SearchEntitlementsFixedSizeCollection> {
        public static ApiFuture<SearchEntitlementsPagedResponse> createAsync(PageContext<SearchEntitlementsRequest, SearchEntitlementsResponse, Entitlement> context, ApiFuture<SearchEntitlementsResponse> futureResponse) {
            ApiFuture<SearchEntitlementsPage> futurePage = SearchEntitlementsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchEntitlementsPagedResponse((SearchEntitlementsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchEntitlementsPagedResponse(SearchEntitlementsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchEntitlementsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEntitlementsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement, ListEntitlementsPage, ListEntitlementsFixedSizeCollection> {
        private ListEntitlementsFixedSizeCollection(List<ListEntitlementsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEntitlementsFixedSizeCollection createEmptyCollection() {
            return new ListEntitlementsFixedSizeCollection(null, 0);
        }

        protected ListEntitlementsFixedSizeCollection createCollection(List<ListEntitlementsPage> pages, int collectionSize) {
            return new ListEntitlementsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEntitlementsPage
    extends AbstractPage<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement, ListEntitlementsPage> {
        private ListEntitlementsPage(PageContext<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement> context, ListEntitlementsResponse response) {
            super(context, (Object)response);
        }

        private static ListEntitlementsPage createEmptyPage() {
            return new ListEntitlementsPage(null, null);
        }

        protected ListEntitlementsPage createPage(PageContext<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement> context, ListEntitlementsResponse response) {
            return new ListEntitlementsPage(context, response);
        }

        public ApiFuture<ListEntitlementsPage> createPageAsync(PageContext<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement> context, ApiFuture<ListEntitlementsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEntitlementsPagedResponse
    extends AbstractPagedListResponse<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement, ListEntitlementsPage, ListEntitlementsFixedSizeCollection> {
        public static ApiFuture<ListEntitlementsPagedResponse> createAsync(PageContext<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement> context, ApiFuture<ListEntitlementsResponse> futureResponse) {
            ApiFuture<ListEntitlementsPage> futurePage = ListEntitlementsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEntitlementsPagedResponse((ListEntitlementsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEntitlementsPagedResponse(ListEntitlementsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEntitlementsFixedSizeCollection.createEmptyCollection());
        }
    }
}

