/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.parametermanager.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.parametermanager.v1.CreateParameterRequest;
import com.google.cloud.parametermanager.v1.CreateParameterVersionRequest;
import com.google.cloud.parametermanager.v1.DeleteParameterRequest;
import com.google.cloud.parametermanager.v1.DeleteParameterVersionRequest;
import com.google.cloud.parametermanager.v1.GetParameterRequest;
import com.google.cloud.parametermanager.v1.GetParameterVersionRequest;
import com.google.cloud.parametermanager.v1.ListParameterVersionsRequest;
import com.google.cloud.parametermanager.v1.ListParameterVersionsResponse;
import com.google.cloud.parametermanager.v1.ListParametersRequest;
import com.google.cloud.parametermanager.v1.ListParametersResponse;
import com.google.cloud.parametermanager.v1.Parameter;
import com.google.cloud.parametermanager.v1.ParameterManagerClient;
import com.google.cloud.parametermanager.v1.ParameterVersion;
import com.google.cloud.parametermanager.v1.RenderParameterVersionRequest;
import com.google.cloud.parametermanager.v1.RenderParameterVersionResponse;
import com.google.cloud.parametermanager.v1.UpdateParameterRequest;
import com.google.cloud.parametermanager.v1.UpdateParameterVersionRequest;
import com.google.cloud.parametermanager.v1.stub.HttpJsonParameterManagerCallableFactory;
import com.google.cloud.parametermanager.v1.stub.ParameterManagerStub;
import com.google.cloud.parametermanager.v1.stub.ParameterManagerStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonParameterManagerStub
extends ParameterManagerStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListParametersRequest, ListParametersResponse> listParametersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/ListParameters").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/parameters", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListParametersResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetParameterRequest, Parameter> getParameterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/GetParameter").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/parameters/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Parameter.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateParameterRequest, Parameter> createParameterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/CreateParameter").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/parameters", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "parameterId", (Object)request.getParameterId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("parameter", (Message)request.getParameter(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Parameter.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateParameterRequest, Parameter> updateParameterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/UpdateParameter").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parameter.name=projects/*/locations/*/parameters/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parameter.name", (Object)request.getParameter().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("parameter", (Message)request.getParameter(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Parameter.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteParameterRequest, Empty> deleteParameterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/DeleteParameter").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/parameters/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListParameterVersionsRequest, ListParameterVersionsResponse> listParameterVersionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/ListParameterVersions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/parameters/*}/versions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListParameterVersionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetParameterVersionRequest, ParameterVersion> getParameterVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/GetParameterVersion").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/parameters/*/versions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ParameterVersion.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RenderParameterVersionRequest, RenderParameterVersionResponse> renderParameterVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/RenderParameterVersion").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/parameters/*/versions/*}:render", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)RenderParameterVersionResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateParameterVersionRequest, ParameterVersion> createParameterVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/CreateParameterVersion").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/parameters/*}/versions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "parameterVersionId", (Object)request.getParameterVersionId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("parameterVersion", (Message)request.getParameterVersion(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ParameterVersion.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateParameterVersionRequest, ParameterVersion> updateParameterVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/UpdateParameterVersion").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parameterVersion.name=projects/*/locations/*/parameters/*/versions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parameterVersion.name", (Object)request.getParameterVersion().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("parameterVersion", (Message)request.getParameterVersion(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ParameterVersion.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteParameterVersionRequest, Empty> deleteParameterVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.parametermanager.v1.ParameterManager/DeleteParameterVersion").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/parameters/*/versions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListParametersRequest, ListParametersResponse> listParametersCallable;
    private final UnaryCallable<ListParametersRequest, ParameterManagerClient.ListParametersPagedResponse> listParametersPagedCallable;
    private final UnaryCallable<GetParameterRequest, Parameter> getParameterCallable;
    private final UnaryCallable<CreateParameterRequest, Parameter> createParameterCallable;
    private final UnaryCallable<UpdateParameterRequest, Parameter> updateParameterCallable;
    private final UnaryCallable<DeleteParameterRequest, Empty> deleteParameterCallable;
    private final UnaryCallable<ListParameterVersionsRequest, ListParameterVersionsResponse> listParameterVersionsCallable;
    private final UnaryCallable<ListParameterVersionsRequest, ParameterManagerClient.ListParameterVersionsPagedResponse> listParameterVersionsPagedCallable;
    private final UnaryCallable<GetParameterVersionRequest, ParameterVersion> getParameterVersionCallable;
    private final UnaryCallable<RenderParameterVersionRequest, RenderParameterVersionResponse> renderParameterVersionCallable;
    private final UnaryCallable<CreateParameterVersionRequest, ParameterVersion> createParameterVersionCallable;
    private final UnaryCallable<UpdateParameterVersionRequest, ParameterVersion> updateParameterVersionCallable;
    private final UnaryCallable<DeleteParameterVersionRequest, Empty> deleteParameterVersionCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ParameterManagerClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonParameterManagerStub create(ParameterManagerStubSettings settings) throws IOException {
        return new HttpJsonParameterManagerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonParameterManagerStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonParameterManagerStub(ParameterManagerStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonParameterManagerStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonParameterManagerStub(ParameterManagerStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonParameterManagerStub(ParameterManagerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonParameterManagerCallableFactory());
    }

    protected HttpJsonParameterManagerStub(ParameterManagerStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listParametersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listParametersMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getParameterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getParameterMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createParameterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createParameterMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateParameterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateParameterMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parameter.name", String.valueOf(request.getParameter().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteParameterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteParameterMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listParameterVersionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listParameterVersionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getParameterVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getParameterVersionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings renderParameterVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(renderParameterVersionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createParameterVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createParameterVersionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateParameterVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateParameterVersionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parameter_version.name", String.valueOf(request.getParameterVersion().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteParameterVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteParameterVersionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listParametersCallable = callableFactory.createUnaryCallable(listParametersTransportSettings, settings.listParametersSettings(), clientContext);
        this.listParametersPagedCallable = callableFactory.createPagedCallable(listParametersTransportSettings, settings.listParametersSettings(), clientContext);
        this.getParameterCallable = callableFactory.createUnaryCallable(getParameterTransportSettings, settings.getParameterSettings(), clientContext);
        this.createParameterCallable = callableFactory.createUnaryCallable(createParameterTransportSettings, settings.createParameterSettings(), clientContext);
        this.updateParameterCallable = callableFactory.createUnaryCallable(updateParameterTransportSettings, settings.updateParameterSettings(), clientContext);
        this.deleteParameterCallable = callableFactory.createUnaryCallable(deleteParameterTransportSettings, settings.deleteParameterSettings(), clientContext);
        this.listParameterVersionsCallable = callableFactory.createUnaryCallable(listParameterVersionsTransportSettings, settings.listParameterVersionsSettings(), clientContext);
        this.listParameterVersionsPagedCallable = callableFactory.createPagedCallable(listParameterVersionsTransportSettings, settings.listParameterVersionsSettings(), clientContext);
        this.getParameterVersionCallable = callableFactory.createUnaryCallable(getParameterVersionTransportSettings, settings.getParameterVersionSettings(), clientContext);
        this.renderParameterVersionCallable = callableFactory.createUnaryCallable(renderParameterVersionTransportSettings, settings.renderParameterVersionSettings(), clientContext);
        this.createParameterVersionCallable = callableFactory.createUnaryCallable(createParameterVersionTransportSettings, settings.createParameterVersionSettings(), clientContext);
        this.updateParameterVersionCallable = callableFactory.createUnaryCallable(updateParameterVersionTransportSettings, settings.updateParameterVersionSettings(), clientContext);
        this.deleteParameterVersionCallable = callableFactory.createUnaryCallable(deleteParameterVersionTransportSettings, settings.deleteParameterVersionSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listParametersMethodDescriptor);
        methodDescriptors.add(getParameterMethodDescriptor);
        methodDescriptors.add(createParameterMethodDescriptor);
        methodDescriptors.add(updateParameterMethodDescriptor);
        methodDescriptors.add(deleteParameterMethodDescriptor);
        methodDescriptors.add(listParameterVersionsMethodDescriptor);
        methodDescriptors.add(getParameterVersionMethodDescriptor);
        methodDescriptors.add(renderParameterVersionMethodDescriptor);
        methodDescriptors.add(createParameterVersionMethodDescriptor);
        methodDescriptors.add(updateParameterVersionMethodDescriptor);
        methodDescriptors.add(deleteParameterVersionMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListParametersRequest, ListParametersResponse> listParametersCallable() {
        return this.listParametersCallable;
    }

    @Override
    public UnaryCallable<ListParametersRequest, ParameterManagerClient.ListParametersPagedResponse> listParametersPagedCallable() {
        return this.listParametersPagedCallable;
    }

    @Override
    public UnaryCallable<GetParameterRequest, Parameter> getParameterCallable() {
        return this.getParameterCallable;
    }

    @Override
    public UnaryCallable<CreateParameterRequest, Parameter> createParameterCallable() {
        return this.createParameterCallable;
    }

    @Override
    public UnaryCallable<UpdateParameterRequest, Parameter> updateParameterCallable() {
        return this.updateParameterCallable;
    }

    @Override
    public UnaryCallable<DeleteParameterRequest, Empty> deleteParameterCallable() {
        return this.deleteParameterCallable;
    }

    @Override
    public UnaryCallable<ListParameterVersionsRequest, ListParameterVersionsResponse> listParameterVersionsCallable() {
        return this.listParameterVersionsCallable;
    }

    @Override
    public UnaryCallable<ListParameterVersionsRequest, ParameterManagerClient.ListParameterVersionsPagedResponse> listParameterVersionsPagedCallable() {
        return this.listParameterVersionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetParameterVersionRequest, ParameterVersion> getParameterVersionCallable() {
        return this.getParameterVersionCallable;
    }

    @Override
    public UnaryCallable<RenderParameterVersionRequest, RenderParameterVersionResponse> renderParameterVersionCallable() {
        return this.renderParameterVersionCallable;
    }

    @Override
    public UnaryCallable<CreateParameterVersionRequest, ParameterVersion> createParameterVersionCallable() {
        return this.createParameterVersionCallable;
    }

    @Override
    public UnaryCallable<UpdateParameterVersionRequest, ParameterVersion> updateParameterVersionCallable() {
        return this.updateParameterVersionCallable;
    }

    @Override
    public UnaryCallable<DeleteParameterVersionRequest, Empty> deleteParameterVersionCallable() {
        return this.deleteParameterVersionCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ParameterManagerClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

