/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.osconfig.v1alpha.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.osconfig.v1alpha.CreateOSPolicyAssignmentRequest;
import com.google.cloud.osconfig.v1alpha.DeleteOSPolicyAssignmentRequest;
import com.google.cloud.osconfig.v1alpha.GetInstanceOSPoliciesComplianceRequest;
import com.google.cloud.osconfig.v1alpha.GetInventoryRequest;
import com.google.cloud.osconfig.v1alpha.GetOSPolicyAssignmentReportRequest;
import com.google.cloud.osconfig.v1alpha.GetOSPolicyAssignmentRequest;
import com.google.cloud.osconfig.v1alpha.GetVulnerabilityReportRequest;
import com.google.cloud.osconfig.v1alpha.InstanceOSPoliciesCompliance;
import com.google.cloud.osconfig.v1alpha.Inventory;
import com.google.cloud.osconfig.v1alpha.ListInstanceOSPoliciesCompliancesRequest;
import com.google.cloud.osconfig.v1alpha.ListInstanceOSPoliciesCompliancesResponse;
import com.google.cloud.osconfig.v1alpha.ListInventoriesRequest;
import com.google.cloud.osconfig.v1alpha.ListInventoriesResponse;
import com.google.cloud.osconfig.v1alpha.ListOSPolicyAssignmentReportsRequest;
import com.google.cloud.osconfig.v1alpha.ListOSPolicyAssignmentReportsResponse;
import com.google.cloud.osconfig.v1alpha.ListOSPolicyAssignmentRevisionsRequest;
import com.google.cloud.osconfig.v1alpha.ListOSPolicyAssignmentRevisionsResponse;
import com.google.cloud.osconfig.v1alpha.ListOSPolicyAssignmentsRequest;
import com.google.cloud.osconfig.v1alpha.ListOSPolicyAssignmentsResponse;
import com.google.cloud.osconfig.v1alpha.ListVulnerabilityReportsRequest;
import com.google.cloud.osconfig.v1alpha.ListVulnerabilityReportsResponse;
import com.google.cloud.osconfig.v1alpha.OSPolicyAssignment;
import com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentOperationMetadata;
import com.google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport;
import com.google.cloud.osconfig.v1alpha.OsConfigZonalServiceClient;
import com.google.cloud.osconfig.v1alpha.UpdateOSPolicyAssignmentRequest;
import com.google.cloud.osconfig.v1alpha.VulnerabilityReport;
import com.google.cloud.osconfig.v1alpha.stub.GrpcOsConfigZonalServiceStub;
import com.google.cloud.osconfig.v1alpha.stub.HttpJsonOsConfigZonalServiceStub;
import com.google.cloud.osconfig.v1alpha.stub.OsConfigZonalServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class OsConfigZonalServiceStubSettings
extends StubSettings<OsConfigZonalServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateOSPolicyAssignmentRequest, Operation> createOSPolicyAssignmentSettings;
    private final OperationCallSettings<CreateOSPolicyAssignmentRequest, OSPolicyAssignment, OSPolicyAssignmentOperationMetadata> createOSPolicyAssignmentOperationSettings;
    private final UnaryCallSettings<UpdateOSPolicyAssignmentRequest, Operation> updateOSPolicyAssignmentSettings;
    private final OperationCallSettings<UpdateOSPolicyAssignmentRequest, OSPolicyAssignment, OSPolicyAssignmentOperationMetadata> updateOSPolicyAssignmentOperationSettings;
    private final UnaryCallSettings<GetOSPolicyAssignmentRequest, OSPolicyAssignment> getOSPolicyAssignmentSettings;
    private final PagedCallSettings<ListOSPolicyAssignmentsRequest, ListOSPolicyAssignmentsResponse, OsConfigZonalServiceClient.ListOSPolicyAssignmentsPagedResponse> listOSPolicyAssignmentsSettings;
    private final PagedCallSettings<ListOSPolicyAssignmentRevisionsRequest, ListOSPolicyAssignmentRevisionsResponse, OsConfigZonalServiceClient.ListOSPolicyAssignmentRevisionsPagedResponse> listOSPolicyAssignmentRevisionsSettings;
    private final UnaryCallSettings<DeleteOSPolicyAssignmentRequest, Operation> deleteOSPolicyAssignmentSettings;
    private final OperationCallSettings<DeleteOSPolicyAssignmentRequest, Empty, OSPolicyAssignmentOperationMetadata> deleteOSPolicyAssignmentOperationSettings;
    private final UnaryCallSettings<GetInstanceOSPoliciesComplianceRequest, InstanceOSPoliciesCompliance> getInstanceOSPoliciesComplianceSettings;
    private final PagedCallSettings<ListInstanceOSPoliciesCompliancesRequest, ListInstanceOSPoliciesCompliancesResponse, OsConfigZonalServiceClient.ListInstanceOSPoliciesCompliancesPagedResponse> listInstanceOSPoliciesCompliancesSettings;
    private final UnaryCallSettings<GetOSPolicyAssignmentReportRequest, OSPolicyAssignmentReport> getOSPolicyAssignmentReportSettings;
    private final PagedCallSettings<ListOSPolicyAssignmentReportsRequest, ListOSPolicyAssignmentReportsResponse, OsConfigZonalServiceClient.ListOSPolicyAssignmentReportsPagedResponse> listOSPolicyAssignmentReportsSettings;
    private final UnaryCallSettings<GetInventoryRequest, Inventory> getInventorySettings;
    private final PagedCallSettings<ListInventoriesRequest, ListInventoriesResponse, OsConfigZonalServiceClient.ListInventoriesPagedResponse> listInventoriesSettings;
    private final UnaryCallSettings<GetVulnerabilityReportRequest, VulnerabilityReport> getVulnerabilityReportSettings;
    private final PagedCallSettings<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse, OsConfigZonalServiceClient.ListVulnerabilityReportsPagedResponse> listVulnerabilityReportsSettings;
    private static final PagedListDescriptor<ListOSPolicyAssignmentsRequest, ListOSPolicyAssignmentsResponse, OSPolicyAssignment> LIST_O_S_POLICY_ASSIGNMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListOSPolicyAssignmentsRequest, ListOSPolicyAssignmentsResponse, OSPolicyAssignment>(){

        public String emptyToken() {
            return "";
        }

        public ListOSPolicyAssignmentsRequest injectToken(ListOSPolicyAssignmentsRequest payload, String token) {
            return ListOSPolicyAssignmentsRequest.newBuilder((ListOSPolicyAssignmentsRequest)payload).setPageToken(token).build();
        }

        public ListOSPolicyAssignmentsRequest injectPageSize(ListOSPolicyAssignmentsRequest payload, int pageSize) {
            return ListOSPolicyAssignmentsRequest.newBuilder((ListOSPolicyAssignmentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListOSPolicyAssignmentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListOSPolicyAssignmentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<OSPolicyAssignment> extractResources(ListOSPolicyAssignmentsResponse payload) {
            return payload.getOsPolicyAssignmentsList() == null ? ImmutableList.of() : payload.getOsPolicyAssignmentsList();
        }
    };
    private static final PagedListDescriptor<ListOSPolicyAssignmentRevisionsRequest, ListOSPolicyAssignmentRevisionsResponse, OSPolicyAssignment> LIST_O_S_POLICY_ASSIGNMENT_REVISIONS_PAGE_STR_DESC = new PagedListDescriptor<ListOSPolicyAssignmentRevisionsRequest, ListOSPolicyAssignmentRevisionsResponse, OSPolicyAssignment>(){

        public String emptyToken() {
            return "";
        }

        public ListOSPolicyAssignmentRevisionsRequest injectToken(ListOSPolicyAssignmentRevisionsRequest payload, String token) {
            return ListOSPolicyAssignmentRevisionsRequest.newBuilder((ListOSPolicyAssignmentRevisionsRequest)payload).setPageToken(token).build();
        }

        public ListOSPolicyAssignmentRevisionsRequest injectPageSize(ListOSPolicyAssignmentRevisionsRequest payload, int pageSize) {
            return ListOSPolicyAssignmentRevisionsRequest.newBuilder((ListOSPolicyAssignmentRevisionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListOSPolicyAssignmentRevisionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListOSPolicyAssignmentRevisionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<OSPolicyAssignment> extractResources(ListOSPolicyAssignmentRevisionsResponse payload) {
            return payload.getOsPolicyAssignmentsList() == null ? ImmutableList.of() : payload.getOsPolicyAssignmentsList();
        }
    };
    private static final PagedListDescriptor<ListInstanceOSPoliciesCompliancesRequest, ListInstanceOSPoliciesCompliancesResponse, InstanceOSPoliciesCompliance> LIST_INSTANCE_O_S_POLICIES_COMPLIANCES_PAGE_STR_DESC = new PagedListDescriptor<ListInstanceOSPoliciesCompliancesRequest, ListInstanceOSPoliciesCompliancesResponse, InstanceOSPoliciesCompliance>(){

        public String emptyToken() {
            return "";
        }

        public ListInstanceOSPoliciesCompliancesRequest injectToken(ListInstanceOSPoliciesCompliancesRequest payload, String token) {
            return ListInstanceOSPoliciesCompliancesRequest.newBuilder((ListInstanceOSPoliciesCompliancesRequest)payload).setPageToken(token).build();
        }

        public ListInstanceOSPoliciesCompliancesRequest injectPageSize(ListInstanceOSPoliciesCompliancesRequest payload, int pageSize) {
            return ListInstanceOSPoliciesCompliancesRequest.newBuilder((ListInstanceOSPoliciesCompliancesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInstanceOSPoliciesCompliancesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInstanceOSPoliciesCompliancesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InstanceOSPoliciesCompliance> extractResources(ListInstanceOSPoliciesCompliancesResponse payload) {
            return payload.getInstanceOsPoliciesCompliancesList() == null ? ImmutableList.of() : payload.getInstanceOsPoliciesCompliancesList();
        }
    };
    private static final PagedListDescriptor<ListOSPolicyAssignmentReportsRequest, ListOSPolicyAssignmentReportsResponse, OSPolicyAssignmentReport> LIST_O_S_POLICY_ASSIGNMENT_REPORTS_PAGE_STR_DESC = new PagedListDescriptor<ListOSPolicyAssignmentReportsRequest, ListOSPolicyAssignmentReportsResponse, OSPolicyAssignmentReport>(){

        public String emptyToken() {
            return "";
        }

        public ListOSPolicyAssignmentReportsRequest injectToken(ListOSPolicyAssignmentReportsRequest payload, String token) {
            return ListOSPolicyAssignmentReportsRequest.newBuilder((ListOSPolicyAssignmentReportsRequest)payload).setPageToken(token).build();
        }

        public ListOSPolicyAssignmentReportsRequest injectPageSize(ListOSPolicyAssignmentReportsRequest payload, int pageSize) {
            return ListOSPolicyAssignmentReportsRequest.newBuilder((ListOSPolicyAssignmentReportsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListOSPolicyAssignmentReportsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListOSPolicyAssignmentReportsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<OSPolicyAssignmentReport> extractResources(ListOSPolicyAssignmentReportsResponse payload) {
            return payload.getOsPolicyAssignmentReportsList() == null ? ImmutableList.of() : payload.getOsPolicyAssignmentReportsList();
        }
    };
    private static final PagedListDescriptor<ListInventoriesRequest, ListInventoriesResponse, Inventory> LIST_INVENTORIES_PAGE_STR_DESC = new PagedListDescriptor<ListInventoriesRequest, ListInventoriesResponse, Inventory>(){

        public String emptyToken() {
            return "";
        }

        public ListInventoriesRequest injectToken(ListInventoriesRequest payload, String token) {
            return ListInventoriesRequest.newBuilder((ListInventoriesRequest)payload).setPageToken(token).build();
        }

        public ListInventoriesRequest injectPageSize(ListInventoriesRequest payload, int pageSize) {
            return ListInventoriesRequest.newBuilder((ListInventoriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInventoriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInventoriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Inventory> extractResources(ListInventoriesResponse payload) {
            return payload.getInventoriesList() == null ? ImmutableList.of() : payload.getInventoriesList();
        }
    };
    private static final PagedListDescriptor<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse, VulnerabilityReport> LIST_VULNERABILITY_REPORTS_PAGE_STR_DESC = new PagedListDescriptor<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse, VulnerabilityReport>(){

        public String emptyToken() {
            return "";
        }

        public ListVulnerabilityReportsRequest injectToken(ListVulnerabilityReportsRequest payload, String token) {
            return ListVulnerabilityReportsRequest.newBuilder((ListVulnerabilityReportsRequest)payload).setPageToken(token).build();
        }

        public ListVulnerabilityReportsRequest injectPageSize(ListVulnerabilityReportsRequest payload, int pageSize) {
            return ListVulnerabilityReportsRequest.newBuilder((ListVulnerabilityReportsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListVulnerabilityReportsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListVulnerabilityReportsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<VulnerabilityReport> extractResources(ListVulnerabilityReportsResponse payload) {
            return payload.getVulnerabilityReportsList() == null ? ImmutableList.of() : payload.getVulnerabilityReportsList();
        }
    };
    private static final PagedListResponseFactory<ListOSPolicyAssignmentsRequest, ListOSPolicyAssignmentsResponse, OsConfigZonalServiceClient.ListOSPolicyAssignmentsPagedResponse> LIST_O_S_POLICY_ASSIGNMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListOSPolicyAssignmentsRequest, ListOSPolicyAssignmentsResponse, OsConfigZonalServiceClient.ListOSPolicyAssignmentsPagedResponse>(){

        public ApiFuture<OsConfigZonalServiceClient.ListOSPolicyAssignmentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListOSPolicyAssignmentsRequest, ListOSPolicyAssignmentsResponse> callable, ListOSPolicyAssignmentsRequest request, ApiCallContext context, ApiFuture<ListOSPolicyAssignmentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_O_S_POLICY_ASSIGNMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OsConfigZonalServiceClient.ListOSPolicyAssignmentsPagedResponse.createAsync((PageContext<ListOSPolicyAssignmentsRequest, ListOSPolicyAssignmentsResponse, OSPolicyAssignment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListOSPolicyAssignmentRevisionsRequest, ListOSPolicyAssignmentRevisionsResponse, OsConfigZonalServiceClient.ListOSPolicyAssignmentRevisionsPagedResponse> LIST_O_S_POLICY_ASSIGNMENT_REVISIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListOSPolicyAssignmentRevisionsRequest, ListOSPolicyAssignmentRevisionsResponse, OsConfigZonalServiceClient.ListOSPolicyAssignmentRevisionsPagedResponse>(){

        public ApiFuture<OsConfigZonalServiceClient.ListOSPolicyAssignmentRevisionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListOSPolicyAssignmentRevisionsRequest, ListOSPolicyAssignmentRevisionsResponse> callable, ListOSPolicyAssignmentRevisionsRequest request, ApiCallContext context, ApiFuture<ListOSPolicyAssignmentRevisionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_O_S_POLICY_ASSIGNMENT_REVISIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OsConfigZonalServiceClient.ListOSPolicyAssignmentRevisionsPagedResponse.createAsync((PageContext<ListOSPolicyAssignmentRevisionsRequest, ListOSPolicyAssignmentRevisionsResponse, OSPolicyAssignment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInstanceOSPoliciesCompliancesRequest, ListInstanceOSPoliciesCompliancesResponse, OsConfigZonalServiceClient.ListInstanceOSPoliciesCompliancesPagedResponse> LIST_INSTANCE_O_S_POLICIES_COMPLIANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListInstanceOSPoliciesCompliancesRequest, ListInstanceOSPoliciesCompliancesResponse, OsConfigZonalServiceClient.ListInstanceOSPoliciesCompliancesPagedResponse>(){

        public ApiFuture<OsConfigZonalServiceClient.ListInstanceOSPoliciesCompliancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstanceOSPoliciesCompliancesRequest, ListInstanceOSPoliciesCompliancesResponse> callable, ListInstanceOSPoliciesCompliancesRequest request, ApiCallContext context, ApiFuture<ListInstanceOSPoliciesCompliancesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCE_O_S_POLICIES_COMPLIANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OsConfigZonalServiceClient.ListInstanceOSPoliciesCompliancesPagedResponse.createAsync((PageContext<ListInstanceOSPoliciesCompliancesRequest, ListInstanceOSPoliciesCompliancesResponse, InstanceOSPoliciesCompliance>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListOSPolicyAssignmentReportsRequest, ListOSPolicyAssignmentReportsResponse, OsConfigZonalServiceClient.ListOSPolicyAssignmentReportsPagedResponse> LIST_O_S_POLICY_ASSIGNMENT_REPORTS_PAGE_STR_FACT = new PagedListResponseFactory<ListOSPolicyAssignmentReportsRequest, ListOSPolicyAssignmentReportsResponse, OsConfigZonalServiceClient.ListOSPolicyAssignmentReportsPagedResponse>(){

        public ApiFuture<OsConfigZonalServiceClient.ListOSPolicyAssignmentReportsPagedResponse> getFuturePagedResponse(UnaryCallable<ListOSPolicyAssignmentReportsRequest, ListOSPolicyAssignmentReportsResponse> callable, ListOSPolicyAssignmentReportsRequest request, ApiCallContext context, ApiFuture<ListOSPolicyAssignmentReportsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_O_S_POLICY_ASSIGNMENT_REPORTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OsConfigZonalServiceClient.ListOSPolicyAssignmentReportsPagedResponse.createAsync((PageContext<ListOSPolicyAssignmentReportsRequest, ListOSPolicyAssignmentReportsResponse, OSPolicyAssignmentReport>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInventoriesRequest, ListInventoriesResponse, OsConfigZonalServiceClient.ListInventoriesPagedResponse> LIST_INVENTORIES_PAGE_STR_FACT = new PagedListResponseFactory<ListInventoriesRequest, ListInventoriesResponse, OsConfigZonalServiceClient.ListInventoriesPagedResponse>(){

        public ApiFuture<OsConfigZonalServiceClient.ListInventoriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListInventoriesRequest, ListInventoriesResponse> callable, ListInventoriesRequest request, ApiCallContext context, ApiFuture<ListInventoriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INVENTORIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OsConfigZonalServiceClient.ListInventoriesPagedResponse.createAsync((PageContext<ListInventoriesRequest, ListInventoriesResponse, Inventory>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse, OsConfigZonalServiceClient.ListVulnerabilityReportsPagedResponse> LIST_VULNERABILITY_REPORTS_PAGE_STR_FACT = new PagedListResponseFactory<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse, OsConfigZonalServiceClient.ListVulnerabilityReportsPagedResponse>(){

        public ApiFuture<OsConfigZonalServiceClient.ListVulnerabilityReportsPagedResponse> getFuturePagedResponse(UnaryCallable<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse> callable, ListVulnerabilityReportsRequest request, ApiCallContext context, ApiFuture<ListVulnerabilityReportsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_VULNERABILITY_REPORTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return OsConfigZonalServiceClient.ListVulnerabilityReportsPagedResponse.createAsync((PageContext<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse, VulnerabilityReport>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateOSPolicyAssignmentRequest, Operation> createOSPolicyAssignmentSettings() {
        return this.createOSPolicyAssignmentSettings;
    }

    public OperationCallSettings<CreateOSPolicyAssignmentRequest, OSPolicyAssignment, OSPolicyAssignmentOperationMetadata> createOSPolicyAssignmentOperationSettings() {
        return this.createOSPolicyAssignmentOperationSettings;
    }

    public UnaryCallSettings<UpdateOSPolicyAssignmentRequest, Operation> updateOSPolicyAssignmentSettings() {
        return this.updateOSPolicyAssignmentSettings;
    }

    public OperationCallSettings<UpdateOSPolicyAssignmentRequest, OSPolicyAssignment, OSPolicyAssignmentOperationMetadata> updateOSPolicyAssignmentOperationSettings() {
        return this.updateOSPolicyAssignmentOperationSettings;
    }

    public UnaryCallSettings<GetOSPolicyAssignmentRequest, OSPolicyAssignment> getOSPolicyAssignmentSettings() {
        return this.getOSPolicyAssignmentSettings;
    }

    public PagedCallSettings<ListOSPolicyAssignmentsRequest, ListOSPolicyAssignmentsResponse, OsConfigZonalServiceClient.ListOSPolicyAssignmentsPagedResponse> listOSPolicyAssignmentsSettings() {
        return this.listOSPolicyAssignmentsSettings;
    }

    public PagedCallSettings<ListOSPolicyAssignmentRevisionsRequest, ListOSPolicyAssignmentRevisionsResponse, OsConfigZonalServiceClient.ListOSPolicyAssignmentRevisionsPagedResponse> listOSPolicyAssignmentRevisionsSettings() {
        return this.listOSPolicyAssignmentRevisionsSettings;
    }

    public UnaryCallSettings<DeleteOSPolicyAssignmentRequest, Operation> deleteOSPolicyAssignmentSettings() {
        return this.deleteOSPolicyAssignmentSettings;
    }

    public OperationCallSettings<DeleteOSPolicyAssignmentRequest, Empty, OSPolicyAssignmentOperationMetadata> deleteOSPolicyAssignmentOperationSettings() {
        return this.deleteOSPolicyAssignmentOperationSettings;
    }

    @Deprecated
    public UnaryCallSettings<GetInstanceOSPoliciesComplianceRequest, InstanceOSPoliciesCompliance> getInstanceOSPoliciesComplianceSettings() {
        return this.getInstanceOSPoliciesComplianceSettings;
    }

    @Deprecated
    public PagedCallSettings<ListInstanceOSPoliciesCompliancesRequest, ListInstanceOSPoliciesCompliancesResponse, OsConfigZonalServiceClient.ListInstanceOSPoliciesCompliancesPagedResponse> listInstanceOSPoliciesCompliancesSettings() {
        return this.listInstanceOSPoliciesCompliancesSettings;
    }

    public UnaryCallSettings<GetOSPolicyAssignmentReportRequest, OSPolicyAssignmentReport> getOSPolicyAssignmentReportSettings() {
        return this.getOSPolicyAssignmentReportSettings;
    }

    public PagedCallSettings<ListOSPolicyAssignmentReportsRequest, ListOSPolicyAssignmentReportsResponse, OsConfigZonalServiceClient.ListOSPolicyAssignmentReportsPagedResponse> listOSPolicyAssignmentReportsSettings() {
        return this.listOSPolicyAssignmentReportsSettings;
    }

    public UnaryCallSettings<GetInventoryRequest, Inventory> getInventorySettings() {
        return this.getInventorySettings;
    }

    public PagedCallSettings<ListInventoriesRequest, ListInventoriesResponse, OsConfigZonalServiceClient.ListInventoriesPagedResponse> listInventoriesSettings() {
        return this.listInventoriesSettings;
    }

    public UnaryCallSettings<GetVulnerabilityReportRequest, VulnerabilityReport> getVulnerabilityReportSettings() {
        return this.getVulnerabilityReportSettings;
    }

    public PagedCallSettings<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse, OsConfigZonalServiceClient.ListVulnerabilityReportsPagedResponse> listVulnerabilityReportsSettings() {
        return this.listVulnerabilityReportsSettings;
    }

    public OsConfigZonalServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcOsConfigZonalServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonOsConfigZonalServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return OsConfigZonalServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "osconfig";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "osconfig.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "osconfig.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return OsConfigZonalServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(OsConfigZonalServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(OsConfigZonalServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return OsConfigZonalServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected OsConfigZonalServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createOSPolicyAssignmentSettings = settingsBuilder.createOSPolicyAssignmentSettings().build();
        this.createOSPolicyAssignmentOperationSettings = settingsBuilder.createOSPolicyAssignmentOperationSettings().build();
        this.updateOSPolicyAssignmentSettings = settingsBuilder.updateOSPolicyAssignmentSettings().build();
        this.updateOSPolicyAssignmentOperationSettings = settingsBuilder.updateOSPolicyAssignmentOperationSettings().build();
        this.getOSPolicyAssignmentSettings = settingsBuilder.getOSPolicyAssignmentSettings().build();
        this.listOSPolicyAssignmentsSettings = settingsBuilder.listOSPolicyAssignmentsSettings().build();
        this.listOSPolicyAssignmentRevisionsSettings = settingsBuilder.listOSPolicyAssignmentRevisionsSettings().build();
        this.deleteOSPolicyAssignmentSettings = settingsBuilder.deleteOSPolicyAssignmentSettings().build();
        this.deleteOSPolicyAssignmentOperationSettings = settingsBuilder.deleteOSPolicyAssignmentOperationSettings().build();
        this.getInstanceOSPoliciesComplianceSettings = settingsBuilder.getInstanceOSPoliciesComplianceSettings().build();
        this.listInstanceOSPoliciesCompliancesSettings = settingsBuilder.listInstanceOSPoliciesCompliancesSettings().build();
        this.getOSPolicyAssignmentReportSettings = settingsBuilder.getOSPolicyAssignmentReportSettings().build();
        this.listOSPolicyAssignmentReportsSettings = settingsBuilder.listOSPolicyAssignmentReportsSettings().build();
        this.getInventorySettings = settingsBuilder.getInventorySettings().build();
        this.listInventoriesSettings = settingsBuilder.listInventoriesSettings().build();
        this.getVulnerabilityReportSettings = settingsBuilder.getVulnerabilityReportSettings().build();
        this.listVulnerabilityReportsSettings = settingsBuilder.listVulnerabilityReportsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<OsConfigZonalServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateOSPolicyAssignmentRequest, Operation> createOSPolicyAssignmentSettings;
        private final OperationCallSettings.Builder<CreateOSPolicyAssignmentRequest, OSPolicyAssignment, OSPolicyAssignmentOperationMetadata> createOSPolicyAssignmentOperationSettings;
        private final UnaryCallSettings.Builder<UpdateOSPolicyAssignmentRequest, Operation> updateOSPolicyAssignmentSettings;
        private final OperationCallSettings.Builder<UpdateOSPolicyAssignmentRequest, OSPolicyAssignment, OSPolicyAssignmentOperationMetadata> updateOSPolicyAssignmentOperationSettings;
        private final UnaryCallSettings.Builder<GetOSPolicyAssignmentRequest, OSPolicyAssignment> getOSPolicyAssignmentSettings;
        private final PagedCallSettings.Builder<ListOSPolicyAssignmentsRequest, ListOSPolicyAssignmentsResponse, OsConfigZonalServiceClient.ListOSPolicyAssignmentsPagedResponse> listOSPolicyAssignmentsSettings;
        private final PagedCallSettings.Builder<ListOSPolicyAssignmentRevisionsRequest, ListOSPolicyAssignmentRevisionsResponse, OsConfigZonalServiceClient.ListOSPolicyAssignmentRevisionsPagedResponse> listOSPolicyAssignmentRevisionsSettings;
        private final UnaryCallSettings.Builder<DeleteOSPolicyAssignmentRequest, Operation> deleteOSPolicyAssignmentSettings;
        private final OperationCallSettings.Builder<DeleteOSPolicyAssignmentRequest, Empty, OSPolicyAssignmentOperationMetadata> deleteOSPolicyAssignmentOperationSettings;
        private final UnaryCallSettings.Builder<GetInstanceOSPoliciesComplianceRequest, InstanceOSPoliciesCompliance> getInstanceOSPoliciesComplianceSettings;
        private final PagedCallSettings.Builder<ListInstanceOSPoliciesCompliancesRequest, ListInstanceOSPoliciesCompliancesResponse, OsConfigZonalServiceClient.ListInstanceOSPoliciesCompliancesPagedResponse> listInstanceOSPoliciesCompliancesSettings;
        private final UnaryCallSettings.Builder<GetOSPolicyAssignmentReportRequest, OSPolicyAssignmentReport> getOSPolicyAssignmentReportSettings;
        private final PagedCallSettings.Builder<ListOSPolicyAssignmentReportsRequest, ListOSPolicyAssignmentReportsResponse, OsConfigZonalServiceClient.ListOSPolicyAssignmentReportsPagedResponse> listOSPolicyAssignmentReportsSettings;
        private final UnaryCallSettings.Builder<GetInventoryRequest, Inventory> getInventorySettings;
        private final PagedCallSettings.Builder<ListInventoriesRequest, ListInventoriesResponse, OsConfigZonalServiceClient.ListInventoriesPagedResponse> listInventoriesSettings;
        private final UnaryCallSettings.Builder<GetVulnerabilityReportRequest, VulnerabilityReport> getVulnerabilityReportSettings;
        private final PagedCallSettings.Builder<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse, OsConfigZonalServiceClient.ListVulnerabilityReportsPagedResponse> listVulnerabilityReportsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createOSPolicyAssignmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createOSPolicyAssignmentOperationSettings = OperationCallSettings.newBuilder();
            this.updateOSPolicyAssignmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateOSPolicyAssignmentOperationSettings = OperationCallSettings.newBuilder();
            this.getOSPolicyAssignmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listOSPolicyAssignmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_O_S_POLICY_ASSIGNMENTS_PAGE_STR_FACT);
            this.listOSPolicyAssignmentRevisionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_O_S_POLICY_ASSIGNMENT_REVISIONS_PAGE_STR_FACT);
            this.deleteOSPolicyAssignmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOSPolicyAssignmentOperationSettings = OperationCallSettings.newBuilder();
            this.getInstanceOSPoliciesComplianceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listInstanceOSPoliciesCompliancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCE_O_S_POLICIES_COMPLIANCES_PAGE_STR_FACT);
            this.getOSPolicyAssignmentReportSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listOSPolicyAssignmentReportsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_O_S_POLICY_ASSIGNMENT_REPORTS_PAGE_STR_FACT);
            this.getInventorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listInventoriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INVENTORIES_PAGE_STR_FACT);
            this.getVulnerabilityReportSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listVulnerabilityReportsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_VULNERABILITY_REPORTS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createOSPolicyAssignmentSettings, this.updateOSPolicyAssignmentSettings, this.getOSPolicyAssignmentSettings, this.listOSPolicyAssignmentsSettings, this.listOSPolicyAssignmentRevisionsSettings, this.deleteOSPolicyAssignmentSettings, this.getInstanceOSPoliciesComplianceSettings, this.listInstanceOSPoliciesCompliancesSettings, this.getOSPolicyAssignmentReportSettings, this.listOSPolicyAssignmentReportsSettings, this.getInventorySettings, this.listInventoriesSettings, (Object[])new UnaryCallSettings.Builder[]{this.getVulnerabilityReportSettings, this.listVulnerabilityReportsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(OsConfigZonalServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createOSPolicyAssignmentSettings = settings.createOSPolicyAssignmentSettings.toBuilder();
            this.createOSPolicyAssignmentOperationSettings = settings.createOSPolicyAssignmentOperationSettings.toBuilder();
            this.updateOSPolicyAssignmentSettings = settings.updateOSPolicyAssignmentSettings.toBuilder();
            this.updateOSPolicyAssignmentOperationSettings = settings.updateOSPolicyAssignmentOperationSettings.toBuilder();
            this.getOSPolicyAssignmentSettings = settings.getOSPolicyAssignmentSettings.toBuilder();
            this.listOSPolicyAssignmentsSettings = settings.listOSPolicyAssignmentsSettings.toBuilder();
            this.listOSPolicyAssignmentRevisionsSettings = settings.listOSPolicyAssignmentRevisionsSettings.toBuilder();
            this.deleteOSPolicyAssignmentSettings = settings.deleteOSPolicyAssignmentSettings.toBuilder();
            this.deleteOSPolicyAssignmentOperationSettings = settings.deleteOSPolicyAssignmentOperationSettings.toBuilder();
            this.getInstanceOSPoliciesComplianceSettings = settings.getInstanceOSPoliciesComplianceSettings.toBuilder();
            this.listInstanceOSPoliciesCompliancesSettings = settings.listInstanceOSPoliciesCompliancesSettings.toBuilder();
            this.getOSPolicyAssignmentReportSettings = settings.getOSPolicyAssignmentReportSettings.toBuilder();
            this.listOSPolicyAssignmentReportsSettings = settings.listOSPolicyAssignmentReportsSettings.toBuilder();
            this.getInventorySettings = settings.getInventorySettings.toBuilder();
            this.listInventoriesSettings = settings.listInventoriesSettings.toBuilder();
            this.getVulnerabilityReportSettings = settings.getVulnerabilityReportSettings.toBuilder();
            this.listVulnerabilityReportsSettings = settings.listVulnerabilityReportsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createOSPolicyAssignmentSettings, this.updateOSPolicyAssignmentSettings, this.getOSPolicyAssignmentSettings, this.listOSPolicyAssignmentsSettings, this.listOSPolicyAssignmentRevisionsSettings, this.deleteOSPolicyAssignmentSettings, this.getInstanceOSPoliciesComplianceSettings, this.listInstanceOSPoliciesCompliancesSettings, this.getOSPolicyAssignmentReportSettings, this.listOSPolicyAssignmentReportsSettings, this.getInventorySettings, this.listInventoriesSettings, (Object[])new UnaryCallSettings.Builder[]{this.getVulnerabilityReportSettings, this.listVulnerabilityReportsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(OsConfigZonalServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)OsConfigZonalServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)OsConfigZonalServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(OsConfigZonalServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)OsConfigZonalServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)OsConfigZonalServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)OsConfigZonalServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(OsConfigZonalServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createOSPolicyAssignmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateOSPolicyAssignmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getOSPolicyAssignmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listOSPolicyAssignmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listOSPolicyAssignmentRevisionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteOSPolicyAssignmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getInstanceOSPoliciesComplianceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listInstanceOSPoliciesCompliancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getOSPolicyAssignmentReportSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listOSPolicyAssignmentReportsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getInventorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listInventoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getVulnerabilityReportSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listVulnerabilityReportsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createOSPolicyAssignmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(OSPolicyAssignment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OSPolicyAssignmentOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateOSPolicyAssignmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(OSPolicyAssignment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OSPolicyAssignmentOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteOSPolicyAssignmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OSPolicyAssignmentOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateOSPolicyAssignmentRequest, Operation> createOSPolicyAssignmentSettings() {
            return this.createOSPolicyAssignmentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateOSPolicyAssignmentRequest, OSPolicyAssignment, OSPolicyAssignmentOperationMetadata> createOSPolicyAssignmentOperationSettings() {
            return this.createOSPolicyAssignmentOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateOSPolicyAssignmentRequest, Operation> updateOSPolicyAssignmentSettings() {
            return this.updateOSPolicyAssignmentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateOSPolicyAssignmentRequest, OSPolicyAssignment, OSPolicyAssignmentOperationMetadata> updateOSPolicyAssignmentOperationSettings() {
            return this.updateOSPolicyAssignmentOperationSettings;
        }

        public UnaryCallSettings.Builder<GetOSPolicyAssignmentRequest, OSPolicyAssignment> getOSPolicyAssignmentSettings() {
            return this.getOSPolicyAssignmentSettings;
        }

        public PagedCallSettings.Builder<ListOSPolicyAssignmentsRequest, ListOSPolicyAssignmentsResponse, OsConfigZonalServiceClient.ListOSPolicyAssignmentsPagedResponse> listOSPolicyAssignmentsSettings() {
            return this.listOSPolicyAssignmentsSettings;
        }

        public PagedCallSettings.Builder<ListOSPolicyAssignmentRevisionsRequest, ListOSPolicyAssignmentRevisionsResponse, OsConfigZonalServiceClient.ListOSPolicyAssignmentRevisionsPagedResponse> listOSPolicyAssignmentRevisionsSettings() {
            return this.listOSPolicyAssignmentRevisionsSettings;
        }

        public UnaryCallSettings.Builder<DeleteOSPolicyAssignmentRequest, Operation> deleteOSPolicyAssignmentSettings() {
            return this.deleteOSPolicyAssignmentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteOSPolicyAssignmentRequest, Empty, OSPolicyAssignmentOperationMetadata> deleteOSPolicyAssignmentOperationSettings() {
            return this.deleteOSPolicyAssignmentOperationSettings;
        }

        @Deprecated
        public UnaryCallSettings.Builder<GetInstanceOSPoliciesComplianceRequest, InstanceOSPoliciesCompliance> getInstanceOSPoliciesComplianceSettings() {
            return this.getInstanceOSPoliciesComplianceSettings;
        }

        @Deprecated
        public PagedCallSettings.Builder<ListInstanceOSPoliciesCompliancesRequest, ListInstanceOSPoliciesCompliancesResponse, OsConfigZonalServiceClient.ListInstanceOSPoliciesCompliancesPagedResponse> listInstanceOSPoliciesCompliancesSettings() {
            return this.listInstanceOSPoliciesCompliancesSettings;
        }

        public UnaryCallSettings.Builder<GetOSPolicyAssignmentReportRequest, OSPolicyAssignmentReport> getOSPolicyAssignmentReportSettings() {
            return this.getOSPolicyAssignmentReportSettings;
        }

        public PagedCallSettings.Builder<ListOSPolicyAssignmentReportsRequest, ListOSPolicyAssignmentReportsResponse, OsConfigZonalServiceClient.ListOSPolicyAssignmentReportsPagedResponse> listOSPolicyAssignmentReportsSettings() {
            return this.listOSPolicyAssignmentReportsSettings;
        }

        public UnaryCallSettings.Builder<GetInventoryRequest, Inventory> getInventorySettings() {
            return this.getInventorySettings;
        }

        public PagedCallSettings.Builder<ListInventoriesRequest, ListInventoriesResponse, OsConfigZonalServiceClient.ListInventoriesPagedResponse> listInventoriesSettings() {
            return this.listInventoriesSettings;
        }

        public UnaryCallSettings.Builder<GetVulnerabilityReportRequest, VulnerabilityReport> getVulnerabilityReportSettings() {
            return this.getVulnerabilityReportSettings;
        }

        public PagedCallSettings.Builder<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse, OsConfigZonalServiceClient.ListVulnerabilityReportsPagedResponse> listVulnerabilityReportsSettings() {
            return this.listVulnerabilityReportsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return OsConfigZonalServiceStubSettings.getDefaultEndpoint();
        }

        public OsConfigZonalServiceStubSettings build() throws IOException {
            return new OsConfigZonalServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

