/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.osconfig.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.osconfig.v1.GetInventoryRequest;
import com.google.cloud.osconfig.v1.GetVulnerabilityReportRequest;
import com.google.cloud.osconfig.v1.Inventory;
import com.google.cloud.osconfig.v1.ListInventoriesRequest;
import com.google.cloud.osconfig.v1.ListInventoriesResponse;
import com.google.cloud.osconfig.v1.ListVulnerabilityReportsRequest;
import com.google.cloud.osconfig.v1.ListVulnerabilityReportsResponse;
import com.google.cloud.osconfig.v1.OsConfigZonalServiceClient;
import com.google.cloud.osconfig.v1.VulnerabilityReport;
import com.google.cloud.osconfig.v1.stub.GrpcOsConfigZonalServiceCallableFactory;
import com.google.cloud.osconfig.v1.stub.OsConfigZonalServiceStub;
import com.google.cloud.osconfig.v1.stub.OsConfigZonalServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcOsConfigZonalServiceStub
extends OsConfigZonalServiceStub {
    private static final MethodDescriptor<GetInventoryRequest, Inventory> getInventoryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.osconfig.v1.OsConfigZonalService/GetInventory").setRequestMarshaller(ProtoUtils.marshaller((Message)GetInventoryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Inventory.getDefaultInstance())).build();
    private static final MethodDescriptor<ListInventoriesRequest, ListInventoriesResponse> listInventoriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.osconfig.v1.OsConfigZonalService/ListInventories").setRequestMarshaller(ProtoUtils.marshaller((Message)ListInventoriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListInventoriesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetVulnerabilityReportRequest, VulnerabilityReport> getVulnerabilityReportMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.osconfig.v1.OsConfigZonalService/GetVulnerabilityReport").setRequestMarshaller(ProtoUtils.marshaller((Message)GetVulnerabilityReportRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)VulnerabilityReport.getDefaultInstance())).build();
    private static final MethodDescriptor<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse> listVulnerabilityReportsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.osconfig.v1.OsConfigZonalService/ListVulnerabilityReports").setRequestMarshaller(ProtoUtils.marshaller((Message)ListVulnerabilityReportsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListVulnerabilityReportsResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetInventoryRequest, Inventory> getInventoryCallable;
    private final UnaryCallable<ListInventoriesRequest, ListInventoriesResponse> listInventoriesCallable;
    private final UnaryCallable<ListInventoriesRequest, OsConfigZonalServiceClient.ListInventoriesPagedResponse> listInventoriesPagedCallable;
    private final UnaryCallable<GetVulnerabilityReportRequest, VulnerabilityReport> getVulnerabilityReportCallable;
    private final UnaryCallable<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse> listVulnerabilityReportsCallable;
    private final UnaryCallable<ListVulnerabilityReportsRequest, OsConfigZonalServiceClient.ListVulnerabilityReportsPagedResponse> listVulnerabilityReportsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcOsConfigZonalServiceStub create(OsConfigZonalServiceStubSettings settings) throws IOException {
        return new GrpcOsConfigZonalServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcOsConfigZonalServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcOsConfigZonalServiceStub(OsConfigZonalServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcOsConfigZonalServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcOsConfigZonalServiceStub(OsConfigZonalServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcOsConfigZonalServiceStub(OsConfigZonalServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcOsConfigZonalServiceCallableFactory());
    }

    protected GrpcOsConfigZonalServiceStub(OsConfigZonalServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getInventoryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getInventoryMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listInventoriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listInventoriesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getVulnerabilityReportTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getVulnerabilityReportMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listVulnerabilityReportsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listVulnerabilityReportsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        this.getInventoryCallable = callableFactory.createUnaryCallable(getInventoryTransportSettings, settings.getInventorySettings(), clientContext);
        this.listInventoriesCallable = callableFactory.createUnaryCallable(listInventoriesTransportSettings, settings.listInventoriesSettings(), clientContext);
        this.listInventoriesPagedCallable = callableFactory.createPagedCallable(listInventoriesTransportSettings, settings.listInventoriesSettings(), clientContext);
        this.getVulnerabilityReportCallable = callableFactory.createUnaryCallable(getVulnerabilityReportTransportSettings, settings.getVulnerabilityReportSettings(), clientContext);
        this.listVulnerabilityReportsCallable = callableFactory.createUnaryCallable(listVulnerabilityReportsTransportSettings, settings.listVulnerabilityReportsSettings(), clientContext);
        this.listVulnerabilityReportsPagedCallable = callableFactory.createPagedCallable(listVulnerabilityReportsTransportSettings, settings.listVulnerabilityReportsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetInventoryRequest, Inventory> getInventoryCallable() {
        return this.getInventoryCallable;
    }

    @Override
    public UnaryCallable<ListInventoriesRequest, ListInventoriesResponse> listInventoriesCallable() {
        return this.listInventoriesCallable;
    }

    @Override
    public UnaryCallable<ListInventoriesRequest, OsConfigZonalServiceClient.ListInventoriesPagedResponse> listInventoriesPagedCallable() {
        return this.listInventoriesPagedCallable;
    }

    @Override
    public UnaryCallable<GetVulnerabilityReportRequest, VulnerabilityReport> getVulnerabilityReportCallable() {
        return this.getVulnerabilityReportCallable;
    }

    @Override
    public UnaryCallable<ListVulnerabilityReportsRequest, ListVulnerabilityReportsResponse> listVulnerabilityReportsCallable() {
        return this.listVulnerabilityReportsCallable;
    }

    @Override
    public UnaryCallable<ListVulnerabilityReportsRequest, OsConfigZonalServiceClient.ListVulnerabilityReportsPagedResponse> listVulnerabilityReportsPagedCallable() {
        return this.listVulnerabilityReportsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

