/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.orchestration.airflow.service.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.orchestration.airflow.service.v1.CheckUpgradeRequest;
import com.google.cloud.orchestration.airflow.service.v1.CheckUpgradeResponse;
import com.google.cloud.orchestration.airflow.service.v1.CreateEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1.CreateUserWorkloadsConfigMapRequest;
import com.google.cloud.orchestration.airflow.service.v1.CreateUserWorkloadsSecretRequest;
import com.google.cloud.orchestration.airflow.service.v1.DatabaseFailoverRequest;
import com.google.cloud.orchestration.airflow.service.v1.DatabaseFailoverResponse;
import com.google.cloud.orchestration.airflow.service.v1.DeleteEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1.DeleteUserWorkloadsConfigMapRequest;
import com.google.cloud.orchestration.airflow.service.v1.DeleteUserWorkloadsSecretRequest;
import com.google.cloud.orchestration.airflow.service.v1.Environment;
import com.google.cloud.orchestration.airflow.service.v1.EnvironmentName;
import com.google.cloud.orchestration.airflow.service.v1.EnvironmentsSettings;
import com.google.cloud.orchestration.airflow.service.v1.ExecuteAirflowCommandRequest;
import com.google.cloud.orchestration.airflow.service.v1.ExecuteAirflowCommandResponse;
import com.google.cloud.orchestration.airflow.service.v1.FetchDatabasePropertiesRequest;
import com.google.cloud.orchestration.airflow.service.v1.FetchDatabasePropertiesResponse;
import com.google.cloud.orchestration.airflow.service.v1.GetEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1.GetUserWorkloadsConfigMapRequest;
import com.google.cloud.orchestration.airflow.service.v1.GetUserWorkloadsSecretRequest;
import com.google.cloud.orchestration.airflow.service.v1.ListEnvironmentsRequest;
import com.google.cloud.orchestration.airflow.service.v1.ListEnvironmentsResponse;
import com.google.cloud.orchestration.airflow.service.v1.ListUserWorkloadsConfigMapsRequest;
import com.google.cloud.orchestration.airflow.service.v1.ListUserWorkloadsConfigMapsResponse;
import com.google.cloud.orchestration.airflow.service.v1.ListUserWorkloadsSecretsRequest;
import com.google.cloud.orchestration.airflow.service.v1.ListUserWorkloadsSecretsResponse;
import com.google.cloud.orchestration.airflow.service.v1.ListWorkloadsRequest;
import com.google.cloud.orchestration.airflow.service.v1.ListWorkloadsResponse;
import com.google.cloud.orchestration.airflow.service.v1.LoadSnapshotRequest;
import com.google.cloud.orchestration.airflow.service.v1.LoadSnapshotResponse;
import com.google.cloud.orchestration.airflow.service.v1.OperationMetadata;
import com.google.cloud.orchestration.airflow.service.v1.PollAirflowCommandRequest;
import com.google.cloud.orchestration.airflow.service.v1.PollAirflowCommandResponse;
import com.google.cloud.orchestration.airflow.service.v1.SaveSnapshotRequest;
import com.google.cloud.orchestration.airflow.service.v1.SaveSnapshotResponse;
import com.google.cloud.orchestration.airflow.service.v1.StopAirflowCommandRequest;
import com.google.cloud.orchestration.airflow.service.v1.StopAirflowCommandResponse;
import com.google.cloud.orchestration.airflow.service.v1.UpdateEnvironmentRequest;
import com.google.cloud.orchestration.airflow.service.v1.UpdateUserWorkloadsConfigMapRequest;
import com.google.cloud.orchestration.airflow.service.v1.UpdateUserWorkloadsSecretRequest;
import com.google.cloud.orchestration.airflow.service.v1.UserWorkloadsConfigMap;
import com.google.cloud.orchestration.airflow.service.v1.UserWorkloadsConfigMapName;
import com.google.cloud.orchestration.airflow.service.v1.UserWorkloadsSecret;
import com.google.cloud.orchestration.airflow.service.v1.UserWorkloadsSecretName;
import com.google.cloud.orchestration.airflow.service.v1.stub.EnvironmentsStub;
import com.google.cloud.orchestration.airflow.service.v1.stub.EnvironmentsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class EnvironmentsClient
implements BackgroundResource {
    private final EnvironmentsSettings settings;
    private final EnvironmentsStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final EnvironmentsClient create() throws IOException {
        return EnvironmentsClient.create(EnvironmentsSettings.newBuilder().build());
    }

    public static final EnvironmentsClient create(EnvironmentsSettings settings) throws IOException {
        return new EnvironmentsClient(settings);
    }

    public static final EnvironmentsClient create(EnvironmentsStub stub) {
        return new EnvironmentsClient(stub);
    }

    protected EnvironmentsClient(EnvironmentsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EnvironmentsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected EnvironmentsClient(EnvironmentsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final EnvironmentsSettings getSettings() {
        return this.settings;
    }

    public EnvironmentsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<Environment, OperationMetadata> createEnvironmentAsync(String parent, Environment environment) {
        CreateEnvironmentRequest request = CreateEnvironmentRequest.newBuilder().setParent(parent).setEnvironment(environment).build();
        return this.createEnvironmentAsync(request);
    }

    public final OperationFuture<Environment, OperationMetadata> createEnvironmentAsync(CreateEnvironmentRequest request) {
        return this.createEnvironmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationCallable() {
        return this.stub.createEnvironmentOperationCallable();
    }

    public final UnaryCallable<CreateEnvironmentRequest, Operation> createEnvironmentCallable() {
        return this.stub.createEnvironmentCallable();
    }

    public final Environment getEnvironment(String name) {
        GetEnvironmentRequest request = GetEnvironmentRequest.newBuilder().setName(name).build();
        return this.getEnvironment(request);
    }

    public final Environment getEnvironment(GetEnvironmentRequest request) {
        return (Environment)this.getEnvironmentCallable().call((Object)request);
    }

    public final UnaryCallable<GetEnvironmentRequest, Environment> getEnvironmentCallable() {
        return this.stub.getEnvironmentCallable();
    }

    public final ListEnvironmentsPagedResponse listEnvironments(String parent) {
        ListEnvironmentsRequest request = ListEnvironmentsRequest.newBuilder().setParent(parent).build();
        return this.listEnvironments(request);
    }

    public final ListEnvironmentsPagedResponse listEnvironments(ListEnvironmentsRequest request) {
        return (ListEnvironmentsPagedResponse)((Object)this.listEnvironmentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsPagedResponse> listEnvironmentsPagedCallable() {
        return this.stub.listEnvironmentsPagedCallable();
    }

    public final UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsResponse> listEnvironmentsCallable() {
        return this.stub.listEnvironmentsCallable();
    }

    public final OperationFuture<Environment, OperationMetadata> updateEnvironmentAsync(String name, Environment environment, FieldMask updateMask) {
        UpdateEnvironmentRequest request = UpdateEnvironmentRequest.newBuilder().setName(name).setEnvironment(environment).setUpdateMask(updateMask).build();
        return this.updateEnvironmentAsync(request);
    }

    public final OperationFuture<Environment, OperationMetadata> updateEnvironmentAsync(UpdateEnvironmentRequest request) {
        return this.updateEnvironmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateEnvironmentRequest, Environment, OperationMetadata> updateEnvironmentOperationCallable() {
        return this.stub.updateEnvironmentOperationCallable();
    }

    public final UnaryCallable<UpdateEnvironmentRequest, Operation> updateEnvironmentCallable() {
        return this.stub.updateEnvironmentCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEnvironmentAsync(String name) {
        DeleteEnvironmentRequest request = DeleteEnvironmentRequest.newBuilder().setName(name).build();
        return this.deleteEnvironmentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEnvironmentAsync(DeleteEnvironmentRequest request) {
        return this.deleteEnvironmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationCallable() {
        return this.stub.deleteEnvironmentOperationCallable();
    }

    public final UnaryCallable<DeleteEnvironmentRequest, Operation> deleteEnvironmentCallable() {
        return this.stub.deleteEnvironmentCallable();
    }

    public final ExecuteAirflowCommandResponse executeAirflowCommand(ExecuteAirflowCommandRequest request) {
        return (ExecuteAirflowCommandResponse)this.executeAirflowCommandCallable().call((Object)request);
    }

    public final UnaryCallable<ExecuteAirflowCommandRequest, ExecuteAirflowCommandResponse> executeAirflowCommandCallable() {
        return this.stub.executeAirflowCommandCallable();
    }

    public final StopAirflowCommandResponse stopAirflowCommand(StopAirflowCommandRequest request) {
        return (StopAirflowCommandResponse)this.stopAirflowCommandCallable().call((Object)request);
    }

    public final UnaryCallable<StopAirflowCommandRequest, StopAirflowCommandResponse> stopAirflowCommandCallable() {
        return this.stub.stopAirflowCommandCallable();
    }

    public final PollAirflowCommandResponse pollAirflowCommand(PollAirflowCommandRequest request) {
        return (PollAirflowCommandResponse)this.pollAirflowCommandCallable().call((Object)request);
    }

    public final UnaryCallable<PollAirflowCommandRequest, PollAirflowCommandResponse> pollAirflowCommandCallable() {
        return this.stub.pollAirflowCommandCallable();
    }

    public final ListWorkloadsPagedResponse listWorkloads(EnvironmentName parent) {
        ListWorkloadsRequest request = ListWorkloadsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listWorkloads(request);
    }

    public final ListWorkloadsPagedResponse listWorkloads(String parent) {
        ListWorkloadsRequest request = ListWorkloadsRequest.newBuilder().setParent(parent).build();
        return this.listWorkloads(request);
    }

    public final ListWorkloadsPagedResponse listWorkloads(ListWorkloadsRequest request) {
        return (ListWorkloadsPagedResponse)((Object)this.listWorkloadsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWorkloadsRequest, ListWorkloadsPagedResponse> listWorkloadsPagedCallable() {
        return this.stub.listWorkloadsPagedCallable();
    }

    public final UnaryCallable<ListWorkloadsRequest, ListWorkloadsResponse> listWorkloadsCallable() {
        return this.stub.listWorkloadsCallable();
    }

    public final OperationFuture<CheckUpgradeResponse, OperationMetadata> checkUpgradeAsync(CheckUpgradeRequest request) {
        return this.checkUpgradeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CheckUpgradeRequest, CheckUpgradeResponse, OperationMetadata> checkUpgradeOperationCallable() {
        return this.stub.checkUpgradeOperationCallable();
    }

    public final UnaryCallable<CheckUpgradeRequest, Operation> checkUpgradeCallable() {
        return this.stub.checkUpgradeCallable();
    }

    public final UserWorkloadsSecret createUserWorkloadsSecret(EnvironmentName parent, UserWorkloadsSecret userWorkloadsSecret) {
        CreateUserWorkloadsSecretRequest request = CreateUserWorkloadsSecretRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setUserWorkloadsSecret(userWorkloadsSecret).build();
        return this.createUserWorkloadsSecret(request);
    }

    public final UserWorkloadsSecret createUserWorkloadsSecret(String parent, UserWorkloadsSecret userWorkloadsSecret) {
        CreateUserWorkloadsSecretRequest request = CreateUserWorkloadsSecretRequest.newBuilder().setParent(parent).setUserWorkloadsSecret(userWorkloadsSecret).build();
        return this.createUserWorkloadsSecret(request);
    }

    public final UserWorkloadsSecret createUserWorkloadsSecret(CreateUserWorkloadsSecretRequest request) {
        return (UserWorkloadsSecret)this.createUserWorkloadsSecretCallable().call((Object)request);
    }

    public final UnaryCallable<CreateUserWorkloadsSecretRequest, UserWorkloadsSecret> createUserWorkloadsSecretCallable() {
        return this.stub.createUserWorkloadsSecretCallable();
    }

    public final UserWorkloadsSecret getUserWorkloadsSecret(UserWorkloadsSecretName name) {
        GetUserWorkloadsSecretRequest request = GetUserWorkloadsSecretRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getUserWorkloadsSecret(request);
    }

    public final UserWorkloadsSecret getUserWorkloadsSecret(String name) {
        GetUserWorkloadsSecretRequest request = GetUserWorkloadsSecretRequest.newBuilder().setName(name).build();
        return this.getUserWorkloadsSecret(request);
    }

    public final UserWorkloadsSecret getUserWorkloadsSecret(GetUserWorkloadsSecretRequest request) {
        return (UserWorkloadsSecret)this.getUserWorkloadsSecretCallable().call((Object)request);
    }

    public final UnaryCallable<GetUserWorkloadsSecretRequest, UserWorkloadsSecret> getUserWorkloadsSecretCallable() {
        return this.stub.getUserWorkloadsSecretCallable();
    }

    public final ListUserWorkloadsSecretsPagedResponse listUserWorkloadsSecrets(EnvironmentName parent) {
        ListUserWorkloadsSecretsRequest request = ListUserWorkloadsSecretsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listUserWorkloadsSecrets(request);
    }

    public final ListUserWorkloadsSecretsPagedResponse listUserWorkloadsSecrets(String parent) {
        ListUserWorkloadsSecretsRequest request = ListUserWorkloadsSecretsRequest.newBuilder().setParent(parent).build();
        return this.listUserWorkloadsSecrets(request);
    }

    public final ListUserWorkloadsSecretsPagedResponse listUserWorkloadsSecrets(ListUserWorkloadsSecretsRequest request) {
        return (ListUserWorkloadsSecretsPagedResponse)((Object)this.listUserWorkloadsSecretsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListUserWorkloadsSecretsRequest, ListUserWorkloadsSecretsPagedResponse> listUserWorkloadsSecretsPagedCallable() {
        return this.stub.listUserWorkloadsSecretsPagedCallable();
    }

    public final UnaryCallable<ListUserWorkloadsSecretsRequest, ListUserWorkloadsSecretsResponse> listUserWorkloadsSecretsCallable() {
        return this.stub.listUserWorkloadsSecretsCallable();
    }

    public final UserWorkloadsSecret updateUserWorkloadsSecret(UserWorkloadsSecret userWorkloadsSecret) {
        UpdateUserWorkloadsSecretRequest request = UpdateUserWorkloadsSecretRequest.newBuilder().setUserWorkloadsSecret(userWorkloadsSecret).build();
        return this.updateUserWorkloadsSecret(request);
    }

    public final UserWorkloadsSecret updateUserWorkloadsSecret(UpdateUserWorkloadsSecretRequest request) {
        return (UserWorkloadsSecret)this.updateUserWorkloadsSecretCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateUserWorkloadsSecretRequest, UserWorkloadsSecret> updateUserWorkloadsSecretCallable() {
        return this.stub.updateUserWorkloadsSecretCallable();
    }

    public final void deleteUserWorkloadsSecret(UserWorkloadsSecretName name) {
        DeleteUserWorkloadsSecretRequest request = DeleteUserWorkloadsSecretRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteUserWorkloadsSecret(request);
    }

    public final void deleteUserWorkloadsSecret(String name) {
        DeleteUserWorkloadsSecretRequest request = DeleteUserWorkloadsSecretRequest.newBuilder().setName(name).build();
        this.deleteUserWorkloadsSecret(request);
    }

    public final void deleteUserWorkloadsSecret(DeleteUserWorkloadsSecretRequest request) {
        this.deleteUserWorkloadsSecretCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteUserWorkloadsSecretRequest, Empty> deleteUserWorkloadsSecretCallable() {
        return this.stub.deleteUserWorkloadsSecretCallable();
    }

    public final UserWorkloadsConfigMap createUserWorkloadsConfigMap(EnvironmentName parent, UserWorkloadsConfigMap userWorkloadsConfigMap) {
        CreateUserWorkloadsConfigMapRequest request = CreateUserWorkloadsConfigMapRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setUserWorkloadsConfigMap(userWorkloadsConfigMap).build();
        return this.createUserWorkloadsConfigMap(request);
    }

    public final UserWorkloadsConfigMap createUserWorkloadsConfigMap(String parent, UserWorkloadsConfigMap userWorkloadsConfigMap) {
        CreateUserWorkloadsConfigMapRequest request = CreateUserWorkloadsConfigMapRequest.newBuilder().setParent(parent).setUserWorkloadsConfigMap(userWorkloadsConfigMap).build();
        return this.createUserWorkloadsConfigMap(request);
    }

    public final UserWorkloadsConfigMap createUserWorkloadsConfigMap(CreateUserWorkloadsConfigMapRequest request) {
        return (UserWorkloadsConfigMap)this.createUserWorkloadsConfigMapCallable().call((Object)request);
    }

    public final UnaryCallable<CreateUserWorkloadsConfigMapRequest, UserWorkloadsConfigMap> createUserWorkloadsConfigMapCallable() {
        return this.stub.createUserWorkloadsConfigMapCallable();
    }

    public final UserWorkloadsConfigMap getUserWorkloadsConfigMap(UserWorkloadsConfigMapName name) {
        GetUserWorkloadsConfigMapRequest request = GetUserWorkloadsConfigMapRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getUserWorkloadsConfigMap(request);
    }

    public final UserWorkloadsConfigMap getUserWorkloadsConfigMap(String name) {
        GetUserWorkloadsConfigMapRequest request = GetUserWorkloadsConfigMapRequest.newBuilder().setName(name).build();
        return this.getUserWorkloadsConfigMap(request);
    }

    public final UserWorkloadsConfigMap getUserWorkloadsConfigMap(GetUserWorkloadsConfigMapRequest request) {
        return (UserWorkloadsConfigMap)this.getUserWorkloadsConfigMapCallable().call((Object)request);
    }

    public final UnaryCallable<GetUserWorkloadsConfigMapRequest, UserWorkloadsConfigMap> getUserWorkloadsConfigMapCallable() {
        return this.stub.getUserWorkloadsConfigMapCallable();
    }

    public final ListUserWorkloadsConfigMapsPagedResponse listUserWorkloadsConfigMaps(EnvironmentName parent) {
        ListUserWorkloadsConfigMapsRequest request = ListUserWorkloadsConfigMapsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listUserWorkloadsConfigMaps(request);
    }

    public final ListUserWorkloadsConfigMapsPagedResponse listUserWorkloadsConfigMaps(String parent) {
        ListUserWorkloadsConfigMapsRequest request = ListUserWorkloadsConfigMapsRequest.newBuilder().setParent(parent).build();
        return this.listUserWorkloadsConfigMaps(request);
    }

    public final ListUserWorkloadsConfigMapsPagedResponse listUserWorkloadsConfigMaps(ListUserWorkloadsConfigMapsRequest request) {
        return (ListUserWorkloadsConfigMapsPagedResponse)((Object)this.listUserWorkloadsConfigMapsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListUserWorkloadsConfigMapsRequest, ListUserWorkloadsConfigMapsPagedResponse> listUserWorkloadsConfigMapsPagedCallable() {
        return this.stub.listUserWorkloadsConfigMapsPagedCallable();
    }

    public final UnaryCallable<ListUserWorkloadsConfigMapsRequest, ListUserWorkloadsConfigMapsResponse> listUserWorkloadsConfigMapsCallable() {
        return this.stub.listUserWorkloadsConfigMapsCallable();
    }

    public final UserWorkloadsConfigMap updateUserWorkloadsConfigMap(UserWorkloadsConfigMap userWorkloadsConfigMap) {
        UpdateUserWorkloadsConfigMapRequest request = UpdateUserWorkloadsConfigMapRequest.newBuilder().setUserWorkloadsConfigMap(userWorkloadsConfigMap).build();
        return this.updateUserWorkloadsConfigMap(request);
    }

    public final UserWorkloadsConfigMap updateUserWorkloadsConfigMap(UpdateUserWorkloadsConfigMapRequest request) {
        return (UserWorkloadsConfigMap)this.updateUserWorkloadsConfigMapCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateUserWorkloadsConfigMapRequest, UserWorkloadsConfigMap> updateUserWorkloadsConfigMapCallable() {
        return this.stub.updateUserWorkloadsConfigMapCallable();
    }

    public final void deleteUserWorkloadsConfigMap(UserWorkloadsConfigMapName name) {
        DeleteUserWorkloadsConfigMapRequest request = DeleteUserWorkloadsConfigMapRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteUserWorkloadsConfigMap(request);
    }

    public final void deleteUserWorkloadsConfigMap(String name) {
        DeleteUserWorkloadsConfigMapRequest request = DeleteUserWorkloadsConfigMapRequest.newBuilder().setName(name).build();
        this.deleteUserWorkloadsConfigMap(request);
    }

    public final void deleteUserWorkloadsConfigMap(DeleteUserWorkloadsConfigMapRequest request) {
        this.deleteUserWorkloadsConfigMapCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteUserWorkloadsConfigMapRequest, Empty> deleteUserWorkloadsConfigMapCallable() {
        return this.stub.deleteUserWorkloadsConfigMapCallable();
    }

    public final OperationFuture<SaveSnapshotResponse, OperationMetadata> saveSnapshotAsync(SaveSnapshotRequest request) {
        return this.saveSnapshotOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SaveSnapshotRequest, SaveSnapshotResponse, OperationMetadata> saveSnapshotOperationCallable() {
        return this.stub.saveSnapshotOperationCallable();
    }

    public final UnaryCallable<SaveSnapshotRequest, Operation> saveSnapshotCallable() {
        return this.stub.saveSnapshotCallable();
    }

    public final OperationFuture<LoadSnapshotResponse, OperationMetadata> loadSnapshotAsync(LoadSnapshotRequest request) {
        return this.loadSnapshotOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<LoadSnapshotRequest, LoadSnapshotResponse, OperationMetadata> loadSnapshotOperationCallable() {
        return this.stub.loadSnapshotOperationCallable();
    }

    public final UnaryCallable<LoadSnapshotRequest, Operation> loadSnapshotCallable() {
        return this.stub.loadSnapshotCallable();
    }

    public final OperationFuture<DatabaseFailoverResponse, OperationMetadata> databaseFailoverAsync(DatabaseFailoverRequest request) {
        return this.databaseFailoverOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DatabaseFailoverRequest, DatabaseFailoverResponse, OperationMetadata> databaseFailoverOperationCallable() {
        return this.stub.databaseFailoverOperationCallable();
    }

    public final UnaryCallable<DatabaseFailoverRequest, Operation> databaseFailoverCallable() {
        return this.stub.databaseFailoverCallable();
    }

    public final FetchDatabasePropertiesResponse fetchDatabaseProperties(FetchDatabasePropertiesRequest request) {
        return (FetchDatabasePropertiesResponse)this.fetchDatabasePropertiesCallable().call((Object)request);
    }

    public final UnaryCallable<FetchDatabasePropertiesRequest, FetchDatabasePropertiesResponse> fetchDatabasePropertiesCallable() {
        return this.stub.fetchDatabasePropertiesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListUserWorkloadsConfigMapsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListUserWorkloadsConfigMapsRequest, ListUserWorkloadsConfigMapsResponse, UserWorkloadsConfigMap, ListUserWorkloadsConfigMapsPage, ListUserWorkloadsConfigMapsFixedSizeCollection> {
        private ListUserWorkloadsConfigMapsFixedSizeCollection(List<ListUserWorkloadsConfigMapsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListUserWorkloadsConfigMapsFixedSizeCollection createEmptyCollection() {
            return new ListUserWorkloadsConfigMapsFixedSizeCollection(null, 0);
        }

        protected ListUserWorkloadsConfigMapsFixedSizeCollection createCollection(List<ListUserWorkloadsConfigMapsPage> pages, int collectionSize) {
            return new ListUserWorkloadsConfigMapsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListUserWorkloadsConfigMapsPage
    extends AbstractPage<ListUserWorkloadsConfigMapsRequest, ListUserWorkloadsConfigMapsResponse, UserWorkloadsConfigMap, ListUserWorkloadsConfigMapsPage> {
        private ListUserWorkloadsConfigMapsPage(PageContext<ListUserWorkloadsConfigMapsRequest, ListUserWorkloadsConfigMapsResponse, UserWorkloadsConfigMap> context, ListUserWorkloadsConfigMapsResponse response) {
            super(context, (Object)response);
        }

        private static ListUserWorkloadsConfigMapsPage createEmptyPage() {
            return new ListUserWorkloadsConfigMapsPage(null, null);
        }

        protected ListUserWorkloadsConfigMapsPage createPage(PageContext<ListUserWorkloadsConfigMapsRequest, ListUserWorkloadsConfigMapsResponse, UserWorkloadsConfigMap> context, ListUserWorkloadsConfigMapsResponse response) {
            return new ListUserWorkloadsConfigMapsPage(context, response);
        }

        public ApiFuture<ListUserWorkloadsConfigMapsPage> createPageAsync(PageContext<ListUserWorkloadsConfigMapsRequest, ListUserWorkloadsConfigMapsResponse, UserWorkloadsConfigMap> context, ApiFuture<ListUserWorkloadsConfigMapsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListUserWorkloadsConfigMapsPagedResponse
    extends AbstractPagedListResponse<ListUserWorkloadsConfigMapsRequest, ListUserWorkloadsConfigMapsResponse, UserWorkloadsConfigMap, ListUserWorkloadsConfigMapsPage, ListUserWorkloadsConfigMapsFixedSizeCollection> {
        public static ApiFuture<ListUserWorkloadsConfigMapsPagedResponse> createAsync(PageContext<ListUserWorkloadsConfigMapsRequest, ListUserWorkloadsConfigMapsResponse, UserWorkloadsConfigMap> context, ApiFuture<ListUserWorkloadsConfigMapsResponse> futureResponse) {
            ApiFuture<ListUserWorkloadsConfigMapsPage> futurePage = ListUserWorkloadsConfigMapsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListUserWorkloadsConfigMapsPagedResponse((ListUserWorkloadsConfigMapsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListUserWorkloadsConfigMapsPagedResponse(ListUserWorkloadsConfigMapsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListUserWorkloadsConfigMapsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListUserWorkloadsSecretsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListUserWorkloadsSecretsRequest, ListUserWorkloadsSecretsResponse, UserWorkloadsSecret, ListUserWorkloadsSecretsPage, ListUserWorkloadsSecretsFixedSizeCollection> {
        private ListUserWorkloadsSecretsFixedSizeCollection(List<ListUserWorkloadsSecretsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListUserWorkloadsSecretsFixedSizeCollection createEmptyCollection() {
            return new ListUserWorkloadsSecretsFixedSizeCollection(null, 0);
        }

        protected ListUserWorkloadsSecretsFixedSizeCollection createCollection(List<ListUserWorkloadsSecretsPage> pages, int collectionSize) {
            return new ListUserWorkloadsSecretsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListUserWorkloadsSecretsPage
    extends AbstractPage<ListUserWorkloadsSecretsRequest, ListUserWorkloadsSecretsResponse, UserWorkloadsSecret, ListUserWorkloadsSecretsPage> {
        private ListUserWorkloadsSecretsPage(PageContext<ListUserWorkloadsSecretsRequest, ListUserWorkloadsSecretsResponse, UserWorkloadsSecret> context, ListUserWorkloadsSecretsResponse response) {
            super(context, (Object)response);
        }

        private static ListUserWorkloadsSecretsPage createEmptyPage() {
            return new ListUserWorkloadsSecretsPage(null, null);
        }

        protected ListUserWorkloadsSecretsPage createPage(PageContext<ListUserWorkloadsSecretsRequest, ListUserWorkloadsSecretsResponse, UserWorkloadsSecret> context, ListUserWorkloadsSecretsResponse response) {
            return new ListUserWorkloadsSecretsPage(context, response);
        }

        public ApiFuture<ListUserWorkloadsSecretsPage> createPageAsync(PageContext<ListUserWorkloadsSecretsRequest, ListUserWorkloadsSecretsResponse, UserWorkloadsSecret> context, ApiFuture<ListUserWorkloadsSecretsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListUserWorkloadsSecretsPagedResponse
    extends AbstractPagedListResponse<ListUserWorkloadsSecretsRequest, ListUserWorkloadsSecretsResponse, UserWorkloadsSecret, ListUserWorkloadsSecretsPage, ListUserWorkloadsSecretsFixedSizeCollection> {
        public static ApiFuture<ListUserWorkloadsSecretsPagedResponse> createAsync(PageContext<ListUserWorkloadsSecretsRequest, ListUserWorkloadsSecretsResponse, UserWorkloadsSecret> context, ApiFuture<ListUserWorkloadsSecretsResponse> futureResponse) {
            ApiFuture<ListUserWorkloadsSecretsPage> futurePage = ListUserWorkloadsSecretsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListUserWorkloadsSecretsPagedResponse((ListUserWorkloadsSecretsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListUserWorkloadsSecretsPagedResponse(ListUserWorkloadsSecretsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListUserWorkloadsSecretsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListWorkloadsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWorkloadsRequest, ListWorkloadsResponse, ListWorkloadsResponse.ComposerWorkload, ListWorkloadsPage, ListWorkloadsFixedSizeCollection> {
        private ListWorkloadsFixedSizeCollection(List<ListWorkloadsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListWorkloadsFixedSizeCollection createEmptyCollection() {
            return new ListWorkloadsFixedSizeCollection(null, 0);
        }

        protected ListWorkloadsFixedSizeCollection createCollection(List<ListWorkloadsPage> pages, int collectionSize) {
            return new ListWorkloadsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListWorkloadsPage
    extends AbstractPage<ListWorkloadsRequest, ListWorkloadsResponse, ListWorkloadsResponse.ComposerWorkload, ListWorkloadsPage> {
        private ListWorkloadsPage(PageContext<ListWorkloadsRequest, ListWorkloadsResponse, ListWorkloadsResponse.ComposerWorkload> context, ListWorkloadsResponse response) {
            super(context, (Object)response);
        }

        private static ListWorkloadsPage createEmptyPage() {
            return new ListWorkloadsPage(null, null);
        }

        protected ListWorkloadsPage createPage(PageContext<ListWorkloadsRequest, ListWorkloadsResponse, ListWorkloadsResponse.ComposerWorkload> context, ListWorkloadsResponse response) {
            return new ListWorkloadsPage(context, response);
        }

        public ApiFuture<ListWorkloadsPage> createPageAsync(PageContext<ListWorkloadsRequest, ListWorkloadsResponse, ListWorkloadsResponse.ComposerWorkload> context, ApiFuture<ListWorkloadsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListWorkloadsPagedResponse
    extends AbstractPagedListResponse<ListWorkloadsRequest, ListWorkloadsResponse, ListWorkloadsResponse.ComposerWorkload, ListWorkloadsPage, ListWorkloadsFixedSizeCollection> {
        public static ApiFuture<ListWorkloadsPagedResponse> createAsync(PageContext<ListWorkloadsRequest, ListWorkloadsResponse, ListWorkloadsResponse.ComposerWorkload> context, ApiFuture<ListWorkloadsResponse> futureResponse) {
            ApiFuture<ListWorkloadsPage> futurePage = ListWorkloadsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListWorkloadsPagedResponse((ListWorkloadsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListWorkloadsPagedResponse(ListWorkloadsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListWorkloadsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEnvironmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment, ListEnvironmentsPage, ListEnvironmentsFixedSizeCollection> {
        private ListEnvironmentsFixedSizeCollection(List<ListEnvironmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEnvironmentsFixedSizeCollection createEmptyCollection() {
            return new ListEnvironmentsFixedSizeCollection(null, 0);
        }

        protected ListEnvironmentsFixedSizeCollection createCollection(List<ListEnvironmentsPage> pages, int collectionSize) {
            return new ListEnvironmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEnvironmentsPage
    extends AbstractPage<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment, ListEnvironmentsPage> {
        private ListEnvironmentsPage(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ListEnvironmentsResponse response) {
            super(context, (Object)response);
        }

        private static ListEnvironmentsPage createEmptyPage() {
            return new ListEnvironmentsPage(null, null);
        }

        protected ListEnvironmentsPage createPage(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ListEnvironmentsResponse response) {
            return new ListEnvironmentsPage(context, response);
        }

        public ApiFuture<ListEnvironmentsPage> createPageAsync(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ApiFuture<ListEnvironmentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEnvironmentsPagedResponse
    extends AbstractPagedListResponse<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment, ListEnvironmentsPage, ListEnvironmentsFixedSizeCollection> {
        public static ApiFuture<ListEnvironmentsPagedResponse> createAsync(PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> context, ApiFuture<ListEnvironmentsResponse> futureResponse) {
            ApiFuture<ListEnvironmentsPage> futurePage = ListEnvironmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEnvironmentsPagedResponse((ListEnvironmentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEnvironmentsPagedResponse(ListEnvironmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEnvironmentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

