/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.optimization.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.optimization.v1.AsyncModelMetadata;
import com.google.cloud.optimization.v1.BatchOptimizeToursRequest;
import com.google.cloud.optimization.v1.BatchOptimizeToursResponse;
import com.google.cloud.optimization.v1.OptimizeToursRequest;
import com.google.cloud.optimization.v1.OptimizeToursResponse;
import com.google.cloud.optimization.v1.stub.FleetRoutingStub;
import com.google.cloud.optimization.v1.stub.FleetRoutingStubSettings;
import com.google.cloud.optimization.v1.stub.GrpcFleetRoutingCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcFleetRoutingStub
extends FleetRoutingStub {
    private static final MethodDescriptor<OptimizeToursRequest, OptimizeToursResponse> optimizeToursMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.optimization.v1.FleetRouting/OptimizeTours").setRequestMarshaller(ProtoUtils.marshaller((Message)OptimizeToursRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)OptimizeToursResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<BatchOptimizeToursRequest, Operation> batchOptimizeToursMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.optimization.v1.FleetRouting/BatchOptimizeTours").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchOptimizeToursRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<OptimizeToursRequest, OptimizeToursResponse> optimizeToursCallable;
    private final UnaryCallable<BatchOptimizeToursRequest, Operation> batchOptimizeToursCallable;
    private final OperationCallable<BatchOptimizeToursRequest, BatchOptimizeToursResponse, AsyncModelMetadata> batchOptimizeToursOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcFleetRoutingStub create(FleetRoutingStubSettings settings) throws IOException {
        return new GrpcFleetRoutingStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcFleetRoutingStub create(ClientContext clientContext) throws IOException {
        return new GrpcFleetRoutingStub(FleetRoutingStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcFleetRoutingStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcFleetRoutingStub(FleetRoutingStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcFleetRoutingStub(FleetRoutingStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcFleetRoutingCallableFactory());
    }

    protected GrpcFleetRoutingStub(FleetRoutingStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings optimizeToursTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(optimizeToursMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings batchOptimizeToursTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchOptimizeToursMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        this.optimizeToursCallable = callableFactory.createUnaryCallable(optimizeToursTransportSettings, settings.optimizeToursSettings(), clientContext);
        this.batchOptimizeToursCallable = callableFactory.createUnaryCallable(batchOptimizeToursTransportSettings, settings.batchOptimizeToursSettings(), clientContext);
        this.batchOptimizeToursOperationCallable = callableFactory.createOperationCallable(batchOptimizeToursTransportSettings, settings.batchOptimizeToursOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<OptimizeToursRequest, OptimizeToursResponse> optimizeToursCallable() {
        return this.optimizeToursCallable;
    }

    @Override
    public UnaryCallable<BatchOptimizeToursRequest, Operation> batchOptimizeToursCallable() {
        return this.batchOptimizeToursCallable;
    }

    @Override
    public OperationCallable<BatchOptimizeToursRequest, BatchOptimizeToursResponse, AsyncModelMetadata> batchOptimizeToursOperationCallable() {
        return this.batchOptimizeToursOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

