/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.notebooks.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.notebooks.v1beta1.CreateEnvironmentRequest;
import com.google.cloud.notebooks.v1beta1.CreateInstanceRequest;
import com.google.cloud.notebooks.v1beta1.DeleteEnvironmentRequest;
import com.google.cloud.notebooks.v1beta1.DeleteInstanceRequest;
import com.google.cloud.notebooks.v1beta1.Environment;
import com.google.cloud.notebooks.v1beta1.GetEnvironmentRequest;
import com.google.cloud.notebooks.v1beta1.GetInstanceRequest;
import com.google.cloud.notebooks.v1beta1.Instance;
import com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableRequest;
import com.google.cloud.notebooks.v1beta1.IsInstanceUpgradeableResponse;
import com.google.cloud.notebooks.v1beta1.ListEnvironmentsRequest;
import com.google.cloud.notebooks.v1beta1.ListEnvironmentsResponse;
import com.google.cloud.notebooks.v1beta1.ListInstancesRequest;
import com.google.cloud.notebooks.v1beta1.ListInstancesResponse;
import com.google.cloud.notebooks.v1beta1.NotebookServiceClient;
import com.google.cloud.notebooks.v1beta1.OperationMetadata;
import com.google.cloud.notebooks.v1beta1.RegisterInstanceRequest;
import com.google.cloud.notebooks.v1beta1.ReportInstanceInfoRequest;
import com.google.cloud.notebooks.v1beta1.ResetInstanceRequest;
import com.google.cloud.notebooks.v1beta1.SetInstanceAcceleratorRequest;
import com.google.cloud.notebooks.v1beta1.SetInstanceLabelsRequest;
import com.google.cloud.notebooks.v1beta1.SetInstanceMachineTypeRequest;
import com.google.cloud.notebooks.v1beta1.StartInstanceRequest;
import com.google.cloud.notebooks.v1beta1.StopInstanceRequest;
import com.google.cloud.notebooks.v1beta1.UpgradeInstanceInternalRequest;
import com.google.cloud.notebooks.v1beta1.UpgradeInstanceRequest;
import com.google.cloud.notebooks.v1beta1.stub.GrpcNotebookServiceStub;
import com.google.cloud.notebooks.v1beta1.stub.NotebookServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class NotebookServiceStubSettings
extends StubSettings<NotebookServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListInstancesRequest, ListInstancesResponse, NotebookServiceClient.ListInstancesPagedResponse> listInstancesSettings;
    private final UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings;
    private final UnaryCallSettings<CreateInstanceRequest, Operation> createInstanceSettings;
    private final OperationCallSettings<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings;
    private final UnaryCallSettings<RegisterInstanceRequest, Operation> registerInstanceSettings;
    private final OperationCallSettings<RegisterInstanceRequest, Instance, OperationMetadata> registerInstanceOperationSettings;
    private final UnaryCallSettings<SetInstanceAcceleratorRequest, Operation> setInstanceAcceleratorSettings;
    private final OperationCallSettings<SetInstanceAcceleratorRequest, Instance, OperationMetadata> setInstanceAcceleratorOperationSettings;
    private final UnaryCallSettings<SetInstanceMachineTypeRequest, Operation> setInstanceMachineTypeSettings;
    private final OperationCallSettings<SetInstanceMachineTypeRequest, Instance, OperationMetadata> setInstanceMachineTypeOperationSettings;
    private final UnaryCallSettings<SetInstanceLabelsRequest, Operation> setInstanceLabelsSettings;
    private final OperationCallSettings<SetInstanceLabelsRequest, Instance, OperationMetadata> setInstanceLabelsOperationSettings;
    private final UnaryCallSettings<DeleteInstanceRequest, Operation> deleteInstanceSettings;
    private final OperationCallSettings<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings;
    private final UnaryCallSettings<StartInstanceRequest, Operation> startInstanceSettings;
    private final OperationCallSettings<StartInstanceRequest, Instance, OperationMetadata> startInstanceOperationSettings;
    private final UnaryCallSettings<StopInstanceRequest, Operation> stopInstanceSettings;
    private final OperationCallSettings<StopInstanceRequest, Instance, OperationMetadata> stopInstanceOperationSettings;
    private final UnaryCallSettings<ResetInstanceRequest, Operation> resetInstanceSettings;
    private final OperationCallSettings<ResetInstanceRequest, Instance, OperationMetadata> resetInstanceOperationSettings;
    private final UnaryCallSettings<ReportInstanceInfoRequest, Operation> reportInstanceInfoSettings;
    private final OperationCallSettings<ReportInstanceInfoRequest, Instance, OperationMetadata> reportInstanceInfoOperationSettings;
    private final UnaryCallSettings<IsInstanceUpgradeableRequest, IsInstanceUpgradeableResponse> isInstanceUpgradeableSettings;
    private final UnaryCallSettings<UpgradeInstanceRequest, Operation> upgradeInstanceSettings;
    private final OperationCallSettings<UpgradeInstanceRequest, Instance, OperationMetadata> upgradeInstanceOperationSettings;
    private final UnaryCallSettings<UpgradeInstanceInternalRequest, Operation> upgradeInstanceInternalSettings;
    private final OperationCallSettings<UpgradeInstanceInternalRequest, Instance, OperationMetadata> upgradeInstanceInternalOperationSettings;
    private final PagedCallSettings<ListEnvironmentsRequest, ListEnvironmentsResponse, NotebookServiceClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings;
    private final UnaryCallSettings<GetEnvironmentRequest, Environment> getEnvironmentSettings;
    private final UnaryCallSettings<CreateEnvironmentRequest, Operation> createEnvironmentSettings;
    private final OperationCallSettings<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationSettings;
    private final UnaryCallSettings<DeleteEnvironmentRequest, Operation> deleteEnvironmentSettings;
    private final OperationCallSettings<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationSettings;
    private static final PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance> LIST_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance>(){

        public String emptyToken() {
            return "";
        }

        public ListInstancesRequest injectToken(ListInstancesRequest payload, String token) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageToken(token).build();
        }

        public ListInstancesRequest injectPageSize(ListInstancesRequest payload, int pageSize) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInstancesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInstancesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Instance> extractResources(ListInstancesResponse payload) {
            return payload.getInstancesList() == null ? ImmutableList.of() : payload.getInstancesList();
        }
    };
    private static final PagedListDescriptor<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> LIST_ENVIRONMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment>(){

        public String emptyToken() {
            return "";
        }

        public ListEnvironmentsRequest injectToken(ListEnvironmentsRequest payload, String token) {
            return ListEnvironmentsRequest.newBuilder((ListEnvironmentsRequest)payload).setPageToken(token).build();
        }

        public ListEnvironmentsRequest injectPageSize(ListEnvironmentsRequest payload, int pageSize) {
            return ListEnvironmentsRequest.newBuilder((ListEnvironmentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEnvironmentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEnvironmentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Environment> extractResources(ListEnvironmentsResponse payload) {
            return payload.getEnvironmentsList() == null ? ImmutableList.of() : payload.getEnvironmentsList();
        }
    };
    private static final PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, NotebookServiceClient.ListInstancesPagedResponse> LIST_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, NotebookServiceClient.ListInstancesPagedResponse>(){

        public ApiFuture<NotebookServiceClient.ListInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstancesRequest, ListInstancesResponse> callable, ListInstancesRequest request, ApiCallContext context, ApiFuture<ListInstancesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NotebookServiceClient.ListInstancesPagedResponse.createAsync((PageContext<ListInstancesRequest, ListInstancesResponse, Instance>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListEnvironmentsRequest, ListEnvironmentsResponse, NotebookServiceClient.ListEnvironmentsPagedResponse> LIST_ENVIRONMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEnvironmentsRequest, ListEnvironmentsResponse, NotebookServiceClient.ListEnvironmentsPagedResponse>(){

        public ApiFuture<NotebookServiceClient.ListEnvironmentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsResponse> callable, ListEnvironmentsRequest request, ApiCallContext context, ApiFuture<ListEnvironmentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENVIRONMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NotebookServiceClient.ListEnvironmentsPagedResponse.createAsync((PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListInstancesRequest, ListInstancesResponse, NotebookServiceClient.ListInstancesPagedResponse> listInstancesSettings() {
        return this.listInstancesSettings;
    }

    public UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings() {
        return this.getInstanceSettings;
    }

    public UnaryCallSettings<CreateInstanceRequest, Operation> createInstanceSettings() {
        return this.createInstanceSettings;
    }

    public OperationCallSettings<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings() {
        return this.createInstanceOperationSettings;
    }

    public UnaryCallSettings<RegisterInstanceRequest, Operation> registerInstanceSettings() {
        return this.registerInstanceSettings;
    }

    public OperationCallSettings<RegisterInstanceRequest, Instance, OperationMetadata> registerInstanceOperationSettings() {
        return this.registerInstanceOperationSettings;
    }

    public UnaryCallSettings<SetInstanceAcceleratorRequest, Operation> setInstanceAcceleratorSettings() {
        return this.setInstanceAcceleratorSettings;
    }

    public OperationCallSettings<SetInstanceAcceleratorRequest, Instance, OperationMetadata> setInstanceAcceleratorOperationSettings() {
        return this.setInstanceAcceleratorOperationSettings;
    }

    public UnaryCallSettings<SetInstanceMachineTypeRequest, Operation> setInstanceMachineTypeSettings() {
        return this.setInstanceMachineTypeSettings;
    }

    public OperationCallSettings<SetInstanceMachineTypeRequest, Instance, OperationMetadata> setInstanceMachineTypeOperationSettings() {
        return this.setInstanceMachineTypeOperationSettings;
    }

    public UnaryCallSettings<SetInstanceLabelsRequest, Operation> setInstanceLabelsSettings() {
        return this.setInstanceLabelsSettings;
    }

    public OperationCallSettings<SetInstanceLabelsRequest, Instance, OperationMetadata> setInstanceLabelsOperationSettings() {
        return this.setInstanceLabelsOperationSettings;
    }

    public UnaryCallSettings<DeleteInstanceRequest, Operation> deleteInstanceSettings() {
        return this.deleteInstanceSettings;
    }

    public OperationCallSettings<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings() {
        return this.deleteInstanceOperationSettings;
    }

    public UnaryCallSettings<StartInstanceRequest, Operation> startInstanceSettings() {
        return this.startInstanceSettings;
    }

    public OperationCallSettings<StartInstanceRequest, Instance, OperationMetadata> startInstanceOperationSettings() {
        return this.startInstanceOperationSettings;
    }

    public UnaryCallSettings<StopInstanceRequest, Operation> stopInstanceSettings() {
        return this.stopInstanceSettings;
    }

    public OperationCallSettings<StopInstanceRequest, Instance, OperationMetadata> stopInstanceOperationSettings() {
        return this.stopInstanceOperationSettings;
    }

    public UnaryCallSettings<ResetInstanceRequest, Operation> resetInstanceSettings() {
        return this.resetInstanceSettings;
    }

    public OperationCallSettings<ResetInstanceRequest, Instance, OperationMetadata> resetInstanceOperationSettings() {
        return this.resetInstanceOperationSettings;
    }

    public UnaryCallSettings<ReportInstanceInfoRequest, Operation> reportInstanceInfoSettings() {
        return this.reportInstanceInfoSettings;
    }

    public OperationCallSettings<ReportInstanceInfoRequest, Instance, OperationMetadata> reportInstanceInfoOperationSettings() {
        return this.reportInstanceInfoOperationSettings;
    }

    public UnaryCallSettings<IsInstanceUpgradeableRequest, IsInstanceUpgradeableResponse> isInstanceUpgradeableSettings() {
        return this.isInstanceUpgradeableSettings;
    }

    public UnaryCallSettings<UpgradeInstanceRequest, Operation> upgradeInstanceSettings() {
        return this.upgradeInstanceSettings;
    }

    public OperationCallSettings<UpgradeInstanceRequest, Instance, OperationMetadata> upgradeInstanceOperationSettings() {
        return this.upgradeInstanceOperationSettings;
    }

    public UnaryCallSettings<UpgradeInstanceInternalRequest, Operation> upgradeInstanceInternalSettings() {
        return this.upgradeInstanceInternalSettings;
    }

    public OperationCallSettings<UpgradeInstanceInternalRequest, Instance, OperationMetadata> upgradeInstanceInternalOperationSettings() {
        return this.upgradeInstanceInternalOperationSettings;
    }

    public PagedCallSettings<ListEnvironmentsRequest, ListEnvironmentsResponse, NotebookServiceClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings() {
        return this.listEnvironmentsSettings;
    }

    public UnaryCallSettings<GetEnvironmentRequest, Environment> getEnvironmentSettings() {
        return this.getEnvironmentSettings;
    }

    public UnaryCallSettings<CreateEnvironmentRequest, Operation> createEnvironmentSettings() {
        return this.createEnvironmentSettings;
    }

    public OperationCallSettings<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationSettings() {
        return this.createEnvironmentOperationSettings;
    }

    public UnaryCallSettings<DeleteEnvironmentRequest, Operation> deleteEnvironmentSettings() {
        return this.deleteEnvironmentSettings;
    }

    public OperationCallSettings<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationSettings() {
        return this.deleteEnvironmentOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public NotebookServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcNotebookServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "notebooks.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "notebooks.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return NotebookServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(NotebookServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected NotebookServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listInstancesSettings = settingsBuilder.listInstancesSettings().build();
        this.getInstanceSettings = settingsBuilder.getInstanceSettings().build();
        this.createInstanceSettings = settingsBuilder.createInstanceSettings().build();
        this.createInstanceOperationSettings = settingsBuilder.createInstanceOperationSettings().build();
        this.registerInstanceSettings = settingsBuilder.registerInstanceSettings().build();
        this.registerInstanceOperationSettings = settingsBuilder.registerInstanceOperationSettings().build();
        this.setInstanceAcceleratorSettings = settingsBuilder.setInstanceAcceleratorSettings().build();
        this.setInstanceAcceleratorOperationSettings = settingsBuilder.setInstanceAcceleratorOperationSettings().build();
        this.setInstanceMachineTypeSettings = settingsBuilder.setInstanceMachineTypeSettings().build();
        this.setInstanceMachineTypeOperationSettings = settingsBuilder.setInstanceMachineTypeOperationSettings().build();
        this.setInstanceLabelsSettings = settingsBuilder.setInstanceLabelsSettings().build();
        this.setInstanceLabelsOperationSettings = settingsBuilder.setInstanceLabelsOperationSettings().build();
        this.deleteInstanceSettings = settingsBuilder.deleteInstanceSettings().build();
        this.deleteInstanceOperationSettings = settingsBuilder.deleteInstanceOperationSettings().build();
        this.startInstanceSettings = settingsBuilder.startInstanceSettings().build();
        this.startInstanceOperationSettings = settingsBuilder.startInstanceOperationSettings().build();
        this.stopInstanceSettings = settingsBuilder.stopInstanceSettings().build();
        this.stopInstanceOperationSettings = settingsBuilder.stopInstanceOperationSettings().build();
        this.resetInstanceSettings = settingsBuilder.resetInstanceSettings().build();
        this.resetInstanceOperationSettings = settingsBuilder.resetInstanceOperationSettings().build();
        this.reportInstanceInfoSettings = settingsBuilder.reportInstanceInfoSettings().build();
        this.reportInstanceInfoOperationSettings = settingsBuilder.reportInstanceInfoOperationSettings().build();
        this.isInstanceUpgradeableSettings = settingsBuilder.isInstanceUpgradeableSettings().build();
        this.upgradeInstanceSettings = settingsBuilder.upgradeInstanceSettings().build();
        this.upgradeInstanceOperationSettings = settingsBuilder.upgradeInstanceOperationSettings().build();
        this.upgradeInstanceInternalSettings = settingsBuilder.upgradeInstanceInternalSettings().build();
        this.upgradeInstanceInternalOperationSettings = settingsBuilder.upgradeInstanceInternalOperationSettings().build();
        this.listEnvironmentsSettings = settingsBuilder.listEnvironmentsSettings().build();
        this.getEnvironmentSettings = settingsBuilder.getEnvironmentSettings().build();
        this.createEnvironmentSettings = settingsBuilder.createEnvironmentSettings().build();
        this.createEnvironmentOperationSettings = settingsBuilder.createEnvironmentOperationSettings().build();
        this.deleteEnvironmentSettings = settingsBuilder.deleteEnvironmentSettings().build();
        this.deleteEnvironmentOperationSettings = settingsBuilder.deleteEnvironmentOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<NotebookServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, NotebookServiceClient.ListInstancesPagedResponse> listInstancesSettings;
        private final UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings;
        private final UnaryCallSettings.Builder<CreateInstanceRequest, Operation> createInstanceSettings;
        private final OperationCallSettings.Builder<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings;
        private final UnaryCallSettings.Builder<RegisterInstanceRequest, Operation> registerInstanceSettings;
        private final OperationCallSettings.Builder<RegisterInstanceRequest, Instance, OperationMetadata> registerInstanceOperationSettings;
        private final UnaryCallSettings.Builder<SetInstanceAcceleratorRequest, Operation> setInstanceAcceleratorSettings;
        private final OperationCallSettings.Builder<SetInstanceAcceleratorRequest, Instance, OperationMetadata> setInstanceAcceleratorOperationSettings;
        private final UnaryCallSettings.Builder<SetInstanceMachineTypeRequest, Operation> setInstanceMachineTypeSettings;
        private final OperationCallSettings.Builder<SetInstanceMachineTypeRequest, Instance, OperationMetadata> setInstanceMachineTypeOperationSettings;
        private final UnaryCallSettings.Builder<SetInstanceLabelsRequest, Operation> setInstanceLabelsSettings;
        private final OperationCallSettings.Builder<SetInstanceLabelsRequest, Instance, OperationMetadata> setInstanceLabelsOperationSettings;
        private final UnaryCallSettings.Builder<DeleteInstanceRequest, Operation> deleteInstanceSettings;
        private final OperationCallSettings.Builder<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings;
        private final UnaryCallSettings.Builder<StartInstanceRequest, Operation> startInstanceSettings;
        private final OperationCallSettings.Builder<StartInstanceRequest, Instance, OperationMetadata> startInstanceOperationSettings;
        private final UnaryCallSettings.Builder<StopInstanceRequest, Operation> stopInstanceSettings;
        private final OperationCallSettings.Builder<StopInstanceRequest, Instance, OperationMetadata> stopInstanceOperationSettings;
        private final UnaryCallSettings.Builder<ResetInstanceRequest, Operation> resetInstanceSettings;
        private final OperationCallSettings.Builder<ResetInstanceRequest, Instance, OperationMetadata> resetInstanceOperationSettings;
        private final UnaryCallSettings.Builder<ReportInstanceInfoRequest, Operation> reportInstanceInfoSettings;
        private final OperationCallSettings.Builder<ReportInstanceInfoRequest, Instance, OperationMetadata> reportInstanceInfoOperationSettings;
        private final UnaryCallSettings.Builder<IsInstanceUpgradeableRequest, IsInstanceUpgradeableResponse> isInstanceUpgradeableSettings;
        private final UnaryCallSettings.Builder<UpgradeInstanceRequest, Operation> upgradeInstanceSettings;
        private final OperationCallSettings.Builder<UpgradeInstanceRequest, Instance, OperationMetadata> upgradeInstanceOperationSettings;
        private final UnaryCallSettings.Builder<UpgradeInstanceInternalRequest, Operation> upgradeInstanceInternalSettings;
        private final OperationCallSettings.Builder<UpgradeInstanceInternalRequest, Instance, OperationMetadata> upgradeInstanceInternalOperationSettings;
        private final PagedCallSettings.Builder<ListEnvironmentsRequest, ListEnvironmentsResponse, NotebookServiceClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings;
        private final UnaryCallSettings.Builder<GetEnvironmentRequest, Environment> getEnvironmentSettings;
        private final UnaryCallSettings.Builder<CreateEnvironmentRequest, Operation> createEnvironmentSettings;
        private final OperationCallSettings.Builder<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationSettings;
        private final UnaryCallSettings.Builder<DeleteEnvironmentRequest, Operation> deleteEnvironmentSettings;
        private final OperationCallSettings.Builder<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCES_PAGE_STR_FACT);
            this.getInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.registerInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.registerInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.setInstanceAcceleratorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setInstanceAcceleratorOperationSettings = OperationCallSettings.newBuilder();
            this.setInstanceMachineTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setInstanceMachineTypeOperationSettings = OperationCallSettings.newBuilder();
            this.setInstanceLabelsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setInstanceLabelsOperationSettings = OperationCallSettings.newBuilder();
            this.deleteInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.startInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.stopInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.stopInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.resetInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resetInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.reportInstanceInfoSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.reportInstanceInfoOperationSettings = OperationCallSettings.newBuilder();
            this.isInstanceUpgradeableSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.upgradeInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.upgradeInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.upgradeInstanceInternalSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.upgradeInstanceInternalOperationSettings = OperationCallSettings.newBuilder();
            this.listEnvironmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENVIRONMENTS_PAGE_STR_FACT);
            this.getEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEnvironmentOperationSettings = OperationCallSettings.newBuilder();
            this.deleteEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEnvironmentOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInstancesSettings, this.getInstanceSettings, this.createInstanceSettings, this.registerInstanceSettings, this.setInstanceAcceleratorSettings, this.setInstanceMachineTypeSettings, this.setInstanceLabelsSettings, this.deleteInstanceSettings, this.startInstanceSettings, this.stopInstanceSettings, this.resetInstanceSettings, this.reportInstanceInfoSettings, (Object[])new UnaryCallSettings.Builder[]{this.isInstanceUpgradeableSettings, this.upgradeInstanceSettings, this.upgradeInstanceInternalSettings, this.listEnvironmentsSettings, this.getEnvironmentSettings, this.createEnvironmentSettings, this.deleteEnvironmentSettings});
            Builder.initDefaults(this);
        }

        protected Builder(NotebookServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listInstancesSettings = settings.listInstancesSettings.toBuilder();
            this.getInstanceSettings = settings.getInstanceSettings.toBuilder();
            this.createInstanceSettings = settings.createInstanceSettings.toBuilder();
            this.createInstanceOperationSettings = settings.createInstanceOperationSettings.toBuilder();
            this.registerInstanceSettings = settings.registerInstanceSettings.toBuilder();
            this.registerInstanceOperationSettings = settings.registerInstanceOperationSettings.toBuilder();
            this.setInstanceAcceleratorSettings = settings.setInstanceAcceleratorSettings.toBuilder();
            this.setInstanceAcceleratorOperationSettings = settings.setInstanceAcceleratorOperationSettings.toBuilder();
            this.setInstanceMachineTypeSettings = settings.setInstanceMachineTypeSettings.toBuilder();
            this.setInstanceMachineTypeOperationSettings = settings.setInstanceMachineTypeOperationSettings.toBuilder();
            this.setInstanceLabelsSettings = settings.setInstanceLabelsSettings.toBuilder();
            this.setInstanceLabelsOperationSettings = settings.setInstanceLabelsOperationSettings.toBuilder();
            this.deleteInstanceSettings = settings.deleteInstanceSettings.toBuilder();
            this.deleteInstanceOperationSettings = settings.deleteInstanceOperationSettings.toBuilder();
            this.startInstanceSettings = settings.startInstanceSettings.toBuilder();
            this.startInstanceOperationSettings = settings.startInstanceOperationSettings.toBuilder();
            this.stopInstanceSettings = settings.stopInstanceSettings.toBuilder();
            this.stopInstanceOperationSettings = settings.stopInstanceOperationSettings.toBuilder();
            this.resetInstanceSettings = settings.resetInstanceSettings.toBuilder();
            this.resetInstanceOperationSettings = settings.resetInstanceOperationSettings.toBuilder();
            this.reportInstanceInfoSettings = settings.reportInstanceInfoSettings.toBuilder();
            this.reportInstanceInfoOperationSettings = settings.reportInstanceInfoOperationSettings.toBuilder();
            this.isInstanceUpgradeableSettings = settings.isInstanceUpgradeableSettings.toBuilder();
            this.upgradeInstanceSettings = settings.upgradeInstanceSettings.toBuilder();
            this.upgradeInstanceOperationSettings = settings.upgradeInstanceOperationSettings.toBuilder();
            this.upgradeInstanceInternalSettings = settings.upgradeInstanceInternalSettings.toBuilder();
            this.upgradeInstanceInternalOperationSettings = settings.upgradeInstanceInternalOperationSettings.toBuilder();
            this.listEnvironmentsSettings = settings.listEnvironmentsSettings.toBuilder();
            this.getEnvironmentSettings = settings.getEnvironmentSettings.toBuilder();
            this.createEnvironmentSettings = settings.createEnvironmentSettings.toBuilder();
            this.createEnvironmentOperationSettings = settings.createEnvironmentOperationSettings.toBuilder();
            this.deleteEnvironmentSettings = settings.deleteEnvironmentSettings.toBuilder();
            this.deleteEnvironmentOperationSettings = settings.deleteEnvironmentOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInstancesSettings, this.getInstanceSettings, this.createInstanceSettings, this.registerInstanceSettings, this.setInstanceAcceleratorSettings, this.setInstanceMachineTypeSettings, this.setInstanceLabelsSettings, this.deleteInstanceSettings, this.startInstanceSettings, this.stopInstanceSettings, this.resetInstanceSettings, this.reportInstanceInfoSettings, (Object[])new UnaryCallSettings.Builder[]{this.isInstanceUpgradeableSettings, this.upgradeInstanceSettings, this.upgradeInstanceInternalSettings, this.listEnvironmentsSettings, this.getEnvironmentSettings, this.createEnvironmentSettings, this.deleteEnvironmentSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(NotebookServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)NotebookServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)NotebookServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(NotebookServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(NotebookServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.registerInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setInstanceAcceleratorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setInstanceMachineTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setInstanceLabelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.startInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.stopInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.resetInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.reportInstanceInfoSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.isInstanceUpgradeableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.upgradeInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.upgradeInstanceInternalSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listEnvironmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.registerInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.setInstanceAcceleratorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.setInstanceMachineTypeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.setInstanceLabelsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.startInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.stopInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.resetInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.reportInstanceInfoOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.upgradeInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.upgradeInstanceInternalOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createEnvironmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Environment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteEnvironmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, NotebookServiceClient.ListInstancesPagedResponse> listInstancesSettings() {
            return this.listInstancesSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings() {
            return this.getInstanceSettings;
        }

        public UnaryCallSettings.Builder<CreateInstanceRequest, Operation> createInstanceSettings() {
            return this.createInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings() {
            return this.createInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<RegisterInstanceRequest, Operation> registerInstanceSettings() {
            return this.registerInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<RegisterInstanceRequest, Instance, OperationMetadata> registerInstanceOperationSettings() {
            return this.registerInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<SetInstanceAcceleratorRequest, Operation> setInstanceAcceleratorSettings() {
            return this.setInstanceAcceleratorSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetInstanceAcceleratorRequest, Instance, OperationMetadata> setInstanceAcceleratorOperationSettings() {
            return this.setInstanceAcceleratorOperationSettings;
        }

        public UnaryCallSettings.Builder<SetInstanceMachineTypeRequest, Operation> setInstanceMachineTypeSettings() {
            return this.setInstanceMachineTypeSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetInstanceMachineTypeRequest, Instance, OperationMetadata> setInstanceMachineTypeOperationSettings() {
            return this.setInstanceMachineTypeOperationSettings;
        }

        public UnaryCallSettings.Builder<SetInstanceLabelsRequest, Operation> setInstanceLabelsSettings() {
            return this.setInstanceLabelsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SetInstanceLabelsRequest, Instance, OperationMetadata> setInstanceLabelsOperationSettings() {
            return this.setInstanceLabelsOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteInstanceRequest, Operation> deleteInstanceSettings() {
            return this.deleteInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings() {
            return this.deleteInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<StartInstanceRequest, Operation> startInstanceSettings() {
            return this.startInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StartInstanceRequest, Instance, OperationMetadata> startInstanceOperationSettings() {
            return this.startInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<StopInstanceRequest, Operation> stopInstanceSettings() {
            return this.stopInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StopInstanceRequest, Instance, OperationMetadata> stopInstanceOperationSettings() {
            return this.stopInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<ResetInstanceRequest, Operation> resetInstanceSettings() {
            return this.resetInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ResetInstanceRequest, Instance, OperationMetadata> resetInstanceOperationSettings() {
            return this.resetInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<ReportInstanceInfoRequest, Operation> reportInstanceInfoSettings() {
            return this.reportInstanceInfoSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ReportInstanceInfoRequest, Instance, OperationMetadata> reportInstanceInfoOperationSettings() {
            return this.reportInstanceInfoOperationSettings;
        }

        public UnaryCallSettings.Builder<IsInstanceUpgradeableRequest, IsInstanceUpgradeableResponse> isInstanceUpgradeableSettings() {
            return this.isInstanceUpgradeableSettings;
        }

        public UnaryCallSettings.Builder<UpgradeInstanceRequest, Operation> upgradeInstanceSettings() {
            return this.upgradeInstanceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpgradeInstanceRequest, Instance, OperationMetadata> upgradeInstanceOperationSettings() {
            return this.upgradeInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<UpgradeInstanceInternalRequest, Operation> upgradeInstanceInternalSettings() {
            return this.upgradeInstanceInternalSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpgradeInstanceInternalRequest, Instance, OperationMetadata> upgradeInstanceInternalOperationSettings() {
            return this.upgradeInstanceInternalOperationSettings;
        }

        public PagedCallSettings.Builder<ListEnvironmentsRequest, ListEnvironmentsResponse, NotebookServiceClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings() {
            return this.listEnvironmentsSettings;
        }

        public UnaryCallSettings.Builder<GetEnvironmentRequest, Environment> getEnvironmentSettings() {
            return this.getEnvironmentSettings;
        }

        public UnaryCallSettings.Builder<CreateEnvironmentRequest, Operation> createEnvironmentSettings() {
            return this.createEnvironmentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateEnvironmentRequest, Environment, OperationMetadata> createEnvironmentOperationSettings() {
            return this.createEnvironmentOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteEnvironmentRequest, Operation> deleteEnvironmentSettings() {
            return this.deleteEnvironmentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteEnvironmentRequest, Empty, OperationMetadata> deleteEnvironmentOperationSettings() {
            return this.deleteEnvironmentOperationSettings;
        }

        public NotebookServiceStubSettings build() throws IOException {
            return new NotebookServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

