/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.networkconnectivity.v1.CreateInternalRangeRequest;
import com.google.cloud.networkconnectivity.v1.DeleteInternalRangeRequest;
import com.google.cloud.networkconnectivity.v1.GetInternalRangeRequest;
import com.google.cloud.networkconnectivity.v1.InternalRange;
import com.google.cloud.networkconnectivity.v1.InternalRangeServiceClient;
import com.google.cloud.networkconnectivity.v1.ListInternalRangesRequest;
import com.google.cloud.networkconnectivity.v1.ListInternalRangesResponse;
import com.google.cloud.networkconnectivity.v1.OperationMetadata;
import com.google.cloud.networkconnectivity.v1.UpdateInternalRangeRequest;
import com.google.cloud.networkconnectivity.v1.stub.GrpcInternalRangeServiceStub;
import com.google.cloud.networkconnectivity.v1.stub.InternalRangeServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class InternalRangeServiceStubSettings
extends StubSettings<InternalRangeServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListInternalRangesRequest, ListInternalRangesResponse, InternalRangeServiceClient.ListInternalRangesPagedResponse> listInternalRangesSettings;
    private final UnaryCallSettings<GetInternalRangeRequest, InternalRange> getInternalRangeSettings;
    private final UnaryCallSettings<CreateInternalRangeRequest, Operation> createInternalRangeSettings;
    private final OperationCallSettings<CreateInternalRangeRequest, InternalRange, OperationMetadata> createInternalRangeOperationSettings;
    private final UnaryCallSettings<UpdateInternalRangeRequest, Operation> updateInternalRangeSettings;
    private final OperationCallSettings<UpdateInternalRangeRequest, InternalRange, OperationMetadata> updateInternalRangeOperationSettings;
    private final UnaryCallSettings<DeleteInternalRangeRequest, Operation> deleteInternalRangeSettings;
    private final OperationCallSettings<DeleteInternalRangeRequest, Empty, OperationMetadata> deleteInternalRangeOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, InternalRangeServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListInternalRangesRequest, ListInternalRangesResponse, InternalRange> LIST_INTERNAL_RANGES_PAGE_STR_DESC = new PagedListDescriptor<ListInternalRangesRequest, ListInternalRangesResponse, InternalRange>(){

        public String emptyToken() {
            return "";
        }

        public ListInternalRangesRequest injectToken(ListInternalRangesRequest payload, String token) {
            return ListInternalRangesRequest.newBuilder((ListInternalRangesRequest)payload).setPageToken(token).build();
        }

        public ListInternalRangesRequest injectPageSize(ListInternalRangesRequest payload, int pageSize) {
            return ListInternalRangesRequest.newBuilder((ListInternalRangesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInternalRangesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInternalRangesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InternalRange> extractResources(ListInternalRangesResponse payload) {
            return payload.getInternalRangesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListInternalRangesRequest, ListInternalRangesResponse, InternalRangeServiceClient.ListInternalRangesPagedResponse> LIST_INTERNAL_RANGES_PAGE_STR_FACT = new PagedListResponseFactory<ListInternalRangesRequest, ListInternalRangesResponse, InternalRangeServiceClient.ListInternalRangesPagedResponse>(){

        public ApiFuture<InternalRangeServiceClient.ListInternalRangesPagedResponse> getFuturePagedResponse(UnaryCallable<ListInternalRangesRequest, ListInternalRangesResponse> callable, ListInternalRangesRequest request, ApiCallContext context, ApiFuture<ListInternalRangesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INTERNAL_RANGES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InternalRangeServiceClient.ListInternalRangesPagedResponse.createAsync((PageContext<ListInternalRangesRequest, ListInternalRangesResponse, InternalRange>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, InternalRangeServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, InternalRangeServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<InternalRangeServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InternalRangeServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListInternalRangesRequest, ListInternalRangesResponse, InternalRangeServiceClient.ListInternalRangesPagedResponse> listInternalRangesSettings() {
        return this.listInternalRangesSettings;
    }

    public UnaryCallSettings<GetInternalRangeRequest, InternalRange> getInternalRangeSettings() {
        return this.getInternalRangeSettings;
    }

    public UnaryCallSettings<CreateInternalRangeRequest, Operation> createInternalRangeSettings() {
        return this.createInternalRangeSettings;
    }

    public OperationCallSettings<CreateInternalRangeRequest, InternalRange, OperationMetadata> createInternalRangeOperationSettings() {
        return this.createInternalRangeOperationSettings;
    }

    public UnaryCallSettings<UpdateInternalRangeRequest, Operation> updateInternalRangeSettings() {
        return this.updateInternalRangeSettings;
    }

    public OperationCallSettings<UpdateInternalRangeRequest, InternalRange, OperationMetadata> updateInternalRangeOperationSettings() {
        return this.updateInternalRangeOperationSettings;
    }

    public UnaryCallSettings<DeleteInternalRangeRequest, Operation> deleteInternalRangeSettings() {
        return this.deleteInternalRangeSettings;
    }

    public OperationCallSettings<DeleteInternalRangeRequest, Empty, OperationMetadata> deleteInternalRangeOperationSettings() {
        return this.deleteInternalRangeOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, InternalRangeServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public InternalRangeServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcInternalRangeServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "networkconnectivity";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "networkconnectivity.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "networkconnectivity.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return InternalRangeServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(InternalRangeServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected InternalRangeServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listInternalRangesSettings = settingsBuilder.listInternalRangesSettings().build();
        this.getInternalRangeSettings = settingsBuilder.getInternalRangeSettings().build();
        this.createInternalRangeSettings = settingsBuilder.createInternalRangeSettings().build();
        this.createInternalRangeOperationSettings = settingsBuilder.createInternalRangeOperationSettings().build();
        this.updateInternalRangeSettings = settingsBuilder.updateInternalRangeSettings().build();
        this.updateInternalRangeOperationSettings = settingsBuilder.updateInternalRangeOperationSettings().build();
        this.deleteInternalRangeSettings = settingsBuilder.deleteInternalRangeSettings().build();
        this.deleteInternalRangeOperationSettings = settingsBuilder.deleteInternalRangeOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<InternalRangeServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListInternalRangesRequest, ListInternalRangesResponse, InternalRangeServiceClient.ListInternalRangesPagedResponse> listInternalRangesSettings;
        private final UnaryCallSettings.Builder<GetInternalRangeRequest, InternalRange> getInternalRangeSettings;
        private final UnaryCallSettings.Builder<CreateInternalRangeRequest, Operation> createInternalRangeSettings;
        private final OperationCallSettings.Builder<CreateInternalRangeRequest, InternalRange, OperationMetadata> createInternalRangeOperationSettings;
        private final UnaryCallSettings.Builder<UpdateInternalRangeRequest, Operation> updateInternalRangeSettings;
        private final OperationCallSettings.Builder<UpdateInternalRangeRequest, InternalRange, OperationMetadata> updateInternalRangeOperationSettings;
        private final UnaryCallSettings.Builder<DeleteInternalRangeRequest, Operation> deleteInternalRangeSettings;
        private final OperationCallSettings.Builder<DeleteInternalRangeRequest, Empty, OperationMetadata> deleteInternalRangeOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, InternalRangeServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listInternalRangesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INTERNAL_RANGES_PAGE_STR_FACT);
            this.getInternalRangeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInternalRangeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInternalRangeOperationSettings = OperationCallSettings.newBuilder();
            this.updateInternalRangeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateInternalRangeOperationSettings = OperationCallSettings.newBuilder();
            this.deleteInternalRangeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteInternalRangeOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInternalRangesSettings, this.getInternalRangeSettings, this.createInternalRangeSettings, this.updateInternalRangeSettings, this.deleteInternalRangeSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(InternalRangeServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listInternalRangesSettings = settings.listInternalRangesSettings.toBuilder();
            this.getInternalRangeSettings = settings.getInternalRangeSettings.toBuilder();
            this.createInternalRangeSettings = settings.createInternalRangeSettings.toBuilder();
            this.createInternalRangeOperationSettings = settings.createInternalRangeOperationSettings.toBuilder();
            this.updateInternalRangeSettings = settings.updateInternalRangeSettings.toBuilder();
            this.updateInternalRangeOperationSettings = settings.updateInternalRangeOperationSettings.toBuilder();
            this.deleteInternalRangeSettings = settings.deleteInternalRangeSettings.toBuilder();
            this.deleteInternalRangeOperationSettings = settings.deleteInternalRangeOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInternalRangesSettings, this.getInternalRangeSettings, this.createInternalRangeSettings, this.updateInternalRangeSettings, this.deleteInternalRangeSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(InternalRangeServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)InternalRangeServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)InternalRangeServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(InternalRangeServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listInternalRangesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getInternalRangeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createInternalRangeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateInternalRangeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteInternalRangeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createInternalRangeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(InternalRange.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateInternalRangeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(InternalRange.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteInternalRangeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListInternalRangesRequest, ListInternalRangesResponse, InternalRangeServiceClient.ListInternalRangesPagedResponse> listInternalRangesSettings() {
            return this.listInternalRangesSettings;
        }

        public UnaryCallSettings.Builder<GetInternalRangeRequest, InternalRange> getInternalRangeSettings() {
            return this.getInternalRangeSettings;
        }

        public UnaryCallSettings.Builder<CreateInternalRangeRequest, Operation> createInternalRangeSettings() {
            return this.createInternalRangeSettings;
        }

        public OperationCallSettings.Builder<CreateInternalRangeRequest, InternalRange, OperationMetadata> createInternalRangeOperationSettings() {
            return this.createInternalRangeOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateInternalRangeRequest, Operation> updateInternalRangeSettings() {
            return this.updateInternalRangeSettings;
        }

        public OperationCallSettings.Builder<UpdateInternalRangeRequest, InternalRange, OperationMetadata> updateInternalRangeOperationSettings() {
            return this.updateInternalRangeOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteInternalRangeRequest, Operation> deleteInternalRangeSettings() {
            return this.deleteInternalRangeSettings;
        }

        public OperationCallSettings.Builder<DeleteInternalRangeRequest, Empty, OperationMetadata> deleteInternalRangeOperationSettings() {
            return this.deleteInternalRangeOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, InternalRangeServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public InternalRangeServiceStubSettings build() throws IOException {
            return new InternalRangeServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

