/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkconnectivity.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.networkconnectivity.v1.CreateServiceConnectionMapRequest;
import com.google.cloud.networkconnectivity.v1.CreateServiceConnectionPolicyRequest;
import com.google.cloud.networkconnectivity.v1.CreateServiceConnectionTokenRequest;
import com.google.cloud.networkconnectivity.v1.CrossNetworkAutomationServiceClient;
import com.google.cloud.networkconnectivity.v1.DeleteServiceClassRequest;
import com.google.cloud.networkconnectivity.v1.DeleteServiceConnectionMapRequest;
import com.google.cloud.networkconnectivity.v1.DeleteServiceConnectionPolicyRequest;
import com.google.cloud.networkconnectivity.v1.DeleteServiceConnectionTokenRequest;
import com.google.cloud.networkconnectivity.v1.GetServiceClassRequest;
import com.google.cloud.networkconnectivity.v1.GetServiceConnectionMapRequest;
import com.google.cloud.networkconnectivity.v1.GetServiceConnectionPolicyRequest;
import com.google.cloud.networkconnectivity.v1.GetServiceConnectionTokenRequest;
import com.google.cloud.networkconnectivity.v1.ListServiceClassesRequest;
import com.google.cloud.networkconnectivity.v1.ListServiceClassesResponse;
import com.google.cloud.networkconnectivity.v1.ListServiceConnectionMapsRequest;
import com.google.cloud.networkconnectivity.v1.ListServiceConnectionMapsResponse;
import com.google.cloud.networkconnectivity.v1.ListServiceConnectionPoliciesRequest;
import com.google.cloud.networkconnectivity.v1.ListServiceConnectionPoliciesResponse;
import com.google.cloud.networkconnectivity.v1.ListServiceConnectionTokensRequest;
import com.google.cloud.networkconnectivity.v1.ListServiceConnectionTokensResponse;
import com.google.cloud.networkconnectivity.v1.OperationMetadata;
import com.google.cloud.networkconnectivity.v1.ServiceClass;
import com.google.cloud.networkconnectivity.v1.ServiceConnectionMap;
import com.google.cloud.networkconnectivity.v1.ServiceConnectionPolicy;
import com.google.cloud.networkconnectivity.v1.ServiceConnectionToken;
import com.google.cloud.networkconnectivity.v1.UpdateServiceClassRequest;
import com.google.cloud.networkconnectivity.v1.UpdateServiceConnectionMapRequest;
import com.google.cloud.networkconnectivity.v1.UpdateServiceConnectionPolicyRequest;
import com.google.cloud.networkconnectivity.v1.stub.CrossNetworkAutomationServiceStub;
import com.google.cloud.networkconnectivity.v1.stub.GrpcCrossNetworkAutomationServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CrossNetworkAutomationServiceStubSettings
extends StubSettings<CrossNetworkAutomationServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListServiceConnectionMapsRequest, ListServiceConnectionMapsResponse, CrossNetworkAutomationServiceClient.ListServiceConnectionMapsPagedResponse> listServiceConnectionMapsSettings;
    private final UnaryCallSettings<GetServiceConnectionMapRequest, ServiceConnectionMap> getServiceConnectionMapSettings;
    private final UnaryCallSettings<CreateServiceConnectionMapRequest, Operation> createServiceConnectionMapSettings;
    private final OperationCallSettings<CreateServiceConnectionMapRequest, ServiceConnectionMap, OperationMetadata> createServiceConnectionMapOperationSettings;
    private final UnaryCallSettings<UpdateServiceConnectionMapRequest, Operation> updateServiceConnectionMapSettings;
    private final OperationCallSettings<UpdateServiceConnectionMapRequest, ServiceConnectionMap, OperationMetadata> updateServiceConnectionMapOperationSettings;
    private final UnaryCallSettings<DeleteServiceConnectionMapRequest, Operation> deleteServiceConnectionMapSettings;
    private final OperationCallSettings<DeleteServiceConnectionMapRequest, Empty, OperationMetadata> deleteServiceConnectionMapOperationSettings;
    private final PagedCallSettings<ListServiceConnectionPoliciesRequest, ListServiceConnectionPoliciesResponse, CrossNetworkAutomationServiceClient.ListServiceConnectionPoliciesPagedResponse> listServiceConnectionPoliciesSettings;
    private final UnaryCallSettings<GetServiceConnectionPolicyRequest, ServiceConnectionPolicy> getServiceConnectionPolicySettings;
    private final UnaryCallSettings<CreateServiceConnectionPolicyRequest, Operation> createServiceConnectionPolicySettings;
    private final OperationCallSettings<CreateServiceConnectionPolicyRequest, ServiceConnectionPolicy, OperationMetadata> createServiceConnectionPolicyOperationSettings;
    private final UnaryCallSettings<UpdateServiceConnectionPolicyRequest, Operation> updateServiceConnectionPolicySettings;
    private final OperationCallSettings<UpdateServiceConnectionPolicyRequest, ServiceConnectionPolicy, OperationMetadata> updateServiceConnectionPolicyOperationSettings;
    private final UnaryCallSettings<DeleteServiceConnectionPolicyRequest, Operation> deleteServiceConnectionPolicySettings;
    private final OperationCallSettings<DeleteServiceConnectionPolicyRequest, Empty, OperationMetadata> deleteServiceConnectionPolicyOperationSettings;
    private final PagedCallSettings<ListServiceClassesRequest, ListServiceClassesResponse, CrossNetworkAutomationServiceClient.ListServiceClassesPagedResponse> listServiceClassesSettings;
    private final UnaryCallSettings<GetServiceClassRequest, ServiceClass> getServiceClassSettings;
    private final UnaryCallSettings<UpdateServiceClassRequest, Operation> updateServiceClassSettings;
    private final OperationCallSettings<UpdateServiceClassRequest, ServiceClass, OperationMetadata> updateServiceClassOperationSettings;
    private final UnaryCallSettings<DeleteServiceClassRequest, Operation> deleteServiceClassSettings;
    private final OperationCallSettings<DeleteServiceClassRequest, Empty, OperationMetadata> deleteServiceClassOperationSettings;
    private final UnaryCallSettings<GetServiceConnectionTokenRequest, ServiceConnectionToken> getServiceConnectionTokenSettings;
    private final PagedCallSettings<ListServiceConnectionTokensRequest, ListServiceConnectionTokensResponse, CrossNetworkAutomationServiceClient.ListServiceConnectionTokensPagedResponse> listServiceConnectionTokensSettings;
    private final UnaryCallSettings<CreateServiceConnectionTokenRequest, Operation> createServiceConnectionTokenSettings;
    private final OperationCallSettings<CreateServiceConnectionTokenRequest, ServiceConnectionToken, OperationMetadata> createServiceConnectionTokenOperationSettings;
    private final UnaryCallSettings<DeleteServiceConnectionTokenRequest, Operation> deleteServiceConnectionTokenSettings;
    private final OperationCallSettings<DeleteServiceConnectionTokenRequest, Empty, OperationMetadata> deleteServiceConnectionTokenOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, CrossNetworkAutomationServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListServiceConnectionMapsRequest, ListServiceConnectionMapsResponse, ServiceConnectionMap> LIST_SERVICE_CONNECTION_MAPS_PAGE_STR_DESC = new PagedListDescriptor<ListServiceConnectionMapsRequest, ListServiceConnectionMapsResponse, ServiceConnectionMap>(){

        public String emptyToken() {
            return "";
        }

        public ListServiceConnectionMapsRequest injectToken(ListServiceConnectionMapsRequest payload, String token) {
            return ListServiceConnectionMapsRequest.newBuilder((ListServiceConnectionMapsRequest)payload).setPageToken(token).build();
        }

        public ListServiceConnectionMapsRequest injectPageSize(ListServiceConnectionMapsRequest payload, int pageSize) {
            return ListServiceConnectionMapsRequest.newBuilder((ListServiceConnectionMapsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServiceConnectionMapsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServiceConnectionMapsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ServiceConnectionMap> extractResources(ListServiceConnectionMapsResponse payload) {
            return payload.getServiceConnectionMapsList();
        }
    };
    private static final PagedListDescriptor<ListServiceConnectionPoliciesRequest, ListServiceConnectionPoliciesResponse, ServiceConnectionPolicy> LIST_SERVICE_CONNECTION_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<ListServiceConnectionPoliciesRequest, ListServiceConnectionPoliciesResponse, ServiceConnectionPolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListServiceConnectionPoliciesRequest injectToken(ListServiceConnectionPoliciesRequest payload, String token) {
            return ListServiceConnectionPoliciesRequest.newBuilder((ListServiceConnectionPoliciesRequest)payload).setPageToken(token).build();
        }

        public ListServiceConnectionPoliciesRequest injectPageSize(ListServiceConnectionPoliciesRequest payload, int pageSize) {
            return ListServiceConnectionPoliciesRequest.newBuilder((ListServiceConnectionPoliciesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServiceConnectionPoliciesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServiceConnectionPoliciesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ServiceConnectionPolicy> extractResources(ListServiceConnectionPoliciesResponse payload) {
            return payload.getServiceConnectionPoliciesList();
        }
    };
    private static final PagedListDescriptor<ListServiceClassesRequest, ListServiceClassesResponse, ServiceClass> LIST_SERVICE_CLASSES_PAGE_STR_DESC = new PagedListDescriptor<ListServiceClassesRequest, ListServiceClassesResponse, ServiceClass>(){

        public String emptyToken() {
            return "";
        }

        public ListServiceClassesRequest injectToken(ListServiceClassesRequest payload, String token) {
            return ListServiceClassesRequest.newBuilder((ListServiceClassesRequest)payload).setPageToken(token).build();
        }

        public ListServiceClassesRequest injectPageSize(ListServiceClassesRequest payload, int pageSize) {
            return ListServiceClassesRequest.newBuilder((ListServiceClassesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServiceClassesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServiceClassesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ServiceClass> extractResources(ListServiceClassesResponse payload) {
            return payload.getServiceClassesList();
        }
    };
    private static final PagedListDescriptor<ListServiceConnectionTokensRequest, ListServiceConnectionTokensResponse, ServiceConnectionToken> LIST_SERVICE_CONNECTION_TOKENS_PAGE_STR_DESC = new PagedListDescriptor<ListServiceConnectionTokensRequest, ListServiceConnectionTokensResponse, ServiceConnectionToken>(){

        public String emptyToken() {
            return "";
        }

        public ListServiceConnectionTokensRequest injectToken(ListServiceConnectionTokensRequest payload, String token) {
            return ListServiceConnectionTokensRequest.newBuilder((ListServiceConnectionTokensRequest)payload).setPageToken(token).build();
        }

        public ListServiceConnectionTokensRequest injectPageSize(ListServiceConnectionTokensRequest payload, int pageSize) {
            return ListServiceConnectionTokensRequest.newBuilder((ListServiceConnectionTokensRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServiceConnectionTokensRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServiceConnectionTokensResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ServiceConnectionToken> extractResources(ListServiceConnectionTokensResponse payload) {
            return payload.getServiceConnectionTokensList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListServiceConnectionMapsRequest, ListServiceConnectionMapsResponse, CrossNetworkAutomationServiceClient.ListServiceConnectionMapsPagedResponse> LIST_SERVICE_CONNECTION_MAPS_PAGE_STR_FACT = new PagedListResponseFactory<ListServiceConnectionMapsRequest, ListServiceConnectionMapsResponse, CrossNetworkAutomationServiceClient.ListServiceConnectionMapsPagedResponse>(){

        public ApiFuture<CrossNetworkAutomationServiceClient.ListServiceConnectionMapsPagedResponse> getFuturePagedResponse(UnaryCallable<ListServiceConnectionMapsRequest, ListServiceConnectionMapsResponse> callable, ListServiceConnectionMapsRequest request, ApiCallContext context, ApiFuture<ListServiceConnectionMapsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICE_CONNECTION_MAPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CrossNetworkAutomationServiceClient.ListServiceConnectionMapsPagedResponse.createAsync((PageContext<ListServiceConnectionMapsRequest, ListServiceConnectionMapsResponse, ServiceConnectionMap>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListServiceConnectionPoliciesRequest, ListServiceConnectionPoliciesResponse, CrossNetworkAutomationServiceClient.ListServiceConnectionPoliciesPagedResponse> LIST_SERVICE_CONNECTION_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<ListServiceConnectionPoliciesRequest, ListServiceConnectionPoliciesResponse, CrossNetworkAutomationServiceClient.ListServiceConnectionPoliciesPagedResponse>(){

        public ApiFuture<CrossNetworkAutomationServiceClient.ListServiceConnectionPoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<ListServiceConnectionPoliciesRequest, ListServiceConnectionPoliciesResponse> callable, ListServiceConnectionPoliciesRequest request, ApiCallContext context, ApiFuture<ListServiceConnectionPoliciesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICE_CONNECTION_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CrossNetworkAutomationServiceClient.ListServiceConnectionPoliciesPagedResponse.createAsync((PageContext<ListServiceConnectionPoliciesRequest, ListServiceConnectionPoliciesResponse, ServiceConnectionPolicy>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListServiceClassesRequest, ListServiceClassesResponse, CrossNetworkAutomationServiceClient.ListServiceClassesPagedResponse> LIST_SERVICE_CLASSES_PAGE_STR_FACT = new PagedListResponseFactory<ListServiceClassesRequest, ListServiceClassesResponse, CrossNetworkAutomationServiceClient.ListServiceClassesPagedResponse>(){

        public ApiFuture<CrossNetworkAutomationServiceClient.ListServiceClassesPagedResponse> getFuturePagedResponse(UnaryCallable<ListServiceClassesRequest, ListServiceClassesResponse> callable, ListServiceClassesRequest request, ApiCallContext context, ApiFuture<ListServiceClassesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICE_CLASSES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CrossNetworkAutomationServiceClient.ListServiceClassesPagedResponse.createAsync((PageContext<ListServiceClassesRequest, ListServiceClassesResponse, ServiceClass>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListServiceConnectionTokensRequest, ListServiceConnectionTokensResponse, CrossNetworkAutomationServiceClient.ListServiceConnectionTokensPagedResponse> LIST_SERVICE_CONNECTION_TOKENS_PAGE_STR_FACT = new PagedListResponseFactory<ListServiceConnectionTokensRequest, ListServiceConnectionTokensResponse, CrossNetworkAutomationServiceClient.ListServiceConnectionTokensPagedResponse>(){

        public ApiFuture<CrossNetworkAutomationServiceClient.ListServiceConnectionTokensPagedResponse> getFuturePagedResponse(UnaryCallable<ListServiceConnectionTokensRequest, ListServiceConnectionTokensResponse> callable, ListServiceConnectionTokensRequest request, ApiCallContext context, ApiFuture<ListServiceConnectionTokensResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICE_CONNECTION_TOKENS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CrossNetworkAutomationServiceClient.ListServiceConnectionTokensPagedResponse.createAsync((PageContext<ListServiceConnectionTokensRequest, ListServiceConnectionTokensResponse, ServiceConnectionToken>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, CrossNetworkAutomationServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, CrossNetworkAutomationServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<CrossNetworkAutomationServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CrossNetworkAutomationServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListServiceConnectionMapsRequest, ListServiceConnectionMapsResponse, CrossNetworkAutomationServiceClient.ListServiceConnectionMapsPagedResponse> listServiceConnectionMapsSettings() {
        return this.listServiceConnectionMapsSettings;
    }

    public UnaryCallSettings<GetServiceConnectionMapRequest, ServiceConnectionMap> getServiceConnectionMapSettings() {
        return this.getServiceConnectionMapSettings;
    }

    public UnaryCallSettings<CreateServiceConnectionMapRequest, Operation> createServiceConnectionMapSettings() {
        return this.createServiceConnectionMapSettings;
    }

    public OperationCallSettings<CreateServiceConnectionMapRequest, ServiceConnectionMap, OperationMetadata> createServiceConnectionMapOperationSettings() {
        return this.createServiceConnectionMapOperationSettings;
    }

    public UnaryCallSettings<UpdateServiceConnectionMapRequest, Operation> updateServiceConnectionMapSettings() {
        return this.updateServiceConnectionMapSettings;
    }

    public OperationCallSettings<UpdateServiceConnectionMapRequest, ServiceConnectionMap, OperationMetadata> updateServiceConnectionMapOperationSettings() {
        return this.updateServiceConnectionMapOperationSettings;
    }

    public UnaryCallSettings<DeleteServiceConnectionMapRequest, Operation> deleteServiceConnectionMapSettings() {
        return this.deleteServiceConnectionMapSettings;
    }

    public OperationCallSettings<DeleteServiceConnectionMapRequest, Empty, OperationMetadata> deleteServiceConnectionMapOperationSettings() {
        return this.deleteServiceConnectionMapOperationSettings;
    }

    public PagedCallSettings<ListServiceConnectionPoliciesRequest, ListServiceConnectionPoliciesResponse, CrossNetworkAutomationServiceClient.ListServiceConnectionPoliciesPagedResponse> listServiceConnectionPoliciesSettings() {
        return this.listServiceConnectionPoliciesSettings;
    }

    public UnaryCallSettings<GetServiceConnectionPolicyRequest, ServiceConnectionPolicy> getServiceConnectionPolicySettings() {
        return this.getServiceConnectionPolicySettings;
    }

    public UnaryCallSettings<CreateServiceConnectionPolicyRequest, Operation> createServiceConnectionPolicySettings() {
        return this.createServiceConnectionPolicySettings;
    }

    public OperationCallSettings<CreateServiceConnectionPolicyRequest, ServiceConnectionPolicy, OperationMetadata> createServiceConnectionPolicyOperationSettings() {
        return this.createServiceConnectionPolicyOperationSettings;
    }

    public UnaryCallSettings<UpdateServiceConnectionPolicyRequest, Operation> updateServiceConnectionPolicySettings() {
        return this.updateServiceConnectionPolicySettings;
    }

    public OperationCallSettings<UpdateServiceConnectionPolicyRequest, ServiceConnectionPolicy, OperationMetadata> updateServiceConnectionPolicyOperationSettings() {
        return this.updateServiceConnectionPolicyOperationSettings;
    }

    public UnaryCallSettings<DeleteServiceConnectionPolicyRequest, Operation> deleteServiceConnectionPolicySettings() {
        return this.deleteServiceConnectionPolicySettings;
    }

    public OperationCallSettings<DeleteServiceConnectionPolicyRequest, Empty, OperationMetadata> deleteServiceConnectionPolicyOperationSettings() {
        return this.deleteServiceConnectionPolicyOperationSettings;
    }

    public PagedCallSettings<ListServiceClassesRequest, ListServiceClassesResponse, CrossNetworkAutomationServiceClient.ListServiceClassesPagedResponse> listServiceClassesSettings() {
        return this.listServiceClassesSettings;
    }

    public UnaryCallSettings<GetServiceClassRequest, ServiceClass> getServiceClassSettings() {
        return this.getServiceClassSettings;
    }

    public UnaryCallSettings<UpdateServiceClassRequest, Operation> updateServiceClassSettings() {
        return this.updateServiceClassSettings;
    }

    public OperationCallSettings<UpdateServiceClassRequest, ServiceClass, OperationMetadata> updateServiceClassOperationSettings() {
        return this.updateServiceClassOperationSettings;
    }

    public UnaryCallSettings<DeleteServiceClassRequest, Operation> deleteServiceClassSettings() {
        return this.deleteServiceClassSettings;
    }

    public OperationCallSettings<DeleteServiceClassRequest, Empty, OperationMetadata> deleteServiceClassOperationSettings() {
        return this.deleteServiceClassOperationSettings;
    }

    public UnaryCallSettings<GetServiceConnectionTokenRequest, ServiceConnectionToken> getServiceConnectionTokenSettings() {
        return this.getServiceConnectionTokenSettings;
    }

    public PagedCallSettings<ListServiceConnectionTokensRequest, ListServiceConnectionTokensResponse, CrossNetworkAutomationServiceClient.ListServiceConnectionTokensPagedResponse> listServiceConnectionTokensSettings() {
        return this.listServiceConnectionTokensSettings;
    }

    public UnaryCallSettings<CreateServiceConnectionTokenRequest, Operation> createServiceConnectionTokenSettings() {
        return this.createServiceConnectionTokenSettings;
    }

    public OperationCallSettings<CreateServiceConnectionTokenRequest, ServiceConnectionToken, OperationMetadata> createServiceConnectionTokenOperationSettings() {
        return this.createServiceConnectionTokenOperationSettings;
    }

    public UnaryCallSettings<DeleteServiceConnectionTokenRequest, Operation> deleteServiceConnectionTokenSettings() {
        return this.deleteServiceConnectionTokenSettings;
    }

    public OperationCallSettings<DeleteServiceConnectionTokenRequest, Empty, OperationMetadata> deleteServiceConnectionTokenOperationSettings() {
        return this.deleteServiceConnectionTokenOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, CrossNetworkAutomationServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public CrossNetworkAutomationServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCrossNetworkAutomationServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "networkconnectivity";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "networkconnectivity.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "networkconnectivity.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CrossNetworkAutomationServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CrossNetworkAutomationServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CrossNetworkAutomationServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listServiceConnectionMapsSettings = settingsBuilder.listServiceConnectionMapsSettings().build();
        this.getServiceConnectionMapSettings = settingsBuilder.getServiceConnectionMapSettings().build();
        this.createServiceConnectionMapSettings = settingsBuilder.createServiceConnectionMapSettings().build();
        this.createServiceConnectionMapOperationSettings = settingsBuilder.createServiceConnectionMapOperationSettings().build();
        this.updateServiceConnectionMapSettings = settingsBuilder.updateServiceConnectionMapSettings().build();
        this.updateServiceConnectionMapOperationSettings = settingsBuilder.updateServiceConnectionMapOperationSettings().build();
        this.deleteServiceConnectionMapSettings = settingsBuilder.deleteServiceConnectionMapSettings().build();
        this.deleteServiceConnectionMapOperationSettings = settingsBuilder.deleteServiceConnectionMapOperationSettings().build();
        this.listServiceConnectionPoliciesSettings = settingsBuilder.listServiceConnectionPoliciesSettings().build();
        this.getServiceConnectionPolicySettings = settingsBuilder.getServiceConnectionPolicySettings().build();
        this.createServiceConnectionPolicySettings = settingsBuilder.createServiceConnectionPolicySettings().build();
        this.createServiceConnectionPolicyOperationSettings = settingsBuilder.createServiceConnectionPolicyOperationSettings().build();
        this.updateServiceConnectionPolicySettings = settingsBuilder.updateServiceConnectionPolicySettings().build();
        this.updateServiceConnectionPolicyOperationSettings = settingsBuilder.updateServiceConnectionPolicyOperationSettings().build();
        this.deleteServiceConnectionPolicySettings = settingsBuilder.deleteServiceConnectionPolicySettings().build();
        this.deleteServiceConnectionPolicyOperationSettings = settingsBuilder.deleteServiceConnectionPolicyOperationSettings().build();
        this.listServiceClassesSettings = settingsBuilder.listServiceClassesSettings().build();
        this.getServiceClassSettings = settingsBuilder.getServiceClassSettings().build();
        this.updateServiceClassSettings = settingsBuilder.updateServiceClassSettings().build();
        this.updateServiceClassOperationSettings = settingsBuilder.updateServiceClassOperationSettings().build();
        this.deleteServiceClassSettings = settingsBuilder.deleteServiceClassSettings().build();
        this.deleteServiceClassOperationSettings = settingsBuilder.deleteServiceClassOperationSettings().build();
        this.getServiceConnectionTokenSettings = settingsBuilder.getServiceConnectionTokenSettings().build();
        this.listServiceConnectionTokensSettings = settingsBuilder.listServiceConnectionTokensSettings().build();
        this.createServiceConnectionTokenSettings = settingsBuilder.createServiceConnectionTokenSettings().build();
        this.createServiceConnectionTokenOperationSettings = settingsBuilder.createServiceConnectionTokenOperationSettings().build();
        this.deleteServiceConnectionTokenSettings = settingsBuilder.deleteServiceConnectionTokenSettings().build();
        this.deleteServiceConnectionTokenOperationSettings = settingsBuilder.deleteServiceConnectionTokenOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CrossNetworkAutomationServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListServiceConnectionMapsRequest, ListServiceConnectionMapsResponse, CrossNetworkAutomationServiceClient.ListServiceConnectionMapsPagedResponse> listServiceConnectionMapsSettings;
        private final UnaryCallSettings.Builder<GetServiceConnectionMapRequest, ServiceConnectionMap> getServiceConnectionMapSettings;
        private final UnaryCallSettings.Builder<CreateServiceConnectionMapRequest, Operation> createServiceConnectionMapSettings;
        private final OperationCallSettings.Builder<CreateServiceConnectionMapRequest, ServiceConnectionMap, OperationMetadata> createServiceConnectionMapOperationSettings;
        private final UnaryCallSettings.Builder<UpdateServiceConnectionMapRequest, Operation> updateServiceConnectionMapSettings;
        private final OperationCallSettings.Builder<UpdateServiceConnectionMapRequest, ServiceConnectionMap, OperationMetadata> updateServiceConnectionMapOperationSettings;
        private final UnaryCallSettings.Builder<DeleteServiceConnectionMapRequest, Operation> deleteServiceConnectionMapSettings;
        private final OperationCallSettings.Builder<DeleteServiceConnectionMapRequest, Empty, OperationMetadata> deleteServiceConnectionMapOperationSettings;
        private final PagedCallSettings.Builder<ListServiceConnectionPoliciesRequest, ListServiceConnectionPoliciesResponse, CrossNetworkAutomationServiceClient.ListServiceConnectionPoliciesPagedResponse> listServiceConnectionPoliciesSettings;
        private final UnaryCallSettings.Builder<GetServiceConnectionPolicyRequest, ServiceConnectionPolicy> getServiceConnectionPolicySettings;
        private final UnaryCallSettings.Builder<CreateServiceConnectionPolicyRequest, Operation> createServiceConnectionPolicySettings;
        private final OperationCallSettings.Builder<CreateServiceConnectionPolicyRequest, ServiceConnectionPolicy, OperationMetadata> createServiceConnectionPolicyOperationSettings;
        private final UnaryCallSettings.Builder<UpdateServiceConnectionPolicyRequest, Operation> updateServiceConnectionPolicySettings;
        private final OperationCallSettings.Builder<UpdateServiceConnectionPolicyRequest, ServiceConnectionPolicy, OperationMetadata> updateServiceConnectionPolicyOperationSettings;
        private final UnaryCallSettings.Builder<DeleteServiceConnectionPolicyRequest, Operation> deleteServiceConnectionPolicySettings;
        private final OperationCallSettings.Builder<DeleteServiceConnectionPolicyRequest, Empty, OperationMetadata> deleteServiceConnectionPolicyOperationSettings;
        private final PagedCallSettings.Builder<ListServiceClassesRequest, ListServiceClassesResponse, CrossNetworkAutomationServiceClient.ListServiceClassesPagedResponse> listServiceClassesSettings;
        private final UnaryCallSettings.Builder<GetServiceClassRequest, ServiceClass> getServiceClassSettings;
        private final UnaryCallSettings.Builder<UpdateServiceClassRequest, Operation> updateServiceClassSettings;
        private final OperationCallSettings.Builder<UpdateServiceClassRequest, ServiceClass, OperationMetadata> updateServiceClassOperationSettings;
        private final UnaryCallSettings.Builder<DeleteServiceClassRequest, Operation> deleteServiceClassSettings;
        private final OperationCallSettings.Builder<DeleteServiceClassRequest, Empty, OperationMetadata> deleteServiceClassOperationSettings;
        private final UnaryCallSettings.Builder<GetServiceConnectionTokenRequest, ServiceConnectionToken> getServiceConnectionTokenSettings;
        private final PagedCallSettings.Builder<ListServiceConnectionTokensRequest, ListServiceConnectionTokensResponse, CrossNetworkAutomationServiceClient.ListServiceConnectionTokensPagedResponse> listServiceConnectionTokensSettings;
        private final UnaryCallSettings.Builder<CreateServiceConnectionTokenRequest, Operation> createServiceConnectionTokenSettings;
        private final OperationCallSettings.Builder<CreateServiceConnectionTokenRequest, ServiceConnectionToken, OperationMetadata> createServiceConnectionTokenOperationSettings;
        private final UnaryCallSettings.Builder<DeleteServiceConnectionTokenRequest, Operation> deleteServiceConnectionTokenSettings;
        private final OperationCallSettings.Builder<DeleteServiceConnectionTokenRequest, Empty, OperationMetadata> deleteServiceConnectionTokenOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, CrossNetworkAutomationServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listServiceConnectionMapsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICE_CONNECTION_MAPS_PAGE_STR_FACT);
            this.getServiceConnectionMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceConnectionMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceConnectionMapOperationSettings = OperationCallSettings.newBuilder();
            this.updateServiceConnectionMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateServiceConnectionMapOperationSettings = OperationCallSettings.newBuilder();
            this.deleteServiceConnectionMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServiceConnectionMapOperationSettings = OperationCallSettings.newBuilder();
            this.listServiceConnectionPoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICE_CONNECTION_POLICIES_PAGE_STR_FACT);
            this.getServiceConnectionPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceConnectionPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceConnectionPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.updateServiceConnectionPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateServiceConnectionPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.deleteServiceConnectionPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServiceConnectionPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.listServiceClassesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICE_CLASSES_PAGE_STR_FACT);
            this.getServiceClassSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateServiceClassSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateServiceClassOperationSettings = OperationCallSettings.newBuilder();
            this.deleteServiceClassSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServiceClassOperationSettings = OperationCallSettings.newBuilder();
            this.getServiceConnectionTokenSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listServiceConnectionTokensSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICE_CONNECTION_TOKENS_PAGE_STR_FACT);
            this.createServiceConnectionTokenSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceConnectionTokenOperationSettings = OperationCallSettings.newBuilder();
            this.deleteServiceConnectionTokenSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServiceConnectionTokenOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listServiceConnectionMapsSettings, this.getServiceConnectionMapSettings, this.createServiceConnectionMapSettings, this.updateServiceConnectionMapSettings, this.deleteServiceConnectionMapSettings, this.listServiceConnectionPoliciesSettings, this.getServiceConnectionPolicySettings, this.createServiceConnectionPolicySettings, this.updateServiceConnectionPolicySettings, this.deleteServiceConnectionPolicySettings, this.listServiceClassesSettings, this.getServiceClassSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateServiceClassSettings, this.deleteServiceClassSettings, this.getServiceConnectionTokenSettings, this.listServiceConnectionTokensSettings, this.createServiceConnectionTokenSettings, this.deleteServiceConnectionTokenSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(CrossNetworkAutomationServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listServiceConnectionMapsSettings = settings.listServiceConnectionMapsSettings.toBuilder();
            this.getServiceConnectionMapSettings = settings.getServiceConnectionMapSettings.toBuilder();
            this.createServiceConnectionMapSettings = settings.createServiceConnectionMapSettings.toBuilder();
            this.createServiceConnectionMapOperationSettings = settings.createServiceConnectionMapOperationSettings.toBuilder();
            this.updateServiceConnectionMapSettings = settings.updateServiceConnectionMapSettings.toBuilder();
            this.updateServiceConnectionMapOperationSettings = settings.updateServiceConnectionMapOperationSettings.toBuilder();
            this.deleteServiceConnectionMapSettings = settings.deleteServiceConnectionMapSettings.toBuilder();
            this.deleteServiceConnectionMapOperationSettings = settings.deleteServiceConnectionMapOperationSettings.toBuilder();
            this.listServiceConnectionPoliciesSettings = settings.listServiceConnectionPoliciesSettings.toBuilder();
            this.getServiceConnectionPolicySettings = settings.getServiceConnectionPolicySettings.toBuilder();
            this.createServiceConnectionPolicySettings = settings.createServiceConnectionPolicySettings.toBuilder();
            this.createServiceConnectionPolicyOperationSettings = settings.createServiceConnectionPolicyOperationSettings.toBuilder();
            this.updateServiceConnectionPolicySettings = settings.updateServiceConnectionPolicySettings.toBuilder();
            this.updateServiceConnectionPolicyOperationSettings = settings.updateServiceConnectionPolicyOperationSettings.toBuilder();
            this.deleteServiceConnectionPolicySettings = settings.deleteServiceConnectionPolicySettings.toBuilder();
            this.deleteServiceConnectionPolicyOperationSettings = settings.deleteServiceConnectionPolicyOperationSettings.toBuilder();
            this.listServiceClassesSettings = settings.listServiceClassesSettings.toBuilder();
            this.getServiceClassSettings = settings.getServiceClassSettings.toBuilder();
            this.updateServiceClassSettings = settings.updateServiceClassSettings.toBuilder();
            this.updateServiceClassOperationSettings = settings.updateServiceClassOperationSettings.toBuilder();
            this.deleteServiceClassSettings = settings.deleteServiceClassSettings.toBuilder();
            this.deleteServiceClassOperationSettings = settings.deleteServiceClassOperationSettings.toBuilder();
            this.getServiceConnectionTokenSettings = settings.getServiceConnectionTokenSettings.toBuilder();
            this.listServiceConnectionTokensSettings = settings.listServiceConnectionTokensSettings.toBuilder();
            this.createServiceConnectionTokenSettings = settings.createServiceConnectionTokenSettings.toBuilder();
            this.createServiceConnectionTokenOperationSettings = settings.createServiceConnectionTokenOperationSettings.toBuilder();
            this.deleteServiceConnectionTokenSettings = settings.deleteServiceConnectionTokenSettings.toBuilder();
            this.deleteServiceConnectionTokenOperationSettings = settings.deleteServiceConnectionTokenOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listServiceConnectionMapsSettings, this.getServiceConnectionMapSettings, this.createServiceConnectionMapSettings, this.updateServiceConnectionMapSettings, this.deleteServiceConnectionMapSettings, this.listServiceConnectionPoliciesSettings, this.getServiceConnectionPolicySettings, this.createServiceConnectionPolicySettings, this.updateServiceConnectionPolicySettings, this.deleteServiceConnectionPolicySettings, this.listServiceClassesSettings, this.getServiceClassSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateServiceClassSettings, this.deleteServiceClassSettings, this.getServiceConnectionTokenSettings, this.listServiceConnectionTokensSettings, this.createServiceConnectionTokenSettings, this.deleteServiceConnectionTokenSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CrossNetworkAutomationServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CrossNetworkAutomationServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CrossNetworkAutomationServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CrossNetworkAutomationServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listServiceConnectionMapsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getServiceConnectionMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createServiceConnectionMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateServiceConnectionMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteServiceConnectionMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listServiceConnectionPoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getServiceConnectionPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createServiceConnectionPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateServiceConnectionPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteServiceConnectionPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listServiceClassesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getServiceClassSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateServiceClassSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteServiceClassSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getServiceConnectionTokenSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listServiceConnectionTokensSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createServiceConnectionTokenSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteServiceConnectionTokenSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createServiceConnectionMapOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ServiceConnectionMap.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateServiceConnectionMapOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ServiceConnectionMap.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteServiceConnectionMapOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createServiceConnectionPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ServiceConnectionPolicy.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateServiceConnectionPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ServiceConnectionPolicy.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteServiceConnectionPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateServiceClassOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ServiceClass.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteServiceClassOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createServiceConnectionTokenOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ServiceConnectionToken.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteServiceConnectionTokenOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListServiceConnectionMapsRequest, ListServiceConnectionMapsResponse, CrossNetworkAutomationServiceClient.ListServiceConnectionMapsPagedResponse> listServiceConnectionMapsSettings() {
            return this.listServiceConnectionMapsSettings;
        }

        public UnaryCallSettings.Builder<GetServiceConnectionMapRequest, ServiceConnectionMap> getServiceConnectionMapSettings() {
            return this.getServiceConnectionMapSettings;
        }

        public UnaryCallSettings.Builder<CreateServiceConnectionMapRequest, Operation> createServiceConnectionMapSettings() {
            return this.createServiceConnectionMapSettings;
        }

        public OperationCallSettings.Builder<CreateServiceConnectionMapRequest, ServiceConnectionMap, OperationMetadata> createServiceConnectionMapOperationSettings() {
            return this.createServiceConnectionMapOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateServiceConnectionMapRequest, Operation> updateServiceConnectionMapSettings() {
            return this.updateServiceConnectionMapSettings;
        }

        public OperationCallSettings.Builder<UpdateServiceConnectionMapRequest, ServiceConnectionMap, OperationMetadata> updateServiceConnectionMapOperationSettings() {
            return this.updateServiceConnectionMapOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteServiceConnectionMapRequest, Operation> deleteServiceConnectionMapSettings() {
            return this.deleteServiceConnectionMapSettings;
        }

        public OperationCallSettings.Builder<DeleteServiceConnectionMapRequest, Empty, OperationMetadata> deleteServiceConnectionMapOperationSettings() {
            return this.deleteServiceConnectionMapOperationSettings;
        }

        public PagedCallSettings.Builder<ListServiceConnectionPoliciesRequest, ListServiceConnectionPoliciesResponse, CrossNetworkAutomationServiceClient.ListServiceConnectionPoliciesPagedResponse> listServiceConnectionPoliciesSettings() {
            return this.listServiceConnectionPoliciesSettings;
        }

        public UnaryCallSettings.Builder<GetServiceConnectionPolicyRequest, ServiceConnectionPolicy> getServiceConnectionPolicySettings() {
            return this.getServiceConnectionPolicySettings;
        }

        public UnaryCallSettings.Builder<CreateServiceConnectionPolicyRequest, Operation> createServiceConnectionPolicySettings() {
            return this.createServiceConnectionPolicySettings;
        }

        public OperationCallSettings.Builder<CreateServiceConnectionPolicyRequest, ServiceConnectionPolicy, OperationMetadata> createServiceConnectionPolicyOperationSettings() {
            return this.createServiceConnectionPolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateServiceConnectionPolicyRequest, Operation> updateServiceConnectionPolicySettings() {
            return this.updateServiceConnectionPolicySettings;
        }

        public OperationCallSettings.Builder<UpdateServiceConnectionPolicyRequest, ServiceConnectionPolicy, OperationMetadata> updateServiceConnectionPolicyOperationSettings() {
            return this.updateServiceConnectionPolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteServiceConnectionPolicyRequest, Operation> deleteServiceConnectionPolicySettings() {
            return this.deleteServiceConnectionPolicySettings;
        }

        public OperationCallSettings.Builder<DeleteServiceConnectionPolicyRequest, Empty, OperationMetadata> deleteServiceConnectionPolicyOperationSettings() {
            return this.deleteServiceConnectionPolicyOperationSettings;
        }

        public PagedCallSettings.Builder<ListServiceClassesRequest, ListServiceClassesResponse, CrossNetworkAutomationServiceClient.ListServiceClassesPagedResponse> listServiceClassesSettings() {
            return this.listServiceClassesSettings;
        }

        public UnaryCallSettings.Builder<GetServiceClassRequest, ServiceClass> getServiceClassSettings() {
            return this.getServiceClassSettings;
        }

        public UnaryCallSettings.Builder<UpdateServiceClassRequest, Operation> updateServiceClassSettings() {
            return this.updateServiceClassSettings;
        }

        public OperationCallSettings.Builder<UpdateServiceClassRequest, ServiceClass, OperationMetadata> updateServiceClassOperationSettings() {
            return this.updateServiceClassOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteServiceClassRequest, Operation> deleteServiceClassSettings() {
            return this.deleteServiceClassSettings;
        }

        public OperationCallSettings.Builder<DeleteServiceClassRequest, Empty, OperationMetadata> deleteServiceClassOperationSettings() {
            return this.deleteServiceClassOperationSettings;
        }

        public UnaryCallSettings.Builder<GetServiceConnectionTokenRequest, ServiceConnectionToken> getServiceConnectionTokenSettings() {
            return this.getServiceConnectionTokenSettings;
        }

        public PagedCallSettings.Builder<ListServiceConnectionTokensRequest, ListServiceConnectionTokensResponse, CrossNetworkAutomationServiceClient.ListServiceConnectionTokensPagedResponse> listServiceConnectionTokensSettings() {
            return this.listServiceConnectionTokensSettings;
        }

        public UnaryCallSettings.Builder<CreateServiceConnectionTokenRequest, Operation> createServiceConnectionTokenSettings() {
            return this.createServiceConnectionTokenSettings;
        }

        public OperationCallSettings.Builder<CreateServiceConnectionTokenRequest, ServiceConnectionToken, OperationMetadata> createServiceConnectionTokenOperationSettings() {
            return this.createServiceConnectionTokenOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteServiceConnectionTokenRequest, Operation> deleteServiceConnectionTokenSettings() {
            return this.deleteServiceConnectionTokenSettings;
        }

        public OperationCallSettings.Builder<DeleteServiceConnectionTokenRequest, Empty, OperationMetadata> deleteServiceConnectionTokenOperationSettings() {
            return this.deleteServiceConnectionTokenOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, CrossNetworkAutomationServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public CrossNetworkAutomationServiceStubSettings build() throws IOException {
            return new CrossNetworkAutomationServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

