/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networksecurity.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.networksecurity.v1beta1.CreateDnsThreatDetectorRequest;
import com.google.cloud.networksecurity.v1beta1.DeleteDnsThreatDetectorRequest;
import com.google.cloud.networksecurity.v1beta1.DnsThreatDetector;
import com.google.cloud.networksecurity.v1beta1.DnsThreatDetectorServiceClient;
import com.google.cloud.networksecurity.v1beta1.GetDnsThreatDetectorRequest;
import com.google.cloud.networksecurity.v1beta1.ListDnsThreatDetectorsRequest;
import com.google.cloud.networksecurity.v1beta1.ListDnsThreatDetectorsResponse;
import com.google.cloud.networksecurity.v1beta1.UpdateDnsThreatDetectorRequest;
import com.google.cloud.networksecurity.v1beta1.stub.DnsThreatDetectorServiceStub;
import com.google.cloud.networksecurity.v1beta1.stub.GrpcDnsThreatDetectorServiceStub;
import com.google.cloud.networksecurity.v1beta1.stub.HttpJsonDnsThreatDetectorServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class DnsThreatDetectorServiceStubSettings
extends StubSettings<DnsThreatDetectorServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListDnsThreatDetectorsRequest, ListDnsThreatDetectorsResponse, DnsThreatDetectorServiceClient.ListDnsThreatDetectorsPagedResponse> listDnsThreatDetectorsSettings;
    private final UnaryCallSettings<GetDnsThreatDetectorRequest, DnsThreatDetector> getDnsThreatDetectorSettings;
    private final UnaryCallSettings<CreateDnsThreatDetectorRequest, DnsThreatDetector> createDnsThreatDetectorSettings;
    private final UnaryCallSettings<UpdateDnsThreatDetectorRequest, DnsThreatDetector> updateDnsThreatDetectorSettings;
    private final UnaryCallSettings<DeleteDnsThreatDetectorRequest, Empty> deleteDnsThreatDetectorSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DnsThreatDetectorServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListDnsThreatDetectorsRequest, ListDnsThreatDetectorsResponse, DnsThreatDetector> LIST_DNS_THREAT_DETECTORS_PAGE_STR_DESC = new PagedListDescriptor<ListDnsThreatDetectorsRequest, ListDnsThreatDetectorsResponse, DnsThreatDetector>(){

        public String emptyToken() {
            return "";
        }

        public ListDnsThreatDetectorsRequest injectToken(ListDnsThreatDetectorsRequest payload, String token) {
            return ListDnsThreatDetectorsRequest.newBuilder((ListDnsThreatDetectorsRequest)payload).setPageToken(token).build();
        }

        public ListDnsThreatDetectorsRequest injectPageSize(ListDnsThreatDetectorsRequest payload, int pageSize) {
            return ListDnsThreatDetectorsRequest.newBuilder((ListDnsThreatDetectorsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDnsThreatDetectorsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDnsThreatDetectorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DnsThreatDetector> extractResources(ListDnsThreatDetectorsResponse payload) {
            return payload.getDnsThreatDetectorsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListDnsThreatDetectorsRequest, ListDnsThreatDetectorsResponse, DnsThreatDetectorServiceClient.ListDnsThreatDetectorsPagedResponse> LIST_DNS_THREAT_DETECTORS_PAGE_STR_FACT = new PagedListResponseFactory<ListDnsThreatDetectorsRequest, ListDnsThreatDetectorsResponse, DnsThreatDetectorServiceClient.ListDnsThreatDetectorsPagedResponse>(){

        public ApiFuture<DnsThreatDetectorServiceClient.ListDnsThreatDetectorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDnsThreatDetectorsRequest, ListDnsThreatDetectorsResponse> callable, ListDnsThreatDetectorsRequest request, ApiCallContext context, ApiFuture<ListDnsThreatDetectorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DNS_THREAT_DETECTORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DnsThreatDetectorServiceClient.ListDnsThreatDetectorsPagedResponse.createAsync((PageContext<ListDnsThreatDetectorsRequest, ListDnsThreatDetectorsResponse, DnsThreatDetector>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DnsThreatDetectorServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DnsThreatDetectorServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<DnsThreatDetectorServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DnsThreatDetectorServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListDnsThreatDetectorsRequest, ListDnsThreatDetectorsResponse, DnsThreatDetectorServiceClient.ListDnsThreatDetectorsPagedResponse> listDnsThreatDetectorsSettings() {
        return this.listDnsThreatDetectorsSettings;
    }

    public UnaryCallSettings<GetDnsThreatDetectorRequest, DnsThreatDetector> getDnsThreatDetectorSettings() {
        return this.getDnsThreatDetectorSettings;
    }

    public UnaryCallSettings<CreateDnsThreatDetectorRequest, DnsThreatDetector> createDnsThreatDetectorSettings() {
        return this.createDnsThreatDetectorSettings;
    }

    public UnaryCallSettings<UpdateDnsThreatDetectorRequest, DnsThreatDetector> updateDnsThreatDetectorSettings() {
        return this.updateDnsThreatDetectorSettings;
    }

    public UnaryCallSettings<DeleteDnsThreatDetectorRequest, Empty> deleteDnsThreatDetectorSettings() {
        return this.deleteDnsThreatDetectorSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DnsThreatDetectorServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public DnsThreatDetectorServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDnsThreatDetectorServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDnsThreatDetectorServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "networksecurity";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "networksecurity.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "networksecurity.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DnsThreatDetectorServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DnsThreatDetectorServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DnsThreatDetectorServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DnsThreatDetectorServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DnsThreatDetectorServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listDnsThreatDetectorsSettings = settingsBuilder.listDnsThreatDetectorsSettings().build();
        this.getDnsThreatDetectorSettings = settingsBuilder.getDnsThreatDetectorSettings().build();
        this.createDnsThreatDetectorSettings = settingsBuilder.createDnsThreatDetectorSettings().build();
        this.updateDnsThreatDetectorSettings = settingsBuilder.updateDnsThreatDetectorSettings().build();
        this.deleteDnsThreatDetectorSettings = settingsBuilder.deleteDnsThreatDetectorSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DnsThreatDetectorServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListDnsThreatDetectorsRequest, ListDnsThreatDetectorsResponse, DnsThreatDetectorServiceClient.ListDnsThreatDetectorsPagedResponse> listDnsThreatDetectorsSettings;
        private final UnaryCallSettings.Builder<GetDnsThreatDetectorRequest, DnsThreatDetector> getDnsThreatDetectorSettings;
        private final UnaryCallSettings.Builder<CreateDnsThreatDetectorRequest, DnsThreatDetector> createDnsThreatDetectorSettings;
        private final UnaryCallSettings.Builder<UpdateDnsThreatDetectorRequest, DnsThreatDetector> updateDnsThreatDetectorSettings;
        private final UnaryCallSettings.Builder<DeleteDnsThreatDetectorRequest, Empty> deleteDnsThreatDetectorSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DnsThreatDetectorServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listDnsThreatDetectorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DNS_THREAT_DETECTORS_PAGE_STR_FACT);
            this.getDnsThreatDetectorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDnsThreatDetectorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDnsThreatDetectorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDnsThreatDetectorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDnsThreatDetectorsSettings, this.getDnsThreatDetectorSettings, this.createDnsThreatDetectorSettings, this.updateDnsThreatDetectorSettings, this.deleteDnsThreatDetectorSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DnsThreatDetectorServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listDnsThreatDetectorsSettings = settings.listDnsThreatDetectorsSettings.toBuilder();
            this.getDnsThreatDetectorSettings = settings.getDnsThreatDetectorSettings.toBuilder();
            this.createDnsThreatDetectorSettings = settings.createDnsThreatDetectorSettings.toBuilder();
            this.updateDnsThreatDetectorSettings = settings.updateDnsThreatDetectorSettings.toBuilder();
            this.deleteDnsThreatDetectorSettings = settings.deleteDnsThreatDetectorSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listDnsThreatDetectorsSettings, this.getDnsThreatDetectorSettings, this.createDnsThreatDetectorSettings, this.updateDnsThreatDetectorSettings, this.deleteDnsThreatDetectorSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DnsThreatDetectorServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DnsThreatDetectorServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DnsThreatDetectorServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DnsThreatDetectorServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DnsThreatDetectorServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DnsThreatDetectorServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DnsThreatDetectorServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DnsThreatDetectorServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listDnsThreatDetectorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getDnsThreatDetectorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createDnsThreatDetectorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateDnsThreatDetectorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteDnsThreatDetectorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListDnsThreatDetectorsRequest, ListDnsThreatDetectorsResponse, DnsThreatDetectorServiceClient.ListDnsThreatDetectorsPagedResponse> listDnsThreatDetectorsSettings() {
            return this.listDnsThreatDetectorsSettings;
        }

        public UnaryCallSettings.Builder<GetDnsThreatDetectorRequest, DnsThreatDetector> getDnsThreatDetectorSettings() {
            return this.getDnsThreatDetectorSettings;
        }

        public UnaryCallSettings.Builder<CreateDnsThreatDetectorRequest, DnsThreatDetector> createDnsThreatDetectorSettings() {
            return this.createDnsThreatDetectorSettings;
        }

        public UnaryCallSettings.Builder<UpdateDnsThreatDetectorRequest, DnsThreatDetector> updateDnsThreatDetectorSettings() {
            return this.updateDnsThreatDetectorSettings;
        }

        public UnaryCallSettings.Builder<DeleteDnsThreatDetectorRequest, Empty> deleteDnsThreatDetectorSettings() {
            return this.deleteDnsThreatDetectorSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DnsThreatDetectorServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public DnsThreatDetectorServiceStubSettings build() throws IOException {
            return new DnsThreatDetectorServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

