/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.networkmanagement.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.networkmanagement.v1.ConnectivityTest;
import com.google.cloud.networkmanagement.v1.CreateConnectivityTestRequest;
import com.google.cloud.networkmanagement.v1.DeleteConnectivityTestRequest;
import com.google.cloud.networkmanagement.v1.GetConnectivityTestRequest;
import com.google.cloud.networkmanagement.v1.ListConnectivityTestsRequest;
import com.google.cloud.networkmanagement.v1.ListConnectivityTestsResponse;
import com.google.cloud.networkmanagement.v1.OperationMetadata;
import com.google.cloud.networkmanagement.v1.ReachabilityServiceClient;
import com.google.cloud.networkmanagement.v1.RerunConnectivityTestRequest;
import com.google.cloud.networkmanagement.v1.UpdateConnectivityTestRequest;
import com.google.cloud.networkmanagement.v1.stub.HttpJsonReachabilityServiceCallableFactory;
import com.google.cloud.networkmanagement.v1.stub.ReachabilityServiceStub;
import com.google.cloud.networkmanagement.v1.stub.ReachabilityServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonReachabilityServiceStub
extends ReachabilityServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(OperationMetadata.getDescriptor()).add(ConnectivityTest.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListConnectivityTestsRequest, ListConnectivityTestsResponse> listConnectivityTestsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.networkmanagement.v1.ReachabilityService/ListConnectivityTests").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/global}/connectivityTests", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListConnectivityTestsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetConnectivityTestRequest, ConnectivityTest> getConnectivityTestMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.networkmanagement.v1.ReachabilityService/GetConnectivityTest").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/global/connectivityTests/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ConnectivityTest.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateConnectivityTestRequest, Operation> createConnectivityTestMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.networkmanagement.v1.ReachabilityService/CreateConnectivityTest").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/global}/connectivityTests", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "testId", (Object)request.getTestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("resource", (Message)request.getResource(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateConnectivityTestRequest, Operation> updateConnectivityTestMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.networkmanagement.v1.ReachabilityService/UpdateConnectivityTest").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource.name=projects/*/locations/global/connectivityTests/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource.name", (Object)request.getResource().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("resource", (Message)request.getResource(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<RerunConnectivityTestRequest, Operation> rerunConnectivityTestMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.networkmanagement.v1.ReachabilityService/RerunConnectivityTest").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/global/connectivityTests/*}:rerun", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteConnectivityTestRequest, Operation> deleteConnectivityTestMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.networkmanagement.v1.ReachabilityService/DeleteConnectivityTest").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/global/connectivityTests/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<ListConnectivityTestsRequest, ListConnectivityTestsResponse> listConnectivityTestsCallable;
    private final UnaryCallable<ListConnectivityTestsRequest, ReachabilityServiceClient.ListConnectivityTestsPagedResponse> listConnectivityTestsPagedCallable;
    private final UnaryCallable<GetConnectivityTestRequest, ConnectivityTest> getConnectivityTestCallable;
    private final UnaryCallable<CreateConnectivityTestRequest, Operation> createConnectivityTestCallable;
    private final OperationCallable<CreateConnectivityTestRequest, ConnectivityTest, OperationMetadata> createConnectivityTestOperationCallable;
    private final UnaryCallable<UpdateConnectivityTestRequest, Operation> updateConnectivityTestCallable;
    private final OperationCallable<UpdateConnectivityTestRequest, ConnectivityTest, OperationMetadata> updateConnectivityTestOperationCallable;
    private final UnaryCallable<RerunConnectivityTestRequest, Operation> rerunConnectivityTestCallable;
    private final OperationCallable<RerunConnectivityTestRequest, ConnectivityTest, OperationMetadata> rerunConnectivityTestOperationCallable;
    private final UnaryCallable<DeleteConnectivityTestRequest, Operation> deleteConnectivityTestCallable;
    private final OperationCallable<DeleteConnectivityTestRequest, Empty, OperationMetadata> deleteConnectivityTestOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonReachabilityServiceStub create(ReachabilityServiceStubSettings settings) throws IOException {
        return new HttpJsonReachabilityServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonReachabilityServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonReachabilityServiceStub(ReachabilityServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonReachabilityServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonReachabilityServiceStub(ReachabilityServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonReachabilityServiceStub(ReachabilityServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonReachabilityServiceCallableFactory());
    }

    protected HttpJsonReachabilityServiceStub(ReachabilityServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=projects/*/locations/global/operations/*}:cancel").build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1/{name=projects/*/locations/global/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/global/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/global}/operations").build()).build());
        HttpJsonCallSettings listConnectivityTestsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listConnectivityTestsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getConnectivityTestTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getConnectivityTestMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createConnectivityTestTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createConnectivityTestMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateConnectivityTestTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateConnectivityTestMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings rerunConnectivityTestTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(rerunConnectivityTestMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteConnectivityTestTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteConnectivityTestMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listConnectivityTestsCallable = callableFactory.createUnaryCallable(listConnectivityTestsTransportSettings, settings.listConnectivityTestsSettings(), clientContext);
        this.listConnectivityTestsPagedCallable = callableFactory.createPagedCallable(listConnectivityTestsTransportSettings, settings.listConnectivityTestsSettings(), clientContext);
        this.getConnectivityTestCallable = callableFactory.createUnaryCallable(getConnectivityTestTransportSettings, settings.getConnectivityTestSettings(), clientContext);
        this.createConnectivityTestCallable = callableFactory.createUnaryCallable(createConnectivityTestTransportSettings, settings.createConnectivityTestSettings(), clientContext);
        this.createConnectivityTestOperationCallable = callableFactory.createOperationCallable(createConnectivityTestTransportSettings, settings.createConnectivityTestOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateConnectivityTestCallable = callableFactory.createUnaryCallable(updateConnectivityTestTransportSettings, settings.updateConnectivityTestSettings(), clientContext);
        this.updateConnectivityTestOperationCallable = callableFactory.createOperationCallable(updateConnectivityTestTransportSettings, settings.updateConnectivityTestOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.rerunConnectivityTestCallable = callableFactory.createUnaryCallable(rerunConnectivityTestTransportSettings, settings.rerunConnectivityTestSettings(), clientContext);
        this.rerunConnectivityTestOperationCallable = callableFactory.createOperationCallable(rerunConnectivityTestTransportSettings, settings.rerunConnectivityTestOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteConnectivityTestCallable = callableFactory.createUnaryCallable(deleteConnectivityTestTransportSettings, settings.deleteConnectivityTestSettings(), clientContext);
        this.deleteConnectivityTestOperationCallable = callableFactory.createOperationCallable(deleteConnectivityTestTransportSettings, settings.deleteConnectivityTestOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listConnectivityTestsMethodDescriptor);
        methodDescriptors.add(getConnectivityTestMethodDescriptor);
        methodDescriptors.add(createConnectivityTestMethodDescriptor);
        methodDescriptors.add(updateConnectivityTestMethodDescriptor);
        methodDescriptors.add(rerunConnectivityTestMethodDescriptor);
        methodDescriptors.add(deleteConnectivityTestMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListConnectivityTestsRequest, ListConnectivityTestsResponse> listConnectivityTestsCallable() {
        return this.listConnectivityTestsCallable;
    }

    @Override
    public UnaryCallable<ListConnectivityTestsRequest, ReachabilityServiceClient.ListConnectivityTestsPagedResponse> listConnectivityTestsPagedCallable() {
        return this.listConnectivityTestsPagedCallable;
    }

    @Override
    public UnaryCallable<GetConnectivityTestRequest, ConnectivityTest> getConnectivityTestCallable() {
        return this.getConnectivityTestCallable;
    }

    @Override
    public UnaryCallable<CreateConnectivityTestRequest, Operation> createConnectivityTestCallable() {
        return this.createConnectivityTestCallable;
    }

    @Override
    public OperationCallable<CreateConnectivityTestRequest, ConnectivityTest, OperationMetadata> createConnectivityTestOperationCallable() {
        return this.createConnectivityTestOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateConnectivityTestRequest, Operation> updateConnectivityTestCallable() {
        return this.updateConnectivityTestCallable;
    }

    @Override
    public OperationCallable<UpdateConnectivityTestRequest, ConnectivityTest, OperationMetadata> updateConnectivityTestOperationCallable() {
        return this.updateConnectivityTestOperationCallable;
    }

    @Override
    public UnaryCallable<RerunConnectivityTestRequest, Operation> rerunConnectivityTestCallable() {
        return this.rerunConnectivityTestCallable;
    }

    @Override
    public OperationCallable<RerunConnectivityTestRequest, ConnectivityTest, OperationMetadata> rerunConnectivityTestOperationCallable() {
        return this.rerunConnectivityTestOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteConnectivityTestRequest, Operation> deleteConnectivityTestCallable() {
        return this.deleteConnectivityTestCallable;
    }

    @Override
    public OperationCallable<DeleteConnectivityTestRequest, Empty, OperationMetadata> deleteConnectivityTestOperationCallable() {
        return this.deleteConnectivityTestOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

