/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.managedkafka.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.managedkafka.v1.Acl;
import com.google.cloud.managedkafka.v1.AddAclEntryRequest;
import com.google.cloud.managedkafka.v1.AddAclEntryResponse;
import com.google.cloud.managedkafka.v1.Cluster;
import com.google.cloud.managedkafka.v1.ConsumerGroup;
import com.google.cloud.managedkafka.v1.CreateAclRequest;
import com.google.cloud.managedkafka.v1.CreateClusterRequest;
import com.google.cloud.managedkafka.v1.CreateTopicRequest;
import com.google.cloud.managedkafka.v1.DeleteAclRequest;
import com.google.cloud.managedkafka.v1.DeleteClusterRequest;
import com.google.cloud.managedkafka.v1.DeleteConsumerGroupRequest;
import com.google.cloud.managedkafka.v1.DeleteTopicRequest;
import com.google.cloud.managedkafka.v1.GetAclRequest;
import com.google.cloud.managedkafka.v1.GetClusterRequest;
import com.google.cloud.managedkafka.v1.GetConsumerGroupRequest;
import com.google.cloud.managedkafka.v1.GetTopicRequest;
import com.google.cloud.managedkafka.v1.ListAclsRequest;
import com.google.cloud.managedkafka.v1.ListAclsResponse;
import com.google.cloud.managedkafka.v1.ListClustersRequest;
import com.google.cloud.managedkafka.v1.ListClustersResponse;
import com.google.cloud.managedkafka.v1.ListConsumerGroupsRequest;
import com.google.cloud.managedkafka.v1.ListConsumerGroupsResponse;
import com.google.cloud.managedkafka.v1.ListTopicsRequest;
import com.google.cloud.managedkafka.v1.ListTopicsResponse;
import com.google.cloud.managedkafka.v1.ManagedKafkaClient;
import com.google.cloud.managedkafka.v1.OperationMetadata;
import com.google.cloud.managedkafka.v1.RemoveAclEntryRequest;
import com.google.cloud.managedkafka.v1.RemoveAclEntryResponse;
import com.google.cloud.managedkafka.v1.Topic;
import com.google.cloud.managedkafka.v1.UpdateAclRequest;
import com.google.cloud.managedkafka.v1.UpdateClusterRequest;
import com.google.cloud.managedkafka.v1.UpdateConsumerGroupRequest;
import com.google.cloud.managedkafka.v1.UpdateTopicRequest;
import com.google.cloud.managedkafka.v1.stub.HttpJsonManagedKafkaCallableFactory;
import com.google.cloud.managedkafka.v1.stub.ManagedKafkaStub;
import com.google.cloud.managedkafka.v1.stub.ManagedKafkaStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonManagedKafkaStub
extends ManagedKafkaStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(Cluster.getDescriptor()).add(OperationMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListClustersRequest, ListClustersResponse> listClustersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/ListClusters").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/clusters", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListClustersResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetClusterRequest, Cluster> getClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/GetCluster").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/clusters/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Cluster.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateClusterRequest, Operation> createClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/CreateCluster").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/clusters", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "clusterId", (Object)request.getClusterId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("cluster", (Message)request.getCluster(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateClusterRequest, Operation> updateClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/UpdateCluster").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{cluster.name=projects/*/locations/*/clusters/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "cluster.name", (Object)request.getCluster().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("cluster", (Message)request.getCluster(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteClusterRequest, Operation> deleteClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/DeleteCluster").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/clusters/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListTopicsRequest, ListTopicsResponse> listTopicsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/ListTopics").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/clusters/*}/topics", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListTopicsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetTopicRequest, Topic> getTopicMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/GetTopic").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/clusters/*/topics/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Topic.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateTopicRequest, Topic> createTopicMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/CreateTopic").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/clusters/*}/topics", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "topicId", (Object)request.getTopicId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("topic", (Message)request.getTopic(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Topic.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateTopicRequest, Topic> updateTopicMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/UpdateTopic").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{topic.name=projects/*/locations/*/clusters/*/topics/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "topic.name", (Object)request.getTopic().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("topic", (Message)request.getTopic(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Topic.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteTopicRequest, Empty> deleteTopicMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/DeleteTopic").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/clusters/*/topics/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListConsumerGroupsRequest, ListConsumerGroupsResponse> listConsumerGroupsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/ListConsumerGroups").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/clusters/*}/consumerGroups", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListConsumerGroupsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetConsumerGroupRequest, ConsumerGroup> getConsumerGroupMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/GetConsumerGroup").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/clusters/*/consumerGroups/**}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ConsumerGroup.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateConsumerGroupRequest, ConsumerGroup> updateConsumerGroupMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/UpdateConsumerGroup").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{consumerGroup.name=projects/*/locations/*/clusters/*/consumerGroups/**}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "consumerGroup.name", (Object)request.getConsumerGroup().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("consumerGroup", (Message)request.getConsumerGroup(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ConsumerGroup.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteConsumerGroupRequest, Empty> deleteConsumerGroupMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/DeleteConsumerGroup").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/clusters/*/consumerGroups/**}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListAclsRequest, ListAclsResponse> listAclsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/ListAcls").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/clusters/*}/acls", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListAclsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetAclRequest, Acl> getAclMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/GetAcl").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/clusters/*/acls/**}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Acl.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateAclRequest, Acl> createAclMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/CreateAcl").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/clusters/*}/acls", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "aclId", (Object)request.getAclId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("acl", (Message)request.getAcl(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Acl.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateAclRequest, Acl> updateAclMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/UpdateAcl").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{acl.name=projects/*/locations/*/clusters/*/acls/**}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "acl.name", (Object)request.getAcl().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("acl", (Message)request.getAcl(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Acl.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteAclRequest, Empty> deleteAclMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/DeleteAcl").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/clusters/*/acls/**}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<AddAclEntryRequest, AddAclEntryResponse> addAclEntryMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/AddAclEntry").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{acl=projects/*/locations/*/clusters/*/acls/**}:addAclEntry", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "acl", (Object)request.getAcl());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("aclEntry", (Message)request.getAclEntry(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AddAclEntryResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<RemoveAclEntryRequest, RemoveAclEntryResponse> removeAclEntryMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.managedkafka.v1.ManagedKafka/RemoveAclEntry").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{acl=projects/*/locations/*/clusters/*/acls/**}:removeAclEntry", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "acl", (Object)request.getAcl());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("aclEntry", (Message)request.getAclEntry(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)RemoveAclEntryResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable;
    private final UnaryCallable<ListClustersRequest, ManagedKafkaClient.ListClustersPagedResponse> listClustersPagedCallable;
    private final UnaryCallable<GetClusterRequest, Cluster> getClusterCallable;
    private final UnaryCallable<CreateClusterRequest, Operation> createClusterCallable;
    private final OperationCallable<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationCallable;
    private final UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable;
    private final OperationCallable<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationCallable;
    private final UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable;
    private final OperationCallable<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationCallable;
    private final UnaryCallable<ListTopicsRequest, ListTopicsResponse> listTopicsCallable;
    private final UnaryCallable<ListTopicsRequest, ManagedKafkaClient.ListTopicsPagedResponse> listTopicsPagedCallable;
    private final UnaryCallable<GetTopicRequest, Topic> getTopicCallable;
    private final UnaryCallable<CreateTopicRequest, Topic> createTopicCallable;
    private final UnaryCallable<UpdateTopicRequest, Topic> updateTopicCallable;
    private final UnaryCallable<DeleteTopicRequest, Empty> deleteTopicCallable;
    private final UnaryCallable<ListConsumerGroupsRequest, ListConsumerGroupsResponse> listConsumerGroupsCallable;
    private final UnaryCallable<ListConsumerGroupsRequest, ManagedKafkaClient.ListConsumerGroupsPagedResponse> listConsumerGroupsPagedCallable;
    private final UnaryCallable<GetConsumerGroupRequest, ConsumerGroup> getConsumerGroupCallable;
    private final UnaryCallable<UpdateConsumerGroupRequest, ConsumerGroup> updateConsumerGroupCallable;
    private final UnaryCallable<DeleteConsumerGroupRequest, Empty> deleteConsumerGroupCallable;
    private final UnaryCallable<ListAclsRequest, ListAclsResponse> listAclsCallable;
    private final UnaryCallable<ListAclsRequest, ManagedKafkaClient.ListAclsPagedResponse> listAclsPagedCallable;
    private final UnaryCallable<GetAclRequest, Acl> getAclCallable;
    private final UnaryCallable<CreateAclRequest, Acl> createAclCallable;
    private final UnaryCallable<UpdateAclRequest, Acl> updateAclCallable;
    private final UnaryCallable<DeleteAclRequest, Empty> deleteAclCallable;
    private final UnaryCallable<AddAclEntryRequest, AddAclEntryResponse> addAclEntryCallable;
    private final UnaryCallable<RemoveAclEntryRequest, RemoveAclEntryResponse> removeAclEntryCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ManagedKafkaClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonManagedKafkaStub create(ManagedKafkaStubSettings settings) throws IOException {
        return new HttpJsonManagedKafkaStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonManagedKafkaStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonManagedKafkaStub(ManagedKafkaStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonManagedKafkaStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonManagedKafkaStub(ManagedKafkaStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonManagedKafkaStub(ManagedKafkaStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonManagedKafkaCallableFactory());
    }

    protected HttpJsonManagedKafkaStub(ManagedKafkaStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=projects/*/locations/*/operations/*}:cancel").build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*}/operations").build()).build());
        HttpJsonCallSettings listClustersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listClustersMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getClusterMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createClusterMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateClusterMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("cluster.name", String.valueOf(request.getCluster().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteClusterMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listTopicsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listTopicsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getTopicTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getTopicMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createTopicTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createTopicMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateTopicTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateTopicMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("topic.name", String.valueOf(request.getTopic().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteTopicTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteTopicMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listConsumerGroupsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listConsumerGroupsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getConsumerGroupTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getConsumerGroupMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateConsumerGroupTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateConsumerGroupMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("consumer_group.name", String.valueOf(request.getConsumerGroup().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteConsumerGroupTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteConsumerGroupMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listAclsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listAclsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getAclTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getAclMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createAclTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createAclMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateAclTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateAclMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("acl.name", String.valueOf(request.getAcl().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteAclTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteAclMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings addAclEntryTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(addAclEntryMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("acl", String.valueOf(request.getAcl()));
            return builder.build();
        }).build();
        HttpJsonCallSettings removeAclEntryTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(removeAclEntryMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("acl", String.valueOf(request.getAcl()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listClustersCallable = callableFactory.createUnaryCallable(listClustersTransportSettings, settings.listClustersSettings(), clientContext);
        this.listClustersPagedCallable = callableFactory.createPagedCallable(listClustersTransportSettings, settings.listClustersSettings(), clientContext);
        this.getClusterCallable = callableFactory.createUnaryCallable(getClusterTransportSettings, settings.getClusterSettings(), clientContext);
        this.createClusterCallable = callableFactory.createUnaryCallable(createClusterTransportSettings, settings.createClusterSettings(), clientContext);
        this.createClusterOperationCallable = callableFactory.createOperationCallable(createClusterTransportSettings, settings.createClusterOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateClusterCallable = callableFactory.createUnaryCallable(updateClusterTransportSettings, settings.updateClusterSettings(), clientContext);
        this.updateClusterOperationCallable = callableFactory.createOperationCallable(updateClusterTransportSettings, settings.updateClusterOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteClusterCallable = callableFactory.createUnaryCallable(deleteClusterTransportSettings, settings.deleteClusterSettings(), clientContext);
        this.deleteClusterOperationCallable = callableFactory.createOperationCallable(deleteClusterTransportSettings, settings.deleteClusterOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listTopicsCallable = callableFactory.createUnaryCallable(listTopicsTransportSettings, settings.listTopicsSettings(), clientContext);
        this.listTopicsPagedCallable = callableFactory.createPagedCallable(listTopicsTransportSettings, settings.listTopicsSettings(), clientContext);
        this.getTopicCallable = callableFactory.createUnaryCallable(getTopicTransportSettings, settings.getTopicSettings(), clientContext);
        this.createTopicCallable = callableFactory.createUnaryCallable(createTopicTransportSettings, settings.createTopicSettings(), clientContext);
        this.updateTopicCallable = callableFactory.createUnaryCallable(updateTopicTransportSettings, settings.updateTopicSettings(), clientContext);
        this.deleteTopicCallable = callableFactory.createUnaryCallable(deleteTopicTransportSettings, settings.deleteTopicSettings(), clientContext);
        this.listConsumerGroupsCallable = callableFactory.createUnaryCallable(listConsumerGroupsTransportSettings, settings.listConsumerGroupsSettings(), clientContext);
        this.listConsumerGroupsPagedCallable = callableFactory.createPagedCallable(listConsumerGroupsTransportSettings, settings.listConsumerGroupsSettings(), clientContext);
        this.getConsumerGroupCallable = callableFactory.createUnaryCallable(getConsumerGroupTransportSettings, settings.getConsumerGroupSettings(), clientContext);
        this.updateConsumerGroupCallable = callableFactory.createUnaryCallable(updateConsumerGroupTransportSettings, settings.updateConsumerGroupSettings(), clientContext);
        this.deleteConsumerGroupCallable = callableFactory.createUnaryCallable(deleteConsumerGroupTransportSettings, settings.deleteConsumerGroupSettings(), clientContext);
        this.listAclsCallable = callableFactory.createUnaryCallable(listAclsTransportSettings, settings.listAclsSettings(), clientContext);
        this.listAclsPagedCallable = callableFactory.createPagedCallable(listAclsTransportSettings, settings.listAclsSettings(), clientContext);
        this.getAclCallable = callableFactory.createUnaryCallable(getAclTransportSettings, settings.getAclSettings(), clientContext);
        this.createAclCallable = callableFactory.createUnaryCallable(createAclTransportSettings, settings.createAclSettings(), clientContext);
        this.updateAclCallable = callableFactory.createUnaryCallable(updateAclTransportSettings, settings.updateAclSettings(), clientContext);
        this.deleteAclCallable = callableFactory.createUnaryCallable(deleteAclTransportSettings, settings.deleteAclSettings(), clientContext);
        this.addAclEntryCallable = callableFactory.createUnaryCallable(addAclEntryTransportSettings, settings.addAclEntrySettings(), clientContext);
        this.removeAclEntryCallable = callableFactory.createUnaryCallable(removeAclEntryTransportSettings, settings.removeAclEntrySettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listClustersMethodDescriptor);
        methodDescriptors.add(getClusterMethodDescriptor);
        methodDescriptors.add(createClusterMethodDescriptor);
        methodDescriptors.add(updateClusterMethodDescriptor);
        methodDescriptors.add(deleteClusterMethodDescriptor);
        methodDescriptors.add(listTopicsMethodDescriptor);
        methodDescriptors.add(getTopicMethodDescriptor);
        methodDescriptors.add(createTopicMethodDescriptor);
        methodDescriptors.add(updateTopicMethodDescriptor);
        methodDescriptors.add(deleteTopicMethodDescriptor);
        methodDescriptors.add(listConsumerGroupsMethodDescriptor);
        methodDescriptors.add(getConsumerGroupMethodDescriptor);
        methodDescriptors.add(updateConsumerGroupMethodDescriptor);
        methodDescriptors.add(deleteConsumerGroupMethodDescriptor);
        methodDescriptors.add(listAclsMethodDescriptor);
        methodDescriptors.add(getAclMethodDescriptor);
        methodDescriptors.add(createAclMethodDescriptor);
        methodDescriptors.add(updateAclMethodDescriptor);
        methodDescriptors.add(deleteAclMethodDescriptor);
        methodDescriptors.add(addAclEntryMethodDescriptor);
        methodDescriptors.add(removeAclEntryMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable() {
        return this.listClustersCallable;
    }

    @Override
    public UnaryCallable<ListClustersRequest, ManagedKafkaClient.ListClustersPagedResponse> listClustersPagedCallable() {
        return this.listClustersPagedCallable;
    }

    @Override
    public UnaryCallable<GetClusterRequest, Cluster> getClusterCallable() {
        return this.getClusterCallable;
    }

    @Override
    public UnaryCallable<CreateClusterRequest, Operation> createClusterCallable() {
        return this.createClusterCallable;
    }

    @Override
    public OperationCallable<CreateClusterRequest, Cluster, OperationMetadata> createClusterOperationCallable() {
        return this.createClusterOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable() {
        return this.updateClusterCallable;
    }

    @Override
    public OperationCallable<UpdateClusterRequest, Cluster, OperationMetadata> updateClusterOperationCallable() {
        return this.updateClusterOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable() {
        return this.deleteClusterCallable;
    }

    @Override
    public OperationCallable<DeleteClusterRequest, Empty, OperationMetadata> deleteClusterOperationCallable() {
        return this.deleteClusterOperationCallable;
    }

    @Override
    public UnaryCallable<ListTopicsRequest, ListTopicsResponse> listTopicsCallable() {
        return this.listTopicsCallable;
    }

    @Override
    public UnaryCallable<ListTopicsRequest, ManagedKafkaClient.ListTopicsPagedResponse> listTopicsPagedCallable() {
        return this.listTopicsPagedCallable;
    }

    @Override
    public UnaryCallable<GetTopicRequest, Topic> getTopicCallable() {
        return this.getTopicCallable;
    }

    @Override
    public UnaryCallable<CreateTopicRequest, Topic> createTopicCallable() {
        return this.createTopicCallable;
    }

    @Override
    public UnaryCallable<UpdateTopicRequest, Topic> updateTopicCallable() {
        return this.updateTopicCallable;
    }

    @Override
    public UnaryCallable<DeleteTopicRequest, Empty> deleteTopicCallable() {
        return this.deleteTopicCallable;
    }

    @Override
    public UnaryCallable<ListConsumerGroupsRequest, ListConsumerGroupsResponse> listConsumerGroupsCallable() {
        return this.listConsumerGroupsCallable;
    }

    @Override
    public UnaryCallable<ListConsumerGroupsRequest, ManagedKafkaClient.ListConsumerGroupsPagedResponse> listConsumerGroupsPagedCallable() {
        return this.listConsumerGroupsPagedCallable;
    }

    @Override
    public UnaryCallable<GetConsumerGroupRequest, ConsumerGroup> getConsumerGroupCallable() {
        return this.getConsumerGroupCallable;
    }

    @Override
    public UnaryCallable<UpdateConsumerGroupRequest, ConsumerGroup> updateConsumerGroupCallable() {
        return this.updateConsumerGroupCallable;
    }

    @Override
    public UnaryCallable<DeleteConsumerGroupRequest, Empty> deleteConsumerGroupCallable() {
        return this.deleteConsumerGroupCallable;
    }

    @Override
    public UnaryCallable<ListAclsRequest, ListAclsResponse> listAclsCallable() {
        return this.listAclsCallable;
    }

    @Override
    public UnaryCallable<ListAclsRequest, ManagedKafkaClient.ListAclsPagedResponse> listAclsPagedCallable() {
        return this.listAclsPagedCallable;
    }

    @Override
    public UnaryCallable<GetAclRequest, Acl> getAclCallable() {
        return this.getAclCallable;
    }

    @Override
    public UnaryCallable<CreateAclRequest, Acl> createAclCallable() {
        return this.createAclCallable;
    }

    @Override
    public UnaryCallable<UpdateAclRequest, Acl> updateAclCallable() {
        return this.updateAclCallable;
    }

    @Override
    public UnaryCallable<DeleteAclRequest, Empty> deleteAclCallable() {
        return this.deleteAclCallable;
    }

    @Override
    public UnaryCallable<AddAclEntryRequest, AddAclEntryResponse> addAclEntryCallable() {
        return this.addAclEntryCallable;
    }

    @Override
    public UnaryCallable<RemoveAclEntryRequest, RemoveAclEntryResponse> removeAclEntryCallable() {
        return this.removeAclEntryCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ManagedKafkaClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

