/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.maintenance.api.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.maintenance.api.v1beta.GetResourceMaintenanceRequest;
import com.google.cloud.maintenance.api.v1beta.ListResourceMaintenancesRequest;
import com.google.cloud.maintenance.api.v1beta.ListResourceMaintenancesResponse;
import com.google.cloud.maintenance.api.v1beta.MaintenanceClient;
import com.google.cloud.maintenance.api.v1beta.ResourceMaintenance;
import com.google.cloud.maintenance.api.v1beta.SummarizeMaintenancesRequest;
import com.google.cloud.maintenance.api.v1beta.SummarizeMaintenancesResponse;
import com.google.cloud.maintenance.api.v1beta.stub.GrpcMaintenanceCallableFactory;
import com.google.cloud.maintenance.api.v1beta.stub.MaintenanceStub;
import com.google.cloud.maintenance.api.v1beta.stub.MaintenanceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcMaintenanceStub
extends MaintenanceStub {
    private static final MethodDescriptor<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse> summarizeMaintenancesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.maintenance.api.v1beta.Maintenance/SummarizeMaintenances").setRequestMarshaller(ProtoUtils.marshaller((Message)SummarizeMaintenancesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SummarizeMaintenancesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse> listResourceMaintenancesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.maintenance.api.v1beta.Maintenance/ListResourceMaintenances").setRequestMarshaller(ProtoUtils.marshaller((Message)ListResourceMaintenancesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListResourceMaintenancesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetResourceMaintenanceRequest, ResourceMaintenance> getResourceMaintenanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.maintenance.api.v1beta.Maintenance/GetResourceMaintenance").setRequestMarshaller(ProtoUtils.marshaller((Message)GetResourceMaintenanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ResourceMaintenance.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse> summarizeMaintenancesCallable;
    private final UnaryCallable<SummarizeMaintenancesRequest, MaintenanceClient.SummarizeMaintenancesPagedResponse> summarizeMaintenancesPagedCallable;
    private final UnaryCallable<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse> listResourceMaintenancesCallable;
    private final UnaryCallable<ListResourceMaintenancesRequest, MaintenanceClient.ListResourceMaintenancesPagedResponse> listResourceMaintenancesPagedCallable;
    private final UnaryCallable<GetResourceMaintenanceRequest, ResourceMaintenance> getResourceMaintenanceCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, MaintenanceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcMaintenanceStub create(MaintenanceStubSettings settings) throws IOException {
        return new GrpcMaintenanceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcMaintenanceStub create(ClientContext clientContext) throws IOException {
        return new GrpcMaintenanceStub(MaintenanceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcMaintenanceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcMaintenanceStub(MaintenanceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcMaintenanceStub(MaintenanceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcMaintenanceCallableFactory());
    }

    protected GrpcMaintenanceStub(MaintenanceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings summarizeMaintenancesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(summarizeMaintenancesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listResourceMaintenancesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listResourceMaintenancesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getResourceMaintenanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getResourceMaintenanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.summarizeMaintenancesCallable = callableFactory.createUnaryCallable(summarizeMaintenancesTransportSettings, settings.summarizeMaintenancesSettings(), clientContext);
        this.summarizeMaintenancesPagedCallable = callableFactory.createPagedCallable(summarizeMaintenancesTransportSettings, settings.summarizeMaintenancesSettings(), clientContext);
        this.listResourceMaintenancesCallable = callableFactory.createUnaryCallable(listResourceMaintenancesTransportSettings, settings.listResourceMaintenancesSettings(), clientContext);
        this.listResourceMaintenancesPagedCallable = callableFactory.createPagedCallable(listResourceMaintenancesTransportSettings, settings.listResourceMaintenancesSettings(), clientContext);
        this.getResourceMaintenanceCallable = callableFactory.createUnaryCallable(getResourceMaintenanceTransportSettings, settings.getResourceMaintenanceSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<SummarizeMaintenancesRequest, SummarizeMaintenancesResponse> summarizeMaintenancesCallable() {
        return this.summarizeMaintenancesCallable;
    }

    @Override
    public UnaryCallable<SummarizeMaintenancesRequest, MaintenanceClient.SummarizeMaintenancesPagedResponse> summarizeMaintenancesPagedCallable() {
        return this.summarizeMaintenancesPagedCallable;
    }

    @Override
    public UnaryCallable<ListResourceMaintenancesRequest, ListResourceMaintenancesResponse> listResourceMaintenancesCallable() {
        return this.listResourceMaintenancesCallable;
    }

    @Override
    public UnaryCallable<ListResourceMaintenancesRequest, MaintenanceClient.ListResourceMaintenancesPagedResponse> listResourceMaintenancesPagedCallable() {
        return this.listResourceMaintenancesPagedCallable;
    }

    @Override
    public UnaryCallable<GetResourceMaintenanceRequest, ResourceMaintenance> getResourceMaintenanceCallable() {
        return this.getResourceMaintenanceCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, MaintenanceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

