/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.locationfinder.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.locationfinder.v1.CloudLocation;
import com.google.cloud.locationfinder.v1.CloudLocationFinderClient;
import com.google.cloud.locationfinder.v1.GetCloudLocationRequest;
import com.google.cloud.locationfinder.v1.ListCloudLocationsRequest;
import com.google.cloud.locationfinder.v1.ListCloudLocationsResponse;
import com.google.cloud.locationfinder.v1.SearchCloudLocationsRequest;
import com.google.cloud.locationfinder.v1.SearchCloudLocationsResponse;
import com.google.cloud.locationfinder.v1.stub.CloudLocationFinderStub;
import com.google.cloud.locationfinder.v1.stub.CloudLocationFinderStubSettings;
import com.google.cloud.locationfinder.v1.stub.HttpJsonCloudLocationFinderCallableFactory;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonCloudLocationFinderStub
extends CloudLocationFinderStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListCloudLocationsRequest, ListCloudLocationsResponse> listCloudLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.locationfinder.v1.CloudLocationFinder/ListCloudLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/cloudLocations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListCloudLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetCloudLocationRequest, CloudLocation> getCloudLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.locationfinder.v1.CloudLocationFinder/GetCloudLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/cloudLocations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CloudLocation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SearchCloudLocationsRequest, SearchCloudLocationsResponse> searchCloudLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.locationfinder.v1.CloudLocationFinder/SearchCloudLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/cloudLocations:search", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "query", (Object)request.getQuery());
        serializer.putQueryParam(fields, "sourceCloudLocation", (Object)request.getSourceCloudLocation());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SearchCloudLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListCloudLocationsRequest, ListCloudLocationsResponse> listCloudLocationsCallable;
    private final UnaryCallable<ListCloudLocationsRequest, CloudLocationFinderClient.ListCloudLocationsPagedResponse> listCloudLocationsPagedCallable;
    private final UnaryCallable<GetCloudLocationRequest, CloudLocation> getCloudLocationCallable;
    private final UnaryCallable<SearchCloudLocationsRequest, SearchCloudLocationsResponse> searchCloudLocationsCallable;
    private final UnaryCallable<SearchCloudLocationsRequest, CloudLocationFinderClient.SearchCloudLocationsPagedResponse> searchCloudLocationsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonCloudLocationFinderStub create(CloudLocationFinderStubSettings settings) throws IOException {
        return new HttpJsonCloudLocationFinderStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCloudLocationFinderStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCloudLocationFinderStub(CloudLocationFinderStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonCloudLocationFinderStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCloudLocationFinderStub(CloudLocationFinderStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCloudLocationFinderStub(CloudLocationFinderStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCloudLocationFinderCallableFactory());
    }

    protected HttpJsonCloudLocationFinderStub(CloudLocationFinderStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listCloudLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listCloudLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getCloudLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getCloudLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings searchCloudLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(searchCloudLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.listCloudLocationsCallable = callableFactory.createUnaryCallable(listCloudLocationsTransportSettings, settings.listCloudLocationsSettings(), clientContext);
        this.listCloudLocationsPagedCallable = callableFactory.createPagedCallable(listCloudLocationsTransportSettings, settings.listCloudLocationsSettings(), clientContext);
        this.getCloudLocationCallable = callableFactory.createUnaryCallable(getCloudLocationTransportSettings, settings.getCloudLocationSettings(), clientContext);
        this.searchCloudLocationsCallable = callableFactory.createUnaryCallable(searchCloudLocationsTransportSettings, settings.searchCloudLocationsSettings(), clientContext);
        this.searchCloudLocationsPagedCallable = callableFactory.createPagedCallable(searchCloudLocationsTransportSettings, settings.searchCloudLocationsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listCloudLocationsMethodDescriptor);
        methodDescriptors.add(getCloudLocationMethodDescriptor);
        methodDescriptors.add(searchCloudLocationsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListCloudLocationsRequest, ListCloudLocationsResponse> listCloudLocationsCallable() {
        return this.listCloudLocationsCallable;
    }

    @Override
    public UnaryCallable<ListCloudLocationsRequest, CloudLocationFinderClient.ListCloudLocationsPagedResponse> listCloudLocationsPagedCallable() {
        return this.listCloudLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetCloudLocationRequest, CloudLocation> getCloudLocationCallable() {
        return this.getCloudLocationCallable;
    }

    @Override
    public UnaryCallable<SearchCloudLocationsRequest, SearchCloudLocationsResponse> searchCloudLocationsCallable() {
        return this.searchCloudLocationsCallable;
    }

    @Override
    public UnaryCallable<SearchCloudLocationsRequest, CloudLocationFinderClient.SearchCloudLocationsPagedResponse> searchCloudLocationsPagedCallable() {
        return this.searchCloudLocationsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

