/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.locationfinder.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.locationfinder.v1.CloudLocation;
import com.google.cloud.locationfinder.v1.CloudLocationFinderClient;
import com.google.cloud.locationfinder.v1.GetCloudLocationRequest;
import com.google.cloud.locationfinder.v1.ListCloudLocationsRequest;
import com.google.cloud.locationfinder.v1.ListCloudLocationsResponse;
import com.google.cloud.locationfinder.v1.SearchCloudLocationsRequest;
import com.google.cloud.locationfinder.v1.SearchCloudLocationsResponse;
import com.google.cloud.locationfinder.v1.stub.CloudLocationFinderStub;
import com.google.cloud.locationfinder.v1.stub.GrpcCloudLocationFinderStub;
import com.google.cloud.locationfinder.v1.stub.HttpJsonCloudLocationFinderStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class CloudLocationFinderStubSettings
extends StubSettings<CloudLocationFinderStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListCloudLocationsRequest, ListCloudLocationsResponse, CloudLocationFinderClient.ListCloudLocationsPagedResponse> listCloudLocationsSettings;
    private final UnaryCallSettings<GetCloudLocationRequest, CloudLocation> getCloudLocationSettings;
    private final PagedCallSettings<SearchCloudLocationsRequest, SearchCloudLocationsResponse, CloudLocationFinderClient.SearchCloudLocationsPagedResponse> searchCloudLocationsSettings;
    private static final PagedListDescriptor<ListCloudLocationsRequest, ListCloudLocationsResponse, CloudLocation> LIST_CLOUD_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListCloudLocationsRequest, ListCloudLocationsResponse, CloudLocation>(){

        public String emptyToken() {
            return "";
        }

        public ListCloudLocationsRequest injectToken(ListCloudLocationsRequest payload, String token) {
            return ListCloudLocationsRequest.newBuilder((ListCloudLocationsRequest)payload).setPageToken(token).build();
        }

        public ListCloudLocationsRequest injectPageSize(ListCloudLocationsRequest payload, int pageSize) {
            return ListCloudLocationsRequest.newBuilder((ListCloudLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCloudLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCloudLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CloudLocation> extractResources(ListCloudLocationsResponse payload) {
            return payload.getCloudLocationsList();
        }
    };
    private static final PagedListDescriptor<SearchCloudLocationsRequest, SearchCloudLocationsResponse, CloudLocation> SEARCH_CLOUD_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<SearchCloudLocationsRequest, SearchCloudLocationsResponse, CloudLocation>(){

        public String emptyToken() {
            return "";
        }

        public SearchCloudLocationsRequest injectToken(SearchCloudLocationsRequest payload, String token) {
            return SearchCloudLocationsRequest.newBuilder((SearchCloudLocationsRequest)payload).setPageToken(token).build();
        }

        public SearchCloudLocationsRequest injectPageSize(SearchCloudLocationsRequest payload, int pageSize) {
            return SearchCloudLocationsRequest.newBuilder((SearchCloudLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchCloudLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchCloudLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CloudLocation> extractResources(SearchCloudLocationsResponse payload) {
            return payload.getCloudLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListCloudLocationsRequest, ListCloudLocationsResponse, CloudLocationFinderClient.ListCloudLocationsPagedResponse> LIST_CLOUD_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListCloudLocationsRequest, ListCloudLocationsResponse, CloudLocationFinderClient.ListCloudLocationsPagedResponse>(){

        public ApiFuture<CloudLocationFinderClient.ListCloudLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCloudLocationsRequest, ListCloudLocationsResponse> callable, ListCloudLocationsRequest request, ApiCallContext context, ApiFuture<ListCloudLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CLOUD_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudLocationFinderClient.ListCloudLocationsPagedResponse.createAsync((PageContext<ListCloudLocationsRequest, ListCloudLocationsResponse, CloudLocation>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchCloudLocationsRequest, SearchCloudLocationsResponse, CloudLocationFinderClient.SearchCloudLocationsPagedResponse> SEARCH_CLOUD_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<SearchCloudLocationsRequest, SearchCloudLocationsResponse, CloudLocationFinderClient.SearchCloudLocationsPagedResponse>(){

        public ApiFuture<CloudLocationFinderClient.SearchCloudLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<SearchCloudLocationsRequest, SearchCloudLocationsResponse> callable, SearchCloudLocationsRequest request, ApiCallContext context, ApiFuture<SearchCloudLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_CLOUD_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudLocationFinderClient.SearchCloudLocationsPagedResponse.createAsync((PageContext<SearchCloudLocationsRequest, SearchCloudLocationsResponse, CloudLocation>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListCloudLocationsRequest, ListCloudLocationsResponse, CloudLocationFinderClient.ListCloudLocationsPagedResponse> listCloudLocationsSettings() {
        return this.listCloudLocationsSettings;
    }

    public UnaryCallSettings<GetCloudLocationRequest, CloudLocation> getCloudLocationSettings() {
        return this.getCloudLocationSettings;
    }

    public PagedCallSettings<SearchCloudLocationsRequest, SearchCloudLocationsResponse, CloudLocationFinderClient.SearchCloudLocationsPagedResponse> searchCloudLocationsSettings() {
        return this.searchCloudLocationsSettings;
    }

    public CloudLocationFinderStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCloudLocationFinderStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCloudLocationFinderStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "cloudlocationfinder";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "cloudlocationfinder.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudlocationfinder.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CloudLocationFinderStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudLocationFinderStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudLocationFinderStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CloudLocationFinderStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CloudLocationFinderStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listCloudLocationsSettings = settingsBuilder.listCloudLocationsSettings().build();
        this.getCloudLocationSettings = settingsBuilder.getCloudLocationSettings().build();
        this.searchCloudLocationsSettings = settingsBuilder.searchCloudLocationsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CloudLocationFinderStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListCloudLocationsRequest, ListCloudLocationsResponse, CloudLocationFinderClient.ListCloudLocationsPagedResponse> listCloudLocationsSettings;
        private final UnaryCallSettings.Builder<GetCloudLocationRequest, CloudLocation> getCloudLocationSettings;
        private final PagedCallSettings.Builder<SearchCloudLocationsRequest, SearchCloudLocationsResponse, CloudLocationFinderClient.SearchCloudLocationsPagedResponse> searchCloudLocationsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listCloudLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CLOUD_LOCATIONS_PAGE_STR_FACT);
            this.getCloudLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.searchCloudLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_CLOUD_LOCATIONS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listCloudLocationsSettings, this.getCloudLocationSettings, this.searchCloudLocationsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CloudLocationFinderStubSettings settings) {
            super((StubSettings)settings);
            this.listCloudLocationsSettings = settings.listCloudLocationsSettings.toBuilder();
            this.getCloudLocationSettings = settings.getCloudLocationSettings.toBuilder();
            this.searchCloudLocationsSettings = settings.searchCloudLocationsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listCloudLocationsSettings, this.getCloudLocationSettings, this.searchCloudLocationsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CloudLocationFinderStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CloudLocationFinderStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudLocationFinderStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CloudLocationFinderStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CloudLocationFinderStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CloudLocationFinderStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudLocationFinderStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CloudLocationFinderStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listCloudLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getCloudLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.searchCloudLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListCloudLocationsRequest, ListCloudLocationsResponse, CloudLocationFinderClient.ListCloudLocationsPagedResponse> listCloudLocationsSettings() {
            return this.listCloudLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetCloudLocationRequest, CloudLocation> getCloudLocationSettings() {
            return this.getCloudLocationSettings;
        }

        public PagedCallSettings.Builder<SearchCloudLocationsRequest, SearchCloudLocationsResponse, CloudLocationFinderClient.SearchCloudLocationsPagedResponse> searchCloudLocationsSettings() {
            return this.searchCloudLocationsSettings;
        }

        public CloudLocationFinderStubSettings build() throws IOException {
            return new CloudLocationFinderStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

