/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.video.livestream.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.video.livestream.v1.Channel;
import com.google.cloud.video.livestream.v1.ChannelOperationResponse;
import com.google.cloud.video.livestream.v1.CreateChannelRequest;
import com.google.cloud.video.livestream.v1.CreateEventRequest;
import com.google.cloud.video.livestream.v1.CreateInputRequest;
import com.google.cloud.video.livestream.v1.DeleteChannelRequest;
import com.google.cloud.video.livestream.v1.DeleteEventRequest;
import com.google.cloud.video.livestream.v1.DeleteInputRequest;
import com.google.cloud.video.livestream.v1.Event;
import com.google.cloud.video.livestream.v1.GetChannelRequest;
import com.google.cloud.video.livestream.v1.GetEventRequest;
import com.google.cloud.video.livestream.v1.GetInputRequest;
import com.google.cloud.video.livestream.v1.Input;
import com.google.cloud.video.livestream.v1.ListChannelsRequest;
import com.google.cloud.video.livestream.v1.ListChannelsResponse;
import com.google.cloud.video.livestream.v1.ListEventsRequest;
import com.google.cloud.video.livestream.v1.ListEventsResponse;
import com.google.cloud.video.livestream.v1.ListInputsRequest;
import com.google.cloud.video.livestream.v1.ListInputsResponse;
import com.google.cloud.video.livestream.v1.LivestreamServiceClient;
import com.google.cloud.video.livestream.v1.OperationMetadata;
import com.google.cloud.video.livestream.v1.StartChannelRequest;
import com.google.cloud.video.livestream.v1.StopChannelRequest;
import com.google.cloud.video.livestream.v1.UpdateChannelRequest;
import com.google.cloud.video.livestream.v1.UpdateInputRequest;
import com.google.cloud.video.livestream.v1.stub.HttpJsonLivestreamServiceCallableFactory;
import com.google.cloud.video.livestream.v1.stub.LivestreamServiceStub;
import com.google.cloud.video.livestream.v1.stub.LivestreamServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonLivestreamServiceStub
extends LivestreamServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(OperationMetadata.getDescriptor()).add(Channel.getDescriptor()).add(Input.getDescriptor()).add(ChannelOperationResponse.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateChannelRequest, Operation> createChannelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/CreateChannel").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/channels", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "channelId", (Object)request.getChannelId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("channel", (Message)request.getChannel(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListChannelsRequest, ListChannelsResponse> listChannelsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/ListChannels").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/channels", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListChannelsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetChannelRequest, Channel> getChannelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/GetChannel").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/channels/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Channel.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteChannelRequest, Operation> deleteChannelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/DeleteChannel").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/channels/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "force", (Object)request.getForce());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateChannelRequest, Operation> updateChannelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/UpdateChannel").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{channel.name=projects/*/locations/*/channels/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "channel.name", (Object)request.getChannel().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("channel", (Message)request.getChannel(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<StartChannelRequest, Operation> startChannelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/StartChannel").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/channels/*}:start", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<StopChannelRequest, Operation> stopChannelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/StopChannel").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/channels/*}:stop", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<CreateInputRequest, Operation> createInputMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/CreateInput").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/inputs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "inputId", (Object)request.getInputId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("input", (Message)request.getInput(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListInputsRequest, ListInputsResponse> listInputsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/ListInputs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/inputs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListInputsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetInputRequest, Input> getInputMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/GetInput").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/inputs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Input.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteInputRequest, Operation> deleteInputMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/DeleteInput").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/inputs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateInputRequest, Operation> updateInputMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/UpdateInput").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{input.name=projects/*/locations/*/inputs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "input.name", (Object)request.getInput().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("input", (Message)request.getInput(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<CreateEventRequest, Event> createEventMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/CreateEvent").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/channels/*}/events", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "eventId", (Object)request.getEventId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("event", (Message)request.getEvent(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Event.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListEventsRequest, ListEventsResponse> listEventsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/ListEvents").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/channels/*}/events", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListEventsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetEventRequest, Event> getEventMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/GetEvent").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/channels/*/events/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Event.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteEventRequest, Empty> deleteEventMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.video.livestream.v1.LivestreamService/DeleteEvent").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/channels/*/events/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateChannelRequest, Operation> createChannelCallable;
    private final OperationCallable<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationCallable;
    private final UnaryCallable<ListChannelsRequest, ListChannelsResponse> listChannelsCallable;
    private final UnaryCallable<ListChannelsRequest, LivestreamServiceClient.ListChannelsPagedResponse> listChannelsPagedCallable;
    private final UnaryCallable<GetChannelRequest, Channel> getChannelCallable;
    private final UnaryCallable<DeleteChannelRequest, Operation> deleteChannelCallable;
    private final OperationCallable<DeleteChannelRequest, Empty, OperationMetadata> deleteChannelOperationCallable;
    private final UnaryCallable<UpdateChannelRequest, Operation> updateChannelCallable;
    private final OperationCallable<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationCallable;
    private final UnaryCallable<StartChannelRequest, Operation> startChannelCallable;
    private final OperationCallable<StartChannelRequest, ChannelOperationResponse, OperationMetadata> startChannelOperationCallable;
    private final UnaryCallable<StopChannelRequest, Operation> stopChannelCallable;
    private final OperationCallable<StopChannelRequest, ChannelOperationResponse, OperationMetadata> stopChannelOperationCallable;
    private final UnaryCallable<CreateInputRequest, Operation> createInputCallable;
    private final OperationCallable<CreateInputRequest, Input, OperationMetadata> createInputOperationCallable;
    private final UnaryCallable<ListInputsRequest, ListInputsResponse> listInputsCallable;
    private final UnaryCallable<ListInputsRequest, LivestreamServiceClient.ListInputsPagedResponse> listInputsPagedCallable;
    private final UnaryCallable<GetInputRequest, Input> getInputCallable;
    private final UnaryCallable<DeleteInputRequest, Operation> deleteInputCallable;
    private final OperationCallable<DeleteInputRequest, Empty, OperationMetadata> deleteInputOperationCallable;
    private final UnaryCallable<UpdateInputRequest, Operation> updateInputCallable;
    private final OperationCallable<UpdateInputRequest, Input, OperationMetadata> updateInputOperationCallable;
    private final UnaryCallable<CreateEventRequest, Event> createEventCallable;
    private final UnaryCallable<ListEventsRequest, ListEventsResponse> listEventsCallable;
    private final UnaryCallable<ListEventsRequest, LivestreamServiceClient.ListEventsPagedResponse> listEventsPagedCallable;
    private final UnaryCallable<GetEventRequest, Event> getEventCallable;
    private final UnaryCallable<DeleteEventRequest, Empty> deleteEventCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonLivestreamServiceStub create(LivestreamServiceStubSettings settings) throws IOException {
        return new HttpJsonLivestreamServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonLivestreamServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonLivestreamServiceStub(LivestreamServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonLivestreamServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonLivestreamServiceStub(LivestreamServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonLivestreamServiceStub(LivestreamServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonLivestreamServiceCallableFactory());
    }

    protected HttpJsonLivestreamServiceStub(LivestreamServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=projects/*/locations/*/operations/*}:cancel").build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*}/operations").build()).build());
        HttpJsonCallSettings createChannelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createChannelMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listChannelsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listChannelsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getChannelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getChannelMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteChannelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteChannelMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateChannelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateChannelMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings startChannelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(startChannelMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings stopChannelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(stopChannelMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createInputTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createInputMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listInputsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listInputsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getInputTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getInputMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteInputTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteInputMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateInputTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateInputMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createEventTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createEventMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listEventsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listEventsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getEventTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getEventMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteEventTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteEventMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createChannelCallable = callableFactory.createUnaryCallable(createChannelTransportSettings, settings.createChannelSettings(), clientContext);
        this.createChannelOperationCallable = callableFactory.createOperationCallable(createChannelTransportSettings, settings.createChannelOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listChannelsCallable = callableFactory.createUnaryCallable(listChannelsTransportSettings, settings.listChannelsSettings(), clientContext);
        this.listChannelsPagedCallable = callableFactory.createPagedCallable(listChannelsTransportSettings, settings.listChannelsSettings(), clientContext);
        this.getChannelCallable = callableFactory.createUnaryCallable(getChannelTransportSettings, settings.getChannelSettings(), clientContext);
        this.deleteChannelCallable = callableFactory.createUnaryCallable(deleteChannelTransportSettings, settings.deleteChannelSettings(), clientContext);
        this.deleteChannelOperationCallable = callableFactory.createOperationCallable(deleteChannelTransportSettings, settings.deleteChannelOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateChannelCallable = callableFactory.createUnaryCallable(updateChannelTransportSettings, settings.updateChannelSettings(), clientContext);
        this.updateChannelOperationCallable = callableFactory.createOperationCallable(updateChannelTransportSettings, settings.updateChannelOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.startChannelCallable = callableFactory.createUnaryCallable(startChannelTransportSettings, settings.startChannelSettings(), clientContext);
        this.startChannelOperationCallable = callableFactory.createOperationCallable(startChannelTransportSettings, settings.startChannelOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.stopChannelCallable = callableFactory.createUnaryCallable(stopChannelTransportSettings, settings.stopChannelSettings(), clientContext);
        this.stopChannelOperationCallable = callableFactory.createOperationCallable(stopChannelTransportSettings, settings.stopChannelOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.createInputCallable = callableFactory.createUnaryCallable(createInputTransportSettings, settings.createInputSettings(), clientContext);
        this.createInputOperationCallable = callableFactory.createOperationCallable(createInputTransportSettings, settings.createInputOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listInputsCallable = callableFactory.createUnaryCallable(listInputsTransportSettings, settings.listInputsSettings(), clientContext);
        this.listInputsPagedCallable = callableFactory.createPagedCallable(listInputsTransportSettings, settings.listInputsSettings(), clientContext);
        this.getInputCallable = callableFactory.createUnaryCallable(getInputTransportSettings, settings.getInputSettings(), clientContext);
        this.deleteInputCallable = callableFactory.createUnaryCallable(deleteInputTransportSettings, settings.deleteInputSettings(), clientContext);
        this.deleteInputOperationCallable = callableFactory.createOperationCallable(deleteInputTransportSettings, settings.deleteInputOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateInputCallable = callableFactory.createUnaryCallable(updateInputTransportSettings, settings.updateInputSettings(), clientContext);
        this.updateInputOperationCallable = callableFactory.createOperationCallable(updateInputTransportSettings, settings.updateInputOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.createEventCallable = callableFactory.createUnaryCallable(createEventTransportSettings, settings.createEventSettings(), clientContext);
        this.listEventsCallable = callableFactory.createUnaryCallable(listEventsTransportSettings, settings.listEventsSettings(), clientContext);
        this.listEventsPagedCallable = callableFactory.createPagedCallable(listEventsTransportSettings, settings.listEventsSettings(), clientContext);
        this.getEventCallable = callableFactory.createUnaryCallable(getEventTransportSettings, settings.getEventSettings(), clientContext);
        this.deleteEventCallable = callableFactory.createUnaryCallable(deleteEventTransportSettings, settings.deleteEventSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createChannelMethodDescriptor);
        methodDescriptors.add(listChannelsMethodDescriptor);
        methodDescriptors.add(getChannelMethodDescriptor);
        methodDescriptors.add(deleteChannelMethodDescriptor);
        methodDescriptors.add(updateChannelMethodDescriptor);
        methodDescriptors.add(startChannelMethodDescriptor);
        methodDescriptors.add(stopChannelMethodDescriptor);
        methodDescriptors.add(createInputMethodDescriptor);
        methodDescriptors.add(listInputsMethodDescriptor);
        methodDescriptors.add(getInputMethodDescriptor);
        methodDescriptors.add(deleteInputMethodDescriptor);
        methodDescriptors.add(updateInputMethodDescriptor);
        methodDescriptors.add(createEventMethodDescriptor);
        methodDescriptors.add(listEventsMethodDescriptor);
        methodDescriptors.add(getEventMethodDescriptor);
        methodDescriptors.add(deleteEventMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateChannelRequest, Operation> createChannelCallable() {
        return this.createChannelCallable;
    }

    @Override
    public OperationCallable<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationCallable() {
        return this.createChannelOperationCallable;
    }

    @Override
    public UnaryCallable<ListChannelsRequest, ListChannelsResponse> listChannelsCallable() {
        return this.listChannelsCallable;
    }

    @Override
    public UnaryCallable<ListChannelsRequest, LivestreamServiceClient.ListChannelsPagedResponse> listChannelsPagedCallable() {
        return this.listChannelsPagedCallable;
    }

    @Override
    public UnaryCallable<GetChannelRequest, Channel> getChannelCallable() {
        return this.getChannelCallable;
    }

    @Override
    public UnaryCallable<DeleteChannelRequest, Operation> deleteChannelCallable() {
        return this.deleteChannelCallable;
    }

    @Override
    public OperationCallable<DeleteChannelRequest, Empty, OperationMetadata> deleteChannelOperationCallable() {
        return this.deleteChannelOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateChannelRequest, Operation> updateChannelCallable() {
        return this.updateChannelCallable;
    }

    @Override
    public OperationCallable<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationCallable() {
        return this.updateChannelOperationCallable;
    }

    @Override
    public UnaryCallable<StartChannelRequest, Operation> startChannelCallable() {
        return this.startChannelCallable;
    }

    @Override
    public OperationCallable<StartChannelRequest, ChannelOperationResponse, OperationMetadata> startChannelOperationCallable() {
        return this.startChannelOperationCallable;
    }

    @Override
    public UnaryCallable<StopChannelRequest, Operation> stopChannelCallable() {
        return this.stopChannelCallable;
    }

    @Override
    public OperationCallable<StopChannelRequest, ChannelOperationResponse, OperationMetadata> stopChannelOperationCallable() {
        return this.stopChannelOperationCallable;
    }

    @Override
    public UnaryCallable<CreateInputRequest, Operation> createInputCallable() {
        return this.createInputCallable;
    }

    @Override
    public OperationCallable<CreateInputRequest, Input, OperationMetadata> createInputOperationCallable() {
        return this.createInputOperationCallable;
    }

    @Override
    public UnaryCallable<ListInputsRequest, ListInputsResponse> listInputsCallable() {
        return this.listInputsCallable;
    }

    @Override
    public UnaryCallable<ListInputsRequest, LivestreamServiceClient.ListInputsPagedResponse> listInputsPagedCallable() {
        return this.listInputsPagedCallable;
    }

    @Override
    public UnaryCallable<GetInputRequest, Input> getInputCallable() {
        return this.getInputCallable;
    }

    @Override
    public UnaryCallable<DeleteInputRequest, Operation> deleteInputCallable() {
        return this.deleteInputCallable;
    }

    @Override
    public OperationCallable<DeleteInputRequest, Empty, OperationMetadata> deleteInputOperationCallable() {
        return this.deleteInputOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateInputRequest, Operation> updateInputCallable() {
        return this.updateInputCallable;
    }

    @Override
    public OperationCallable<UpdateInputRequest, Input, OperationMetadata> updateInputOperationCallable() {
        return this.updateInputOperationCallable;
    }

    @Override
    public UnaryCallable<CreateEventRequest, Event> createEventCallable() {
        return this.createEventCallable;
    }

    @Override
    public UnaryCallable<ListEventsRequest, ListEventsResponse> listEventsCallable() {
        return this.listEventsCallable;
    }

    @Override
    public UnaryCallable<ListEventsRequest, LivestreamServiceClient.ListEventsPagedResponse> listEventsPagedCallable() {
        return this.listEventsPagedCallable;
    }

    @Override
    public UnaryCallable<GetEventRequest, Event> getEventCallable() {
        return this.getEventCallable;
    }

    @Override
    public UnaryCallable<DeleteEventRequest, Empty> deleteEventCallable() {
        return this.deleteEventCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

