/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.licensemanager.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.licensemanager.v1.AggregateUsageRequest;
import com.google.cloud.licensemanager.v1.AggregateUsageResponse;
import com.google.cloud.licensemanager.v1.Configuration;
import com.google.cloud.licensemanager.v1.CreateConfigurationRequest;
import com.google.cloud.licensemanager.v1.DeactivateConfigurationRequest;
import com.google.cloud.licensemanager.v1.DeleteConfigurationRequest;
import com.google.cloud.licensemanager.v1.GetConfigurationRequest;
import com.google.cloud.licensemanager.v1.GetInstanceRequest;
import com.google.cloud.licensemanager.v1.GetProductRequest;
import com.google.cloud.licensemanager.v1.Instance;
import com.google.cloud.licensemanager.v1.LicenseManagerClient;
import com.google.cloud.licensemanager.v1.ListConfigurationsRequest;
import com.google.cloud.licensemanager.v1.ListConfigurationsResponse;
import com.google.cloud.licensemanager.v1.ListInstancesRequest;
import com.google.cloud.licensemanager.v1.ListInstancesResponse;
import com.google.cloud.licensemanager.v1.ListProductsRequest;
import com.google.cloud.licensemanager.v1.ListProductsResponse;
import com.google.cloud.licensemanager.v1.OperationMetadata;
import com.google.cloud.licensemanager.v1.Product;
import com.google.cloud.licensemanager.v1.QueryConfigurationLicenseUsageRequest;
import com.google.cloud.licensemanager.v1.QueryConfigurationLicenseUsageResponse;
import com.google.cloud.licensemanager.v1.ReactivateConfigurationRequest;
import com.google.cloud.licensemanager.v1.UpdateConfigurationRequest;
import com.google.cloud.licensemanager.v1.stub.GrpcLicenseManagerCallableFactory;
import com.google.cloud.licensemanager.v1.stub.LicenseManagerStub;
import com.google.cloud.licensemanager.v1.stub.LicenseManagerStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcLicenseManagerStub
extends LicenseManagerStub {
    private static final MethodDescriptor<ListConfigurationsRequest, ListConfigurationsResponse> listConfigurationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/ListConfigurations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListConfigurationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListConfigurationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetConfigurationRequest, Configuration> getConfigurationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/GetConfiguration").setRequestMarshaller(ProtoUtils.marshaller((Message)GetConfigurationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Configuration.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateConfigurationRequest, Operation> createConfigurationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/CreateConfiguration").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateConfigurationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateConfigurationRequest, Operation> updateConfigurationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/UpdateConfiguration").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateConfigurationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteConfigurationRequest, Operation> deleteConfigurationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/DeleteConfiguration").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteConfigurationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListInstancesRequest, ListInstancesResponse> listInstancesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/ListInstances").setRequestMarshaller(ProtoUtils.marshaller((Message)ListInstancesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListInstancesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetInstanceRequest, Instance> getInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/GetInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)GetInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Instance.getDefaultInstance())).build();
    private static final MethodDescriptor<DeactivateConfigurationRequest, Operation> deactivateConfigurationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/DeactivateConfiguration").setRequestMarshaller(ProtoUtils.marshaller((Message)DeactivateConfigurationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ReactivateConfigurationRequest, Operation> reactivateConfigurationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/ReactivateConfiguration").setRequestMarshaller(ProtoUtils.marshaller((Message)ReactivateConfigurationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<QueryConfigurationLicenseUsageRequest, QueryConfigurationLicenseUsageResponse> queryConfigurationLicenseUsageMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/QueryConfigurationLicenseUsage").setRequestMarshaller(ProtoUtils.marshaller((Message)QueryConfigurationLicenseUsageRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)QueryConfigurationLicenseUsageResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<AggregateUsageRequest, AggregateUsageResponse> aggregateUsageMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/AggregateUsage").setRequestMarshaller(ProtoUtils.marshaller((Message)AggregateUsageRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AggregateUsageResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListProductsRequest, ListProductsResponse> listProductsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/ListProducts").setRequestMarshaller(ProtoUtils.marshaller((Message)ListProductsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListProductsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetProductRequest, Product> getProductMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.licensemanager.v1.LicenseManager/GetProduct").setRequestMarshaller(ProtoUtils.marshaller((Message)GetProductRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Product.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<ListConfigurationsRequest, ListConfigurationsResponse> listConfigurationsCallable;
    private final UnaryCallable<ListConfigurationsRequest, LicenseManagerClient.ListConfigurationsPagedResponse> listConfigurationsPagedCallable;
    private final UnaryCallable<GetConfigurationRequest, Configuration> getConfigurationCallable;
    private final UnaryCallable<CreateConfigurationRequest, Operation> createConfigurationCallable;
    private final OperationCallable<CreateConfigurationRequest, Configuration, OperationMetadata> createConfigurationOperationCallable;
    private final UnaryCallable<UpdateConfigurationRequest, Operation> updateConfigurationCallable;
    private final OperationCallable<UpdateConfigurationRequest, Configuration, OperationMetadata> updateConfigurationOperationCallable;
    private final UnaryCallable<DeleteConfigurationRequest, Operation> deleteConfigurationCallable;
    private final OperationCallable<DeleteConfigurationRequest, Empty, OperationMetadata> deleteConfigurationOperationCallable;
    private final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable;
    private final UnaryCallable<ListInstancesRequest, LicenseManagerClient.ListInstancesPagedResponse> listInstancesPagedCallable;
    private final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable;
    private final UnaryCallable<DeactivateConfigurationRequest, Operation> deactivateConfigurationCallable;
    private final OperationCallable<DeactivateConfigurationRequest, Configuration, OperationMetadata> deactivateConfigurationOperationCallable;
    private final UnaryCallable<ReactivateConfigurationRequest, Operation> reactivateConfigurationCallable;
    private final OperationCallable<ReactivateConfigurationRequest, Configuration, OperationMetadata> reactivateConfigurationOperationCallable;
    private final UnaryCallable<QueryConfigurationLicenseUsageRequest, QueryConfigurationLicenseUsageResponse> queryConfigurationLicenseUsageCallable;
    private final UnaryCallable<AggregateUsageRequest, AggregateUsageResponse> aggregateUsageCallable;
    private final UnaryCallable<AggregateUsageRequest, LicenseManagerClient.AggregateUsagePagedResponse> aggregateUsagePagedCallable;
    private final UnaryCallable<ListProductsRequest, ListProductsResponse> listProductsCallable;
    private final UnaryCallable<ListProductsRequest, LicenseManagerClient.ListProductsPagedResponse> listProductsPagedCallable;
    private final UnaryCallable<GetProductRequest, Product> getProductCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, LicenseManagerClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcLicenseManagerStub create(LicenseManagerStubSettings settings) throws IOException {
        return new GrpcLicenseManagerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcLicenseManagerStub create(ClientContext clientContext) throws IOException {
        return new GrpcLicenseManagerStub(LicenseManagerStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcLicenseManagerStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcLicenseManagerStub(LicenseManagerStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcLicenseManagerStub(LicenseManagerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcLicenseManagerCallableFactory());
    }

    protected GrpcLicenseManagerStub(LicenseManagerStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listConfigurationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listConfigurationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getConfigurationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getConfigurationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createConfigurationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createConfigurationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateConfigurationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateConfigurationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("configuration.name", String.valueOf(request.getConfiguration().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteConfigurationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteConfigurationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listInstancesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listInstancesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getInstanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deactivateConfigurationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deactivateConfigurationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings reactivateConfigurationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(reactivateConfigurationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings queryConfigurationLicenseUsageTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(queryConfigurationLicenseUsageMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings aggregateUsageTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(aggregateUsageMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listProductsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listProductsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getProductTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getProductMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listConfigurationsCallable = callableFactory.createUnaryCallable(listConfigurationsTransportSettings, settings.listConfigurationsSettings(), clientContext);
        this.listConfigurationsPagedCallable = callableFactory.createPagedCallable(listConfigurationsTransportSettings, settings.listConfigurationsSettings(), clientContext);
        this.getConfigurationCallable = callableFactory.createUnaryCallable(getConfigurationTransportSettings, settings.getConfigurationSettings(), clientContext);
        this.createConfigurationCallable = callableFactory.createUnaryCallable(createConfigurationTransportSettings, settings.createConfigurationSettings(), clientContext);
        this.createConfigurationOperationCallable = callableFactory.createOperationCallable(createConfigurationTransportSettings, settings.createConfigurationOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateConfigurationCallable = callableFactory.createUnaryCallable(updateConfigurationTransportSettings, settings.updateConfigurationSettings(), clientContext);
        this.updateConfigurationOperationCallable = callableFactory.createOperationCallable(updateConfigurationTransportSettings, settings.updateConfigurationOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteConfigurationCallable = callableFactory.createUnaryCallable(deleteConfigurationTransportSettings, settings.deleteConfigurationSettings(), clientContext);
        this.deleteConfigurationOperationCallable = callableFactory.createOperationCallable(deleteConfigurationTransportSettings, settings.deleteConfigurationOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listInstancesCallable = callableFactory.createUnaryCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.listInstancesPagedCallable = callableFactory.createPagedCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.getInstanceCallable = callableFactory.createUnaryCallable(getInstanceTransportSettings, settings.getInstanceSettings(), clientContext);
        this.deactivateConfigurationCallable = callableFactory.createUnaryCallable(deactivateConfigurationTransportSettings, settings.deactivateConfigurationSettings(), clientContext);
        this.deactivateConfigurationOperationCallable = callableFactory.createOperationCallable(deactivateConfigurationTransportSettings, settings.deactivateConfigurationOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.reactivateConfigurationCallable = callableFactory.createUnaryCallable(reactivateConfigurationTransportSettings, settings.reactivateConfigurationSettings(), clientContext);
        this.reactivateConfigurationOperationCallable = callableFactory.createOperationCallable(reactivateConfigurationTransportSettings, settings.reactivateConfigurationOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.queryConfigurationLicenseUsageCallable = callableFactory.createUnaryCallable(queryConfigurationLicenseUsageTransportSettings, settings.queryConfigurationLicenseUsageSettings(), clientContext);
        this.aggregateUsageCallable = callableFactory.createUnaryCallable(aggregateUsageTransportSettings, settings.aggregateUsageSettings(), clientContext);
        this.aggregateUsagePagedCallable = callableFactory.createPagedCallable(aggregateUsageTransportSettings, settings.aggregateUsageSettings(), clientContext);
        this.listProductsCallable = callableFactory.createUnaryCallable(listProductsTransportSettings, settings.listProductsSettings(), clientContext);
        this.listProductsPagedCallable = callableFactory.createPagedCallable(listProductsTransportSettings, settings.listProductsSettings(), clientContext);
        this.getProductCallable = callableFactory.createUnaryCallable(getProductTransportSettings, settings.getProductSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListConfigurationsRequest, ListConfigurationsResponse> listConfigurationsCallable() {
        return this.listConfigurationsCallable;
    }

    @Override
    public UnaryCallable<ListConfigurationsRequest, LicenseManagerClient.ListConfigurationsPagedResponse> listConfigurationsPagedCallable() {
        return this.listConfigurationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetConfigurationRequest, Configuration> getConfigurationCallable() {
        return this.getConfigurationCallable;
    }

    @Override
    public UnaryCallable<CreateConfigurationRequest, Operation> createConfigurationCallable() {
        return this.createConfigurationCallable;
    }

    @Override
    public OperationCallable<CreateConfigurationRequest, Configuration, OperationMetadata> createConfigurationOperationCallable() {
        return this.createConfigurationOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateConfigurationRequest, Operation> updateConfigurationCallable() {
        return this.updateConfigurationCallable;
    }

    @Override
    public OperationCallable<UpdateConfigurationRequest, Configuration, OperationMetadata> updateConfigurationOperationCallable() {
        return this.updateConfigurationOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteConfigurationRequest, Operation> deleteConfigurationCallable() {
        return this.deleteConfigurationCallable;
    }

    @Override
    public OperationCallable<DeleteConfigurationRequest, Empty, OperationMetadata> deleteConfigurationOperationCallable() {
        return this.deleteConfigurationOperationCallable;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.listInstancesCallable;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, LicenseManagerClient.ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.listInstancesPagedCallable;
    }

    @Override
    public UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.getInstanceCallable;
    }

    @Override
    public UnaryCallable<DeactivateConfigurationRequest, Operation> deactivateConfigurationCallable() {
        return this.deactivateConfigurationCallable;
    }

    @Override
    public OperationCallable<DeactivateConfigurationRequest, Configuration, OperationMetadata> deactivateConfigurationOperationCallable() {
        return this.deactivateConfigurationOperationCallable;
    }

    @Override
    public UnaryCallable<ReactivateConfigurationRequest, Operation> reactivateConfigurationCallable() {
        return this.reactivateConfigurationCallable;
    }

    @Override
    public OperationCallable<ReactivateConfigurationRequest, Configuration, OperationMetadata> reactivateConfigurationOperationCallable() {
        return this.reactivateConfigurationOperationCallable;
    }

    @Override
    public UnaryCallable<QueryConfigurationLicenseUsageRequest, QueryConfigurationLicenseUsageResponse> queryConfigurationLicenseUsageCallable() {
        return this.queryConfigurationLicenseUsageCallable;
    }

    @Override
    public UnaryCallable<AggregateUsageRequest, AggregateUsageResponse> aggregateUsageCallable() {
        return this.aggregateUsageCallable;
    }

    @Override
    public UnaryCallable<AggregateUsageRequest, LicenseManagerClient.AggregateUsagePagedResponse> aggregateUsagePagedCallable() {
        return this.aggregateUsagePagedCallable;
    }

    @Override
    public UnaryCallable<ListProductsRequest, ListProductsResponse> listProductsCallable() {
        return this.listProductsCallable;
    }

    @Override
    public UnaryCallable<ListProductsRequest, LicenseManagerClient.ListProductsPagedResponse> listProductsPagedCallable() {
        return this.listProductsPagedCallable;
    }

    @Override
    public UnaryCallable<GetProductRequest, Product> getProductCallable() {
        return this.getProductCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, LicenseManagerClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

