/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.language.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.language.v1.AnalyzeEntitiesRequest;
import com.google.cloud.language.v1.AnalyzeEntitiesResponse;
import com.google.cloud.language.v1.AnalyzeEntitySentimentRequest;
import com.google.cloud.language.v1.AnalyzeEntitySentimentResponse;
import com.google.cloud.language.v1.AnalyzeSentimentRequest;
import com.google.cloud.language.v1.AnalyzeSentimentResponse;
import com.google.cloud.language.v1.AnalyzeSyntaxRequest;
import com.google.cloud.language.v1.AnalyzeSyntaxResponse;
import com.google.cloud.language.v1.AnnotateTextRequest;
import com.google.cloud.language.v1.AnnotateTextResponse;
import com.google.cloud.language.v1.ClassifyTextRequest;
import com.google.cloud.language.v1.ClassifyTextResponse;
import com.google.cloud.language.v1.Document;
import com.google.cloud.language.v1.EncodingType;
import com.google.cloud.language.v1.LanguageServiceSettings;
import com.google.cloud.language.v1.stub.LanguageServiceStub;
import com.google.cloud.language.v1.stub.LanguageServiceStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class LanguageServiceClient
implements BackgroundResource {
    private final LanguageServiceSettings settings;
    private final LanguageServiceStub stub;

    public static final LanguageServiceClient create() throws IOException {
        return LanguageServiceClient.create(LanguageServiceSettings.newBuilder().build());
    }

    public static final LanguageServiceClient create(LanguageServiceSettings settings) throws IOException {
        return new LanguageServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final LanguageServiceClient create(LanguageServiceStub stub) {
        return new LanguageServiceClient(stub);
    }

    protected LanguageServiceClient(LanguageServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((LanguageServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected LanguageServiceClient(LanguageServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final LanguageServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public LanguageServiceStub getStub() {
        return this.stub;
    }

    public final AnalyzeSentimentResponse analyzeSentiment(Document document, EncodingType encodingType) {
        AnalyzeSentimentRequest request = AnalyzeSentimentRequest.newBuilder().setDocument(document).setEncodingType(encodingType).build();
        return this.analyzeSentiment(request);
    }

    public final AnalyzeSentimentResponse analyzeSentiment(Document document) {
        AnalyzeSentimentRequest request = AnalyzeSentimentRequest.newBuilder().setDocument(document).build();
        return this.analyzeSentiment(request);
    }

    public final AnalyzeSentimentResponse analyzeSentiment(AnalyzeSentimentRequest request) {
        return (AnalyzeSentimentResponse)this.analyzeSentimentCallable().call((Object)request);
    }

    public final UnaryCallable<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentCallable() {
        return this.stub.analyzeSentimentCallable();
    }

    public final AnalyzeEntitiesResponse analyzeEntities(Document document, EncodingType encodingType) {
        AnalyzeEntitiesRequest request = AnalyzeEntitiesRequest.newBuilder().setDocument(document).setEncodingType(encodingType).build();
        return this.analyzeEntities(request);
    }

    public final AnalyzeEntitiesResponse analyzeEntities(Document document) {
        AnalyzeEntitiesRequest request = AnalyzeEntitiesRequest.newBuilder().setDocument(document).build();
        return this.analyzeEntities(request);
    }

    public final AnalyzeEntitiesResponse analyzeEntities(AnalyzeEntitiesRequest request) {
        return (AnalyzeEntitiesResponse)this.analyzeEntitiesCallable().call((Object)request);
    }

    public final UnaryCallable<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesCallable() {
        return this.stub.analyzeEntitiesCallable();
    }

    public final AnalyzeEntitySentimentResponse analyzeEntitySentiment(Document document, EncodingType encodingType) {
        AnalyzeEntitySentimentRequest request = AnalyzeEntitySentimentRequest.newBuilder().setDocument(document).setEncodingType(encodingType).build();
        return this.analyzeEntitySentiment(request);
    }

    public final AnalyzeEntitySentimentResponse analyzeEntitySentiment(Document document) {
        AnalyzeEntitySentimentRequest request = AnalyzeEntitySentimentRequest.newBuilder().setDocument(document).build();
        return this.analyzeEntitySentiment(request);
    }

    public final AnalyzeEntitySentimentResponse analyzeEntitySentiment(AnalyzeEntitySentimentRequest request) {
        return (AnalyzeEntitySentimentResponse)this.analyzeEntitySentimentCallable().call((Object)request);
    }

    public final UnaryCallable<AnalyzeEntitySentimentRequest, AnalyzeEntitySentimentResponse> analyzeEntitySentimentCallable() {
        return this.stub.analyzeEntitySentimentCallable();
    }

    public final AnalyzeSyntaxResponse analyzeSyntax(Document document, EncodingType encodingType) {
        AnalyzeSyntaxRequest request = AnalyzeSyntaxRequest.newBuilder().setDocument(document).setEncodingType(encodingType).build();
        return this.analyzeSyntax(request);
    }

    public final AnalyzeSyntaxResponse analyzeSyntax(Document document) {
        AnalyzeSyntaxRequest request = AnalyzeSyntaxRequest.newBuilder().setDocument(document).build();
        return this.analyzeSyntax(request);
    }

    public final AnalyzeSyntaxResponse analyzeSyntax(AnalyzeSyntaxRequest request) {
        return (AnalyzeSyntaxResponse)this.analyzeSyntaxCallable().call((Object)request);
    }

    public final UnaryCallable<AnalyzeSyntaxRequest, AnalyzeSyntaxResponse> analyzeSyntaxCallable() {
        return this.stub.analyzeSyntaxCallable();
    }

    public final ClassifyTextResponse classifyText(Document document) {
        ClassifyTextRequest request = ClassifyTextRequest.newBuilder().setDocument(document).build();
        return this.classifyText(request);
    }

    public final ClassifyTextResponse classifyText(ClassifyTextRequest request) {
        return (ClassifyTextResponse)this.classifyTextCallable().call((Object)request);
    }

    public final UnaryCallable<ClassifyTextRequest, ClassifyTextResponse> classifyTextCallable() {
        return this.stub.classifyTextCallable();
    }

    public final AnnotateTextResponse annotateText(Document document, AnnotateTextRequest.Features features, EncodingType encodingType) {
        AnnotateTextRequest request = AnnotateTextRequest.newBuilder().setDocument(document).setFeatures(features).setEncodingType(encodingType).build();
        return this.annotateText(request);
    }

    public final AnnotateTextResponse annotateText(Document document, AnnotateTextRequest.Features features) {
        AnnotateTextRequest request = AnnotateTextRequest.newBuilder().setDocument(document).setFeatures(features).build();
        return this.annotateText(request);
    }

    public final AnnotateTextResponse annotateText(AnnotateTextRequest request) {
        return (AnnotateTextResponse)this.annotateTextCallable().call((Object)request);
    }

    public final UnaryCallable<AnnotateTextRequest, AnnotateTextResponse> annotateTextCallable() {
        return this.stub.annotateTextCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

