/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.language.spi.v1beta1;

import com.google.api.gax.core.ConnectionSettings;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.ApiCallSettings;
import com.google.api.gax.grpc.ServiceApiSettings;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.auth.Credentials;
import com.google.cloud.language.v1beta1.AnalyzeEntitiesRequest;
import com.google.cloud.language.v1beta1.AnalyzeEntitiesResponse;
import com.google.cloud.language.v1beta1.AnalyzeSentimentRequest;
import com.google.cloud.language.v1beta1.AnalyzeSentimentResponse;
import com.google.cloud.language.v1beta1.AnnotateTextRequest;
import com.google.cloud.language.v1beta1.AnnotateTextResponse;
import com.google.cloud.language.v1beta1.LanguageServiceGrpc;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.Duration;

public class LanguageServiceSettings
extends ServiceApiSettings {
    private static final String DEFAULT_SERVICE_ADDRESS = "language.googleapis.com";
    private static final int DEFAULT_SERVICE_PORT = 443;
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    public static final ConnectionSettings DEFAULT_CONNECTION_SETTINGS = ConnectionSettings.newBuilder().setServiceAddress("language.googleapis.com").setPort(443).provideCredentialsWith(DEFAULT_SERVICE_SCOPES).build();
    private final SimpleCallSettings<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentSettings;
    private final SimpleCallSettings<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesSettings;
    private final SimpleCallSettings<AnnotateTextRequest, AnnotateTextResponse> annotateTextSettings;

    public SimpleCallSettings<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentSettings() {
        return this.analyzeSentimentSettings;
    }

    public SimpleCallSettings<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesSettings() {
        return this.analyzeEntitiesSettings;
    }

    public SimpleCallSettings<AnnotateTextRequest, AnnotateTextResponse> annotateTextSettings() {
        return this.annotateTextSettings;
    }

    public static String getDefaultServiceAddress() {
        return DEFAULT_SERVICE_ADDRESS;
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static ImmutableList<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private LanguageServiceSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getChannelProvider(), settingsBuilder.getExecutorProvider(), settingsBuilder.getGeneratorName(), settingsBuilder.getGeneratorVersion(), settingsBuilder.getClientLibName(), settingsBuilder.getClientLibVersion());
        this.analyzeSentimentSettings = settingsBuilder.analyzeSentimentSettings().build();
        this.analyzeEntitiesSettings = settingsBuilder.analyzeEntitiesSettings().build();
        this.annotateTextSettings = settingsBuilder.annotateTextSettings().build();
    }

    public static class Builder
    extends ServiceApiSettings.Builder {
        private final ImmutableList<ApiCallSettings.Builder> methodSettingsBuilders;
        private SimpleCallSettings.Builder<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentSettings;
        private SimpleCallSettings.Builder<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesSettings;
        private SimpleCallSettings.Builder<AnnotateTextRequest, AnnotateTextResponse> annotateTextSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(DEFAULT_CONNECTION_SETTINGS);
            this.analyzeSentimentSettings = SimpleCallSettings.newBuilder((MethodDescriptor)LanguageServiceGrpc.METHOD_ANALYZE_SENTIMENT);
            this.analyzeEntitiesSettings = SimpleCallSettings.newBuilder((MethodDescriptor)LanguageServiceGrpc.METHOD_ANALYZE_ENTITIES);
            this.annotateTextSettings = SimpleCallSettings.newBuilder((MethodDescriptor)LanguageServiceGrpc.METHOD_ANNOTATE_TEXT);
            this.methodSettingsBuilders = ImmutableList.of(this.analyzeSentimentSettings, this.analyzeEntitiesSettings, this.annotateTextSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.analyzeSentimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.analyzeEntitiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.annotateTextSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(LanguageServiceSettings settings) {
            super((ServiceApiSettings)settings);
            this.analyzeSentimentSettings = settings.analyzeSentimentSettings.toBuilder();
            this.analyzeEntitiesSettings = settings.analyzeEntitiesSettings.toBuilder();
            this.annotateTextSettings = settings.annotateTextSettings.toBuilder();
            this.methodSettingsBuilders = ImmutableList.of(this.analyzeSentimentSettings, this.analyzeEntitiesSettings, this.annotateTextSettings);
        }

        protected ConnectionSettings getDefaultConnectionSettings() {
            return DEFAULT_CONNECTION_SETTINGS;
        }

        public Builder provideExecutorWith(ScheduledExecutorService executor, boolean shouldAutoClose) {
            super.provideExecutorWith(executor, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ManagedChannel channel, boolean shouldAutoClose) {
            super.provideChannelWith(channel, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ConnectionSettings settings) {
            super.provideChannelWith(settings);
            return this;
        }

        public Builder provideChannelWith(Credentials credentials) {
            super.provideChannelWith(credentials);
            return this;
        }

        public Builder provideChannelWith(List<String> scopes) {
            super.provideChannelWith(scopes);
            return this;
        }

        public Builder setGeneratorHeader(String name, String version) {
            super.setGeneratorHeader(name, version);
            return this;
        }

        public Builder setClientLibHeader(String name, String version) {
            super.setClientLibHeader(name, version);
            return this;
        }

        public Builder applyToAllApiMethods(ApiCallSettings.Builder apiCallSettings) throws Exception {
            super.applyToAllApiMethods(this.methodSettingsBuilders, apiCallSettings);
            return this;
        }

        public SimpleCallSettings.Builder<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentSettings() {
            return this.analyzeSentimentSettings;
        }

        public SimpleCallSettings.Builder<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesSettings() {
            return this.analyzeEntitiesSettings;
        }

        public SimpleCallSettings.Builder<AnnotateTextRequest, AnnotateTextResponse> annotateTextSettings() {
            return this.annotateTextSettings;
        }

        public LanguageServiceSettings build() throws IOException {
            return new LanguageServiceSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.millis((long)60000L)).setInitialRpcTimeout(Duration.millis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.millis((long)60000L)).setTotalTimeout(Duration.millis((long)600000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

