/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.language.v1beta2;

import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.ClientContext;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.auth.Credentials;
import com.google.cloud.language.v1beta2.AnalyzeEntitiesRequest;
import com.google.cloud.language.v1beta2.AnalyzeEntitiesResponse;
import com.google.cloud.language.v1beta2.AnalyzeEntitySentimentRequest;
import com.google.cloud.language.v1beta2.AnalyzeEntitySentimentResponse;
import com.google.cloud.language.v1beta2.AnalyzeSentimentRequest;
import com.google.cloud.language.v1beta2.AnalyzeSentimentResponse;
import com.google.cloud.language.v1beta2.AnalyzeSyntaxRequest;
import com.google.cloud.language.v1beta2.AnalyzeSyntaxResponse;
import com.google.cloud.language.v1beta2.AnnotateTextRequest;
import com.google.cloud.language.v1beta2.AnnotateTextResponse;
import com.google.cloud.language.v1beta2.Document;
import com.google.cloud.language.v1beta2.EncodingType;
import com.google.cloud.language.v1beta2.LanguageServiceSettings;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

@BetaApi
public class LanguageServiceClient
implements AutoCloseable {
    private final LanguageServiceSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentCallable;
    private final UnaryCallable<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesCallable;
    private final UnaryCallable<AnalyzeEntitySentimentRequest, AnalyzeEntitySentimentResponse> analyzeEntitySentimentCallable;
    private final UnaryCallable<AnalyzeSyntaxRequest, AnalyzeSyntaxResponse> analyzeSyntaxCallable;
    private final UnaryCallable<AnnotateTextRequest, AnnotateTextResponse> annotateTextCallable;

    public static final LanguageServiceClient create() throws IOException {
        return LanguageServiceClient.create(LanguageServiceSettings.defaultBuilder().build());
    }

    public static final LanguageServiceClient create(LanguageServiceSettings settings) throws IOException {
        return new LanguageServiceClient(settings);
    }

    protected LanguageServiceClient(LanguageServiceSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        Credentials credentials = settings.getCredentialsProvider().getCredentials();
        ClientContext clientContext = ClientContext.newBuilder().setExecutor(this.executor).setChannel((Channel)this.channel).setCredentials(credentials).build();
        this.analyzeSentimentCallable = UnaryCallable.create(settings.analyzeSentimentSettings(), (ClientContext)clientContext);
        this.analyzeEntitiesCallable = UnaryCallable.create(settings.analyzeEntitiesSettings(), (ClientContext)clientContext);
        this.analyzeEntitySentimentCallable = UnaryCallable.create(settings.analyzeEntitySentimentSettings(), (ClientContext)clientContext);
        this.analyzeSyntaxCallable = UnaryCallable.create(settings.analyzeSyntaxSettings(), (ClientContext)clientContext);
        this.annotateTextCallable = UnaryCallable.create(settings.annotateTextSettings(), (ClientContext)clientContext);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    LanguageServiceClient.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    LanguageServiceClient.this.executor.shutdown();
                }
            });
        }
    }

    public final LanguageServiceSettings getSettings() {
        return this.settings;
    }

    public final AnalyzeSentimentResponse analyzeSentiment(Document document) {
        AnalyzeSentimentRequest request = AnalyzeSentimentRequest.newBuilder().setDocument(document).build();
        return this.analyzeSentiment(request);
    }

    private final AnalyzeSentimentResponse analyzeSentiment(AnalyzeSentimentRequest request) {
        return (AnalyzeSentimentResponse)this.analyzeSentimentCallable().call((Object)request);
    }

    public final UnaryCallable<AnalyzeSentimentRequest, AnalyzeSentimentResponse> analyzeSentimentCallable() {
        return this.analyzeSentimentCallable;
    }

    public final AnalyzeEntitiesResponse analyzeEntities(Document document, EncodingType encodingType) {
        AnalyzeEntitiesRequest request = AnalyzeEntitiesRequest.newBuilder().setDocument(document).setEncodingType(encodingType).build();
        return this.analyzeEntities(request);
    }

    public final AnalyzeEntitiesResponse analyzeEntities(AnalyzeEntitiesRequest request) {
        return (AnalyzeEntitiesResponse)this.analyzeEntitiesCallable().call((Object)request);
    }

    public final UnaryCallable<AnalyzeEntitiesRequest, AnalyzeEntitiesResponse> analyzeEntitiesCallable() {
        return this.analyzeEntitiesCallable;
    }

    public final AnalyzeEntitySentimentResponse analyzeEntitySentiment(Document document, EncodingType encodingType) {
        AnalyzeEntitySentimentRequest request = AnalyzeEntitySentimentRequest.newBuilder().setDocument(document).setEncodingType(encodingType).build();
        return this.analyzeEntitySentiment(request);
    }

    public final AnalyzeEntitySentimentResponse analyzeEntitySentiment(AnalyzeEntitySentimentRequest request) {
        return (AnalyzeEntitySentimentResponse)this.analyzeEntitySentimentCallable().call((Object)request);
    }

    public final UnaryCallable<AnalyzeEntitySentimentRequest, AnalyzeEntitySentimentResponse> analyzeEntitySentimentCallable() {
        return this.analyzeEntitySentimentCallable;
    }

    public final AnalyzeSyntaxResponse analyzeSyntax(Document document, EncodingType encodingType) {
        AnalyzeSyntaxRequest request = AnalyzeSyntaxRequest.newBuilder().setDocument(document).setEncodingType(encodingType).build();
        return this.analyzeSyntax(request);
    }

    public final AnalyzeSyntaxResponse analyzeSyntax(AnalyzeSyntaxRequest request) {
        return (AnalyzeSyntaxResponse)this.analyzeSyntaxCallable().call((Object)request);
    }

    public final UnaryCallable<AnalyzeSyntaxRequest, AnalyzeSyntaxResponse> analyzeSyntaxCallable() {
        return this.analyzeSyntaxCallable;
    }

    public final AnnotateTextResponse annotateText(Document document, AnnotateTextRequest.Features features, EncodingType encodingType) {
        AnnotateTextRequest request = AnnotateTextRequest.newBuilder().setDocument(document).setFeatures(features).setEncodingType(encodingType).build();
        return this.annotateText(request);
    }

    public final AnnotateTextResponse annotateText(AnnotateTextRequest request) {
        return (AnnotateTextResponse)this.annotateTextCallable().call((Object)request);
    }

    public final UnaryCallable<AnnotateTextRequest, AnnotateTextResponse> annotateTextCallable() {
        return this.annotateTextCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

