/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.config.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.config.v1.ConfigClient;
import com.google.cloud.config.v1.CreateDeploymentRequest;
import com.google.cloud.config.v1.CreatePreviewRequest;
import com.google.cloud.config.v1.DeleteDeploymentRequest;
import com.google.cloud.config.v1.DeletePreviewRequest;
import com.google.cloud.config.v1.DeleteStatefileRequest;
import com.google.cloud.config.v1.Deployment;
import com.google.cloud.config.v1.ExportDeploymentStatefileRequest;
import com.google.cloud.config.v1.ExportLockInfoRequest;
import com.google.cloud.config.v1.ExportPreviewResultRequest;
import com.google.cloud.config.v1.ExportPreviewResultResponse;
import com.google.cloud.config.v1.ExportRevisionStatefileRequest;
import com.google.cloud.config.v1.GetDeploymentRequest;
import com.google.cloud.config.v1.GetPreviewRequest;
import com.google.cloud.config.v1.GetResourceChangeRequest;
import com.google.cloud.config.v1.GetResourceDriftRequest;
import com.google.cloud.config.v1.GetResourceRequest;
import com.google.cloud.config.v1.GetRevisionRequest;
import com.google.cloud.config.v1.GetTerraformVersionRequest;
import com.google.cloud.config.v1.ImportStatefileRequest;
import com.google.cloud.config.v1.ListDeploymentsRequest;
import com.google.cloud.config.v1.ListDeploymentsResponse;
import com.google.cloud.config.v1.ListPreviewsRequest;
import com.google.cloud.config.v1.ListPreviewsResponse;
import com.google.cloud.config.v1.ListResourceChangesRequest;
import com.google.cloud.config.v1.ListResourceChangesResponse;
import com.google.cloud.config.v1.ListResourceDriftsRequest;
import com.google.cloud.config.v1.ListResourceDriftsResponse;
import com.google.cloud.config.v1.ListResourcesRequest;
import com.google.cloud.config.v1.ListResourcesResponse;
import com.google.cloud.config.v1.ListRevisionsRequest;
import com.google.cloud.config.v1.ListRevisionsResponse;
import com.google.cloud.config.v1.ListTerraformVersionsRequest;
import com.google.cloud.config.v1.ListTerraformVersionsResponse;
import com.google.cloud.config.v1.LockDeploymentRequest;
import com.google.cloud.config.v1.LockInfo;
import com.google.cloud.config.v1.OperationMetadata;
import com.google.cloud.config.v1.Preview;
import com.google.cloud.config.v1.Resource;
import com.google.cloud.config.v1.ResourceChange;
import com.google.cloud.config.v1.ResourceDrift;
import com.google.cloud.config.v1.Revision;
import com.google.cloud.config.v1.Statefile;
import com.google.cloud.config.v1.TerraformVersion;
import com.google.cloud.config.v1.UnlockDeploymentRequest;
import com.google.cloud.config.v1.UpdateDeploymentRequest;
import com.google.cloud.config.v1.stub.ConfigStub;
import com.google.cloud.config.v1.stub.ConfigStubSettings;
import com.google.cloud.config.v1.stub.GrpcConfigCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcConfigStub
extends ConfigStub {
    private static final MethodDescriptor<ListDeploymentsRequest, ListDeploymentsResponse> listDeploymentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/ListDeployments").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDeploymentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDeploymentsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetDeploymentRequest, Deployment> getDeploymentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/GetDeployment").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDeploymentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Deployment.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateDeploymentRequest, Operation> createDeploymentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/CreateDeployment").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateDeploymentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateDeploymentRequest, Operation> updateDeploymentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/UpdateDeployment").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateDeploymentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteDeploymentRequest, Operation> deleteDeploymentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/DeleteDeployment").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteDeploymentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListRevisionsRequest, ListRevisionsResponse> listRevisionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/ListRevisions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListRevisionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListRevisionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetRevisionRequest, Revision> getRevisionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/GetRevision").setRequestMarshaller(ProtoUtils.marshaller((Message)GetRevisionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Revision.getDefaultInstance())).build();
    private static final MethodDescriptor<GetResourceRequest, Resource> getResourceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/GetResource").setRequestMarshaller(ProtoUtils.marshaller((Message)GetResourceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Resource.getDefaultInstance())).build();
    private static final MethodDescriptor<ListResourcesRequest, ListResourcesResponse> listResourcesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/ListResources").setRequestMarshaller(ProtoUtils.marshaller((Message)ListResourcesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListResourcesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ExportDeploymentStatefileRequest, Statefile> exportDeploymentStatefileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/ExportDeploymentStatefile").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportDeploymentStatefileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Statefile.getDefaultInstance())).build();
    private static final MethodDescriptor<ExportRevisionStatefileRequest, Statefile> exportRevisionStatefileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/ExportRevisionStatefile").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportRevisionStatefileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Statefile.getDefaultInstance())).build();
    private static final MethodDescriptor<ImportStatefileRequest, Statefile> importStatefileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/ImportStatefile").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportStatefileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Statefile.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteStatefileRequest, Empty> deleteStatefileMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/DeleteStatefile").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteStatefileRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<LockDeploymentRequest, Operation> lockDeploymentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/LockDeployment").setRequestMarshaller(ProtoUtils.marshaller((Message)LockDeploymentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UnlockDeploymentRequest, Operation> unlockDeploymentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/UnlockDeployment").setRequestMarshaller(ProtoUtils.marshaller((Message)UnlockDeploymentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ExportLockInfoRequest, LockInfo> exportLockInfoMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/ExportLockInfo").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportLockInfoRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)LockInfo.getDefaultInstance())).build();
    private static final MethodDescriptor<CreatePreviewRequest, Operation> createPreviewMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/CreatePreview").setRequestMarshaller(ProtoUtils.marshaller((Message)CreatePreviewRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetPreviewRequest, Preview> getPreviewMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/GetPreview").setRequestMarshaller(ProtoUtils.marshaller((Message)GetPreviewRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Preview.getDefaultInstance())).build();
    private static final MethodDescriptor<ListPreviewsRequest, ListPreviewsResponse> listPreviewsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/ListPreviews").setRequestMarshaller(ProtoUtils.marshaller((Message)ListPreviewsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListPreviewsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeletePreviewRequest, Operation> deletePreviewMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/DeletePreview").setRequestMarshaller(ProtoUtils.marshaller((Message)DeletePreviewRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ExportPreviewResultRequest, ExportPreviewResultResponse> exportPreviewResultMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/ExportPreviewResult").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportPreviewResultRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ExportPreviewResultResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListTerraformVersionsRequest, ListTerraformVersionsResponse> listTerraformVersionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/ListTerraformVersions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTerraformVersionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTerraformVersionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetTerraformVersionRequest, TerraformVersion> getTerraformVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/GetTerraformVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTerraformVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TerraformVersion.getDefaultInstance())).build();
    private static final MethodDescriptor<ListResourceChangesRequest, ListResourceChangesResponse> listResourceChangesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/ListResourceChanges").setRequestMarshaller(ProtoUtils.marshaller((Message)ListResourceChangesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListResourceChangesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetResourceChangeRequest, ResourceChange> getResourceChangeMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/GetResourceChange").setRequestMarshaller(ProtoUtils.marshaller((Message)GetResourceChangeRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ResourceChange.getDefaultInstance())).build();
    private static final MethodDescriptor<ListResourceDriftsRequest, ListResourceDriftsResponse> listResourceDriftsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/ListResourceDrifts").setRequestMarshaller(ProtoUtils.marshaller((Message)ListResourceDriftsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListResourceDriftsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetResourceDriftRequest, ResourceDrift> getResourceDriftMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.config.v1.Config/GetResourceDrift").setRequestMarshaller(ProtoUtils.marshaller((Message)GetResourceDriftRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ResourceDrift.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<ListDeploymentsRequest, ListDeploymentsResponse> listDeploymentsCallable;
    private final UnaryCallable<ListDeploymentsRequest, ConfigClient.ListDeploymentsPagedResponse> listDeploymentsPagedCallable;
    private final UnaryCallable<GetDeploymentRequest, Deployment> getDeploymentCallable;
    private final UnaryCallable<CreateDeploymentRequest, Operation> createDeploymentCallable;
    private final OperationCallable<CreateDeploymentRequest, Deployment, OperationMetadata> createDeploymentOperationCallable;
    private final UnaryCallable<UpdateDeploymentRequest, Operation> updateDeploymentCallable;
    private final OperationCallable<UpdateDeploymentRequest, Deployment, OperationMetadata> updateDeploymentOperationCallable;
    private final UnaryCallable<DeleteDeploymentRequest, Operation> deleteDeploymentCallable;
    private final OperationCallable<DeleteDeploymentRequest, Deployment, OperationMetadata> deleteDeploymentOperationCallable;
    private final UnaryCallable<ListRevisionsRequest, ListRevisionsResponse> listRevisionsCallable;
    private final UnaryCallable<ListRevisionsRequest, ConfigClient.ListRevisionsPagedResponse> listRevisionsPagedCallable;
    private final UnaryCallable<GetRevisionRequest, Revision> getRevisionCallable;
    private final UnaryCallable<GetResourceRequest, Resource> getResourceCallable;
    private final UnaryCallable<ListResourcesRequest, ListResourcesResponse> listResourcesCallable;
    private final UnaryCallable<ListResourcesRequest, ConfigClient.ListResourcesPagedResponse> listResourcesPagedCallable;
    private final UnaryCallable<ExportDeploymentStatefileRequest, Statefile> exportDeploymentStatefileCallable;
    private final UnaryCallable<ExportRevisionStatefileRequest, Statefile> exportRevisionStatefileCallable;
    private final UnaryCallable<ImportStatefileRequest, Statefile> importStatefileCallable;
    private final UnaryCallable<DeleteStatefileRequest, Empty> deleteStatefileCallable;
    private final UnaryCallable<LockDeploymentRequest, Operation> lockDeploymentCallable;
    private final OperationCallable<LockDeploymentRequest, Deployment, OperationMetadata> lockDeploymentOperationCallable;
    private final UnaryCallable<UnlockDeploymentRequest, Operation> unlockDeploymentCallable;
    private final OperationCallable<UnlockDeploymentRequest, Deployment, OperationMetadata> unlockDeploymentOperationCallable;
    private final UnaryCallable<ExportLockInfoRequest, LockInfo> exportLockInfoCallable;
    private final UnaryCallable<CreatePreviewRequest, Operation> createPreviewCallable;
    private final OperationCallable<CreatePreviewRequest, Preview, OperationMetadata> createPreviewOperationCallable;
    private final UnaryCallable<GetPreviewRequest, Preview> getPreviewCallable;
    private final UnaryCallable<ListPreviewsRequest, ListPreviewsResponse> listPreviewsCallable;
    private final UnaryCallable<ListPreviewsRequest, ConfigClient.ListPreviewsPagedResponse> listPreviewsPagedCallable;
    private final UnaryCallable<DeletePreviewRequest, Operation> deletePreviewCallable;
    private final OperationCallable<DeletePreviewRequest, Preview, OperationMetadata> deletePreviewOperationCallable;
    private final UnaryCallable<ExportPreviewResultRequest, ExportPreviewResultResponse> exportPreviewResultCallable;
    private final UnaryCallable<ListTerraformVersionsRequest, ListTerraformVersionsResponse> listTerraformVersionsCallable;
    private final UnaryCallable<ListTerraformVersionsRequest, ConfigClient.ListTerraformVersionsPagedResponse> listTerraformVersionsPagedCallable;
    private final UnaryCallable<GetTerraformVersionRequest, TerraformVersion> getTerraformVersionCallable;
    private final UnaryCallable<ListResourceChangesRequest, ListResourceChangesResponse> listResourceChangesCallable;
    private final UnaryCallable<ListResourceChangesRequest, ConfigClient.ListResourceChangesPagedResponse> listResourceChangesPagedCallable;
    private final UnaryCallable<GetResourceChangeRequest, ResourceChange> getResourceChangeCallable;
    private final UnaryCallable<ListResourceDriftsRequest, ListResourceDriftsResponse> listResourceDriftsCallable;
    private final UnaryCallable<ListResourceDriftsRequest, ConfigClient.ListResourceDriftsPagedResponse> listResourceDriftsPagedCallable;
    private final UnaryCallable<GetResourceDriftRequest, ResourceDrift> getResourceDriftCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ConfigClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcConfigStub create(ConfigStubSettings settings) throws IOException {
        return new GrpcConfigStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcConfigStub create(ClientContext clientContext) throws IOException {
        return new GrpcConfigStub(ConfigStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcConfigStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcConfigStub(ConfigStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcConfigStub(ConfigStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcConfigCallableFactory());
    }

    protected GrpcConfigStub(ConfigStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listDeploymentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDeploymentsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getDeploymentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDeploymentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createDeploymentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createDeploymentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateDeploymentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateDeploymentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("deployment.name", String.valueOf(request.getDeployment().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteDeploymentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteDeploymentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listRevisionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listRevisionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getRevisionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getRevisionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getResourceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getResourceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listResourcesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listResourcesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings exportDeploymentStatefileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportDeploymentStatefileMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings exportRevisionStatefileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportRevisionStatefileMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings importStatefileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importStatefileMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteStatefileTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteStatefileMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings lockDeploymentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(lockDeploymentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings unlockDeploymentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(unlockDeploymentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings exportLockInfoTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportLockInfoMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createPreviewTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createPreviewMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getPreviewTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getPreviewMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listPreviewsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listPreviewsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deletePreviewTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deletePreviewMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings exportPreviewResultTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportPreviewResultMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listTerraformVersionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTerraformVersionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getTerraformVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTerraformVersionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listResourceChangesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listResourceChangesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getResourceChangeTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getResourceChangeMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listResourceDriftsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listResourceDriftsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getResourceDriftTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getResourceDriftMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.listDeploymentsCallable = callableFactory.createUnaryCallable(listDeploymentsTransportSettings, settings.listDeploymentsSettings(), clientContext);
        this.listDeploymentsPagedCallable = callableFactory.createPagedCallable(listDeploymentsTransportSettings, settings.listDeploymentsSettings(), clientContext);
        this.getDeploymentCallable = callableFactory.createUnaryCallable(getDeploymentTransportSettings, settings.getDeploymentSettings(), clientContext);
        this.createDeploymentCallable = callableFactory.createUnaryCallable(createDeploymentTransportSettings, settings.createDeploymentSettings(), clientContext);
        this.createDeploymentOperationCallable = callableFactory.createOperationCallable(createDeploymentTransportSettings, settings.createDeploymentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateDeploymentCallable = callableFactory.createUnaryCallable(updateDeploymentTransportSettings, settings.updateDeploymentSettings(), clientContext);
        this.updateDeploymentOperationCallable = callableFactory.createOperationCallable(updateDeploymentTransportSettings, settings.updateDeploymentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteDeploymentCallable = callableFactory.createUnaryCallable(deleteDeploymentTransportSettings, settings.deleteDeploymentSettings(), clientContext);
        this.deleteDeploymentOperationCallable = callableFactory.createOperationCallable(deleteDeploymentTransportSettings, settings.deleteDeploymentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listRevisionsCallable = callableFactory.createUnaryCallable(listRevisionsTransportSettings, settings.listRevisionsSettings(), clientContext);
        this.listRevisionsPagedCallable = callableFactory.createPagedCallable(listRevisionsTransportSettings, settings.listRevisionsSettings(), clientContext);
        this.getRevisionCallable = callableFactory.createUnaryCallable(getRevisionTransportSettings, settings.getRevisionSettings(), clientContext);
        this.getResourceCallable = callableFactory.createUnaryCallable(getResourceTransportSettings, settings.getResourceSettings(), clientContext);
        this.listResourcesCallable = callableFactory.createUnaryCallable(listResourcesTransportSettings, settings.listResourcesSettings(), clientContext);
        this.listResourcesPagedCallable = callableFactory.createPagedCallable(listResourcesTransportSettings, settings.listResourcesSettings(), clientContext);
        this.exportDeploymentStatefileCallable = callableFactory.createUnaryCallable(exportDeploymentStatefileTransportSettings, settings.exportDeploymentStatefileSettings(), clientContext);
        this.exportRevisionStatefileCallable = callableFactory.createUnaryCallable(exportRevisionStatefileTransportSettings, settings.exportRevisionStatefileSettings(), clientContext);
        this.importStatefileCallable = callableFactory.createUnaryCallable(importStatefileTransportSettings, settings.importStatefileSettings(), clientContext);
        this.deleteStatefileCallable = callableFactory.createUnaryCallable(deleteStatefileTransportSettings, settings.deleteStatefileSettings(), clientContext);
        this.lockDeploymentCallable = callableFactory.createUnaryCallable(lockDeploymentTransportSettings, settings.lockDeploymentSettings(), clientContext);
        this.lockDeploymentOperationCallable = callableFactory.createOperationCallable(lockDeploymentTransportSettings, settings.lockDeploymentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.unlockDeploymentCallable = callableFactory.createUnaryCallable(unlockDeploymentTransportSettings, settings.unlockDeploymentSettings(), clientContext);
        this.unlockDeploymentOperationCallable = callableFactory.createOperationCallable(unlockDeploymentTransportSettings, settings.unlockDeploymentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.exportLockInfoCallable = callableFactory.createUnaryCallable(exportLockInfoTransportSettings, settings.exportLockInfoSettings(), clientContext);
        this.createPreviewCallable = callableFactory.createUnaryCallable(createPreviewTransportSettings, settings.createPreviewSettings(), clientContext);
        this.createPreviewOperationCallable = callableFactory.createOperationCallable(createPreviewTransportSettings, settings.createPreviewOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getPreviewCallable = callableFactory.createUnaryCallable(getPreviewTransportSettings, settings.getPreviewSettings(), clientContext);
        this.listPreviewsCallable = callableFactory.createUnaryCallable(listPreviewsTransportSettings, settings.listPreviewsSettings(), clientContext);
        this.listPreviewsPagedCallable = callableFactory.createPagedCallable(listPreviewsTransportSettings, settings.listPreviewsSettings(), clientContext);
        this.deletePreviewCallable = callableFactory.createUnaryCallable(deletePreviewTransportSettings, settings.deletePreviewSettings(), clientContext);
        this.deletePreviewOperationCallable = callableFactory.createOperationCallable(deletePreviewTransportSettings, settings.deletePreviewOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.exportPreviewResultCallable = callableFactory.createUnaryCallable(exportPreviewResultTransportSettings, settings.exportPreviewResultSettings(), clientContext);
        this.listTerraformVersionsCallable = callableFactory.createUnaryCallable(listTerraformVersionsTransportSettings, settings.listTerraformVersionsSettings(), clientContext);
        this.listTerraformVersionsPagedCallable = callableFactory.createPagedCallable(listTerraformVersionsTransportSettings, settings.listTerraformVersionsSettings(), clientContext);
        this.getTerraformVersionCallable = callableFactory.createUnaryCallable(getTerraformVersionTransportSettings, settings.getTerraformVersionSettings(), clientContext);
        this.listResourceChangesCallable = callableFactory.createUnaryCallable(listResourceChangesTransportSettings, settings.listResourceChangesSettings(), clientContext);
        this.listResourceChangesPagedCallable = callableFactory.createPagedCallable(listResourceChangesTransportSettings, settings.listResourceChangesSettings(), clientContext);
        this.getResourceChangeCallable = callableFactory.createUnaryCallable(getResourceChangeTransportSettings, settings.getResourceChangeSettings(), clientContext);
        this.listResourceDriftsCallable = callableFactory.createUnaryCallable(listResourceDriftsTransportSettings, settings.listResourceDriftsSettings(), clientContext);
        this.listResourceDriftsPagedCallable = callableFactory.createPagedCallable(listResourceDriftsTransportSettings, settings.listResourceDriftsSettings(), clientContext);
        this.getResourceDriftCallable = callableFactory.createUnaryCallable(getResourceDriftTransportSettings, settings.getResourceDriftSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListDeploymentsRequest, ListDeploymentsResponse> listDeploymentsCallable() {
        return this.listDeploymentsCallable;
    }

    @Override
    public UnaryCallable<ListDeploymentsRequest, ConfigClient.ListDeploymentsPagedResponse> listDeploymentsPagedCallable() {
        return this.listDeploymentsPagedCallable;
    }

    @Override
    public UnaryCallable<GetDeploymentRequest, Deployment> getDeploymentCallable() {
        return this.getDeploymentCallable;
    }

    @Override
    public UnaryCallable<CreateDeploymentRequest, Operation> createDeploymentCallable() {
        return this.createDeploymentCallable;
    }

    @Override
    public OperationCallable<CreateDeploymentRequest, Deployment, OperationMetadata> createDeploymentOperationCallable() {
        return this.createDeploymentOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateDeploymentRequest, Operation> updateDeploymentCallable() {
        return this.updateDeploymentCallable;
    }

    @Override
    public OperationCallable<UpdateDeploymentRequest, Deployment, OperationMetadata> updateDeploymentOperationCallable() {
        return this.updateDeploymentOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteDeploymentRequest, Operation> deleteDeploymentCallable() {
        return this.deleteDeploymentCallable;
    }

    @Override
    public OperationCallable<DeleteDeploymentRequest, Deployment, OperationMetadata> deleteDeploymentOperationCallable() {
        return this.deleteDeploymentOperationCallable;
    }

    @Override
    public UnaryCallable<ListRevisionsRequest, ListRevisionsResponse> listRevisionsCallable() {
        return this.listRevisionsCallable;
    }

    @Override
    public UnaryCallable<ListRevisionsRequest, ConfigClient.ListRevisionsPagedResponse> listRevisionsPagedCallable() {
        return this.listRevisionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetRevisionRequest, Revision> getRevisionCallable() {
        return this.getRevisionCallable;
    }

    @Override
    public UnaryCallable<GetResourceRequest, Resource> getResourceCallable() {
        return this.getResourceCallable;
    }

    @Override
    public UnaryCallable<ListResourcesRequest, ListResourcesResponse> listResourcesCallable() {
        return this.listResourcesCallable;
    }

    @Override
    public UnaryCallable<ListResourcesRequest, ConfigClient.ListResourcesPagedResponse> listResourcesPagedCallable() {
        return this.listResourcesPagedCallable;
    }

    @Override
    public UnaryCallable<ExportDeploymentStatefileRequest, Statefile> exportDeploymentStatefileCallable() {
        return this.exportDeploymentStatefileCallable;
    }

    @Override
    public UnaryCallable<ExportRevisionStatefileRequest, Statefile> exportRevisionStatefileCallable() {
        return this.exportRevisionStatefileCallable;
    }

    @Override
    public UnaryCallable<ImportStatefileRequest, Statefile> importStatefileCallable() {
        return this.importStatefileCallable;
    }

    @Override
    public UnaryCallable<DeleteStatefileRequest, Empty> deleteStatefileCallable() {
        return this.deleteStatefileCallable;
    }

    @Override
    public UnaryCallable<LockDeploymentRequest, Operation> lockDeploymentCallable() {
        return this.lockDeploymentCallable;
    }

    @Override
    public OperationCallable<LockDeploymentRequest, Deployment, OperationMetadata> lockDeploymentOperationCallable() {
        return this.lockDeploymentOperationCallable;
    }

    @Override
    public UnaryCallable<UnlockDeploymentRequest, Operation> unlockDeploymentCallable() {
        return this.unlockDeploymentCallable;
    }

    @Override
    public OperationCallable<UnlockDeploymentRequest, Deployment, OperationMetadata> unlockDeploymentOperationCallable() {
        return this.unlockDeploymentOperationCallable;
    }

    @Override
    public UnaryCallable<ExportLockInfoRequest, LockInfo> exportLockInfoCallable() {
        return this.exportLockInfoCallable;
    }

    @Override
    public UnaryCallable<CreatePreviewRequest, Operation> createPreviewCallable() {
        return this.createPreviewCallable;
    }

    @Override
    public OperationCallable<CreatePreviewRequest, Preview, OperationMetadata> createPreviewOperationCallable() {
        return this.createPreviewOperationCallable;
    }

    @Override
    public UnaryCallable<GetPreviewRequest, Preview> getPreviewCallable() {
        return this.getPreviewCallable;
    }

    @Override
    public UnaryCallable<ListPreviewsRequest, ListPreviewsResponse> listPreviewsCallable() {
        return this.listPreviewsCallable;
    }

    @Override
    public UnaryCallable<ListPreviewsRequest, ConfigClient.ListPreviewsPagedResponse> listPreviewsPagedCallable() {
        return this.listPreviewsPagedCallable;
    }

    @Override
    public UnaryCallable<DeletePreviewRequest, Operation> deletePreviewCallable() {
        return this.deletePreviewCallable;
    }

    @Override
    public OperationCallable<DeletePreviewRequest, Preview, OperationMetadata> deletePreviewOperationCallable() {
        return this.deletePreviewOperationCallable;
    }

    @Override
    public UnaryCallable<ExportPreviewResultRequest, ExportPreviewResultResponse> exportPreviewResultCallable() {
        return this.exportPreviewResultCallable;
    }

    @Override
    public UnaryCallable<ListTerraformVersionsRequest, ListTerraformVersionsResponse> listTerraformVersionsCallable() {
        return this.listTerraformVersionsCallable;
    }

    @Override
    public UnaryCallable<ListTerraformVersionsRequest, ConfigClient.ListTerraformVersionsPagedResponse> listTerraformVersionsPagedCallable() {
        return this.listTerraformVersionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetTerraformVersionRequest, TerraformVersion> getTerraformVersionCallable() {
        return this.getTerraformVersionCallable;
    }

    @Override
    public UnaryCallable<ListResourceChangesRequest, ListResourceChangesResponse> listResourceChangesCallable() {
        return this.listResourceChangesCallable;
    }

    @Override
    public UnaryCallable<ListResourceChangesRequest, ConfigClient.ListResourceChangesPagedResponse> listResourceChangesPagedCallable() {
        return this.listResourceChangesPagedCallable;
    }

    @Override
    public UnaryCallable<GetResourceChangeRequest, ResourceChange> getResourceChangeCallable() {
        return this.getResourceChangeCallable;
    }

    @Override
    public UnaryCallable<ListResourceDriftsRequest, ListResourceDriftsResponse> listResourceDriftsCallable() {
        return this.listResourceDriftsCallable;
    }

    @Override
    public UnaryCallable<ListResourceDriftsRequest, ConfigClient.ListResourceDriftsPagedResponse> listResourceDriftsPagedCallable() {
        return this.listResourceDriftsPagedCallable;
    }

    @Override
    public UnaryCallable<GetResourceDriftRequest, ResourceDrift> getResourceDriftCallable() {
        return this.getResourceDriftCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ConfigClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

