/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.config.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.config.v1.ConfigSettings;
import com.google.cloud.config.v1.CreateDeploymentRequest;
import com.google.cloud.config.v1.CreatePreviewRequest;
import com.google.cloud.config.v1.DeleteDeploymentRequest;
import com.google.cloud.config.v1.DeletePreviewRequest;
import com.google.cloud.config.v1.DeleteStatefileRequest;
import com.google.cloud.config.v1.Deployment;
import com.google.cloud.config.v1.DeploymentName;
import com.google.cloud.config.v1.ExportDeploymentStatefileRequest;
import com.google.cloud.config.v1.ExportLockInfoRequest;
import com.google.cloud.config.v1.ExportPreviewResultRequest;
import com.google.cloud.config.v1.ExportPreviewResultResponse;
import com.google.cloud.config.v1.ExportRevisionStatefileRequest;
import com.google.cloud.config.v1.GetDeploymentRequest;
import com.google.cloud.config.v1.GetPreviewRequest;
import com.google.cloud.config.v1.GetResourceChangeRequest;
import com.google.cloud.config.v1.GetResourceDriftRequest;
import com.google.cloud.config.v1.GetResourceRequest;
import com.google.cloud.config.v1.GetRevisionRequest;
import com.google.cloud.config.v1.GetTerraformVersionRequest;
import com.google.cloud.config.v1.ImportStatefileRequest;
import com.google.cloud.config.v1.ListDeploymentsRequest;
import com.google.cloud.config.v1.ListDeploymentsResponse;
import com.google.cloud.config.v1.ListPreviewsRequest;
import com.google.cloud.config.v1.ListPreviewsResponse;
import com.google.cloud.config.v1.ListResourceChangesRequest;
import com.google.cloud.config.v1.ListResourceChangesResponse;
import com.google.cloud.config.v1.ListResourceDriftsRequest;
import com.google.cloud.config.v1.ListResourceDriftsResponse;
import com.google.cloud.config.v1.ListResourcesRequest;
import com.google.cloud.config.v1.ListResourcesResponse;
import com.google.cloud.config.v1.ListRevisionsRequest;
import com.google.cloud.config.v1.ListRevisionsResponse;
import com.google.cloud.config.v1.ListTerraformVersionsRequest;
import com.google.cloud.config.v1.ListTerraformVersionsResponse;
import com.google.cloud.config.v1.LocationName;
import com.google.cloud.config.v1.LockDeploymentRequest;
import com.google.cloud.config.v1.LockInfo;
import com.google.cloud.config.v1.OperationMetadata;
import com.google.cloud.config.v1.Preview;
import com.google.cloud.config.v1.PreviewName;
import com.google.cloud.config.v1.Resource;
import com.google.cloud.config.v1.ResourceChange;
import com.google.cloud.config.v1.ResourceChangeName;
import com.google.cloud.config.v1.ResourceDrift;
import com.google.cloud.config.v1.ResourceDriftName;
import com.google.cloud.config.v1.ResourceName;
import com.google.cloud.config.v1.Revision;
import com.google.cloud.config.v1.RevisionName;
import com.google.cloud.config.v1.Statefile;
import com.google.cloud.config.v1.TerraformVersion;
import com.google.cloud.config.v1.TerraformVersionName;
import com.google.cloud.config.v1.UnlockDeploymentRequest;
import com.google.cloud.config.v1.UpdateDeploymentRequest;
import com.google.cloud.config.v1.stub.ConfigStub;
import com.google.cloud.config.v1.stub.ConfigStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ConfigClient
implements BackgroundResource {
    private final ConfigSettings settings;
    private final ConfigStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ConfigClient create() throws IOException {
        return ConfigClient.create(ConfigSettings.newBuilder().build());
    }

    public static final ConfigClient create(ConfigSettings settings) throws IOException {
        return new ConfigClient(settings);
    }

    public static final ConfigClient create(ConfigStub stub) {
        return new ConfigClient(stub);
    }

    protected ConfigClient(ConfigSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConfigStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ConfigClient(ConfigStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ConfigSettings getSettings() {
        return this.settings;
    }

    public ConfigStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListDeploymentsPagedResponse listDeployments(LocationName parent) {
        ListDeploymentsRequest request = ListDeploymentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDeployments(request);
    }

    public final ListDeploymentsPagedResponse listDeployments(String parent) {
        ListDeploymentsRequest request = ListDeploymentsRequest.newBuilder().setParent(parent).build();
        return this.listDeployments(request);
    }

    public final ListDeploymentsPagedResponse listDeployments(ListDeploymentsRequest request) {
        return (ListDeploymentsPagedResponse)((Object)this.listDeploymentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDeploymentsRequest, ListDeploymentsPagedResponse> listDeploymentsPagedCallable() {
        return this.stub.listDeploymentsPagedCallable();
    }

    public final UnaryCallable<ListDeploymentsRequest, ListDeploymentsResponse> listDeploymentsCallable() {
        return this.stub.listDeploymentsCallable();
    }

    public final Deployment getDeployment(DeploymentName name) {
        GetDeploymentRequest request = GetDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDeployment(request);
    }

    public final Deployment getDeployment(String name) {
        GetDeploymentRequest request = GetDeploymentRequest.newBuilder().setName(name).build();
        return this.getDeployment(request);
    }

    public final Deployment getDeployment(GetDeploymentRequest request) {
        return (Deployment)this.getDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<GetDeploymentRequest, Deployment> getDeploymentCallable() {
        return this.stub.getDeploymentCallable();
    }

    public final OperationFuture<Deployment, OperationMetadata> createDeploymentAsync(LocationName parent, Deployment deployment, String deploymentId) {
        CreateDeploymentRequest request = CreateDeploymentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDeployment(deployment).setDeploymentId(deploymentId).build();
        return this.createDeploymentAsync(request);
    }

    public final OperationFuture<Deployment, OperationMetadata> createDeploymentAsync(String parent, Deployment deployment, String deploymentId) {
        CreateDeploymentRequest request = CreateDeploymentRequest.newBuilder().setParent(parent).setDeployment(deployment).setDeploymentId(deploymentId).build();
        return this.createDeploymentAsync(request);
    }

    public final OperationFuture<Deployment, OperationMetadata> createDeploymentAsync(CreateDeploymentRequest request) {
        return this.createDeploymentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDeploymentRequest, Deployment, OperationMetadata> createDeploymentOperationCallable() {
        return this.stub.createDeploymentOperationCallable();
    }

    public final UnaryCallable<CreateDeploymentRequest, Operation> createDeploymentCallable() {
        return this.stub.createDeploymentCallable();
    }

    public final OperationFuture<Deployment, OperationMetadata> updateDeploymentAsync(Deployment deployment, FieldMask updateMask) {
        UpdateDeploymentRequest request = UpdateDeploymentRequest.newBuilder().setDeployment(deployment).setUpdateMask(updateMask).build();
        return this.updateDeploymentAsync(request);
    }

    public final OperationFuture<Deployment, OperationMetadata> updateDeploymentAsync(UpdateDeploymentRequest request) {
        return this.updateDeploymentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDeploymentRequest, Deployment, OperationMetadata> updateDeploymentOperationCallable() {
        return this.stub.updateDeploymentOperationCallable();
    }

    public final UnaryCallable<UpdateDeploymentRequest, Operation> updateDeploymentCallable() {
        return this.stub.updateDeploymentCallable();
    }

    public final OperationFuture<Deployment, OperationMetadata> deleteDeploymentAsync(DeploymentName name) {
        DeleteDeploymentRequest request = DeleteDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDeploymentAsync(request);
    }

    public final OperationFuture<Deployment, OperationMetadata> deleteDeploymentAsync(String name) {
        DeleteDeploymentRequest request = DeleteDeploymentRequest.newBuilder().setName(name).build();
        return this.deleteDeploymentAsync(request);
    }

    public final OperationFuture<Deployment, OperationMetadata> deleteDeploymentAsync(DeleteDeploymentRequest request) {
        return this.deleteDeploymentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDeploymentRequest, Deployment, OperationMetadata> deleteDeploymentOperationCallable() {
        return this.stub.deleteDeploymentOperationCallable();
    }

    public final UnaryCallable<DeleteDeploymentRequest, Operation> deleteDeploymentCallable() {
        return this.stub.deleteDeploymentCallable();
    }

    public final ListRevisionsPagedResponse listRevisions(DeploymentName parent) {
        ListRevisionsRequest request = ListRevisionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRevisions(request);
    }

    public final ListRevisionsPagedResponse listRevisions(String parent) {
        ListRevisionsRequest request = ListRevisionsRequest.newBuilder().setParent(parent).build();
        return this.listRevisions(request);
    }

    public final ListRevisionsPagedResponse listRevisions(ListRevisionsRequest request) {
        return (ListRevisionsPagedResponse)((Object)this.listRevisionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRevisionsRequest, ListRevisionsPagedResponse> listRevisionsPagedCallable() {
        return this.stub.listRevisionsPagedCallable();
    }

    public final UnaryCallable<ListRevisionsRequest, ListRevisionsResponse> listRevisionsCallable() {
        return this.stub.listRevisionsCallable();
    }

    public final Revision getRevision(RevisionName name) {
        GetRevisionRequest request = GetRevisionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRevision(request);
    }

    public final Revision getRevision(String name) {
        GetRevisionRequest request = GetRevisionRequest.newBuilder().setName(name).build();
        return this.getRevision(request);
    }

    public final Revision getRevision(GetRevisionRequest request) {
        return (Revision)this.getRevisionCallable().call((Object)request);
    }

    public final UnaryCallable<GetRevisionRequest, Revision> getRevisionCallable() {
        return this.stub.getRevisionCallable();
    }

    public final Resource getResource(ResourceName name) {
        GetResourceRequest request = GetResourceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getResource(request);
    }

    public final Resource getResource(String name) {
        GetResourceRequest request = GetResourceRequest.newBuilder().setName(name).build();
        return this.getResource(request);
    }

    public final Resource getResource(GetResourceRequest request) {
        return (Resource)this.getResourceCallable().call((Object)request);
    }

    public final UnaryCallable<GetResourceRequest, Resource> getResourceCallable() {
        return this.stub.getResourceCallable();
    }

    public final ListResourcesPagedResponse listResources(RevisionName parent) {
        ListResourcesRequest request = ListResourcesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listResources(request);
    }

    public final ListResourcesPagedResponse listResources(String parent) {
        ListResourcesRequest request = ListResourcesRequest.newBuilder().setParent(parent).build();
        return this.listResources(request);
    }

    public final ListResourcesPagedResponse listResources(ListResourcesRequest request) {
        return (ListResourcesPagedResponse)((Object)this.listResourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListResourcesRequest, ListResourcesPagedResponse> listResourcesPagedCallable() {
        return this.stub.listResourcesPagedCallable();
    }

    public final UnaryCallable<ListResourcesRequest, ListResourcesResponse> listResourcesCallable() {
        return this.stub.listResourcesCallable();
    }

    public final Statefile exportDeploymentStatefile(ExportDeploymentStatefileRequest request) {
        return (Statefile)this.exportDeploymentStatefileCallable().call((Object)request);
    }

    public final UnaryCallable<ExportDeploymentStatefileRequest, Statefile> exportDeploymentStatefileCallable() {
        return this.stub.exportDeploymentStatefileCallable();
    }

    public final Statefile exportRevisionStatefile(ExportRevisionStatefileRequest request) {
        return (Statefile)this.exportRevisionStatefileCallable().call((Object)request);
    }

    public final UnaryCallable<ExportRevisionStatefileRequest, Statefile> exportRevisionStatefileCallable() {
        return this.stub.exportRevisionStatefileCallable();
    }

    public final Statefile importStatefile(DeploymentName parent, long lockId) {
        ImportStatefileRequest request = ImportStatefileRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setLockId(lockId).build();
        return this.importStatefile(request);
    }

    public final Statefile importStatefile(String parent, long lockId) {
        ImportStatefileRequest request = ImportStatefileRequest.newBuilder().setParent(parent).setLockId(lockId).build();
        return this.importStatefile(request);
    }

    public final Statefile importStatefile(ImportStatefileRequest request) {
        return (Statefile)this.importStatefileCallable().call((Object)request);
    }

    public final UnaryCallable<ImportStatefileRequest, Statefile> importStatefileCallable() {
        return this.stub.importStatefileCallable();
    }

    public final void deleteStatefile(DeploymentName name) {
        DeleteStatefileRequest request = DeleteStatefileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteStatefile(request);
    }

    public final void deleteStatefile(String name) {
        DeleteStatefileRequest request = DeleteStatefileRequest.newBuilder().setName(name).build();
        this.deleteStatefile(request);
    }

    public final void deleteStatefile(DeleteStatefileRequest request) {
        this.deleteStatefileCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteStatefileRequest, Empty> deleteStatefileCallable() {
        return this.stub.deleteStatefileCallable();
    }

    public final OperationFuture<Deployment, OperationMetadata> lockDeploymentAsync(DeploymentName name) {
        LockDeploymentRequest request = LockDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.lockDeploymentAsync(request);
    }

    public final OperationFuture<Deployment, OperationMetadata> lockDeploymentAsync(String name) {
        LockDeploymentRequest request = LockDeploymentRequest.newBuilder().setName(name).build();
        return this.lockDeploymentAsync(request);
    }

    public final OperationFuture<Deployment, OperationMetadata> lockDeploymentAsync(LockDeploymentRequest request) {
        return this.lockDeploymentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<LockDeploymentRequest, Deployment, OperationMetadata> lockDeploymentOperationCallable() {
        return this.stub.lockDeploymentOperationCallable();
    }

    public final UnaryCallable<LockDeploymentRequest, Operation> lockDeploymentCallable() {
        return this.stub.lockDeploymentCallable();
    }

    public final OperationFuture<Deployment, OperationMetadata> unlockDeploymentAsync(DeploymentName name, long lockId) {
        UnlockDeploymentRequest request = UnlockDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).setLockId(lockId).build();
        return this.unlockDeploymentAsync(request);
    }

    public final OperationFuture<Deployment, OperationMetadata> unlockDeploymentAsync(String name, long lockId) {
        UnlockDeploymentRequest request = UnlockDeploymentRequest.newBuilder().setName(name).setLockId(lockId).build();
        return this.unlockDeploymentAsync(request);
    }

    public final OperationFuture<Deployment, OperationMetadata> unlockDeploymentAsync(UnlockDeploymentRequest request) {
        return this.unlockDeploymentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UnlockDeploymentRequest, Deployment, OperationMetadata> unlockDeploymentOperationCallable() {
        return this.stub.unlockDeploymentOperationCallable();
    }

    public final UnaryCallable<UnlockDeploymentRequest, Operation> unlockDeploymentCallable() {
        return this.stub.unlockDeploymentCallable();
    }

    public final LockInfo exportLockInfo(DeploymentName name) {
        ExportLockInfoRequest request = ExportLockInfoRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.exportLockInfo(request);
    }

    public final LockInfo exportLockInfo(String name) {
        ExportLockInfoRequest request = ExportLockInfoRequest.newBuilder().setName(name).build();
        return this.exportLockInfo(request);
    }

    public final LockInfo exportLockInfo(ExportLockInfoRequest request) {
        return (LockInfo)this.exportLockInfoCallable().call((Object)request);
    }

    public final UnaryCallable<ExportLockInfoRequest, LockInfo> exportLockInfoCallable() {
        return this.stub.exportLockInfoCallable();
    }

    public final OperationFuture<Preview, OperationMetadata> createPreviewAsync(LocationName parent, Preview preview) {
        CreatePreviewRequest request = CreatePreviewRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPreview(preview).build();
        return this.createPreviewAsync(request);
    }

    public final OperationFuture<Preview, OperationMetadata> createPreviewAsync(String parent, Preview preview) {
        CreatePreviewRequest request = CreatePreviewRequest.newBuilder().setParent(parent).setPreview(preview).build();
        return this.createPreviewAsync(request);
    }

    public final OperationFuture<Preview, OperationMetadata> createPreviewAsync(CreatePreviewRequest request) {
        return this.createPreviewOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePreviewRequest, Preview, OperationMetadata> createPreviewOperationCallable() {
        return this.stub.createPreviewOperationCallable();
    }

    public final UnaryCallable<CreatePreviewRequest, Operation> createPreviewCallable() {
        return this.stub.createPreviewCallable();
    }

    public final Preview getPreview(PreviewName name) {
        GetPreviewRequest request = GetPreviewRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPreview(request);
    }

    public final Preview getPreview(String name) {
        GetPreviewRequest request = GetPreviewRequest.newBuilder().setName(name).build();
        return this.getPreview(request);
    }

    public final Preview getPreview(GetPreviewRequest request) {
        return (Preview)this.getPreviewCallable().call((Object)request);
    }

    public final UnaryCallable<GetPreviewRequest, Preview> getPreviewCallable() {
        return this.stub.getPreviewCallable();
    }

    public final ListPreviewsPagedResponse listPreviews(LocationName parent) {
        ListPreviewsRequest request = ListPreviewsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPreviews(request);
    }

    public final ListPreviewsPagedResponse listPreviews(String parent) {
        ListPreviewsRequest request = ListPreviewsRequest.newBuilder().setParent(parent).build();
        return this.listPreviews(request);
    }

    public final ListPreviewsPagedResponse listPreviews(ListPreviewsRequest request) {
        return (ListPreviewsPagedResponse)((Object)this.listPreviewsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPreviewsRequest, ListPreviewsPagedResponse> listPreviewsPagedCallable() {
        return this.stub.listPreviewsPagedCallable();
    }

    public final UnaryCallable<ListPreviewsRequest, ListPreviewsResponse> listPreviewsCallable() {
        return this.stub.listPreviewsCallable();
    }

    public final OperationFuture<Preview, OperationMetadata> deletePreviewAsync(PreviewName name) {
        DeletePreviewRequest request = DeletePreviewRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePreviewAsync(request);
    }

    public final OperationFuture<Preview, OperationMetadata> deletePreviewAsync(String name) {
        DeletePreviewRequest request = DeletePreviewRequest.newBuilder().setName(name).build();
        return this.deletePreviewAsync(request);
    }

    public final OperationFuture<Preview, OperationMetadata> deletePreviewAsync(DeletePreviewRequest request) {
        return this.deletePreviewOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePreviewRequest, Preview, OperationMetadata> deletePreviewOperationCallable() {
        return this.stub.deletePreviewOperationCallable();
    }

    public final UnaryCallable<DeletePreviewRequest, Operation> deletePreviewCallable() {
        return this.stub.deletePreviewCallable();
    }

    public final ExportPreviewResultResponse exportPreviewResult(ExportPreviewResultRequest request) {
        return (ExportPreviewResultResponse)this.exportPreviewResultCallable().call((Object)request);
    }

    public final UnaryCallable<ExportPreviewResultRequest, ExportPreviewResultResponse> exportPreviewResultCallable() {
        return this.stub.exportPreviewResultCallable();
    }

    public final ListTerraformVersionsPagedResponse listTerraformVersions(LocationName parent) {
        ListTerraformVersionsRequest request = ListTerraformVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTerraformVersions(request);
    }

    public final ListTerraformVersionsPagedResponse listTerraformVersions(String parent) {
        ListTerraformVersionsRequest request = ListTerraformVersionsRequest.newBuilder().setParent(parent).build();
        return this.listTerraformVersions(request);
    }

    public final ListTerraformVersionsPagedResponse listTerraformVersions(ListTerraformVersionsRequest request) {
        return (ListTerraformVersionsPagedResponse)((Object)this.listTerraformVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTerraformVersionsRequest, ListTerraformVersionsPagedResponse> listTerraformVersionsPagedCallable() {
        return this.stub.listTerraformVersionsPagedCallable();
    }

    public final UnaryCallable<ListTerraformVersionsRequest, ListTerraformVersionsResponse> listTerraformVersionsCallable() {
        return this.stub.listTerraformVersionsCallable();
    }

    public final TerraformVersion getTerraformVersion(TerraformVersionName name) {
        GetTerraformVersionRequest request = GetTerraformVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTerraformVersion(request);
    }

    public final TerraformVersion getTerraformVersion(String name) {
        GetTerraformVersionRequest request = GetTerraformVersionRequest.newBuilder().setName(name).build();
        return this.getTerraformVersion(request);
    }

    public final TerraformVersion getTerraformVersion(GetTerraformVersionRequest request) {
        return (TerraformVersion)this.getTerraformVersionCallable().call((Object)request);
    }

    public final UnaryCallable<GetTerraformVersionRequest, TerraformVersion> getTerraformVersionCallable() {
        return this.stub.getTerraformVersionCallable();
    }

    public final ListResourceChangesPagedResponse listResourceChanges(PreviewName parent) {
        ListResourceChangesRequest request = ListResourceChangesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listResourceChanges(request);
    }

    public final ListResourceChangesPagedResponse listResourceChanges(String parent) {
        ListResourceChangesRequest request = ListResourceChangesRequest.newBuilder().setParent(parent).build();
        return this.listResourceChanges(request);
    }

    public final ListResourceChangesPagedResponse listResourceChanges(ListResourceChangesRequest request) {
        return (ListResourceChangesPagedResponse)((Object)this.listResourceChangesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListResourceChangesRequest, ListResourceChangesPagedResponse> listResourceChangesPagedCallable() {
        return this.stub.listResourceChangesPagedCallable();
    }

    public final UnaryCallable<ListResourceChangesRequest, ListResourceChangesResponse> listResourceChangesCallable() {
        return this.stub.listResourceChangesCallable();
    }

    public final ResourceChange getResourceChange(ResourceChangeName name) {
        GetResourceChangeRequest request = GetResourceChangeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getResourceChange(request);
    }

    public final ResourceChange getResourceChange(String name) {
        GetResourceChangeRequest request = GetResourceChangeRequest.newBuilder().setName(name).build();
        return this.getResourceChange(request);
    }

    public final ResourceChange getResourceChange(GetResourceChangeRequest request) {
        return (ResourceChange)this.getResourceChangeCallable().call((Object)request);
    }

    public final UnaryCallable<GetResourceChangeRequest, ResourceChange> getResourceChangeCallable() {
        return this.stub.getResourceChangeCallable();
    }

    public final ListResourceDriftsPagedResponse listResourceDrifts(PreviewName parent) {
        ListResourceDriftsRequest request = ListResourceDriftsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listResourceDrifts(request);
    }

    public final ListResourceDriftsPagedResponse listResourceDrifts(String parent) {
        ListResourceDriftsRequest request = ListResourceDriftsRequest.newBuilder().setParent(parent).build();
        return this.listResourceDrifts(request);
    }

    public final ListResourceDriftsPagedResponse listResourceDrifts(ListResourceDriftsRequest request) {
        return (ListResourceDriftsPagedResponse)((Object)this.listResourceDriftsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListResourceDriftsRequest, ListResourceDriftsPagedResponse> listResourceDriftsPagedCallable() {
        return this.stub.listResourceDriftsPagedCallable();
    }

    public final UnaryCallable<ListResourceDriftsRequest, ListResourceDriftsResponse> listResourceDriftsCallable() {
        return this.stub.listResourceDriftsCallable();
    }

    public final ResourceDrift getResourceDrift(ResourceDriftName name) {
        GetResourceDriftRequest request = GetResourceDriftRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getResourceDrift(request);
    }

    public final ResourceDrift getResourceDrift(String name) {
        GetResourceDriftRequest request = GetResourceDriftRequest.newBuilder().setName(name).build();
        return this.getResourceDrift(request);
    }

    public final ResourceDrift getResourceDrift(GetResourceDriftRequest request) {
        return (ResourceDrift)this.getResourceDriftCallable().call((Object)request);
    }

    public final UnaryCallable<GetResourceDriftRequest, ResourceDrift> getResourceDriftCallable() {
        return this.stub.getResourceDriftCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListResourceDriftsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListResourceDriftsRequest, ListResourceDriftsResponse, ResourceDrift, ListResourceDriftsPage, ListResourceDriftsFixedSizeCollection> {
        private ListResourceDriftsFixedSizeCollection(List<ListResourceDriftsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListResourceDriftsFixedSizeCollection createEmptyCollection() {
            return new ListResourceDriftsFixedSizeCollection(null, 0);
        }

        protected ListResourceDriftsFixedSizeCollection createCollection(List<ListResourceDriftsPage> pages, int collectionSize) {
            return new ListResourceDriftsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListResourceDriftsPage
    extends AbstractPage<ListResourceDriftsRequest, ListResourceDriftsResponse, ResourceDrift, ListResourceDriftsPage> {
        private ListResourceDriftsPage(PageContext<ListResourceDriftsRequest, ListResourceDriftsResponse, ResourceDrift> context, ListResourceDriftsResponse response) {
            super(context, (Object)response);
        }

        private static ListResourceDriftsPage createEmptyPage() {
            return new ListResourceDriftsPage(null, null);
        }

        protected ListResourceDriftsPage createPage(PageContext<ListResourceDriftsRequest, ListResourceDriftsResponse, ResourceDrift> context, ListResourceDriftsResponse response) {
            return new ListResourceDriftsPage(context, response);
        }

        public ApiFuture<ListResourceDriftsPage> createPageAsync(PageContext<ListResourceDriftsRequest, ListResourceDriftsResponse, ResourceDrift> context, ApiFuture<ListResourceDriftsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListResourceDriftsPagedResponse
    extends AbstractPagedListResponse<ListResourceDriftsRequest, ListResourceDriftsResponse, ResourceDrift, ListResourceDriftsPage, ListResourceDriftsFixedSizeCollection> {
        public static ApiFuture<ListResourceDriftsPagedResponse> createAsync(PageContext<ListResourceDriftsRequest, ListResourceDriftsResponse, ResourceDrift> context, ApiFuture<ListResourceDriftsResponse> futureResponse) {
            ApiFuture<ListResourceDriftsPage> futurePage = ListResourceDriftsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListResourceDriftsPagedResponse((ListResourceDriftsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListResourceDriftsPagedResponse(ListResourceDriftsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListResourceDriftsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListResourceChangesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListResourceChangesRequest, ListResourceChangesResponse, ResourceChange, ListResourceChangesPage, ListResourceChangesFixedSizeCollection> {
        private ListResourceChangesFixedSizeCollection(List<ListResourceChangesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListResourceChangesFixedSizeCollection createEmptyCollection() {
            return new ListResourceChangesFixedSizeCollection(null, 0);
        }

        protected ListResourceChangesFixedSizeCollection createCollection(List<ListResourceChangesPage> pages, int collectionSize) {
            return new ListResourceChangesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListResourceChangesPage
    extends AbstractPage<ListResourceChangesRequest, ListResourceChangesResponse, ResourceChange, ListResourceChangesPage> {
        private ListResourceChangesPage(PageContext<ListResourceChangesRequest, ListResourceChangesResponse, ResourceChange> context, ListResourceChangesResponse response) {
            super(context, (Object)response);
        }

        private static ListResourceChangesPage createEmptyPage() {
            return new ListResourceChangesPage(null, null);
        }

        protected ListResourceChangesPage createPage(PageContext<ListResourceChangesRequest, ListResourceChangesResponse, ResourceChange> context, ListResourceChangesResponse response) {
            return new ListResourceChangesPage(context, response);
        }

        public ApiFuture<ListResourceChangesPage> createPageAsync(PageContext<ListResourceChangesRequest, ListResourceChangesResponse, ResourceChange> context, ApiFuture<ListResourceChangesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListResourceChangesPagedResponse
    extends AbstractPagedListResponse<ListResourceChangesRequest, ListResourceChangesResponse, ResourceChange, ListResourceChangesPage, ListResourceChangesFixedSizeCollection> {
        public static ApiFuture<ListResourceChangesPagedResponse> createAsync(PageContext<ListResourceChangesRequest, ListResourceChangesResponse, ResourceChange> context, ApiFuture<ListResourceChangesResponse> futureResponse) {
            ApiFuture<ListResourceChangesPage> futurePage = ListResourceChangesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListResourceChangesPagedResponse((ListResourceChangesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListResourceChangesPagedResponse(ListResourceChangesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListResourceChangesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTerraformVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTerraformVersionsRequest, ListTerraformVersionsResponse, TerraformVersion, ListTerraformVersionsPage, ListTerraformVersionsFixedSizeCollection> {
        private ListTerraformVersionsFixedSizeCollection(List<ListTerraformVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTerraformVersionsFixedSizeCollection createEmptyCollection() {
            return new ListTerraformVersionsFixedSizeCollection(null, 0);
        }

        protected ListTerraformVersionsFixedSizeCollection createCollection(List<ListTerraformVersionsPage> pages, int collectionSize) {
            return new ListTerraformVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTerraformVersionsPage
    extends AbstractPage<ListTerraformVersionsRequest, ListTerraformVersionsResponse, TerraformVersion, ListTerraformVersionsPage> {
        private ListTerraformVersionsPage(PageContext<ListTerraformVersionsRequest, ListTerraformVersionsResponse, TerraformVersion> context, ListTerraformVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListTerraformVersionsPage createEmptyPage() {
            return new ListTerraformVersionsPage(null, null);
        }

        protected ListTerraformVersionsPage createPage(PageContext<ListTerraformVersionsRequest, ListTerraformVersionsResponse, TerraformVersion> context, ListTerraformVersionsResponse response) {
            return new ListTerraformVersionsPage(context, response);
        }

        public ApiFuture<ListTerraformVersionsPage> createPageAsync(PageContext<ListTerraformVersionsRequest, ListTerraformVersionsResponse, TerraformVersion> context, ApiFuture<ListTerraformVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTerraformVersionsPagedResponse
    extends AbstractPagedListResponse<ListTerraformVersionsRequest, ListTerraformVersionsResponse, TerraformVersion, ListTerraformVersionsPage, ListTerraformVersionsFixedSizeCollection> {
        public static ApiFuture<ListTerraformVersionsPagedResponse> createAsync(PageContext<ListTerraformVersionsRequest, ListTerraformVersionsResponse, TerraformVersion> context, ApiFuture<ListTerraformVersionsResponse> futureResponse) {
            ApiFuture<ListTerraformVersionsPage> futurePage = ListTerraformVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTerraformVersionsPagedResponse((ListTerraformVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTerraformVersionsPagedResponse(ListTerraformVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTerraformVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPreviewsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPreviewsRequest, ListPreviewsResponse, Preview, ListPreviewsPage, ListPreviewsFixedSizeCollection> {
        private ListPreviewsFixedSizeCollection(List<ListPreviewsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPreviewsFixedSizeCollection createEmptyCollection() {
            return new ListPreviewsFixedSizeCollection(null, 0);
        }

        protected ListPreviewsFixedSizeCollection createCollection(List<ListPreviewsPage> pages, int collectionSize) {
            return new ListPreviewsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPreviewsPage
    extends AbstractPage<ListPreviewsRequest, ListPreviewsResponse, Preview, ListPreviewsPage> {
        private ListPreviewsPage(PageContext<ListPreviewsRequest, ListPreviewsResponse, Preview> context, ListPreviewsResponse response) {
            super(context, (Object)response);
        }

        private static ListPreviewsPage createEmptyPage() {
            return new ListPreviewsPage(null, null);
        }

        protected ListPreviewsPage createPage(PageContext<ListPreviewsRequest, ListPreviewsResponse, Preview> context, ListPreviewsResponse response) {
            return new ListPreviewsPage(context, response);
        }

        public ApiFuture<ListPreviewsPage> createPageAsync(PageContext<ListPreviewsRequest, ListPreviewsResponse, Preview> context, ApiFuture<ListPreviewsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPreviewsPagedResponse
    extends AbstractPagedListResponse<ListPreviewsRequest, ListPreviewsResponse, Preview, ListPreviewsPage, ListPreviewsFixedSizeCollection> {
        public static ApiFuture<ListPreviewsPagedResponse> createAsync(PageContext<ListPreviewsRequest, ListPreviewsResponse, Preview> context, ApiFuture<ListPreviewsResponse> futureResponse) {
            ApiFuture<ListPreviewsPage> futurePage = ListPreviewsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPreviewsPagedResponse((ListPreviewsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPreviewsPagedResponse(ListPreviewsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPreviewsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListResourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListResourcesRequest, ListResourcesResponse, Resource, ListResourcesPage, ListResourcesFixedSizeCollection> {
        private ListResourcesFixedSizeCollection(List<ListResourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListResourcesFixedSizeCollection createEmptyCollection() {
            return new ListResourcesFixedSizeCollection(null, 0);
        }

        protected ListResourcesFixedSizeCollection createCollection(List<ListResourcesPage> pages, int collectionSize) {
            return new ListResourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListResourcesPage
    extends AbstractPage<ListResourcesRequest, ListResourcesResponse, Resource, ListResourcesPage> {
        private ListResourcesPage(PageContext<ListResourcesRequest, ListResourcesResponse, Resource> context, ListResourcesResponse response) {
            super(context, (Object)response);
        }

        private static ListResourcesPage createEmptyPage() {
            return new ListResourcesPage(null, null);
        }

        protected ListResourcesPage createPage(PageContext<ListResourcesRequest, ListResourcesResponse, Resource> context, ListResourcesResponse response) {
            return new ListResourcesPage(context, response);
        }

        public ApiFuture<ListResourcesPage> createPageAsync(PageContext<ListResourcesRequest, ListResourcesResponse, Resource> context, ApiFuture<ListResourcesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListResourcesPagedResponse
    extends AbstractPagedListResponse<ListResourcesRequest, ListResourcesResponse, Resource, ListResourcesPage, ListResourcesFixedSizeCollection> {
        public static ApiFuture<ListResourcesPagedResponse> createAsync(PageContext<ListResourcesRequest, ListResourcesResponse, Resource> context, ApiFuture<ListResourcesResponse> futureResponse) {
            ApiFuture<ListResourcesPage> futurePage = ListResourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListResourcesPagedResponse((ListResourcesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListResourcesPagedResponse(ListResourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListResourcesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRevisionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRevisionsRequest, ListRevisionsResponse, Revision, ListRevisionsPage, ListRevisionsFixedSizeCollection> {
        private ListRevisionsFixedSizeCollection(List<ListRevisionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRevisionsFixedSizeCollection createEmptyCollection() {
            return new ListRevisionsFixedSizeCollection(null, 0);
        }

        protected ListRevisionsFixedSizeCollection createCollection(List<ListRevisionsPage> pages, int collectionSize) {
            return new ListRevisionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRevisionsPage
    extends AbstractPage<ListRevisionsRequest, ListRevisionsResponse, Revision, ListRevisionsPage> {
        private ListRevisionsPage(PageContext<ListRevisionsRequest, ListRevisionsResponse, Revision> context, ListRevisionsResponse response) {
            super(context, (Object)response);
        }

        private static ListRevisionsPage createEmptyPage() {
            return new ListRevisionsPage(null, null);
        }

        protected ListRevisionsPage createPage(PageContext<ListRevisionsRequest, ListRevisionsResponse, Revision> context, ListRevisionsResponse response) {
            return new ListRevisionsPage(context, response);
        }

        public ApiFuture<ListRevisionsPage> createPageAsync(PageContext<ListRevisionsRequest, ListRevisionsResponse, Revision> context, ApiFuture<ListRevisionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRevisionsPagedResponse
    extends AbstractPagedListResponse<ListRevisionsRequest, ListRevisionsResponse, Revision, ListRevisionsPage, ListRevisionsFixedSizeCollection> {
        public static ApiFuture<ListRevisionsPagedResponse> createAsync(PageContext<ListRevisionsRequest, ListRevisionsResponse, Revision> context, ApiFuture<ListRevisionsResponse> futureResponse) {
            ApiFuture<ListRevisionsPage> futurePage = ListRevisionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRevisionsPagedResponse((ListRevisionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRevisionsPagedResponse(ListRevisionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRevisionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDeploymentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDeploymentsRequest, ListDeploymentsResponse, Deployment, ListDeploymentsPage, ListDeploymentsFixedSizeCollection> {
        private ListDeploymentsFixedSizeCollection(List<ListDeploymentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDeploymentsFixedSizeCollection createEmptyCollection() {
            return new ListDeploymentsFixedSizeCollection(null, 0);
        }

        protected ListDeploymentsFixedSizeCollection createCollection(List<ListDeploymentsPage> pages, int collectionSize) {
            return new ListDeploymentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDeploymentsPage
    extends AbstractPage<ListDeploymentsRequest, ListDeploymentsResponse, Deployment, ListDeploymentsPage> {
        private ListDeploymentsPage(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ListDeploymentsResponse response) {
            super(context, (Object)response);
        }

        private static ListDeploymentsPage createEmptyPage() {
            return new ListDeploymentsPage(null, null);
        }

        protected ListDeploymentsPage createPage(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ListDeploymentsResponse response) {
            return new ListDeploymentsPage(context, response);
        }

        public ApiFuture<ListDeploymentsPage> createPageAsync(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ApiFuture<ListDeploymentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDeploymentsPagedResponse
    extends AbstractPagedListResponse<ListDeploymentsRequest, ListDeploymentsResponse, Deployment, ListDeploymentsPage, ListDeploymentsFixedSizeCollection> {
        public static ApiFuture<ListDeploymentsPagedResponse> createAsync(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ApiFuture<ListDeploymentsResponse> futureResponse) {
            ApiFuture<ListDeploymentsPage> futurePage = ListDeploymentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDeploymentsPagedResponse((ListDeploymentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDeploymentsPagedResponse(ListDeploymentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDeploymentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

