/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.config.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.config.v1.ConfigClient;
import com.google.cloud.config.v1.CreateDeploymentRequest;
import com.google.cloud.config.v1.CreatePreviewRequest;
import com.google.cloud.config.v1.DeleteDeploymentRequest;
import com.google.cloud.config.v1.DeletePreviewRequest;
import com.google.cloud.config.v1.DeleteStatefileRequest;
import com.google.cloud.config.v1.Deployment;
import com.google.cloud.config.v1.ExportDeploymentStatefileRequest;
import com.google.cloud.config.v1.ExportLockInfoRequest;
import com.google.cloud.config.v1.ExportPreviewResultRequest;
import com.google.cloud.config.v1.ExportPreviewResultResponse;
import com.google.cloud.config.v1.ExportRevisionStatefileRequest;
import com.google.cloud.config.v1.GetDeploymentRequest;
import com.google.cloud.config.v1.GetPreviewRequest;
import com.google.cloud.config.v1.GetResourceRequest;
import com.google.cloud.config.v1.GetRevisionRequest;
import com.google.cloud.config.v1.ImportStatefileRequest;
import com.google.cloud.config.v1.ListDeploymentsRequest;
import com.google.cloud.config.v1.ListDeploymentsResponse;
import com.google.cloud.config.v1.ListPreviewsRequest;
import com.google.cloud.config.v1.ListPreviewsResponse;
import com.google.cloud.config.v1.ListResourcesRequest;
import com.google.cloud.config.v1.ListResourcesResponse;
import com.google.cloud.config.v1.ListRevisionsRequest;
import com.google.cloud.config.v1.ListRevisionsResponse;
import com.google.cloud.config.v1.LockDeploymentRequest;
import com.google.cloud.config.v1.LockInfo;
import com.google.cloud.config.v1.OperationMetadata;
import com.google.cloud.config.v1.Preview;
import com.google.cloud.config.v1.Resource;
import com.google.cloud.config.v1.Revision;
import com.google.cloud.config.v1.Statefile;
import com.google.cloud.config.v1.UnlockDeploymentRequest;
import com.google.cloud.config.v1.UpdateDeploymentRequest;
import com.google.cloud.config.v1.stub.ConfigStub;
import com.google.cloud.config.v1.stub.ConfigStubSettings;
import com.google.cloud.config.v1.stub.HttpJsonConfigCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonConfigStub
extends ConfigStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Deployment.getDescriptor()).add(OperationMetadata.getDescriptor()).add(Preview.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListDeploymentsRequest, ListDeploymentsResponse> listDeploymentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/ListDeployments").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/deployments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListDeploymentsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetDeploymentRequest, Deployment> getDeploymentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/GetDeployment").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/deployments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Deployment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateDeploymentRequest, Operation> createDeploymentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/CreateDeployment").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/deployments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "deploymentId", (Object)request.getDeploymentId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("deployment", (Message)request.getDeployment(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateDeploymentRequest, Operation> updateDeploymentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/UpdateDeployment").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{deployment.name=projects/*/locations/*/deployments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "deployment.name", (Object)request.getDeployment().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("deployment", (Message)request.getDeployment(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteDeploymentRequest, Operation> deleteDeploymentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/DeleteDeployment").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/deployments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "deletePolicy", (Object)request.getDeletePolicyValue());
        serializer.putQueryParam(fields, "force", (Object)request.getForce());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListRevisionsRequest, ListRevisionsResponse> listRevisionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/ListRevisions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/deployments/*}/revisions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListRevisionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetRevisionRequest, Revision> getRevisionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/GetRevision").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/deployments/*/revisions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Revision.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetResourceRequest, Resource> getResourceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/GetResource").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/deployments/*/revisions/*/resources/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Resource.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListResourcesRequest, ListResourcesResponse> listResourcesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/ListResources").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/deployments/*/revisions/*}/resources", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListResourcesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ExportDeploymentStatefileRequest, Statefile> exportDeploymentStatefileMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/ExportDeploymentStatefile").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/deployments/*}:exportState", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Statefile.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ExportRevisionStatefileRequest, Statefile> exportRevisionStatefileMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/ExportRevisionStatefile").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/deployments/*/revisions/*}:exportState", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Statefile.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ImportStatefileRequest, Statefile> importStatefileMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/ImportStatefile").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/deployments/*}:importState", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Statefile.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteStatefileRequest, Empty> deleteStatefileMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/DeleteStatefile").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/deployments/*}:deleteState", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<LockDeploymentRequest, Operation> lockDeploymentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/LockDeployment").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/deployments/*}:lock", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UnlockDeploymentRequest, Operation> unlockDeploymentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/UnlockDeployment").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/deployments/*}:unlock", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ExportLockInfoRequest, LockInfo> exportLockInfoMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/ExportLockInfo").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/deployments/*}:exportLock", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)LockInfo.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreatePreviewRequest, Operation> createPreviewMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/CreatePreview").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/previews", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "previewId", (Object)request.getPreviewId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("preview", (Message)request.getPreview(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetPreviewRequest, Preview> getPreviewMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/GetPreview").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/previews/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Preview.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListPreviewsRequest, ListPreviewsResponse> listPreviewsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/ListPreviews").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/previews", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListPreviewsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeletePreviewRequest, Operation> deletePreviewMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/DeletePreview").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/previews/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ExportPreviewResultRequest, ExportPreviewResultResponse> exportPreviewResultMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.config.v1.Config/ExportPreviewResult").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/previews/*}:export", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ExportPreviewResultResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/locations/*/deployments/*}:setIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/locations/*/deployments/*}:getIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{resource=projects/*/locations/*/deployments/*}:testIamPermissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestIamPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListDeploymentsRequest, ListDeploymentsResponse> listDeploymentsCallable;
    private final UnaryCallable<ListDeploymentsRequest, ConfigClient.ListDeploymentsPagedResponse> listDeploymentsPagedCallable;
    private final UnaryCallable<GetDeploymentRequest, Deployment> getDeploymentCallable;
    private final UnaryCallable<CreateDeploymentRequest, Operation> createDeploymentCallable;
    private final OperationCallable<CreateDeploymentRequest, Deployment, OperationMetadata> createDeploymentOperationCallable;
    private final UnaryCallable<UpdateDeploymentRequest, Operation> updateDeploymentCallable;
    private final OperationCallable<UpdateDeploymentRequest, Deployment, OperationMetadata> updateDeploymentOperationCallable;
    private final UnaryCallable<DeleteDeploymentRequest, Operation> deleteDeploymentCallable;
    private final OperationCallable<DeleteDeploymentRequest, Deployment, OperationMetadata> deleteDeploymentOperationCallable;
    private final UnaryCallable<ListRevisionsRequest, ListRevisionsResponse> listRevisionsCallable;
    private final UnaryCallable<ListRevisionsRequest, ConfigClient.ListRevisionsPagedResponse> listRevisionsPagedCallable;
    private final UnaryCallable<GetRevisionRequest, Revision> getRevisionCallable;
    private final UnaryCallable<GetResourceRequest, Resource> getResourceCallable;
    private final UnaryCallable<ListResourcesRequest, ListResourcesResponse> listResourcesCallable;
    private final UnaryCallable<ListResourcesRequest, ConfigClient.ListResourcesPagedResponse> listResourcesPagedCallable;
    private final UnaryCallable<ExportDeploymentStatefileRequest, Statefile> exportDeploymentStatefileCallable;
    private final UnaryCallable<ExportRevisionStatefileRequest, Statefile> exportRevisionStatefileCallable;
    private final UnaryCallable<ImportStatefileRequest, Statefile> importStatefileCallable;
    private final UnaryCallable<DeleteStatefileRequest, Empty> deleteStatefileCallable;
    private final UnaryCallable<LockDeploymentRequest, Operation> lockDeploymentCallable;
    private final OperationCallable<LockDeploymentRequest, Deployment, OperationMetadata> lockDeploymentOperationCallable;
    private final UnaryCallable<UnlockDeploymentRequest, Operation> unlockDeploymentCallable;
    private final OperationCallable<UnlockDeploymentRequest, Deployment, OperationMetadata> unlockDeploymentOperationCallable;
    private final UnaryCallable<ExportLockInfoRequest, LockInfo> exportLockInfoCallable;
    private final UnaryCallable<CreatePreviewRequest, Operation> createPreviewCallable;
    private final OperationCallable<CreatePreviewRequest, Preview, OperationMetadata> createPreviewOperationCallable;
    private final UnaryCallable<GetPreviewRequest, Preview> getPreviewCallable;
    private final UnaryCallable<ListPreviewsRequest, ListPreviewsResponse> listPreviewsCallable;
    private final UnaryCallable<ListPreviewsRequest, ConfigClient.ListPreviewsPagedResponse> listPreviewsPagedCallable;
    private final UnaryCallable<DeletePreviewRequest, Operation> deletePreviewCallable;
    private final OperationCallable<DeletePreviewRequest, Preview, OperationMetadata> deletePreviewOperationCallable;
    private final UnaryCallable<ExportPreviewResultRequest, ExportPreviewResultResponse> exportPreviewResultCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ConfigClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonConfigStub create(ConfigStubSettings settings) throws IOException {
        return new HttpJsonConfigStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonConfigStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonConfigStub(ConfigStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonConfigStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonConfigStub(ConfigStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonConfigStub(ConfigStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonConfigCallableFactory());
    }

    protected HttpJsonConfigStub(ConfigStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=projects/*/locations/*/operations/*}:cancel").build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*}/operations").build()).build());
        HttpJsonCallSettings listDeploymentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listDeploymentsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getDeploymentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getDeploymentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createDeploymentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createDeploymentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateDeploymentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateDeploymentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("deployment.name", String.valueOf(request.getDeployment().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteDeploymentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteDeploymentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listRevisionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRevisionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getRevisionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRevisionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getResourceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getResourceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listResourcesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listResourcesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings exportDeploymentStatefileTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(exportDeploymentStatefileMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings exportRevisionStatefileTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(exportRevisionStatefileMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings importStatefileTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(importStatefileMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteStatefileTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteStatefileMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings lockDeploymentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(lockDeploymentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings unlockDeploymentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(unlockDeploymentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings exportLockInfoTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(exportLockInfoMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createPreviewTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createPreviewMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getPreviewTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getPreviewMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listPreviewsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listPreviewsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deletePreviewTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deletePreviewMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings exportPreviewResultTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(exportPreviewResultMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.listDeploymentsCallable = callableFactory.createUnaryCallable(listDeploymentsTransportSettings, settings.listDeploymentsSettings(), clientContext);
        this.listDeploymentsPagedCallable = callableFactory.createPagedCallable(listDeploymentsTransportSettings, settings.listDeploymentsSettings(), clientContext);
        this.getDeploymentCallable = callableFactory.createUnaryCallable(getDeploymentTransportSettings, settings.getDeploymentSettings(), clientContext);
        this.createDeploymentCallable = callableFactory.createUnaryCallable(createDeploymentTransportSettings, settings.createDeploymentSettings(), clientContext);
        this.createDeploymentOperationCallable = callableFactory.createOperationCallable(createDeploymentTransportSettings, settings.createDeploymentOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateDeploymentCallable = callableFactory.createUnaryCallable(updateDeploymentTransportSettings, settings.updateDeploymentSettings(), clientContext);
        this.updateDeploymentOperationCallable = callableFactory.createOperationCallable(updateDeploymentTransportSettings, settings.updateDeploymentOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteDeploymentCallable = callableFactory.createUnaryCallable(deleteDeploymentTransportSettings, settings.deleteDeploymentSettings(), clientContext);
        this.deleteDeploymentOperationCallable = callableFactory.createOperationCallable(deleteDeploymentTransportSettings, settings.deleteDeploymentOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listRevisionsCallable = callableFactory.createUnaryCallable(listRevisionsTransportSettings, settings.listRevisionsSettings(), clientContext);
        this.listRevisionsPagedCallable = callableFactory.createPagedCallable(listRevisionsTransportSettings, settings.listRevisionsSettings(), clientContext);
        this.getRevisionCallable = callableFactory.createUnaryCallable(getRevisionTransportSettings, settings.getRevisionSettings(), clientContext);
        this.getResourceCallable = callableFactory.createUnaryCallable(getResourceTransportSettings, settings.getResourceSettings(), clientContext);
        this.listResourcesCallable = callableFactory.createUnaryCallable(listResourcesTransportSettings, settings.listResourcesSettings(), clientContext);
        this.listResourcesPagedCallable = callableFactory.createPagedCallable(listResourcesTransportSettings, settings.listResourcesSettings(), clientContext);
        this.exportDeploymentStatefileCallable = callableFactory.createUnaryCallable(exportDeploymentStatefileTransportSettings, settings.exportDeploymentStatefileSettings(), clientContext);
        this.exportRevisionStatefileCallable = callableFactory.createUnaryCallable(exportRevisionStatefileTransportSettings, settings.exportRevisionStatefileSettings(), clientContext);
        this.importStatefileCallable = callableFactory.createUnaryCallable(importStatefileTransportSettings, settings.importStatefileSettings(), clientContext);
        this.deleteStatefileCallable = callableFactory.createUnaryCallable(deleteStatefileTransportSettings, settings.deleteStatefileSettings(), clientContext);
        this.lockDeploymentCallable = callableFactory.createUnaryCallable(lockDeploymentTransportSettings, settings.lockDeploymentSettings(), clientContext);
        this.lockDeploymentOperationCallable = callableFactory.createOperationCallable(lockDeploymentTransportSettings, settings.lockDeploymentOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.unlockDeploymentCallable = callableFactory.createUnaryCallable(unlockDeploymentTransportSettings, settings.unlockDeploymentSettings(), clientContext);
        this.unlockDeploymentOperationCallable = callableFactory.createOperationCallable(unlockDeploymentTransportSettings, settings.unlockDeploymentOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.exportLockInfoCallable = callableFactory.createUnaryCallable(exportLockInfoTransportSettings, settings.exportLockInfoSettings(), clientContext);
        this.createPreviewCallable = callableFactory.createUnaryCallable(createPreviewTransportSettings, settings.createPreviewSettings(), clientContext);
        this.createPreviewOperationCallable = callableFactory.createOperationCallable(createPreviewTransportSettings, settings.createPreviewOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getPreviewCallable = callableFactory.createUnaryCallable(getPreviewTransportSettings, settings.getPreviewSettings(), clientContext);
        this.listPreviewsCallable = callableFactory.createUnaryCallable(listPreviewsTransportSettings, settings.listPreviewsSettings(), clientContext);
        this.listPreviewsPagedCallable = callableFactory.createPagedCallable(listPreviewsTransportSettings, settings.listPreviewsSettings(), clientContext);
        this.deletePreviewCallable = callableFactory.createUnaryCallable(deletePreviewTransportSettings, settings.deletePreviewSettings(), clientContext);
        this.deletePreviewOperationCallable = callableFactory.createOperationCallable(deletePreviewTransportSettings, settings.deletePreviewOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.exportPreviewResultCallable = callableFactory.createUnaryCallable(exportPreviewResultTransportSettings, settings.exportPreviewResultSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listDeploymentsMethodDescriptor);
        methodDescriptors.add(getDeploymentMethodDescriptor);
        methodDescriptors.add(createDeploymentMethodDescriptor);
        methodDescriptors.add(updateDeploymentMethodDescriptor);
        methodDescriptors.add(deleteDeploymentMethodDescriptor);
        methodDescriptors.add(listRevisionsMethodDescriptor);
        methodDescriptors.add(getRevisionMethodDescriptor);
        methodDescriptors.add(getResourceMethodDescriptor);
        methodDescriptors.add(listResourcesMethodDescriptor);
        methodDescriptors.add(exportDeploymentStatefileMethodDescriptor);
        methodDescriptors.add(exportRevisionStatefileMethodDescriptor);
        methodDescriptors.add(importStatefileMethodDescriptor);
        methodDescriptors.add(deleteStatefileMethodDescriptor);
        methodDescriptors.add(lockDeploymentMethodDescriptor);
        methodDescriptors.add(unlockDeploymentMethodDescriptor);
        methodDescriptors.add(exportLockInfoMethodDescriptor);
        methodDescriptors.add(createPreviewMethodDescriptor);
        methodDescriptors.add(getPreviewMethodDescriptor);
        methodDescriptors.add(listPreviewsMethodDescriptor);
        methodDescriptors.add(deletePreviewMethodDescriptor);
        methodDescriptors.add(exportPreviewResultMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListDeploymentsRequest, ListDeploymentsResponse> listDeploymentsCallable() {
        return this.listDeploymentsCallable;
    }

    @Override
    public UnaryCallable<ListDeploymentsRequest, ConfigClient.ListDeploymentsPagedResponse> listDeploymentsPagedCallable() {
        return this.listDeploymentsPagedCallable;
    }

    @Override
    public UnaryCallable<GetDeploymentRequest, Deployment> getDeploymentCallable() {
        return this.getDeploymentCallable;
    }

    @Override
    public UnaryCallable<CreateDeploymentRequest, Operation> createDeploymentCallable() {
        return this.createDeploymentCallable;
    }

    @Override
    public OperationCallable<CreateDeploymentRequest, Deployment, OperationMetadata> createDeploymentOperationCallable() {
        return this.createDeploymentOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateDeploymentRequest, Operation> updateDeploymentCallable() {
        return this.updateDeploymentCallable;
    }

    @Override
    public OperationCallable<UpdateDeploymentRequest, Deployment, OperationMetadata> updateDeploymentOperationCallable() {
        return this.updateDeploymentOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteDeploymentRequest, Operation> deleteDeploymentCallable() {
        return this.deleteDeploymentCallable;
    }

    @Override
    public OperationCallable<DeleteDeploymentRequest, Deployment, OperationMetadata> deleteDeploymentOperationCallable() {
        return this.deleteDeploymentOperationCallable;
    }

    @Override
    public UnaryCallable<ListRevisionsRequest, ListRevisionsResponse> listRevisionsCallable() {
        return this.listRevisionsCallable;
    }

    @Override
    public UnaryCallable<ListRevisionsRequest, ConfigClient.ListRevisionsPagedResponse> listRevisionsPagedCallable() {
        return this.listRevisionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetRevisionRequest, Revision> getRevisionCallable() {
        return this.getRevisionCallable;
    }

    @Override
    public UnaryCallable<GetResourceRequest, Resource> getResourceCallable() {
        return this.getResourceCallable;
    }

    @Override
    public UnaryCallable<ListResourcesRequest, ListResourcesResponse> listResourcesCallable() {
        return this.listResourcesCallable;
    }

    @Override
    public UnaryCallable<ListResourcesRequest, ConfigClient.ListResourcesPagedResponse> listResourcesPagedCallable() {
        return this.listResourcesPagedCallable;
    }

    @Override
    public UnaryCallable<ExportDeploymentStatefileRequest, Statefile> exportDeploymentStatefileCallable() {
        return this.exportDeploymentStatefileCallable;
    }

    @Override
    public UnaryCallable<ExportRevisionStatefileRequest, Statefile> exportRevisionStatefileCallable() {
        return this.exportRevisionStatefileCallable;
    }

    @Override
    public UnaryCallable<ImportStatefileRequest, Statefile> importStatefileCallable() {
        return this.importStatefileCallable;
    }

    @Override
    public UnaryCallable<DeleteStatefileRequest, Empty> deleteStatefileCallable() {
        return this.deleteStatefileCallable;
    }

    @Override
    public UnaryCallable<LockDeploymentRequest, Operation> lockDeploymentCallable() {
        return this.lockDeploymentCallable;
    }

    @Override
    public OperationCallable<LockDeploymentRequest, Deployment, OperationMetadata> lockDeploymentOperationCallable() {
        return this.lockDeploymentOperationCallable;
    }

    @Override
    public UnaryCallable<UnlockDeploymentRequest, Operation> unlockDeploymentCallable() {
        return this.unlockDeploymentCallable;
    }

    @Override
    public OperationCallable<UnlockDeploymentRequest, Deployment, OperationMetadata> unlockDeploymentOperationCallable() {
        return this.unlockDeploymentOperationCallable;
    }

    @Override
    public UnaryCallable<ExportLockInfoRequest, LockInfo> exportLockInfoCallable() {
        return this.exportLockInfoCallable;
    }

    @Override
    public UnaryCallable<CreatePreviewRequest, Operation> createPreviewCallable() {
        return this.createPreviewCallable;
    }

    @Override
    public OperationCallable<CreatePreviewRequest, Preview, OperationMetadata> createPreviewOperationCallable() {
        return this.createPreviewOperationCallable;
    }

    @Override
    public UnaryCallable<GetPreviewRequest, Preview> getPreviewCallable() {
        return this.getPreviewCallable;
    }

    @Override
    public UnaryCallable<ListPreviewsRequest, ListPreviewsResponse> listPreviewsCallable() {
        return this.listPreviewsCallable;
    }

    @Override
    public UnaryCallable<ListPreviewsRequest, ConfigClient.ListPreviewsPagedResponse> listPreviewsPagedCallable() {
        return this.listPreviewsPagedCallable;
    }

    @Override
    public UnaryCallable<DeletePreviewRequest, Operation> deletePreviewCallable() {
        return this.deletePreviewCallable;
    }

    @Override
    public OperationCallable<DeletePreviewRequest, Preview, OperationMetadata> deletePreviewOperationCallable() {
        return this.deletePreviewOperationCallable;
    }

    @Override
    public UnaryCallable<ExportPreviewResultRequest, ExportPreviewResultResponse> exportPreviewResultCallable() {
        return this.exportPreviewResultCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ConfigClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

