/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.ids.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.ids.v1.CreateEndpointRequest;
import com.google.cloud.ids.v1.DeleteEndpointRequest;
import com.google.cloud.ids.v1.Endpoint;
import com.google.cloud.ids.v1.EndpointName;
import com.google.cloud.ids.v1.GetEndpointRequest;
import com.google.cloud.ids.v1.IDSSettings;
import com.google.cloud.ids.v1.ListEndpointsRequest;
import com.google.cloud.ids.v1.ListEndpointsResponse;
import com.google.cloud.ids.v1.LocationName;
import com.google.cloud.ids.v1.OperationMetadata;
import com.google.cloud.ids.v1.stub.IDSStub;
import com.google.cloud.ids.v1.stub.IDSStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class IDSClient
implements BackgroundResource {
    private final IDSSettings settings;
    private final IDSStub stub;
    private final OperationsClient operationsClient;

    public static final IDSClient create() throws IOException {
        return IDSClient.create(IDSSettings.newBuilder().build());
    }

    public static final IDSClient create(IDSSettings settings) throws IOException {
        return new IDSClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final IDSClient create(IDSStub stub) {
        return new IDSClient(stub);
    }

    protected IDSClient(IDSSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((IDSStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected IDSClient(IDSStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final IDSSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public IDSStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListEndpointsPagedResponse listEndpoints(LocationName parent) {
        ListEndpointsRequest request = ListEndpointsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEndpoints(request);
    }

    public final ListEndpointsPagedResponse listEndpoints(String parent) {
        ListEndpointsRequest request = ListEndpointsRequest.newBuilder().setParent(parent).build();
        return this.listEndpoints(request);
    }

    public final ListEndpointsPagedResponse listEndpoints(ListEndpointsRequest request) {
        return (ListEndpointsPagedResponse)((Object)this.listEndpointsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEndpointsRequest, ListEndpointsPagedResponse> listEndpointsPagedCallable() {
        return this.stub.listEndpointsPagedCallable();
    }

    public final UnaryCallable<ListEndpointsRequest, ListEndpointsResponse> listEndpointsCallable() {
        return this.stub.listEndpointsCallable();
    }

    public final Endpoint getEndpoint(EndpointName name) {
        GetEndpointRequest request = GetEndpointRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEndpoint(request);
    }

    public final Endpoint getEndpoint(String name) {
        GetEndpointRequest request = GetEndpointRequest.newBuilder().setName(name).build();
        return this.getEndpoint(request);
    }

    public final Endpoint getEndpoint(GetEndpointRequest request) {
        return (Endpoint)this.getEndpointCallable().call((Object)request);
    }

    public final UnaryCallable<GetEndpointRequest, Endpoint> getEndpointCallable() {
        return this.stub.getEndpointCallable();
    }

    public final OperationFuture<Endpoint, OperationMetadata> createEndpointAsync(LocationName parent, Endpoint endpoint, String endpointId) {
        CreateEndpointRequest request = CreateEndpointRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEndpoint(endpoint).setEndpointId(endpointId).build();
        return this.createEndpointAsync(request);
    }

    public final OperationFuture<Endpoint, OperationMetadata> createEndpointAsync(String parent, Endpoint endpoint, String endpointId) {
        CreateEndpointRequest request = CreateEndpointRequest.newBuilder().setParent(parent).setEndpoint(endpoint).setEndpointId(endpointId).build();
        return this.createEndpointAsync(request);
    }

    public final OperationFuture<Endpoint, OperationMetadata> createEndpointAsync(CreateEndpointRequest request) {
        return this.createEndpointOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEndpointRequest, Endpoint, OperationMetadata> createEndpointOperationCallable() {
        return this.stub.createEndpointOperationCallable();
    }

    public final UnaryCallable<CreateEndpointRequest, Operation> createEndpointCallable() {
        return this.stub.createEndpointCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEndpointAsync(EndpointName name) {
        DeleteEndpointRequest request = DeleteEndpointRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteEndpointAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEndpointAsync(String name) {
        DeleteEndpointRequest request = DeleteEndpointRequest.newBuilder().setName(name).build();
        return this.deleteEndpointAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEndpointAsync(DeleteEndpointRequest request) {
        return this.deleteEndpointOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteEndpointRequest, Empty, OperationMetadata> deleteEndpointOperationCallable() {
        return this.stub.deleteEndpointOperationCallable();
    }

    public final UnaryCallable<DeleteEndpointRequest, Operation> deleteEndpointCallable() {
        return this.stub.deleteEndpointCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListEndpointsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEndpointsRequest, ListEndpointsResponse, Endpoint, ListEndpointsPage, ListEndpointsFixedSizeCollection> {
        private ListEndpointsFixedSizeCollection(List<ListEndpointsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEndpointsFixedSizeCollection createEmptyCollection() {
            return new ListEndpointsFixedSizeCollection(null, 0);
        }

        protected ListEndpointsFixedSizeCollection createCollection(List<ListEndpointsPage> pages, int collectionSize) {
            return new ListEndpointsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEndpointsPage
    extends AbstractPage<ListEndpointsRequest, ListEndpointsResponse, Endpoint, ListEndpointsPage> {
        private ListEndpointsPage(PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint> context, ListEndpointsResponse response) {
            super(context, (Object)response);
        }

        private static ListEndpointsPage createEmptyPage() {
            return new ListEndpointsPage(null, null);
        }

        protected ListEndpointsPage createPage(PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint> context, ListEndpointsResponse response) {
            return new ListEndpointsPage(context, response);
        }

        public ApiFuture<ListEndpointsPage> createPageAsync(PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint> context, ApiFuture<ListEndpointsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEndpointsPagedResponse
    extends AbstractPagedListResponse<ListEndpointsRequest, ListEndpointsResponse, Endpoint, ListEndpointsPage, ListEndpointsFixedSizeCollection> {
        public static ApiFuture<ListEndpointsPagedResponse> createAsync(PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint> context, ApiFuture<ListEndpointsResponse> futureResponse) {
            ApiFuture<ListEndpointsPage> futurePage = ListEndpointsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEndpointsPagedResponse((ListEndpointsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEndpointsPagedResponse(ListEndpointsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEndpointsFixedSizeCollection.createEmptyCollection());
        }
    }
}

