/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gsuiteaddons.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gsuiteaddons.v1.Authorization;
import com.google.cloud.gsuiteaddons.v1.AuthorizationName;
import com.google.cloud.gsuiteaddons.v1.CreateDeploymentRequest;
import com.google.cloud.gsuiteaddons.v1.DeleteDeploymentRequest;
import com.google.cloud.gsuiteaddons.v1.Deployment;
import com.google.cloud.gsuiteaddons.v1.DeploymentName;
import com.google.cloud.gsuiteaddons.v1.GSuiteAddOnsSettings;
import com.google.cloud.gsuiteaddons.v1.GetAuthorizationRequest;
import com.google.cloud.gsuiteaddons.v1.GetDeploymentRequest;
import com.google.cloud.gsuiteaddons.v1.GetInstallStatusRequest;
import com.google.cloud.gsuiteaddons.v1.InstallDeploymentRequest;
import com.google.cloud.gsuiteaddons.v1.InstallStatus;
import com.google.cloud.gsuiteaddons.v1.InstallStatusName;
import com.google.cloud.gsuiteaddons.v1.ListDeploymentsRequest;
import com.google.cloud.gsuiteaddons.v1.ListDeploymentsResponse;
import com.google.cloud.gsuiteaddons.v1.ProjectName;
import com.google.cloud.gsuiteaddons.v1.ReplaceDeploymentRequest;
import com.google.cloud.gsuiteaddons.v1.UninstallDeploymentRequest;
import com.google.cloud.gsuiteaddons.v1.stub.GSuiteAddOnsStub;
import com.google.cloud.gsuiteaddons.v1.stub.GSuiteAddOnsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class GSuiteAddOnsClient
implements BackgroundResource {
    private final GSuiteAddOnsSettings settings;
    private final GSuiteAddOnsStub stub;

    public static final GSuiteAddOnsClient create() throws IOException {
        return GSuiteAddOnsClient.create(GSuiteAddOnsSettings.newBuilder().build());
    }

    public static final GSuiteAddOnsClient create(GSuiteAddOnsSettings settings) throws IOException {
        return new GSuiteAddOnsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GSuiteAddOnsClient create(GSuiteAddOnsStub stub) {
        return new GSuiteAddOnsClient(stub);
    }

    protected GSuiteAddOnsClient(GSuiteAddOnsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GSuiteAddOnsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GSuiteAddOnsClient(GSuiteAddOnsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GSuiteAddOnsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GSuiteAddOnsStub getStub() {
        return this.stub;
    }

    public final Authorization getAuthorization(AuthorizationName name) {
        GetAuthorizationRequest request = GetAuthorizationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAuthorization(request);
    }

    public final Authorization getAuthorization(String name) {
        GetAuthorizationRequest request = GetAuthorizationRequest.newBuilder().setName(name).build();
        return this.getAuthorization(request);
    }

    public final Authorization getAuthorization(GetAuthorizationRequest request) {
        return (Authorization)this.getAuthorizationCallable().call((Object)request);
    }

    public final UnaryCallable<GetAuthorizationRequest, Authorization> getAuthorizationCallable() {
        return this.stub.getAuthorizationCallable();
    }

    public final Deployment createDeployment(ProjectName parent, Deployment deployment, String deploymentId) {
        CreateDeploymentRequest request = CreateDeploymentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDeployment(deployment).setDeploymentId(deploymentId).build();
        return this.createDeployment(request);
    }

    public final Deployment createDeployment(String parent, Deployment deployment, String deploymentId) {
        CreateDeploymentRequest request = CreateDeploymentRequest.newBuilder().setParent(parent).setDeployment(deployment).setDeploymentId(deploymentId).build();
        return this.createDeployment(request);
    }

    public final Deployment createDeployment(CreateDeploymentRequest request) {
        return (Deployment)this.createDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDeploymentRequest, Deployment> createDeploymentCallable() {
        return this.stub.createDeploymentCallable();
    }

    public final Deployment replaceDeployment(Deployment deployment) {
        ReplaceDeploymentRequest request = ReplaceDeploymentRequest.newBuilder().setDeployment(deployment).build();
        return this.replaceDeployment(request);
    }

    public final Deployment replaceDeployment(ReplaceDeploymentRequest request) {
        return (Deployment)this.replaceDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<ReplaceDeploymentRequest, Deployment> replaceDeploymentCallable() {
        return this.stub.replaceDeploymentCallable();
    }

    public final Deployment getDeployment(DeploymentName name) {
        GetDeploymentRequest request = GetDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDeployment(request);
    }

    public final Deployment getDeployment(String name) {
        GetDeploymentRequest request = GetDeploymentRequest.newBuilder().setName(name).build();
        return this.getDeployment(request);
    }

    public final Deployment getDeployment(GetDeploymentRequest request) {
        return (Deployment)this.getDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<GetDeploymentRequest, Deployment> getDeploymentCallable() {
        return this.stub.getDeploymentCallable();
    }

    public final ListDeploymentsPagedResponse listDeployments(ProjectName parent) {
        ListDeploymentsRequest request = ListDeploymentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDeployments(request);
    }

    public final ListDeploymentsPagedResponse listDeployments(String parent) {
        ListDeploymentsRequest request = ListDeploymentsRequest.newBuilder().setParent(parent).build();
        return this.listDeployments(request);
    }

    public final ListDeploymentsPagedResponse listDeployments(ListDeploymentsRequest request) {
        return (ListDeploymentsPagedResponse)((Object)this.listDeploymentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDeploymentsRequest, ListDeploymentsPagedResponse> listDeploymentsPagedCallable() {
        return this.stub.listDeploymentsPagedCallable();
    }

    public final UnaryCallable<ListDeploymentsRequest, ListDeploymentsResponse> listDeploymentsCallable() {
        return this.stub.listDeploymentsCallable();
    }

    public final void deleteDeployment(DeploymentName name) {
        DeleteDeploymentRequest request = DeleteDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDeployment(request);
    }

    public final void deleteDeployment(String name) {
        DeleteDeploymentRequest request = DeleteDeploymentRequest.newBuilder().setName(name).build();
        this.deleteDeployment(request);
    }

    public final void deleteDeployment(DeleteDeploymentRequest request) {
        this.deleteDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDeploymentRequest, Empty> deleteDeploymentCallable() {
        return this.stub.deleteDeploymentCallable();
    }

    public final void installDeployment(DeploymentName name) {
        InstallDeploymentRequest request = InstallDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.installDeployment(request);
    }

    public final void installDeployment(String name) {
        InstallDeploymentRequest request = InstallDeploymentRequest.newBuilder().setName(name).build();
        this.installDeployment(request);
    }

    public final void installDeployment(InstallDeploymentRequest request) {
        this.installDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<InstallDeploymentRequest, Empty> installDeploymentCallable() {
        return this.stub.installDeploymentCallable();
    }

    public final void uninstallDeployment(DeploymentName name) {
        UninstallDeploymentRequest request = UninstallDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.uninstallDeployment(request);
    }

    public final void uninstallDeployment(String name) {
        UninstallDeploymentRequest request = UninstallDeploymentRequest.newBuilder().setName(name).build();
        this.uninstallDeployment(request);
    }

    public final void uninstallDeployment(UninstallDeploymentRequest request) {
        this.uninstallDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<UninstallDeploymentRequest, Empty> uninstallDeploymentCallable() {
        return this.stub.uninstallDeploymentCallable();
    }

    public final InstallStatus getInstallStatus(InstallStatusName name) {
        GetInstallStatusRequest request = GetInstallStatusRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstallStatus(request);
    }

    public final InstallStatus getInstallStatus(String name) {
        GetInstallStatusRequest request = GetInstallStatusRequest.newBuilder().setName(name).build();
        return this.getInstallStatus(request);
    }

    public final InstallStatus getInstallStatus(GetInstallStatusRequest request) {
        return (InstallStatus)this.getInstallStatusCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstallStatusRequest, InstallStatus> getInstallStatusCallable() {
        return this.stub.getInstallStatusCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDeploymentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDeploymentsRequest, ListDeploymentsResponse, Deployment, ListDeploymentsPage, ListDeploymentsFixedSizeCollection> {
        private ListDeploymentsFixedSizeCollection(List<ListDeploymentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDeploymentsFixedSizeCollection createEmptyCollection() {
            return new ListDeploymentsFixedSizeCollection(null, 0);
        }

        protected ListDeploymentsFixedSizeCollection createCollection(List<ListDeploymentsPage> pages, int collectionSize) {
            return new ListDeploymentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDeploymentsPage
    extends AbstractPage<ListDeploymentsRequest, ListDeploymentsResponse, Deployment, ListDeploymentsPage> {
        private ListDeploymentsPage(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ListDeploymentsResponse response) {
            super(context, (Object)response);
        }

        private static ListDeploymentsPage createEmptyPage() {
            return new ListDeploymentsPage(null, null);
        }

        protected ListDeploymentsPage createPage(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ListDeploymentsResponse response) {
            return new ListDeploymentsPage(context, response);
        }

        public ApiFuture<ListDeploymentsPage> createPageAsync(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ApiFuture<ListDeploymentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDeploymentsPagedResponse
    extends AbstractPagedListResponse<ListDeploymentsRequest, ListDeploymentsResponse, Deployment, ListDeploymentsPage, ListDeploymentsFixedSizeCollection> {
        public static ApiFuture<ListDeploymentsPagedResponse> createAsync(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ApiFuture<ListDeploymentsResponse> futureResponse) {
            ApiFuture<ListDeploymentsPage> futurePage = ListDeploymentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDeploymentsPagedResponse((ListDeploymentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDeploymentsPagedResponse(ListDeploymentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDeploymentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

