/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkerecommender.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gkerecommender.v1.FetchBenchmarkingDataRequest;
import com.google.cloud.gkerecommender.v1.FetchBenchmarkingDataResponse;
import com.google.cloud.gkerecommender.v1.FetchModelServerVersionsRequest;
import com.google.cloud.gkerecommender.v1.FetchModelServerVersionsResponse;
import com.google.cloud.gkerecommender.v1.FetchModelServersRequest;
import com.google.cloud.gkerecommender.v1.FetchModelServersResponse;
import com.google.cloud.gkerecommender.v1.FetchModelsRequest;
import com.google.cloud.gkerecommender.v1.FetchModelsResponse;
import com.google.cloud.gkerecommender.v1.FetchProfilesRequest;
import com.google.cloud.gkerecommender.v1.FetchProfilesResponse;
import com.google.cloud.gkerecommender.v1.GenerateOptimizedManifestRequest;
import com.google.cloud.gkerecommender.v1.GenerateOptimizedManifestResponse;
import com.google.cloud.gkerecommender.v1.GkeInferenceQuickstartClient;
import com.google.cloud.gkerecommender.v1.Profile;
import com.google.cloud.gkerecommender.v1.stub.GkeInferenceQuickstartStub;
import com.google.cloud.gkerecommender.v1.stub.GrpcGkeInferenceQuickstartStub;
import com.google.cloud.gkerecommender.v1.stub.HttpJsonGkeInferenceQuickstartStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class GkeInferenceQuickstartStubSettings
extends StubSettings<GkeInferenceQuickstartStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<FetchModelsRequest, FetchModelsResponse, GkeInferenceQuickstartClient.FetchModelsPagedResponse> fetchModelsSettings;
    private final PagedCallSettings<FetchModelServersRequest, FetchModelServersResponse, GkeInferenceQuickstartClient.FetchModelServersPagedResponse> fetchModelServersSettings;
    private final PagedCallSettings<FetchModelServerVersionsRequest, FetchModelServerVersionsResponse, GkeInferenceQuickstartClient.FetchModelServerVersionsPagedResponse> fetchModelServerVersionsSettings;
    private final PagedCallSettings<FetchProfilesRequest, FetchProfilesResponse, GkeInferenceQuickstartClient.FetchProfilesPagedResponse> fetchProfilesSettings;
    private final UnaryCallSettings<GenerateOptimizedManifestRequest, GenerateOptimizedManifestResponse> generateOptimizedManifestSettings;
    private final UnaryCallSettings<FetchBenchmarkingDataRequest, FetchBenchmarkingDataResponse> fetchBenchmarkingDataSettings;
    private static final PagedListDescriptor<FetchModelsRequest, FetchModelsResponse, String> FETCH_MODELS_PAGE_STR_DESC = new PagedListDescriptor<FetchModelsRequest, FetchModelsResponse, String>(){

        public String emptyToken() {
            return "";
        }

        public FetchModelsRequest injectToken(FetchModelsRequest payload, String token) {
            return FetchModelsRequest.newBuilder((FetchModelsRequest)payload).setPageToken(token).build();
        }

        public FetchModelsRequest injectPageSize(FetchModelsRequest payload, int pageSize) {
            return FetchModelsRequest.newBuilder((FetchModelsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(FetchModelsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(FetchModelsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<String> extractResources(FetchModelsResponse payload) {
            return payload.getModelsList();
        }
    };
    private static final PagedListDescriptor<FetchModelServersRequest, FetchModelServersResponse, String> FETCH_MODEL_SERVERS_PAGE_STR_DESC = new PagedListDescriptor<FetchModelServersRequest, FetchModelServersResponse, String>(){

        public String emptyToken() {
            return "";
        }

        public FetchModelServersRequest injectToken(FetchModelServersRequest payload, String token) {
            return FetchModelServersRequest.newBuilder((FetchModelServersRequest)payload).setPageToken(token).build();
        }

        public FetchModelServersRequest injectPageSize(FetchModelServersRequest payload, int pageSize) {
            return FetchModelServersRequest.newBuilder((FetchModelServersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(FetchModelServersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(FetchModelServersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<String> extractResources(FetchModelServersResponse payload) {
            return payload.getModelServersList();
        }
    };
    private static final PagedListDescriptor<FetchModelServerVersionsRequest, FetchModelServerVersionsResponse, String> FETCH_MODEL_SERVER_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<FetchModelServerVersionsRequest, FetchModelServerVersionsResponse, String>(){

        public String emptyToken() {
            return "";
        }

        public FetchModelServerVersionsRequest injectToken(FetchModelServerVersionsRequest payload, String token) {
            return FetchModelServerVersionsRequest.newBuilder((FetchModelServerVersionsRequest)payload).setPageToken(token).build();
        }

        public FetchModelServerVersionsRequest injectPageSize(FetchModelServerVersionsRequest payload, int pageSize) {
            return FetchModelServerVersionsRequest.newBuilder((FetchModelServerVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(FetchModelServerVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(FetchModelServerVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<String> extractResources(FetchModelServerVersionsResponse payload) {
            return payload.getModelServerVersionsList();
        }
    };
    private static final PagedListDescriptor<FetchProfilesRequest, FetchProfilesResponse, Profile> FETCH_PROFILES_PAGE_STR_DESC = new PagedListDescriptor<FetchProfilesRequest, FetchProfilesResponse, Profile>(){

        public String emptyToken() {
            return "";
        }

        public FetchProfilesRequest injectToken(FetchProfilesRequest payload, String token) {
            return FetchProfilesRequest.newBuilder((FetchProfilesRequest)payload).setPageToken(token).build();
        }

        public FetchProfilesRequest injectPageSize(FetchProfilesRequest payload, int pageSize) {
            return FetchProfilesRequest.newBuilder((FetchProfilesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(FetchProfilesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(FetchProfilesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Profile> extractResources(FetchProfilesResponse payload) {
            return payload.getProfileList();
        }
    };
    private static final PagedListResponseFactory<FetchModelsRequest, FetchModelsResponse, GkeInferenceQuickstartClient.FetchModelsPagedResponse> FETCH_MODELS_PAGE_STR_FACT = new PagedListResponseFactory<FetchModelsRequest, FetchModelsResponse, GkeInferenceQuickstartClient.FetchModelsPagedResponse>(){

        public ApiFuture<GkeInferenceQuickstartClient.FetchModelsPagedResponse> getFuturePagedResponse(UnaryCallable<FetchModelsRequest, FetchModelsResponse> callable, FetchModelsRequest request, ApiCallContext context, ApiFuture<FetchModelsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)FETCH_MODELS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GkeInferenceQuickstartClient.FetchModelsPagedResponse.createAsync((PageContext<FetchModelsRequest, FetchModelsResponse, String>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<FetchModelServersRequest, FetchModelServersResponse, GkeInferenceQuickstartClient.FetchModelServersPagedResponse> FETCH_MODEL_SERVERS_PAGE_STR_FACT = new PagedListResponseFactory<FetchModelServersRequest, FetchModelServersResponse, GkeInferenceQuickstartClient.FetchModelServersPagedResponse>(){

        public ApiFuture<GkeInferenceQuickstartClient.FetchModelServersPagedResponse> getFuturePagedResponse(UnaryCallable<FetchModelServersRequest, FetchModelServersResponse> callable, FetchModelServersRequest request, ApiCallContext context, ApiFuture<FetchModelServersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)FETCH_MODEL_SERVERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GkeInferenceQuickstartClient.FetchModelServersPagedResponse.createAsync((PageContext<FetchModelServersRequest, FetchModelServersResponse, String>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<FetchModelServerVersionsRequest, FetchModelServerVersionsResponse, GkeInferenceQuickstartClient.FetchModelServerVersionsPagedResponse> FETCH_MODEL_SERVER_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<FetchModelServerVersionsRequest, FetchModelServerVersionsResponse, GkeInferenceQuickstartClient.FetchModelServerVersionsPagedResponse>(){

        public ApiFuture<GkeInferenceQuickstartClient.FetchModelServerVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<FetchModelServerVersionsRequest, FetchModelServerVersionsResponse> callable, FetchModelServerVersionsRequest request, ApiCallContext context, ApiFuture<FetchModelServerVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)FETCH_MODEL_SERVER_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GkeInferenceQuickstartClient.FetchModelServerVersionsPagedResponse.createAsync((PageContext<FetchModelServerVersionsRequest, FetchModelServerVersionsResponse, String>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<FetchProfilesRequest, FetchProfilesResponse, GkeInferenceQuickstartClient.FetchProfilesPagedResponse> FETCH_PROFILES_PAGE_STR_FACT = new PagedListResponseFactory<FetchProfilesRequest, FetchProfilesResponse, GkeInferenceQuickstartClient.FetchProfilesPagedResponse>(){

        public ApiFuture<GkeInferenceQuickstartClient.FetchProfilesPagedResponse> getFuturePagedResponse(UnaryCallable<FetchProfilesRequest, FetchProfilesResponse> callable, FetchProfilesRequest request, ApiCallContext context, ApiFuture<FetchProfilesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)FETCH_PROFILES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GkeInferenceQuickstartClient.FetchProfilesPagedResponse.createAsync((PageContext<FetchProfilesRequest, FetchProfilesResponse, Profile>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<FetchModelsRequest, FetchModelsResponse, GkeInferenceQuickstartClient.FetchModelsPagedResponse> fetchModelsSettings() {
        return this.fetchModelsSettings;
    }

    public PagedCallSettings<FetchModelServersRequest, FetchModelServersResponse, GkeInferenceQuickstartClient.FetchModelServersPagedResponse> fetchModelServersSettings() {
        return this.fetchModelServersSettings;
    }

    public PagedCallSettings<FetchModelServerVersionsRequest, FetchModelServerVersionsResponse, GkeInferenceQuickstartClient.FetchModelServerVersionsPagedResponse> fetchModelServerVersionsSettings() {
        return this.fetchModelServerVersionsSettings;
    }

    public PagedCallSettings<FetchProfilesRequest, FetchProfilesResponse, GkeInferenceQuickstartClient.FetchProfilesPagedResponse> fetchProfilesSettings() {
        return this.fetchProfilesSettings;
    }

    public UnaryCallSettings<GenerateOptimizedManifestRequest, GenerateOptimizedManifestResponse> generateOptimizedManifestSettings() {
        return this.generateOptimizedManifestSettings;
    }

    public UnaryCallSettings<FetchBenchmarkingDataRequest, FetchBenchmarkingDataResponse> fetchBenchmarkingDataSettings() {
        return this.fetchBenchmarkingDataSettings;
    }

    public GkeInferenceQuickstartStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcGkeInferenceQuickstartStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonGkeInferenceQuickstartStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "gkerecommender";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "gkerecommender.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "gkerecommender.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GkeInferenceQuickstartStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GkeInferenceQuickstartStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GkeInferenceQuickstartStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return GkeInferenceQuickstartStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GkeInferenceQuickstartStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.fetchModelsSettings = settingsBuilder.fetchModelsSettings().build();
        this.fetchModelServersSettings = settingsBuilder.fetchModelServersSettings().build();
        this.fetchModelServerVersionsSettings = settingsBuilder.fetchModelServerVersionsSettings().build();
        this.fetchProfilesSettings = settingsBuilder.fetchProfilesSettings().build();
        this.generateOptimizedManifestSettings = settingsBuilder.generateOptimizedManifestSettings().build();
        this.fetchBenchmarkingDataSettings = settingsBuilder.fetchBenchmarkingDataSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GkeInferenceQuickstartStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<FetchModelsRequest, FetchModelsResponse, GkeInferenceQuickstartClient.FetchModelsPagedResponse> fetchModelsSettings;
        private final PagedCallSettings.Builder<FetchModelServersRequest, FetchModelServersResponse, GkeInferenceQuickstartClient.FetchModelServersPagedResponse> fetchModelServersSettings;
        private final PagedCallSettings.Builder<FetchModelServerVersionsRequest, FetchModelServerVersionsResponse, GkeInferenceQuickstartClient.FetchModelServerVersionsPagedResponse> fetchModelServerVersionsSettings;
        private final PagedCallSettings.Builder<FetchProfilesRequest, FetchProfilesResponse, GkeInferenceQuickstartClient.FetchProfilesPagedResponse> fetchProfilesSettings;
        private final UnaryCallSettings.Builder<GenerateOptimizedManifestRequest, GenerateOptimizedManifestResponse> generateOptimizedManifestSettings;
        private final UnaryCallSettings.Builder<FetchBenchmarkingDataRequest, FetchBenchmarkingDataResponse> fetchBenchmarkingDataSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.fetchModelsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)FETCH_MODELS_PAGE_STR_FACT);
            this.fetchModelServersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)FETCH_MODEL_SERVERS_PAGE_STR_FACT);
            this.fetchModelServerVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)FETCH_MODEL_SERVER_VERSIONS_PAGE_STR_FACT);
            this.fetchProfilesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)FETCH_PROFILES_PAGE_STR_FACT);
            this.generateOptimizedManifestSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.fetchBenchmarkingDataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.fetchModelsSettings, this.fetchModelServersSettings, this.fetchModelServerVersionsSettings, this.fetchProfilesSettings, this.generateOptimizedManifestSettings, this.fetchBenchmarkingDataSettings);
            Builder.initDefaults(this);
        }

        protected Builder(GkeInferenceQuickstartStubSettings settings) {
            super((StubSettings)settings);
            this.fetchModelsSettings = settings.fetchModelsSettings.toBuilder();
            this.fetchModelServersSettings = settings.fetchModelServersSettings.toBuilder();
            this.fetchModelServerVersionsSettings = settings.fetchModelServerVersionsSettings.toBuilder();
            this.fetchProfilesSettings = settings.fetchProfilesSettings.toBuilder();
            this.generateOptimizedManifestSettings = settings.generateOptimizedManifestSettings.toBuilder();
            this.fetchBenchmarkingDataSettings = settings.fetchBenchmarkingDataSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.fetchModelsSettings, this.fetchModelServersSettings, this.fetchModelServerVersionsSettings, this.fetchProfilesSettings, this.generateOptimizedManifestSettings, this.fetchBenchmarkingDataSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GkeInferenceQuickstartStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GkeInferenceQuickstartStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GkeInferenceQuickstartStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(GkeInferenceQuickstartStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)GkeInferenceQuickstartStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)GkeInferenceQuickstartStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GkeInferenceQuickstartStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(GkeInferenceQuickstartStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.fetchModelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.fetchModelServersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.fetchModelServerVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.fetchProfilesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.generateOptimizedManifestSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.fetchBenchmarkingDataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<FetchModelsRequest, FetchModelsResponse, GkeInferenceQuickstartClient.FetchModelsPagedResponse> fetchModelsSettings() {
            return this.fetchModelsSettings;
        }

        public PagedCallSettings.Builder<FetchModelServersRequest, FetchModelServersResponse, GkeInferenceQuickstartClient.FetchModelServersPagedResponse> fetchModelServersSettings() {
            return this.fetchModelServersSettings;
        }

        public PagedCallSettings.Builder<FetchModelServerVersionsRequest, FetchModelServerVersionsResponse, GkeInferenceQuickstartClient.FetchModelServerVersionsPagedResponse> fetchModelServerVersionsSettings() {
            return this.fetchModelServerVersionsSettings;
        }

        public PagedCallSettings.Builder<FetchProfilesRequest, FetchProfilesResponse, GkeInferenceQuickstartClient.FetchProfilesPagedResponse> fetchProfilesSettings() {
            return this.fetchProfilesSettings;
        }

        public UnaryCallSettings.Builder<GenerateOptimizedManifestRequest, GenerateOptimizedManifestResponse> generateOptimizedManifestSettings() {
            return this.generateOptimizedManifestSettings;
        }

        public UnaryCallSettings.Builder<FetchBenchmarkingDataRequest, FetchBenchmarkingDataResponse> fetchBenchmarkingDataSettings() {
            return this.fetchBenchmarkingDataSettings;
        }

        public GkeInferenceQuickstartStubSettings build() throws IOException {
            return new GkeInferenceQuickstartStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

