/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkehub.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gkehub.v1.CreateFeatureRequest;
import com.google.cloud.gkehub.v1.CreateMembershipRequest;
import com.google.cloud.gkehub.v1.DeleteFeatureRequest;
import com.google.cloud.gkehub.v1.DeleteMembershipRequest;
import com.google.cloud.gkehub.v1.Feature;
import com.google.cloud.gkehub.v1.GenerateConnectManifestRequest;
import com.google.cloud.gkehub.v1.GenerateConnectManifestResponse;
import com.google.cloud.gkehub.v1.GetFeatureRequest;
import com.google.cloud.gkehub.v1.GetMembershipRequest;
import com.google.cloud.gkehub.v1.GkeHubSettings;
import com.google.cloud.gkehub.v1.ListFeaturesRequest;
import com.google.cloud.gkehub.v1.ListFeaturesResponse;
import com.google.cloud.gkehub.v1.ListMembershipsRequest;
import com.google.cloud.gkehub.v1.ListMembershipsResponse;
import com.google.cloud.gkehub.v1.LocationName;
import com.google.cloud.gkehub.v1.Membership;
import com.google.cloud.gkehub.v1.MembershipName;
import com.google.cloud.gkehub.v1.OperationMetadata;
import com.google.cloud.gkehub.v1.UpdateFeatureRequest;
import com.google.cloud.gkehub.v1.UpdateMembershipRequest;
import com.google.cloud.gkehub.v1.stub.GkeHubStub;
import com.google.cloud.gkehub.v1.stub.GkeHubStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class GkeHubClient
implements BackgroundResource {
    private final GkeHubSettings settings;
    private final GkeHubStub stub;
    private final OperationsClient operationsClient;

    public static final GkeHubClient create() throws IOException {
        return GkeHubClient.create(GkeHubSettings.newBuilder().build());
    }

    public static final GkeHubClient create(GkeHubSettings settings) throws IOException {
        return new GkeHubClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GkeHubClient create(GkeHubStub stub) {
        return new GkeHubClient(stub);
    }

    protected GkeHubClient(GkeHubSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GkeHubStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GkeHubClient(GkeHubStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final GkeHubSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GkeHubStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListMembershipsPagedResponse listMemberships(LocationName parent) {
        ListMembershipsRequest request = ListMembershipsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMemberships(request);
    }

    public final ListMembershipsPagedResponse listMemberships(String parent) {
        ListMembershipsRequest request = ListMembershipsRequest.newBuilder().setParent(parent).build();
        return this.listMemberships(request);
    }

    public final ListMembershipsPagedResponse listMemberships(ListMembershipsRequest request) {
        return (ListMembershipsPagedResponse)((Object)this.listMembershipsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMembershipsRequest, ListMembershipsPagedResponse> listMembershipsPagedCallable() {
        return this.stub.listMembershipsPagedCallable();
    }

    public final UnaryCallable<ListMembershipsRequest, ListMembershipsResponse> listMembershipsCallable() {
        return this.stub.listMembershipsCallable();
    }

    public final ListFeaturesPagedResponse listFeatures(String parent) {
        ListFeaturesRequest request = ListFeaturesRequest.newBuilder().setParent(parent).build();
        return this.listFeatures(request);
    }

    public final ListFeaturesPagedResponse listFeatures(ListFeaturesRequest request) {
        return (ListFeaturesPagedResponse)((Object)this.listFeaturesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFeaturesRequest, ListFeaturesPagedResponse> listFeaturesPagedCallable() {
        return this.stub.listFeaturesPagedCallable();
    }

    public final UnaryCallable<ListFeaturesRequest, ListFeaturesResponse> listFeaturesCallable() {
        return this.stub.listFeaturesCallable();
    }

    public final Membership getMembership(MembershipName name) {
        GetMembershipRequest request = GetMembershipRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMembership(request);
    }

    public final Membership getMembership(String name) {
        GetMembershipRequest request = GetMembershipRequest.newBuilder().setName(name).build();
        return this.getMembership(request);
    }

    public final Membership getMembership(GetMembershipRequest request) {
        return (Membership)this.getMembershipCallable().call((Object)request);
    }

    public final UnaryCallable<GetMembershipRequest, Membership> getMembershipCallable() {
        return this.stub.getMembershipCallable();
    }

    public final Feature getFeature(String name) {
        GetFeatureRequest request = GetFeatureRequest.newBuilder().setName(name).build();
        return this.getFeature(request);
    }

    public final Feature getFeature(GetFeatureRequest request) {
        return (Feature)this.getFeatureCallable().call((Object)request);
    }

    public final UnaryCallable<GetFeatureRequest, Feature> getFeatureCallable() {
        return this.stub.getFeatureCallable();
    }

    public final OperationFuture<Membership, OperationMetadata> createMembershipAsync(LocationName parent, Membership resource, String membershipId) {
        CreateMembershipRequest request = CreateMembershipRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setResource(resource).setMembershipId(membershipId).build();
        return this.createMembershipAsync(request);
    }

    public final OperationFuture<Membership, OperationMetadata> createMembershipAsync(String parent, Membership resource, String membershipId) {
        CreateMembershipRequest request = CreateMembershipRequest.newBuilder().setParent(parent).setResource(resource).setMembershipId(membershipId).build();
        return this.createMembershipAsync(request);
    }

    public final OperationFuture<Membership, OperationMetadata> createMembershipAsync(CreateMembershipRequest request) {
        return this.createMembershipOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateMembershipRequest, Membership, OperationMetadata> createMembershipOperationCallable() {
        return this.stub.createMembershipOperationCallable();
    }

    public final UnaryCallable<CreateMembershipRequest, Operation> createMembershipCallable() {
        return this.stub.createMembershipCallable();
    }

    public final OperationFuture<Feature, OperationMetadata> createFeatureAsync(String parent, Feature resource, String featureId) {
        CreateFeatureRequest request = CreateFeatureRequest.newBuilder().setParent(parent).setResource(resource).setFeatureId(featureId).build();
        return this.createFeatureAsync(request);
    }

    public final OperationFuture<Feature, OperationMetadata> createFeatureAsync(CreateFeatureRequest request) {
        return this.createFeatureOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateFeatureRequest, Feature, OperationMetadata> createFeatureOperationCallable() {
        return this.stub.createFeatureOperationCallable();
    }

    public final UnaryCallable<CreateFeatureRequest, Operation> createFeatureCallable() {
        return this.stub.createFeatureCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMembershipAsync(MembershipName name) {
        DeleteMembershipRequest request = DeleteMembershipRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteMembershipAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMembershipAsync(String name) {
        DeleteMembershipRequest request = DeleteMembershipRequest.newBuilder().setName(name).build();
        return this.deleteMembershipAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMembershipAsync(DeleteMembershipRequest request) {
        return this.deleteMembershipOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteMembershipRequest, Empty, OperationMetadata> deleteMembershipOperationCallable() {
        return this.stub.deleteMembershipOperationCallable();
    }

    public final UnaryCallable<DeleteMembershipRequest, Operation> deleteMembershipCallable() {
        return this.stub.deleteMembershipCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteFeatureAsync(String name) {
        DeleteFeatureRequest request = DeleteFeatureRequest.newBuilder().setName(name).build();
        return this.deleteFeatureAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteFeatureAsync(DeleteFeatureRequest request) {
        return this.deleteFeatureOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteFeatureRequest, Empty, OperationMetadata> deleteFeatureOperationCallable() {
        return this.stub.deleteFeatureOperationCallable();
    }

    public final UnaryCallable<DeleteFeatureRequest, Operation> deleteFeatureCallable() {
        return this.stub.deleteFeatureCallable();
    }

    public final OperationFuture<Membership, OperationMetadata> updateMembershipAsync(String name, Membership resource, FieldMask updateMask) {
        UpdateMembershipRequest request = UpdateMembershipRequest.newBuilder().setName(name).setResource(resource).setUpdateMask(updateMask).build();
        return this.updateMembershipAsync(request);
    }

    public final OperationFuture<Membership, OperationMetadata> updateMembershipAsync(UpdateMembershipRequest request) {
        return this.updateMembershipOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateMembershipRequest, Membership, OperationMetadata> updateMembershipOperationCallable() {
        return this.stub.updateMembershipOperationCallable();
    }

    public final UnaryCallable<UpdateMembershipRequest, Operation> updateMembershipCallable() {
        return this.stub.updateMembershipCallable();
    }

    public final OperationFuture<Feature, OperationMetadata> updateFeatureAsync(String name, Feature resource, FieldMask updateMask) {
        UpdateFeatureRequest request = UpdateFeatureRequest.newBuilder().setName(name).setResource(resource).setUpdateMask(updateMask).build();
        return this.updateFeatureAsync(request);
    }

    public final OperationFuture<Feature, OperationMetadata> updateFeatureAsync(UpdateFeatureRequest request) {
        return this.updateFeatureOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateFeatureRequest, Feature, OperationMetadata> updateFeatureOperationCallable() {
        return this.stub.updateFeatureOperationCallable();
    }

    public final UnaryCallable<UpdateFeatureRequest, Operation> updateFeatureCallable() {
        return this.stub.updateFeatureCallable();
    }

    public final GenerateConnectManifestResponse generateConnectManifest(GenerateConnectManifestRequest request) {
        return (GenerateConnectManifestResponse)this.generateConnectManifestCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateConnectManifestRequest, GenerateConnectManifestResponse> generateConnectManifestCallable() {
        return this.stub.generateConnectManifestCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFeaturesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFeaturesRequest, ListFeaturesResponse, Feature, ListFeaturesPage, ListFeaturesFixedSizeCollection> {
        private ListFeaturesFixedSizeCollection(List<ListFeaturesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFeaturesFixedSizeCollection createEmptyCollection() {
            return new ListFeaturesFixedSizeCollection(null, 0);
        }

        protected ListFeaturesFixedSizeCollection createCollection(List<ListFeaturesPage> pages, int collectionSize) {
            return new ListFeaturesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFeaturesPage
    extends AbstractPage<ListFeaturesRequest, ListFeaturesResponse, Feature, ListFeaturesPage> {
        private ListFeaturesPage(PageContext<ListFeaturesRequest, ListFeaturesResponse, Feature> context, ListFeaturesResponse response) {
            super(context, (Object)response);
        }

        private static ListFeaturesPage createEmptyPage() {
            return new ListFeaturesPage(null, null);
        }

        protected ListFeaturesPage createPage(PageContext<ListFeaturesRequest, ListFeaturesResponse, Feature> context, ListFeaturesResponse response) {
            return new ListFeaturesPage(context, response);
        }

        public ApiFuture<ListFeaturesPage> createPageAsync(PageContext<ListFeaturesRequest, ListFeaturesResponse, Feature> context, ApiFuture<ListFeaturesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFeaturesPagedResponse
    extends AbstractPagedListResponse<ListFeaturesRequest, ListFeaturesResponse, Feature, ListFeaturesPage, ListFeaturesFixedSizeCollection> {
        public static ApiFuture<ListFeaturesPagedResponse> createAsync(PageContext<ListFeaturesRequest, ListFeaturesResponse, Feature> context, ApiFuture<ListFeaturesResponse> futureResponse) {
            ApiFuture<ListFeaturesPage> futurePage = ListFeaturesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFeaturesPagedResponse((ListFeaturesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListFeaturesPagedResponse(ListFeaturesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFeaturesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMembershipsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMembershipsRequest, ListMembershipsResponse, Membership, ListMembershipsPage, ListMembershipsFixedSizeCollection> {
        private ListMembershipsFixedSizeCollection(List<ListMembershipsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMembershipsFixedSizeCollection createEmptyCollection() {
            return new ListMembershipsFixedSizeCollection(null, 0);
        }

        protected ListMembershipsFixedSizeCollection createCollection(List<ListMembershipsPage> pages, int collectionSize) {
            return new ListMembershipsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMembershipsPage
    extends AbstractPage<ListMembershipsRequest, ListMembershipsResponse, Membership, ListMembershipsPage> {
        private ListMembershipsPage(PageContext<ListMembershipsRequest, ListMembershipsResponse, Membership> context, ListMembershipsResponse response) {
            super(context, (Object)response);
        }

        private static ListMembershipsPage createEmptyPage() {
            return new ListMembershipsPage(null, null);
        }

        protected ListMembershipsPage createPage(PageContext<ListMembershipsRequest, ListMembershipsResponse, Membership> context, ListMembershipsResponse response) {
            return new ListMembershipsPage(context, response);
        }

        public ApiFuture<ListMembershipsPage> createPageAsync(PageContext<ListMembershipsRequest, ListMembershipsResponse, Membership> context, ApiFuture<ListMembershipsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMembershipsPagedResponse
    extends AbstractPagedListResponse<ListMembershipsRequest, ListMembershipsResponse, Membership, ListMembershipsPage, ListMembershipsFixedSizeCollection> {
        public static ApiFuture<ListMembershipsPagedResponse> createAsync(PageContext<ListMembershipsRequest, ListMembershipsResponse, Membership> context, ApiFuture<ListMembershipsResponse> futureResponse) {
            ApiFuture<ListMembershipsPage> futurePage = ListMembershipsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMembershipsPagedResponse((ListMembershipsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMembershipsPagedResponse(ListMembershipsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMembershipsFixedSizeCollection.createEmptyCollection());
        }
    }
}

