/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkemulticloud.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gkemulticloud.v1.AzureClient;
import com.google.cloud.gkemulticloud.v1.AzureCluster;
import com.google.cloud.gkemulticloud.v1.AzureClustersClient;
import com.google.cloud.gkemulticloud.v1.AzureJsonWebKeys;
import com.google.cloud.gkemulticloud.v1.AzureNodePool;
import com.google.cloud.gkemulticloud.v1.AzureOpenIdConfig;
import com.google.cloud.gkemulticloud.v1.AzureServerConfig;
import com.google.cloud.gkemulticloud.v1.CreateAzureClientRequest;
import com.google.cloud.gkemulticloud.v1.CreateAzureClusterRequest;
import com.google.cloud.gkemulticloud.v1.CreateAzureNodePoolRequest;
import com.google.cloud.gkemulticloud.v1.DeleteAzureClientRequest;
import com.google.cloud.gkemulticloud.v1.DeleteAzureClusterRequest;
import com.google.cloud.gkemulticloud.v1.DeleteAzureNodePoolRequest;
import com.google.cloud.gkemulticloud.v1.GenerateAzureAccessTokenRequest;
import com.google.cloud.gkemulticloud.v1.GenerateAzureAccessTokenResponse;
import com.google.cloud.gkemulticloud.v1.GenerateAzureClusterAgentTokenRequest;
import com.google.cloud.gkemulticloud.v1.GenerateAzureClusterAgentTokenResponse;
import com.google.cloud.gkemulticloud.v1.GetAzureClientRequest;
import com.google.cloud.gkemulticloud.v1.GetAzureClusterRequest;
import com.google.cloud.gkemulticloud.v1.GetAzureJsonWebKeysRequest;
import com.google.cloud.gkemulticloud.v1.GetAzureNodePoolRequest;
import com.google.cloud.gkemulticloud.v1.GetAzureOpenIdConfigRequest;
import com.google.cloud.gkemulticloud.v1.GetAzureServerConfigRequest;
import com.google.cloud.gkemulticloud.v1.ListAzureClientsRequest;
import com.google.cloud.gkemulticloud.v1.ListAzureClientsResponse;
import com.google.cloud.gkemulticloud.v1.ListAzureClustersRequest;
import com.google.cloud.gkemulticloud.v1.ListAzureClustersResponse;
import com.google.cloud.gkemulticloud.v1.ListAzureNodePoolsRequest;
import com.google.cloud.gkemulticloud.v1.ListAzureNodePoolsResponse;
import com.google.cloud.gkemulticloud.v1.OperationMetadata;
import com.google.cloud.gkemulticloud.v1.UpdateAzureClusterRequest;
import com.google.cloud.gkemulticloud.v1.UpdateAzureNodePoolRequest;
import com.google.cloud.gkemulticloud.v1.stub.AzureClustersStub;
import com.google.cloud.gkemulticloud.v1.stub.GrpcAzureClustersStub;
import com.google.cloud.gkemulticloud.v1.stub.HttpJsonAzureClustersStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class AzureClustersStubSettings
extends StubSettings<AzureClustersStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateAzureClientRequest, Operation> createAzureClientSettings;
    private final OperationCallSettings<CreateAzureClientRequest, AzureClient, OperationMetadata> createAzureClientOperationSettings;
    private final UnaryCallSettings<GetAzureClientRequest, AzureClient> getAzureClientSettings;
    private final PagedCallSettings<ListAzureClientsRequest, ListAzureClientsResponse, AzureClustersClient.ListAzureClientsPagedResponse> listAzureClientsSettings;
    private final UnaryCallSettings<DeleteAzureClientRequest, Operation> deleteAzureClientSettings;
    private final OperationCallSettings<DeleteAzureClientRequest, Empty, OperationMetadata> deleteAzureClientOperationSettings;
    private final UnaryCallSettings<CreateAzureClusterRequest, Operation> createAzureClusterSettings;
    private final OperationCallSettings<CreateAzureClusterRequest, AzureCluster, OperationMetadata> createAzureClusterOperationSettings;
    private final UnaryCallSettings<UpdateAzureClusterRequest, Operation> updateAzureClusterSettings;
    private final OperationCallSettings<UpdateAzureClusterRequest, AzureCluster, OperationMetadata> updateAzureClusterOperationSettings;
    private final UnaryCallSettings<GetAzureClusterRequest, AzureCluster> getAzureClusterSettings;
    private final PagedCallSettings<ListAzureClustersRequest, ListAzureClustersResponse, AzureClustersClient.ListAzureClustersPagedResponse> listAzureClustersSettings;
    private final UnaryCallSettings<DeleteAzureClusterRequest, Operation> deleteAzureClusterSettings;
    private final OperationCallSettings<DeleteAzureClusterRequest, Empty, OperationMetadata> deleteAzureClusterOperationSettings;
    private final UnaryCallSettings<GenerateAzureClusterAgentTokenRequest, GenerateAzureClusterAgentTokenResponse> generateAzureClusterAgentTokenSettings;
    private final UnaryCallSettings<GenerateAzureAccessTokenRequest, GenerateAzureAccessTokenResponse> generateAzureAccessTokenSettings;
    private final UnaryCallSettings<CreateAzureNodePoolRequest, Operation> createAzureNodePoolSettings;
    private final OperationCallSettings<CreateAzureNodePoolRequest, AzureNodePool, OperationMetadata> createAzureNodePoolOperationSettings;
    private final UnaryCallSettings<UpdateAzureNodePoolRequest, Operation> updateAzureNodePoolSettings;
    private final OperationCallSettings<UpdateAzureNodePoolRequest, AzureNodePool, OperationMetadata> updateAzureNodePoolOperationSettings;
    private final UnaryCallSettings<GetAzureNodePoolRequest, AzureNodePool> getAzureNodePoolSettings;
    private final PagedCallSettings<ListAzureNodePoolsRequest, ListAzureNodePoolsResponse, AzureClustersClient.ListAzureNodePoolsPagedResponse> listAzureNodePoolsSettings;
    private final UnaryCallSettings<DeleteAzureNodePoolRequest, Operation> deleteAzureNodePoolSettings;
    private final OperationCallSettings<DeleteAzureNodePoolRequest, Empty, OperationMetadata> deleteAzureNodePoolOperationSettings;
    private final UnaryCallSettings<GetAzureOpenIdConfigRequest, AzureOpenIdConfig> getAzureOpenIdConfigSettings;
    private final UnaryCallSettings<GetAzureJsonWebKeysRequest, AzureJsonWebKeys> getAzureJsonWebKeysSettings;
    private final UnaryCallSettings<GetAzureServerConfigRequest, AzureServerConfig> getAzureServerConfigSettings;
    private static final PagedListDescriptor<ListAzureClientsRequest, ListAzureClientsResponse, AzureClient> LIST_AZURE_CLIENTS_PAGE_STR_DESC = new PagedListDescriptor<ListAzureClientsRequest, ListAzureClientsResponse, AzureClient>(){

        public String emptyToken() {
            return "";
        }

        public ListAzureClientsRequest injectToken(ListAzureClientsRequest payload, String token) {
            return ListAzureClientsRequest.newBuilder((ListAzureClientsRequest)payload).setPageToken(token).build();
        }

        public ListAzureClientsRequest injectPageSize(ListAzureClientsRequest payload, int pageSize) {
            return ListAzureClientsRequest.newBuilder((ListAzureClientsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAzureClientsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAzureClientsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AzureClient> extractResources(ListAzureClientsResponse payload) {
            return payload.getAzureClientsList() == null ? ImmutableList.of() : payload.getAzureClientsList();
        }
    };
    private static final PagedListDescriptor<ListAzureClustersRequest, ListAzureClustersResponse, AzureCluster> LIST_AZURE_CLUSTERS_PAGE_STR_DESC = new PagedListDescriptor<ListAzureClustersRequest, ListAzureClustersResponse, AzureCluster>(){

        public String emptyToken() {
            return "";
        }

        public ListAzureClustersRequest injectToken(ListAzureClustersRequest payload, String token) {
            return ListAzureClustersRequest.newBuilder((ListAzureClustersRequest)payload).setPageToken(token).build();
        }

        public ListAzureClustersRequest injectPageSize(ListAzureClustersRequest payload, int pageSize) {
            return ListAzureClustersRequest.newBuilder((ListAzureClustersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAzureClustersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAzureClustersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AzureCluster> extractResources(ListAzureClustersResponse payload) {
            return payload.getAzureClustersList() == null ? ImmutableList.of() : payload.getAzureClustersList();
        }
    };
    private static final PagedListDescriptor<ListAzureNodePoolsRequest, ListAzureNodePoolsResponse, AzureNodePool> LIST_AZURE_NODE_POOLS_PAGE_STR_DESC = new PagedListDescriptor<ListAzureNodePoolsRequest, ListAzureNodePoolsResponse, AzureNodePool>(){

        public String emptyToken() {
            return "";
        }

        public ListAzureNodePoolsRequest injectToken(ListAzureNodePoolsRequest payload, String token) {
            return ListAzureNodePoolsRequest.newBuilder((ListAzureNodePoolsRequest)payload).setPageToken(token).build();
        }

        public ListAzureNodePoolsRequest injectPageSize(ListAzureNodePoolsRequest payload, int pageSize) {
            return ListAzureNodePoolsRequest.newBuilder((ListAzureNodePoolsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAzureNodePoolsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAzureNodePoolsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AzureNodePool> extractResources(ListAzureNodePoolsResponse payload) {
            return payload.getAzureNodePoolsList() == null ? ImmutableList.of() : payload.getAzureNodePoolsList();
        }
    };
    private static final PagedListResponseFactory<ListAzureClientsRequest, ListAzureClientsResponse, AzureClustersClient.ListAzureClientsPagedResponse> LIST_AZURE_CLIENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListAzureClientsRequest, ListAzureClientsResponse, AzureClustersClient.ListAzureClientsPagedResponse>(){

        public ApiFuture<AzureClustersClient.ListAzureClientsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAzureClientsRequest, ListAzureClientsResponse> callable, ListAzureClientsRequest request, ApiCallContext context, ApiFuture<ListAzureClientsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AZURE_CLIENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AzureClustersClient.ListAzureClientsPagedResponse.createAsync((PageContext<ListAzureClientsRequest, ListAzureClientsResponse, AzureClient>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAzureClustersRequest, ListAzureClustersResponse, AzureClustersClient.ListAzureClustersPagedResponse> LIST_AZURE_CLUSTERS_PAGE_STR_FACT = new PagedListResponseFactory<ListAzureClustersRequest, ListAzureClustersResponse, AzureClustersClient.ListAzureClustersPagedResponse>(){

        public ApiFuture<AzureClustersClient.ListAzureClustersPagedResponse> getFuturePagedResponse(UnaryCallable<ListAzureClustersRequest, ListAzureClustersResponse> callable, ListAzureClustersRequest request, ApiCallContext context, ApiFuture<ListAzureClustersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AZURE_CLUSTERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AzureClustersClient.ListAzureClustersPagedResponse.createAsync((PageContext<ListAzureClustersRequest, ListAzureClustersResponse, AzureCluster>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAzureNodePoolsRequest, ListAzureNodePoolsResponse, AzureClustersClient.ListAzureNodePoolsPagedResponse> LIST_AZURE_NODE_POOLS_PAGE_STR_FACT = new PagedListResponseFactory<ListAzureNodePoolsRequest, ListAzureNodePoolsResponse, AzureClustersClient.ListAzureNodePoolsPagedResponse>(){

        public ApiFuture<AzureClustersClient.ListAzureNodePoolsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAzureNodePoolsRequest, ListAzureNodePoolsResponse> callable, ListAzureNodePoolsRequest request, ApiCallContext context, ApiFuture<ListAzureNodePoolsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AZURE_NODE_POOLS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AzureClustersClient.ListAzureNodePoolsPagedResponse.createAsync((PageContext<ListAzureNodePoolsRequest, ListAzureNodePoolsResponse, AzureNodePool>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateAzureClientRequest, Operation> createAzureClientSettings() {
        return this.createAzureClientSettings;
    }

    public OperationCallSettings<CreateAzureClientRequest, AzureClient, OperationMetadata> createAzureClientOperationSettings() {
        return this.createAzureClientOperationSettings;
    }

    public UnaryCallSettings<GetAzureClientRequest, AzureClient> getAzureClientSettings() {
        return this.getAzureClientSettings;
    }

    public PagedCallSettings<ListAzureClientsRequest, ListAzureClientsResponse, AzureClustersClient.ListAzureClientsPagedResponse> listAzureClientsSettings() {
        return this.listAzureClientsSettings;
    }

    public UnaryCallSettings<DeleteAzureClientRequest, Operation> deleteAzureClientSettings() {
        return this.deleteAzureClientSettings;
    }

    public OperationCallSettings<DeleteAzureClientRequest, Empty, OperationMetadata> deleteAzureClientOperationSettings() {
        return this.deleteAzureClientOperationSettings;
    }

    public UnaryCallSettings<CreateAzureClusterRequest, Operation> createAzureClusterSettings() {
        return this.createAzureClusterSettings;
    }

    public OperationCallSettings<CreateAzureClusterRequest, AzureCluster, OperationMetadata> createAzureClusterOperationSettings() {
        return this.createAzureClusterOperationSettings;
    }

    public UnaryCallSettings<UpdateAzureClusterRequest, Operation> updateAzureClusterSettings() {
        return this.updateAzureClusterSettings;
    }

    public OperationCallSettings<UpdateAzureClusterRequest, AzureCluster, OperationMetadata> updateAzureClusterOperationSettings() {
        return this.updateAzureClusterOperationSettings;
    }

    public UnaryCallSettings<GetAzureClusterRequest, AzureCluster> getAzureClusterSettings() {
        return this.getAzureClusterSettings;
    }

    public PagedCallSettings<ListAzureClustersRequest, ListAzureClustersResponse, AzureClustersClient.ListAzureClustersPagedResponse> listAzureClustersSettings() {
        return this.listAzureClustersSettings;
    }

    public UnaryCallSettings<DeleteAzureClusterRequest, Operation> deleteAzureClusterSettings() {
        return this.deleteAzureClusterSettings;
    }

    public OperationCallSettings<DeleteAzureClusterRequest, Empty, OperationMetadata> deleteAzureClusterOperationSettings() {
        return this.deleteAzureClusterOperationSettings;
    }

    public UnaryCallSettings<GenerateAzureClusterAgentTokenRequest, GenerateAzureClusterAgentTokenResponse> generateAzureClusterAgentTokenSettings() {
        return this.generateAzureClusterAgentTokenSettings;
    }

    public UnaryCallSettings<GenerateAzureAccessTokenRequest, GenerateAzureAccessTokenResponse> generateAzureAccessTokenSettings() {
        return this.generateAzureAccessTokenSettings;
    }

    public UnaryCallSettings<CreateAzureNodePoolRequest, Operation> createAzureNodePoolSettings() {
        return this.createAzureNodePoolSettings;
    }

    public OperationCallSettings<CreateAzureNodePoolRequest, AzureNodePool, OperationMetadata> createAzureNodePoolOperationSettings() {
        return this.createAzureNodePoolOperationSettings;
    }

    public UnaryCallSettings<UpdateAzureNodePoolRequest, Operation> updateAzureNodePoolSettings() {
        return this.updateAzureNodePoolSettings;
    }

    public OperationCallSettings<UpdateAzureNodePoolRequest, AzureNodePool, OperationMetadata> updateAzureNodePoolOperationSettings() {
        return this.updateAzureNodePoolOperationSettings;
    }

    public UnaryCallSettings<GetAzureNodePoolRequest, AzureNodePool> getAzureNodePoolSettings() {
        return this.getAzureNodePoolSettings;
    }

    public PagedCallSettings<ListAzureNodePoolsRequest, ListAzureNodePoolsResponse, AzureClustersClient.ListAzureNodePoolsPagedResponse> listAzureNodePoolsSettings() {
        return this.listAzureNodePoolsSettings;
    }

    public UnaryCallSettings<DeleteAzureNodePoolRequest, Operation> deleteAzureNodePoolSettings() {
        return this.deleteAzureNodePoolSettings;
    }

    public OperationCallSettings<DeleteAzureNodePoolRequest, Empty, OperationMetadata> deleteAzureNodePoolOperationSettings() {
        return this.deleteAzureNodePoolOperationSettings;
    }

    public UnaryCallSettings<GetAzureOpenIdConfigRequest, AzureOpenIdConfig> getAzureOpenIdConfigSettings() {
        return this.getAzureOpenIdConfigSettings;
    }

    public UnaryCallSettings<GetAzureJsonWebKeysRequest, AzureJsonWebKeys> getAzureJsonWebKeysSettings() {
        return this.getAzureJsonWebKeysSettings;
    }

    public UnaryCallSettings<GetAzureServerConfigRequest, AzureServerConfig> getAzureServerConfigSettings() {
        return this.getAzureServerConfigSettings;
    }

    public AzureClustersStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAzureClustersStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAzureClustersStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "gkemulticloud";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "gkemulticloud.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "gkemulticloud.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AzureClustersStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AzureClustersStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AzureClustersStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AzureClustersStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AzureClustersStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createAzureClientSettings = settingsBuilder.createAzureClientSettings().build();
        this.createAzureClientOperationSettings = settingsBuilder.createAzureClientOperationSettings().build();
        this.getAzureClientSettings = settingsBuilder.getAzureClientSettings().build();
        this.listAzureClientsSettings = settingsBuilder.listAzureClientsSettings().build();
        this.deleteAzureClientSettings = settingsBuilder.deleteAzureClientSettings().build();
        this.deleteAzureClientOperationSettings = settingsBuilder.deleteAzureClientOperationSettings().build();
        this.createAzureClusterSettings = settingsBuilder.createAzureClusterSettings().build();
        this.createAzureClusterOperationSettings = settingsBuilder.createAzureClusterOperationSettings().build();
        this.updateAzureClusterSettings = settingsBuilder.updateAzureClusterSettings().build();
        this.updateAzureClusterOperationSettings = settingsBuilder.updateAzureClusterOperationSettings().build();
        this.getAzureClusterSettings = settingsBuilder.getAzureClusterSettings().build();
        this.listAzureClustersSettings = settingsBuilder.listAzureClustersSettings().build();
        this.deleteAzureClusterSettings = settingsBuilder.deleteAzureClusterSettings().build();
        this.deleteAzureClusterOperationSettings = settingsBuilder.deleteAzureClusterOperationSettings().build();
        this.generateAzureClusterAgentTokenSettings = settingsBuilder.generateAzureClusterAgentTokenSettings().build();
        this.generateAzureAccessTokenSettings = settingsBuilder.generateAzureAccessTokenSettings().build();
        this.createAzureNodePoolSettings = settingsBuilder.createAzureNodePoolSettings().build();
        this.createAzureNodePoolOperationSettings = settingsBuilder.createAzureNodePoolOperationSettings().build();
        this.updateAzureNodePoolSettings = settingsBuilder.updateAzureNodePoolSettings().build();
        this.updateAzureNodePoolOperationSettings = settingsBuilder.updateAzureNodePoolOperationSettings().build();
        this.getAzureNodePoolSettings = settingsBuilder.getAzureNodePoolSettings().build();
        this.listAzureNodePoolsSettings = settingsBuilder.listAzureNodePoolsSettings().build();
        this.deleteAzureNodePoolSettings = settingsBuilder.deleteAzureNodePoolSettings().build();
        this.deleteAzureNodePoolOperationSettings = settingsBuilder.deleteAzureNodePoolOperationSettings().build();
        this.getAzureOpenIdConfigSettings = settingsBuilder.getAzureOpenIdConfigSettings().build();
        this.getAzureJsonWebKeysSettings = settingsBuilder.getAzureJsonWebKeysSettings().build();
        this.getAzureServerConfigSettings = settingsBuilder.getAzureServerConfigSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AzureClustersStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateAzureClientRequest, Operation> createAzureClientSettings;
        private final OperationCallSettings.Builder<CreateAzureClientRequest, AzureClient, OperationMetadata> createAzureClientOperationSettings;
        private final UnaryCallSettings.Builder<GetAzureClientRequest, AzureClient> getAzureClientSettings;
        private final PagedCallSettings.Builder<ListAzureClientsRequest, ListAzureClientsResponse, AzureClustersClient.ListAzureClientsPagedResponse> listAzureClientsSettings;
        private final UnaryCallSettings.Builder<DeleteAzureClientRequest, Operation> deleteAzureClientSettings;
        private final OperationCallSettings.Builder<DeleteAzureClientRequest, Empty, OperationMetadata> deleteAzureClientOperationSettings;
        private final UnaryCallSettings.Builder<CreateAzureClusterRequest, Operation> createAzureClusterSettings;
        private final OperationCallSettings.Builder<CreateAzureClusterRequest, AzureCluster, OperationMetadata> createAzureClusterOperationSettings;
        private final UnaryCallSettings.Builder<UpdateAzureClusterRequest, Operation> updateAzureClusterSettings;
        private final OperationCallSettings.Builder<UpdateAzureClusterRequest, AzureCluster, OperationMetadata> updateAzureClusterOperationSettings;
        private final UnaryCallSettings.Builder<GetAzureClusterRequest, AzureCluster> getAzureClusterSettings;
        private final PagedCallSettings.Builder<ListAzureClustersRequest, ListAzureClustersResponse, AzureClustersClient.ListAzureClustersPagedResponse> listAzureClustersSettings;
        private final UnaryCallSettings.Builder<DeleteAzureClusterRequest, Operation> deleteAzureClusterSettings;
        private final OperationCallSettings.Builder<DeleteAzureClusterRequest, Empty, OperationMetadata> deleteAzureClusterOperationSettings;
        private final UnaryCallSettings.Builder<GenerateAzureClusterAgentTokenRequest, GenerateAzureClusterAgentTokenResponse> generateAzureClusterAgentTokenSettings;
        private final UnaryCallSettings.Builder<GenerateAzureAccessTokenRequest, GenerateAzureAccessTokenResponse> generateAzureAccessTokenSettings;
        private final UnaryCallSettings.Builder<CreateAzureNodePoolRequest, Operation> createAzureNodePoolSettings;
        private final OperationCallSettings.Builder<CreateAzureNodePoolRequest, AzureNodePool, OperationMetadata> createAzureNodePoolOperationSettings;
        private final UnaryCallSettings.Builder<UpdateAzureNodePoolRequest, Operation> updateAzureNodePoolSettings;
        private final OperationCallSettings.Builder<UpdateAzureNodePoolRequest, AzureNodePool, OperationMetadata> updateAzureNodePoolOperationSettings;
        private final UnaryCallSettings.Builder<GetAzureNodePoolRequest, AzureNodePool> getAzureNodePoolSettings;
        private final PagedCallSettings.Builder<ListAzureNodePoolsRequest, ListAzureNodePoolsResponse, AzureClustersClient.ListAzureNodePoolsPagedResponse> listAzureNodePoolsSettings;
        private final UnaryCallSettings.Builder<DeleteAzureNodePoolRequest, Operation> deleteAzureNodePoolSettings;
        private final OperationCallSettings.Builder<DeleteAzureNodePoolRequest, Empty, OperationMetadata> deleteAzureNodePoolOperationSettings;
        private final UnaryCallSettings.Builder<GetAzureOpenIdConfigRequest, AzureOpenIdConfig> getAzureOpenIdConfigSettings;
        private final UnaryCallSettings.Builder<GetAzureJsonWebKeysRequest, AzureJsonWebKeys> getAzureJsonWebKeysSettings;
        private final UnaryCallSettings.Builder<GetAzureServerConfigRequest, AzureServerConfig> getAzureServerConfigSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createAzureClientSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAzureClientOperationSettings = OperationCallSettings.newBuilder();
            this.getAzureClientSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAzureClientsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AZURE_CLIENTS_PAGE_STR_FACT);
            this.deleteAzureClientSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAzureClientOperationSettings = OperationCallSettings.newBuilder();
            this.createAzureClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAzureClusterOperationSettings = OperationCallSettings.newBuilder();
            this.updateAzureClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAzureClusterOperationSettings = OperationCallSettings.newBuilder();
            this.getAzureClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAzureClustersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AZURE_CLUSTERS_PAGE_STR_FACT);
            this.deleteAzureClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAzureClusterOperationSettings = OperationCallSettings.newBuilder();
            this.generateAzureClusterAgentTokenSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateAzureAccessTokenSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAzureNodePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAzureNodePoolOperationSettings = OperationCallSettings.newBuilder();
            this.updateAzureNodePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAzureNodePoolOperationSettings = OperationCallSettings.newBuilder();
            this.getAzureNodePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAzureNodePoolsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AZURE_NODE_POOLS_PAGE_STR_FACT);
            this.deleteAzureNodePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAzureNodePoolOperationSettings = OperationCallSettings.newBuilder();
            this.getAzureOpenIdConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAzureJsonWebKeysSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAzureServerConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createAzureClientSettings, this.getAzureClientSettings, this.listAzureClientsSettings, this.deleteAzureClientSettings, this.createAzureClusterSettings, this.updateAzureClusterSettings, this.getAzureClusterSettings, this.listAzureClustersSettings, this.deleteAzureClusterSettings, this.generateAzureClusterAgentTokenSettings, this.generateAzureAccessTokenSettings, this.createAzureNodePoolSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateAzureNodePoolSettings, this.getAzureNodePoolSettings, this.listAzureNodePoolsSettings, this.deleteAzureNodePoolSettings, this.getAzureOpenIdConfigSettings, this.getAzureJsonWebKeysSettings, this.getAzureServerConfigSettings});
            Builder.initDefaults(this);
        }

        protected Builder(AzureClustersStubSettings settings) {
            super((StubSettings)settings);
            this.createAzureClientSettings = settings.createAzureClientSettings.toBuilder();
            this.createAzureClientOperationSettings = settings.createAzureClientOperationSettings.toBuilder();
            this.getAzureClientSettings = settings.getAzureClientSettings.toBuilder();
            this.listAzureClientsSettings = settings.listAzureClientsSettings.toBuilder();
            this.deleteAzureClientSettings = settings.deleteAzureClientSettings.toBuilder();
            this.deleteAzureClientOperationSettings = settings.deleteAzureClientOperationSettings.toBuilder();
            this.createAzureClusterSettings = settings.createAzureClusterSettings.toBuilder();
            this.createAzureClusterOperationSettings = settings.createAzureClusterOperationSettings.toBuilder();
            this.updateAzureClusterSettings = settings.updateAzureClusterSettings.toBuilder();
            this.updateAzureClusterOperationSettings = settings.updateAzureClusterOperationSettings.toBuilder();
            this.getAzureClusterSettings = settings.getAzureClusterSettings.toBuilder();
            this.listAzureClustersSettings = settings.listAzureClustersSettings.toBuilder();
            this.deleteAzureClusterSettings = settings.deleteAzureClusterSettings.toBuilder();
            this.deleteAzureClusterOperationSettings = settings.deleteAzureClusterOperationSettings.toBuilder();
            this.generateAzureClusterAgentTokenSettings = settings.generateAzureClusterAgentTokenSettings.toBuilder();
            this.generateAzureAccessTokenSettings = settings.generateAzureAccessTokenSettings.toBuilder();
            this.createAzureNodePoolSettings = settings.createAzureNodePoolSettings.toBuilder();
            this.createAzureNodePoolOperationSettings = settings.createAzureNodePoolOperationSettings.toBuilder();
            this.updateAzureNodePoolSettings = settings.updateAzureNodePoolSettings.toBuilder();
            this.updateAzureNodePoolOperationSettings = settings.updateAzureNodePoolOperationSettings.toBuilder();
            this.getAzureNodePoolSettings = settings.getAzureNodePoolSettings.toBuilder();
            this.listAzureNodePoolsSettings = settings.listAzureNodePoolsSettings.toBuilder();
            this.deleteAzureNodePoolSettings = settings.deleteAzureNodePoolSettings.toBuilder();
            this.deleteAzureNodePoolOperationSettings = settings.deleteAzureNodePoolOperationSettings.toBuilder();
            this.getAzureOpenIdConfigSettings = settings.getAzureOpenIdConfigSettings.toBuilder();
            this.getAzureJsonWebKeysSettings = settings.getAzureJsonWebKeysSettings.toBuilder();
            this.getAzureServerConfigSettings = settings.getAzureServerConfigSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createAzureClientSettings, this.getAzureClientSettings, this.listAzureClientsSettings, this.deleteAzureClientSettings, this.createAzureClusterSettings, this.updateAzureClusterSettings, this.getAzureClusterSettings, this.listAzureClustersSettings, this.deleteAzureClusterSettings, this.generateAzureClusterAgentTokenSettings, this.generateAzureAccessTokenSettings, this.createAzureNodePoolSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateAzureNodePoolSettings, this.getAzureNodePoolSettings, this.listAzureNodePoolsSettings, this.deleteAzureNodePoolSettings, this.getAzureOpenIdConfigSettings, this.getAzureJsonWebKeysSettings, this.getAzureServerConfigSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AzureClustersStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AzureClustersStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AzureClustersStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AzureClustersStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AzureClustersStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AzureClustersStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AzureClustersStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AzureClustersStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createAzureClientSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getAzureClientSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAzureClientsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteAzureClientSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createAzureClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateAzureClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getAzureClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAzureClustersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteAzureClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.generateAzureClusterAgentTokenSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.generateAzureAccessTokenSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createAzureNodePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateAzureNodePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getAzureNodePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAzureNodePoolsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteAzureNodePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getAzureOpenIdConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getAzureJsonWebKeysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getAzureServerConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createAzureClientOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AzureClient.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteAzureClientOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createAzureClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AzureCluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateAzureClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AzureCluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteAzureClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createAzureNodePoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AzureNodePool.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateAzureNodePoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AzureNodePool.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteAzureNodePoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateAzureClientRequest, Operation> createAzureClientSettings() {
            return this.createAzureClientSettings;
        }

        public OperationCallSettings.Builder<CreateAzureClientRequest, AzureClient, OperationMetadata> createAzureClientOperationSettings() {
            return this.createAzureClientOperationSettings;
        }

        public UnaryCallSettings.Builder<GetAzureClientRequest, AzureClient> getAzureClientSettings() {
            return this.getAzureClientSettings;
        }

        public PagedCallSettings.Builder<ListAzureClientsRequest, ListAzureClientsResponse, AzureClustersClient.ListAzureClientsPagedResponse> listAzureClientsSettings() {
            return this.listAzureClientsSettings;
        }

        public UnaryCallSettings.Builder<DeleteAzureClientRequest, Operation> deleteAzureClientSettings() {
            return this.deleteAzureClientSettings;
        }

        public OperationCallSettings.Builder<DeleteAzureClientRequest, Empty, OperationMetadata> deleteAzureClientOperationSettings() {
            return this.deleteAzureClientOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateAzureClusterRequest, Operation> createAzureClusterSettings() {
            return this.createAzureClusterSettings;
        }

        public OperationCallSettings.Builder<CreateAzureClusterRequest, AzureCluster, OperationMetadata> createAzureClusterOperationSettings() {
            return this.createAzureClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateAzureClusterRequest, Operation> updateAzureClusterSettings() {
            return this.updateAzureClusterSettings;
        }

        public OperationCallSettings.Builder<UpdateAzureClusterRequest, AzureCluster, OperationMetadata> updateAzureClusterOperationSettings() {
            return this.updateAzureClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<GetAzureClusterRequest, AzureCluster> getAzureClusterSettings() {
            return this.getAzureClusterSettings;
        }

        public PagedCallSettings.Builder<ListAzureClustersRequest, ListAzureClustersResponse, AzureClustersClient.ListAzureClustersPagedResponse> listAzureClustersSettings() {
            return this.listAzureClustersSettings;
        }

        public UnaryCallSettings.Builder<DeleteAzureClusterRequest, Operation> deleteAzureClusterSettings() {
            return this.deleteAzureClusterSettings;
        }

        public OperationCallSettings.Builder<DeleteAzureClusterRequest, Empty, OperationMetadata> deleteAzureClusterOperationSettings() {
            return this.deleteAzureClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<GenerateAzureClusterAgentTokenRequest, GenerateAzureClusterAgentTokenResponse> generateAzureClusterAgentTokenSettings() {
            return this.generateAzureClusterAgentTokenSettings;
        }

        public UnaryCallSettings.Builder<GenerateAzureAccessTokenRequest, GenerateAzureAccessTokenResponse> generateAzureAccessTokenSettings() {
            return this.generateAzureAccessTokenSettings;
        }

        public UnaryCallSettings.Builder<CreateAzureNodePoolRequest, Operation> createAzureNodePoolSettings() {
            return this.createAzureNodePoolSettings;
        }

        public OperationCallSettings.Builder<CreateAzureNodePoolRequest, AzureNodePool, OperationMetadata> createAzureNodePoolOperationSettings() {
            return this.createAzureNodePoolOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateAzureNodePoolRequest, Operation> updateAzureNodePoolSettings() {
            return this.updateAzureNodePoolSettings;
        }

        public OperationCallSettings.Builder<UpdateAzureNodePoolRequest, AzureNodePool, OperationMetadata> updateAzureNodePoolOperationSettings() {
            return this.updateAzureNodePoolOperationSettings;
        }

        public UnaryCallSettings.Builder<GetAzureNodePoolRequest, AzureNodePool> getAzureNodePoolSettings() {
            return this.getAzureNodePoolSettings;
        }

        public PagedCallSettings.Builder<ListAzureNodePoolsRequest, ListAzureNodePoolsResponse, AzureClustersClient.ListAzureNodePoolsPagedResponse> listAzureNodePoolsSettings() {
            return this.listAzureNodePoolsSettings;
        }

        public UnaryCallSettings.Builder<DeleteAzureNodePoolRequest, Operation> deleteAzureNodePoolSettings() {
            return this.deleteAzureNodePoolSettings;
        }

        public OperationCallSettings.Builder<DeleteAzureNodePoolRequest, Empty, OperationMetadata> deleteAzureNodePoolOperationSettings() {
            return this.deleteAzureNodePoolOperationSettings;
        }

        public UnaryCallSettings.Builder<GetAzureOpenIdConfigRequest, AzureOpenIdConfig> getAzureOpenIdConfigSettings() {
            return this.getAzureOpenIdConfigSettings;
        }

        public UnaryCallSettings.Builder<GetAzureJsonWebKeysRequest, AzureJsonWebKeys> getAzureJsonWebKeysSettings() {
            return this.getAzureJsonWebKeysSettings;
        }

        public UnaryCallSettings.Builder<GetAzureServerConfigRequest, AzureServerConfig> getAzureServerConfigSettings() {
            return this.getAzureServerConfigSettings;
        }

        public AzureClustersStubSettings build() throws IOException {
            return new AzureClustersStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

