/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkemulticloud.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gkemulticloud.v1.AttachedCluster;
import com.google.cloud.gkemulticloud.v1.AttachedClusterName;
import com.google.cloud.gkemulticloud.v1.AttachedClustersSettings;
import com.google.cloud.gkemulticloud.v1.AttachedServerConfig;
import com.google.cloud.gkemulticloud.v1.AttachedServerConfigName;
import com.google.cloud.gkemulticloud.v1.CreateAttachedClusterRequest;
import com.google.cloud.gkemulticloud.v1.DeleteAttachedClusterRequest;
import com.google.cloud.gkemulticloud.v1.GenerateAttachedClusterInstallManifestRequest;
import com.google.cloud.gkemulticloud.v1.GenerateAttachedClusterInstallManifestResponse;
import com.google.cloud.gkemulticloud.v1.GetAttachedClusterRequest;
import com.google.cloud.gkemulticloud.v1.GetAttachedServerConfigRequest;
import com.google.cloud.gkemulticloud.v1.ImportAttachedClusterRequest;
import com.google.cloud.gkemulticloud.v1.ListAttachedClustersRequest;
import com.google.cloud.gkemulticloud.v1.ListAttachedClustersResponse;
import com.google.cloud.gkemulticloud.v1.LocationName;
import com.google.cloud.gkemulticloud.v1.OperationMetadata;
import com.google.cloud.gkemulticloud.v1.UpdateAttachedClusterRequest;
import com.google.cloud.gkemulticloud.v1.stub.AttachedClustersStub;
import com.google.cloud.gkemulticloud.v1.stub.AttachedClustersStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AttachedClustersClient
implements BackgroundResource {
    private final AttachedClustersSettings settings;
    private final AttachedClustersStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final AttachedClustersClient create() throws IOException {
        return AttachedClustersClient.create(AttachedClustersSettings.newBuilder().build());
    }

    public static final AttachedClustersClient create(AttachedClustersSettings settings) throws IOException {
        return new AttachedClustersClient(settings);
    }

    public static final AttachedClustersClient create(AttachedClustersStub stub) {
        return new AttachedClustersClient(stub);
    }

    protected AttachedClustersClient(AttachedClustersSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AttachedClustersStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected AttachedClustersClient(AttachedClustersStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final AttachedClustersSettings getSettings() {
        return this.settings;
    }

    public AttachedClustersStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<AttachedCluster, OperationMetadata> createAttachedClusterAsync(LocationName parent, AttachedCluster attachedCluster, String attachedClusterId) {
        CreateAttachedClusterRequest request = CreateAttachedClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAttachedCluster(attachedCluster).setAttachedClusterId(attachedClusterId).build();
        return this.createAttachedClusterAsync(request);
    }

    public final OperationFuture<AttachedCluster, OperationMetadata> createAttachedClusterAsync(String parent, AttachedCluster attachedCluster, String attachedClusterId) {
        CreateAttachedClusterRequest request = CreateAttachedClusterRequest.newBuilder().setParent(parent).setAttachedCluster(attachedCluster).setAttachedClusterId(attachedClusterId).build();
        return this.createAttachedClusterAsync(request);
    }

    public final OperationFuture<AttachedCluster, OperationMetadata> createAttachedClusterAsync(CreateAttachedClusterRequest request) {
        return this.createAttachedClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAttachedClusterRequest, AttachedCluster, OperationMetadata> createAttachedClusterOperationCallable() {
        return this.stub.createAttachedClusterOperationCallable();
    }

    public final UnaryCallable<CreateAttachedClusterRequest, Operation> createAttachedClusterCallable() {
        return this.stub.createAttachedClusterCallable();
    }

    public final OperationFuture<AttachedCluster, OperationMetadata> updateAttachedClusterAsync(AttachedCluster attachedCluster, FieldMask updateMask) {
        UpdateAttachedClusterRequest request = UpdateAttachedClusterRequest.newBuilder().setAttachedCluster(attachedCluster).setUpdateMask(updateMask).build();
        return this.updateAttachedClusterAsync(request);
    }

    public final OperationFuture<AttachedCluster, OperationMetadata> updateAttachedClusterAsync(UpdateAttachedClusterRequest request) {
        return this.updateAttachedClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateAttachedClusterRequest, AttachedCluster, OperationMetadata> updateAttachedClusterOperationCallable() {
        return this.stub.updateAttachedClusterOperationCallable();
    }

    public final UnaryCallable<UpdateAttachedClusterRequest, Operation> updateAttachedClusterCallable() {
        return this.stub.updateAttachedClusterCallable();
    }

    public final OperationFuture<AttachedCluster, OperationMetadata> importAttachedClusterAsync(LocationName parent, String fleetMembership) {
        ImportAttachedClusterRequest request = ImportAttachedClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFleetMembership(fleetMembership).build();
        return this.importAttachedClusterAsync(request);
    }

    public final OperationFuture<AttachedCluster, OperationMetadata> importAttachedClusterAsync(String parent, String fleetMembership) {
        ImportAttachedClusterRequest request = ImportAttachedClusterRequest.newBuilder().setParent(parent).setFleetMembership(fleetMembership).build();
        return this.importAttachedClusterAsync(request);
    }

    public final OperationFuture<AttachedCluster, OperationMetadata> importAttachedClusterAsync(ImportAttachedClusterRequest request) {
        return this.importAttachedClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportAttachedClusterRequest, AttachedCluster, OperationMetadata> importAttachedClusterOperationCallable() {
        return this.stub.importAttachedClusterOperationCallable();
    }

    public final UnaryCallable<ImportAttachedClusterRequest, Operation> importAttachedClusterCallable() {
        return this.stub.importAttachedClusterCallable();
    }

    public final AttachedCluster getAttachedCluster(AttachedClusterName name) {
        GetAttachedClusterRequest request = GetAttachedClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAttachedCluster(request);
    }

    public final AttachedCluster getAttachedCluster(String name) {
        GetAttachedClusterRequest request = GetAttachedClusterRequest.newBuilder().setName(name).build();
        return this.getAttachedCluster(request);
    }

    public final AttachedCluster getAttachedCluster(GetAttachedClusterRequest request) {
        return (AttachedCluster)this.getAttachedClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetAttachedClusterRequest, AttachedCluster> getAttachedClusterCallable() {
        return this.stub.getAttachedClusterCallable();
    }

    public final ListAttachedClustersPagedResponse listAttachedClusters(LocationName parent) {
        ListAttachedClustersRequest request = ListAttachedClustersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAttachedClusters(request);
    }

    public final ListAttachedClustersPagedResponse listAttachedClusters(String parent) {
        ListAttachedClustersRequest request = ListAttachedClustersRequest.newBuilder().setParent(parent).build();
        return this.listAttachedClusters(request);
    }

    public final ListAttachedClustersPagedResponse listAttachedClusters(ListAttachedClustersRequest request) {
        return (ListAttachedClustersPagedResponse)((Object)this.listAttachedClustersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAttachedClustersRequest, ListAttachedClustersPagedResponse> listAttachedClustersPagedCallable() {
        return this.stub.listAttachedClustersPagedCallable();
    }

    public final UnaryCallable<ListAttachedClustersRequest, ListAttachedClustersResponse> listAttachedClustersCallable() {
        return this.stub.listAttachedClustersCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAttachedClusterAsync(AttachedClusterName name) {
        DeleteAttachedClusterRequest request = DeleteAttachedClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAttachedClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAttachedClusterAsync(String name) {
        DeleteAttachedClusterRequest request = DeleteAttachedClusterRequest.newBuilder().setName(name).build();
        return this.deleteAttachedClusterAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAttachedClusterAsync(DeleteAttachedClusterRequest request) {
        return this.deleteAttachedClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAttachedClusterRequest, Empty, OperationMetadata> deleteAttachedClusterOperationCallable() {
        return this.stub.deleteAttachedClusterOperationCallable();
    }

    public final UnaryCallable<DeleteAttachedClusterRequest, Operation> deleteAttachedClusterCallable() {
        return this.stub.deleteAttachedClusterCallable();
    }

    public final AttachedServerConfig getAttachedServerConfig(AttachedServerConfigName name) {
        GetAttachedServerConfigRequest request = GetAttachedServerConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAttachedServerConfig(request);
    }

    public final AttachedServerConfig getAttachedServerConfig(String name) {
        GetAttachedServerConfigRequest request = GetAttachedServerConfigRequest.newBuilder().setName(name).build();
        return this.getAttachedServerConfig(request);
    }

    public final AttachedServerConfig getAttachedServerConfig(GetAttachedServerConfigRequest request) {
        return (AttachedServerConfig)this.getAttachedServerConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetAttachedServerConfigRequest, AttachedServerConfig> getAttachedServerConfigCallable() {
        return this.stub.getAttachedServerConfigCallable();
    }

    public final GenerateAttachedClusterInstallManifestResponse generateAttachedClusterInstallManifest(LocationName parent, String attachedClusterId) {
        GenerateAttachedClusterInstallManifestRequest request = GenerateAttachedClusterInstallManifestRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAttachedClusterId(attachedClusterId).build();
        return this.generateAttachedClusterInstallManifest(request);
    }

    public final GenerateAttachedClusterInstallManifestResponse generateAttachedClusterInstallManifest(String parent, String attachedClusterId) {
        GenerateAttachedClusterInstallManifestRequest request = GenerateAttachedClusterInstallManifestRequest.newBuilder().setParent(parent).setAttachedClusterId(attachedClusterId).build();
        return this.generateAttachedClusterInstallManifest(request);
    }

    public final GenerateAttachedClusterInstallManifestResponse generateAttachedClusterInstallManifest(GenerateAttachedClusterInstallManifestRequest request) {
        return (GenerateAttachedClusterInstallManifestResponse)this.generateAttachedClusterInstallManifestCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateAttachedClusterInstallManifestRequest, GenerateAttachedClusterInstallManifestResponse> generateAttachedClusterInstallManifestCallable() {
        return this.stub.generateAttachedClusterInstallManifestCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAttachedClustersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAttachedClustersRequest, ListAttachedClustersResponse, AttachedCluster, ListAttachedClustersPage, ListAttachedClustersFixedSizeCollection> {
        private ListAttachedClustersFixedSizeCollection(List<ListAttachedClustersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAttachedClustersFixedSizeCollection createEmptyCollection() {
            return new ListAttachedClustersFixedSizeCollection(null, 0);
        }

        protected ListAttachedClustersFixedSizeCollection createCollection(List<ListAttachedClustersPage> pages, int collectionSize) {
            return new ListAttachedClustersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAttachedClustersPage
    extends AbstractPage<ListAttachedClustersRequest, ListAttachedClustersResponse, AttachedCluster, ListAttachedClustersPage> {
        private ListAttachedClustersPage(PageContext<ListAttachedClustersRequest, ListAttachedClustersResponse, AttachedCluster> context, ListAttachedClustersResponse response) {
            super(context, (Object)response);
        }

        private static ListAttachedClustersPage createEmptyPage() {
            return new ListAttachedClustersPage(null, null);
        }

        protected ListAttachedClustersPage createPage(PageContext<ListAttachedClustersRequest, ListAttachedClustersResponse, AttachedCluster> context, ListAttachedClustersResponse response) {
            return new ListAttachedClustersPage(context, response);
        }

        public ApiFuture<ListAttachedClustersPage> createPageAsync(PageContext<ListAttachedClustersRequest, ListAttachedClustersResponse, AttachedCluster> context, ApiFuture<ListAttachedClustersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAttachedClustersPagedResponse
    extends AbstractPagedListResponse<ListAttachedClustersRequest, ListAttachedClustersResponse, AttachedCluster, ListAttachedClustersPage, ListAttachedClustersFixedSizeCollection> {
        public static ApiFuture<ListAttachedClustersPagedResponse> createAsync(PageContext<ListAttachedClustersRequest, ListAttachedClustersResponse, AttachedCluster> context, ApiFuture<ListAttachedClustersResponse> futureResponse) {
            ApiFuture<ListAttachedClustersPage> futurePage = ListAttachedClustersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAttachedClustersPagedResponse((ListAttachedClustersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAttachedClustersPagedResponse(ListAttachedClustersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAttachedClustersFixedSizeCollection.createEmptyCollection());
        }
    }
}

