/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkeconnect.gateway.v1beta1.stub;

import com.google.api.HttpBody;
import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.gkeconnect.gateway.v1beta1.stub.GatewayServiceStub;
import com.google.cloud.gkeconnect.gateway.v1beta1.stub.GrpcGatewayServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class GatewayServiceStubSettings
extends StubSettings<GatewayServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<HttpBody, HttpBody> getResourceSettings;
    private final UnaryCallSettings<HttpBody, HttpBody> postResourceSettings;
    private final UnaryCallSettings<HttpBody, HttpBody> deleteResourceSettings;
    private final UnaryCallSettings<HttpBody, HttpBody> putResourceSettings;
    private final UnaryCallSettings<HttpBody, HttpBody> patchResourceSettings;

    public UnaryCallSettings<HttpBody, HttpBody> getResourceSettings() {
        return this.getResourceSettings;
    }

    public UnaryCallSettings<HttpBody, HttpBody> postResourceSettings() {
        return this.postResourceSettings;
    }

    public UnaryCallSettings<HttpBody, HttpBody> deleteResourceSettings() {
        return this.deleteResourceSettings;
    }

    public UnaryCallSettings<HttpBody, HttpBody> putResourceSettings() {
        return this.putResourceSettings;
    }

    public UnaryCallSettings<HttpBody, HttpBody> patchResourceSettings() {
        return this.patchResourceSettings;
    }

    public GatewayServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcGatewayServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "connectgateway.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "connectgateway.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GatewayServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GatewayServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GatewayServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getResourceSettings = settingsBuilder.getResourceSettings().build();
        this.postResourceSettings = settingsBuilder.postResourceSettings().build();
        this.deleteResourceSettings = settingsBuilder.deleteResourceSettings().build();
        this.putResourceSettings = settingsBuilder.putResourceSettings().build();
        this.patchResourceSettings = settingsBuilder.patchResourceSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GatewayServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<HttpBody, HttpBody> getResourceSettings;
        private final UnaryCallSettings.Builder<HttpBody, HttpBody> postResourceSettings;
        private final UnaryCallSettings.Builder<HttpBody, HttpBody> deleteResourceSettings;
        private final UnaryCallSettings.Builder<HttpBody, HttpBody> putResourceSettings;
        private final UnaryCallSettings.Builder<HttpBody, HttpBody> patchResourceSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getResourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.postResourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteResourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.putResourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchResourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getResourceSettings, this.postResourceSettings, this.deleteResourceSettings, this.putResourceSettings, this.patchResourceSettings);
            Builder.initDefaults(this);
        }

        protected Builder(GatewayServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getResourceSettings = settings.getResourceSettings.toBuilder();
            this.postResourceSettings = settings.postResourceSettings.toBuilder();
            this.deleteResourceSettings = settings.deleteResourceSettings.toBuilder();
            this.putResourceSettings = settings.putResourceSettings.toBuilder();
            this.patchResourceSettings = settings.patchResourceSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getResourceSettings, this.postResourceSettings, this.deleteResourceSettings, this.putResourceSettings, this.patchResourceSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GatewayServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GatewayServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GatewayServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(GatewayServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(GatewayServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getResourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.postResourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteResourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.putResourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.patchResourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<HttpBody, HttpBody> getResourceSettings() {
            return this.getResourceSettings;
        }

        public UnaryCallSettings.Builder<HttpBody, HttpBody> postResourceSettings() {
            return this.postResourceSettings;
        }

        public UnaryCallSettings.Builder<HttpBody, HttpBody> deleteResourceSettings() {
            return this.deleteResourceSettings;
        }

        public UnaryCallSettings.Builder<HttpBody, HttpBody> putResourceSettings() {
            return this.putResourceSettings;
        }

        public UnaryCallSettings.Builder<HttpBody, HttpBody> patchResourceSettings() {
            return this.patchResourceSettings;
        }

        public GatewayServiceStubSettings build() throws IOException {
            return new GatewayServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

