/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.ServiceDefaults;
import com.google.cloud.ServiceOptions;
import com.google.cloud.TransportOptions;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreFactory;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.FirestoreOpenTelemetryOptions;
import com.google.cloud.firestore.FirestoreRpcFactory;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.cloud.firestore.spi.v1.GrpcFirestoreRpc;
import com.google.cloud.firestore.telemetry.TraceUtil;
import com.google.cloud.firestore.v1.FirestoreSettings;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FirestoreOptions
extends ServiceOptions<Firestore, FirestoreOptions> {
    private static final String API_SHORT_NAME = "Firestore";
    private static final Set<String> SCOPES = ImmutableSet.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/datastore").build();
    private static final long serialVersionUID = -5853552236134770090L;
    private static final String FIRESTORE_EMULATOR_SYSTEM_VARIABLE = "FIRESTORE_EMULATOR_HOST";
    private final String databaseId;
    private final TransportChannelProvider channelProvider;
    private final CredentialsProvider credentialsProvider;
    private final String emulatorHost;
    @Nonnull
    private final transient FirestoreOpenTelemetryOptions openTelemetryOptions;
    @Nonnull
    private final transient TraceUtil traceUtil;

    public static FirestoreOptions getDefaultInstance() {
        return FirestoreOptions.newBuilder().build();
    }

    protected boolean projectIdRequired() {
        return false;
    }

    protected String getDefaultHost() {
        return FirestoreDefaults.INSTANCE.getHost();
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public TransportChannelProvider getTransportChannelProvider() {
        return this.channelProvider;
    }

    public String getEmulatorHost() {
        return this.emulatorHost;
    }

    @Nonnull
    TraceUtil getTraceUtil() {
        return this.traceUtil;
    }

    @BetaApi
    @Nonnull
    public FirestoreOpenTelemetryOptions getOpenTelemetryOptions() {
        return this.openTelemetryOptions;
    }

    @InternalApi(value="This class should only be extended within google-cloud-java")
    protected FirestoreOptions(Builder builder) {
        super(FirestoreFactory.class, FirestoreRpcFactory.class, (ServiceOptions.Builder)builder, (ServiceDefaults)new FirestoreDefaults());
        ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator;
        this.openTelemetryOptions = builder.openTelemetryOptions != null ? builder.openTelemetryOptions : FirestoreOpenTelemetryOptions.newBuilder().build();
        this.traceUtil = TraceUtil.getInstance(this);
        String string = this.databaseId = builder.databaseId != null ? builder.databaseId : FirestoreDefaults.INSTANCE.getDatabaseId();
        this.channelProvider = builder.channelProvider == null ? ((channelConfigurator = this.traceUtil.getChannelConfigurator()) == null ? GrpcTransportOptions.setUpChannelProvider((InstantiatingGrpcChannelProvider.Builder)FirestoreSettings.defaultGrpcTransportProviderBuilder(), (ServiceOptions)this) : GrpcTransportOptions.setUpChannelProvider((InstantiatingGrpcChannelProvider.Builder)FirestoreSettings.defaultGrpcTransportProviderBuilder().setChannelConfigurator(channelConfigurator), (ServiceOptions)this)) : builder.channelProvider;
        this.credentialsProvider = builder.credentialsProvider != null ? builder.credentialsProvider : GrpcTransportOptions.setUpCredentialsProvider((ServiceOptions)this);
        this.emulatorHost = builder.emulatorHost;
    }

    @Nonnull
    public static GrpcTransportOptions.Builder getDefaultTransportOptionsBuilder() {
        return GrpcTransportOptions.newBuilder();
    }

    @Nonnull
    public static InstantiatingGrpcChannelProvider.Builder getDefaultTransportChannelProviderBuilder() {
        return FirestoreSettings.defaultGrpcTransportProviderBuilder();
    }

    @Nonnull
    public static GoogleCredentialsProvider.Builder getDefaultCredentialsProviderBuilder() {
        return FirestoreSettings.defaultCredentialsProviderBuilder();
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    FirestoreRpc getFirestoreRpc() {
        return (FirestoreRpc)this.getRpc();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FirestoreOptions that = (FirestoreOptions)((Object)o);
        return Objects.equals(this.databaseId, that.databaseId) && Objects.equals(this.channelProvider, that.channelProvider) && this.baseEquals(that);
    }

    public int hashCode() {
        return Objects.hash(this.databaseId, this.channelProvider, this.baseHashCode());
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends ServiceOptions.Builder<Firestore, FirestoreOptions, Builder> {
        @Nullable
        private String databaseId = null;
        @Nullable
        private TransportChannelProvider channelProvider = null;
        @Nullable
        private CredentialsProvider credentialsProvider = null;
        @Nullable
        private String emulatorHost = null;
        @Nullable
        private FirestoreOpenTelemetryOptions openTelemetryOptions = null;

        private Builder() {
        }

        private Builder(FirestoreOptions options) {
            super((ServiceOptions)options);
            this.databaseId = options.databaseId;
            this.channelProvider = options.channelProvider;
            this.credentialsProvider = options.credentialsProvider;
            this.emulatorHost = options.emulatorHost;
            this.openTelemetryOptions = options.openTelemetryOptions;
        }

        @Nonnull
        public Builder setTransportOptions(@Nonnull TransportOptions transportOptions) {
            if (!(transportOptions instanceof GrpcTransportOptions)) {
                throw new IllegalArgumentException("Only GRPC transport is allowed for Firestore.");
            }
            super.setTransportOptions(transportOptions);
            return this;
        }

        @Nonnull
        public Builder setChannelProvider(@Nonnull TransportChannelProvider channelProvider) {
            if (!(channelProvider instanceof InstantiatingGrpcChannelProvider)) {
                throw new IllegalArgumentException("Only GRPC channels are allowed for Firestore.");
            }
            this.channelProvider = channelProvider;
            return this;
        }

        @Nonnull
        public Builder setCredentialsProvider(@Nonnull CredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public Builder setEmulatorHost(@Nonnull String emulatorHost) {
            this.emulatorHost = emulatorHost;
            return this;
        }

        public Builder setDatabaseId(@Nonnull String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        @BetaApi
        @Nonnull
        public Builder setOpenTelemetryOptions(@Nonnull FirestoreOpenTelemetryOptions openTelemetryOptions) {
            this.openTelemetryOptions = openTelemetryOptions;
            return this;
        }

        @Nonnull
        public FirestoreOptions build() {
            if (this.credentials == null && this.credentialsProvider != null) {
                try {
                    this.setCredentials(this.credentialsProvider.getCredentials());
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to obtain credentials", e);
                }
            }
            if (this.openTelemetryOptions == null) {
                this.setOpenTelemetryOptions(FirestoreOpenTelemetryOptions.newBuilder().build());
            }
            if (this.emulatorHost == null) {
                this.emulatorHost = System.getenv(FirestoreOptions.FIRESTORE_EMULATOR_SYSTEM_VARIABLE);
            }
            if (this.emulatorHost != null) {
                try {
                    String hostUrlString = "http://" + this.emulatorHost;
                    URI.create(hostUrlString);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Value: '" + this.emulatorHost + "' for property FIRESTORE_EMULATOR_HOST is not a valid host", e);
                }
                this.setChannelProvider((TransportChannelProvider)InstantiatingGrpcChannelProvider.newBuilder().setEndpoint(this.emulatorHost).setChannelConfigurator(ManagedChannelBuilder::usePlaintext).build());
                this.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)new EmulatorCredentials()));
            }
            return new FirestoreOptions(this);
        }
    }

    private static class FirestoreDefaults
    implements ServiceDefaults<Firestore, FirestoreOptions> {
        private static final FirestoreDefaults INSTANCE = new FirestoreDefaults();
        private final String HOST = FirestoreSettings.getDefaultEndpoint();
        private final String DATABASE_ID = "(default)";
        private final TransportOptions TRANSPORT_OPTIONS = FirestoreOptions.getDefaultTransportOptionsBuilder().build();

        private FirestoreDefaults() {
        }

        @Nonnull
        String getHost() {
            return this.HOST;
        }

        @Nonnull
        String getDatabaseId() {
            return "(default)";
        }

        @Nonnull
        public FirestoreFactory getDefaultServiceFactory() {
            return DefaultFirestoreFactory.INSTANCE;
        }

        @Nonnull
        public FirestoreRpcFactory getDefaultRpcFactory() {
            return DefaultFirestoreRpcFactory.INSTANCE;
        }

        @Nonnull
        public TransportOptions getDefaultTransportOptions() {
            return this.TRANSPORT_OPTIONS;
        }
    }

    public static class EmulatorCredentials
    extends Credentials {
        private final Map<String, List<String>> HEADERS = ImmutableMap.of((Object)"Authorization", Collections.singletonList("Bearer owner"));

        public String getAuthenticationType() {
            throw new IllegalArgumentException("Not supported");
        }

        public Map<String, List<String>> getRequestMetadata(URI uri) {
            return this.HEADERS;
        }

        public boolean hasRequestMetadata() {
            return true;
        }

        public boolean hasRequestMetadataOnly() {
            return true;
        }

        public void refresh() {
        }
    }

    public static class DefaultFirestoreRpcFactory
    implements FirestoreRpcFactory {
        private static final FirestoreRpcFactory INSTANCE = new DefaultFirestoreRpcFactory();

        @Nonnull
        public FirestoreRpc create(@Nonnull FirestoreOptions options) {
            try {
                return new GrpcFirestoreRpc(options);
            }
            catch (IOException e) {
                throw FirestoreException.forIOException(e, false);
            }
        }
    }

    public static class DefaultFirestoreFactory
    implements FirestoreFactory {
        private static final FirestoreFactory INSTANCE = new DefaultFirestoreFactory();

        @Nonnull
        public Firestore create(@Nonnull FirestoreOptions options) {
            return new FirestoreImpl(options);
        }
    }
}

