/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.CustomClassMapper;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.UserDataConverter;
import com.google.common.base.Preconditions;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.DocumentTransform;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class FieldValue {
    private static final FieldValue SERVER_TIMESTAMP_SENTINEL = new FieldValue(){

        @Override
        boolean includeInDocumentMask() {
            return false;
        }

        @Override
        boolean includeInDocumentTransform() {
            return true;
        }

        @Override
        String getMethodName() {
            return "FieldValue.serverTimestamp()";
        }

        @Override
        DocumentTransform.FieldTransform toProto(FieldPath path) {
            DocumentTransform.FieldTransform.Builder fieldTransform = DocumentTransform.FieldTransform.newBuilder();
            fieldTransform.setFieldPath(path.getEncodedPath());
            fieldTransform.setSetToServerValue(DocumentTransform.FieldTransform.ServerValue.REQUEST_TIME);
            return fieldTransform.build();
        }
    };
    static final FieldValue DELETE_SENTINEL = new FieldValue(){

        @Override
        boolean includeInDocumentMask() {
            return true;
        }

        @Override
        boolean includeInDocumentTransform() {
            return false;
        }

        @Override
        String getMethodName() {
            return "FieldValue.delete()";
        }

        @Override
        DocumentTransform.FieldTransform toProto(FieldPath path) {
            throw new IllegalStateException("FieldValue.delete() should not be included in a FieldTransform");
        }
    };

    private FieldValue() {
    }

    @Nonnull
    public static FieldValue serverTimestamp() {
        return SERVER_TIMESTAMP_SENTINEL;
    }

    @Nonnull
    public static FieldValue delete() {
        return DELETE_SENTINEL;
    }

    @Nonnull
    public static FieldValue increment(long l) {
        return new NumericIncrementFieldValue(l);
    }

    @Nonnull
    public static FieldValue increment(double d) {
        return new NumericIncrementFieldValue(d);
    }

    @Nonnull
    public static FieldValue arrayUnion(Object ... elements) {
        Preconditions.checkArgument((elements.length > 0 ? 1 : 0) != 0, (Object)"arrayUnion() expects at least 1 element");
        return new ArrayUnionFieldValue(Arrays.asList(elements));
    }

    @Nonnull
    public static FieldValue arrayRemove(Object ... elements) {
        Preconditions.checkArgument((elements.length > 0 ? 1 : 0) != 0, (Object)"arrayRemove() expects at least 1 element");
        return new ArrayRemoveFieldValue(Arrays.asList(elements));
    }

    abstract boolean includeInDocumentMask();

    abstract boolean includeInDocumentTransform();

    abstract String getMethodName();

    abstract DocumentTransform.FieldTransform toProto(FieldPath var1);

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return super.hashCode();
    }

    static class NumericIncrementFieldValue
    extends FieldValue {
        final Number operand;

        NumericIncrementFieldValue(Number operand) {
            this.operand = operand;
        }

        @Override
        boolean includeInDocumentMask() {
            return false;
        }

        @Override
        boolean includeInDocumentTransform() {
            return true;
        }

        @Override
        String getMethodName() {
            return "FieldValue.increment()";
        }

        @Override
        DocumentTransform.FieldTransform toProto(FieldPath path) {
            DocumentTransform.FieldTransform.Builder fieldTransform = DocumentTransform.FieldTransform.newBuilder();
            fieldTransform.setFieldPath(path.getEncodedPath());
            fieldTransform.setIncrement(UserDataConverter.encodeValue(path, this.operand, UserDataConverter.ARGUMENT));
            return fieldTransform.build();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NumericIncrementFieldValue that = (NumericIncrementFieldValue)o;
            return Objects.equals(this.operand, that.operand);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.operand);
        }
    }

    static class ArrayUnionFieldValue
    extends FieldValue {
        final List<Object> elements;

        ArrayUnionFieldValue(List<Object> elements) {
            this.elements = elements;
        }

        @Override
        boolean includeInDocumentMask() {
            return false;
        }

        @Override
        boolean includeInDocumentTransform() {
            return true;
        }

        @Override
        String getMethodName() {
            return "FieldValue.arrayUnion()";
        }

        @Override
        DocumentTransform.FieldTransform toProto(FieldPath path) {
            ArrayValue.Builder encodedElements = ArrayValue.newBuilder();
            for (Object element : this.elements) {
                Object data = CustomClassMapper.convertToPlainJavaTypes(element);
                encodedElements.addValues(UserDataConverter.encodeValue(path, data, UserDataConverter.ARGUMENT));
            }
            DocumentTransform.FieldTransform.Builder fieldTransform = DocumentTransform.FieldTransform.newBuilder();
            fieldTransform.setFieldPath(path.getEncodedPath());
            fieldTransform.setAppendMissingElements(encodedElements);
            return fieldTransform.build();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArrayUnionFieldValue that = (ArrayUnionFieldValue)o;
            return Objects.equals(this.elements, that.elements);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.elements);
        }
    }

    static class ArrayRemoveFieldValue
    extends FieldValue {
        final List<Object> elements;

        ArrayRemoveFieldValue(List<Object> elements) {
            this.elements = elements;
        }

        @Override
        boolean includeInDocumentMask() {
            return false;
        }

        @Override
        boolean includeInDocumentTransform() {
            return true;
        }

        @Override
        String getMethodName() {
            return "FieldValue.arrayRemove()";
        }

        @Override
        DocumentTransform.FieldTransform toProto(FieldPath path) {
            ArrayValue.Builder encodedElements = ArrayValue.newBuilder();
            for (Object element : this.elements) {
                Object data = CustomClassMapper.convertToPlainJavaTypes(element);
                encodedElements.addValues(UserDataConverter.encodeValue(path, data, UserDataConverter.ARGUMENT));
            }
            DocumentTransform.FieldTransform.Builder fieldTransform = DocumentTransform.FieldTransform.newBuilder();
            fieldTransform.setFieldPath(path.getEncodedPath());
            fieldTransform.setRemoveAllFromArray(encodedElements);
            return fieldTransform.build();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArrayRemoveFieldValue that = (ArrayRemoveFieldValue)o;
            return Objects.equals(this.elements, that.elements);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.elements);
        }
    }
}

