/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalExtensionOnly;
import com.google.cloud.firestore.BasePath;
import com.google.cloud.firestore.CustomClassMapper;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.DocumentTransform;
import com.google.cloud.firestore.FieldMask;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FieldValue;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.Precondition;
import com.google.cloud.firestore.SetOptions;
import com.google.cloud.firestore.UserDataConverter;
import com.google.cloud.firestore.WriteResult;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.Write;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Tracing;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalExtensionOnly
public abstract class UpdateBuilder<T> {
    final FirestoreImpl firestore;
    private final List<WriteOperation> writes = new ArrayList<WriteOperation>();
    protected volatile boolean committed;

    UpdateBuilder(FirestoreImpl firestore) {
        this.firestore = firestore;
    }

    abstract T wrapResult(int var1);

    private static Map<String, Object> expandObject(Map<FieldPath, Object> data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        TreeSet<FieldPath> sortedFields = new TreeSet<FieldPath>(data.keySet());
        BasePath lastField = null;
        for (FieldPath field : sortedFields) {
            if (lastField != null && lastField.isPrefixOf(field)) {
                throw new IllegalArgumentException(String.format("Detected ambiguous definition for field '%s'.", lastField));
            }
            ImmutableList<String> segments = field.getSegments();
            Object value = data.get(field);
            Map<String, Object> currentMap = result;
            for (int i = 0; i < segments.size(); ++i) {
                if (i == segments.size() - 1) {
                    currentMap.put((String)segments.get(i), value);
                    continue;
                }
                if (!currentMap.containsKey(segments.get(i))) {
                    currentMap.put((String)segments.get(i), new HashMap());
                }
                currentMap = (Map)currentMap.get(segments.get(i));
            }
            lastField = field;
        }
        return result;
    }

    @Nonnull
    public T create(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields) {
        return this.performCreate(documentReference, fields);
    }

    private T performCreate(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields) {
        Tracing.getTracer().getCurrentSpan().addAnnotation("CloudFirestoreOperation.CreateDocument");
        DocumentSnapshot documentSnapshot = DocumentSnapshot.fromObject(this.firestore, documentReference, fields, UserDataConverter.NO_DELETES);
        DocumentTransform documentTransform = DocumentTransform.fromFieldPathMap(documentReference, UpdateBuilder.convertToFieldPaths(fields, false));
        Write.Builder write = documentSnapshot.toPb();
        write.setCurrentDocument(Precondition.exists(false).toPb());
        if (!documentTransform.isEmpty()) {
            write.addAllUpdateTransforms(documentTransform.toPb());
        }
        return this.addWrite(documentReference, write);
    }

    @Nonnull
    public T create(@Nonnull DocumentReference documentReference, @Nonnull Object pojo) {
        Object data = CustomClassMapper.convertToPlainJavaTypes(pojo);
        if (!(data instanceof Map)) {
            throw FirestoreException.forInvalidArgument("Can't set a document's data to an array or primitive", new Object[0]);
        }
        return this.performCreate(documentReference, (Map)data);
    }

    @Nonnull
    public T set(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields) {
        return this.set(documentReference, fields, SetOptions.OVERWRITE);
    }

    @Nonnull
    public T set(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields, @Nonnull SetOptions options) {
        return this.performSet(documentReference, fields, options);
    }

    @Nonnull
    public T set(@Nonnull DocumentReference documentReference, @Nonnull Object pojo) {
        return this.set(documentReference, pojo, SetOptions.OVERWRITE);
    }

    @Nonnull
    public T set(@Nonnull DocumentReference documentReference, @Nonnull Object pojo, @Nonnull SetOptions options) {
        Object data = CustomClassMapper.convertToPlainJavaTypes(pojo);
        if (!(data instanceof Map)) {
            throw new IllegalArgumentException("Can't set a document's data to an array or primitive");
        }
        return this.performSet(documentReference, (Map)data, options);
    }

    private T performSet(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields, @Nonnull SetOptions options) {
        Map<FieldPath, Object> documentData = options.getFieldMask() != null ? UpdateBuilder.applyFieldMask(fields, options.getFieldMask()) : UpdateBuilder.convertToFieldPaths(fields, false);
        DocumentSnapshot documentSnapshot = DocumentSnapshot.fromObject(this.firestore, documentReference, UpdateBuilder.expandObject(documentData), options.getEncodingOptions());
        FieldMask documentMask = FieldMask.EMPTY_MASK;
        DocumentTransform documentTransform = DocumentTransform.fromFieldPathMap(documentReference, documentData);
        if (options.getFieldMask() != null) {
            TreeSet fieldPaths = options.getFieldMask().stream().filter(Predicates.not(documentTransform.getFields()::contains)).collect(Collectors.toCollection(TreeSet::new));
            documentMask = new FieldMask(fieldPaths);
        } else if (options.isMerge()) {
            documentMask = FieldMask.fromObject(fields);
        }
        Write.Builder write = documentSnapshot.toPb();
        if (!documentTransform.isEmpty()) {
            write.addAllUpdateTransforms(documentTransform.toPb());
        }
        if (options.isMerge() || options.getFieldMask() != null) {
            write.setUpdateMask(documentMask.toPb());
        }
        return this.addWrite(documentReference, write);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T addWrite(DocumentReference documentReference, Write.Builder write) {
        int writeIndex;
        WriteOperation operation = new WriteOperation(documentReference, write.build());
        List<WriteOperation> list = this.writes;
        synchronized (list) {
            Preconditions.checkState((!this.committed ? 1 : 0) != 0, (Object)String.format("Cannot modify a %s that has already been committed.", this.getClass().getSimpleName()));
            this.writes.add(operation);
            writeIndex = this.writes.size() - 1;
        }
        return this.wrapResult(writeIndex);
    }

    private static Map<FieldPath, Object> applyFieldMask(Map<String, Object> fields, List<FieldPath> fieldMask) {
        HashSet<FieldPath> remainingFields = new HashSet<FieldPath>(fieldMask);
        Map<FieldPath, Object> filteredData = UpdateBuilder.applyFieldMask(fields, remainingFields, FieldPath.empty());
        if (!remainingFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("Field masks contains invalid path. No data exist at field '%s'.", remainingFields.iterator().next()));
        }
        return filteredData;
    }

    private static Map<FieldPath, Object> applyFieldMask(Map<String, Object> fields, Set<FieldPath> fieldMask, FieldPath root) {
        HashMap<FieldPath, Object> filteredMap = new HashMap<FieldPath, Object>();
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            FieldPath currentField = root.append(FieldPath.of(entry.getKey()));
            if (fieldMask.remove(currentField)) {
                filteredMap.put(currentField, entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Map) {
                filteredMap.putAll(UpdateBuilder.applyFieldMask((Map)entry.getValue(), fieldMask, currentField));
                continue;
            }
            if (entry.getValue() != FieldValue.DELETE_SENTINEL) continue;
            throw new IllegalArgumentException(String.format("Cannot specify FieldValue.delete() for non-merged field '%s'.", currentField));
        }
        return filteredMap;
    }

    private static Map<FieldPath, Object> convertToFieldPaths(@Nonnull Map<String, Object> fields, boolean splitOnDots) {
        HashMap<FieldPath, Object> fieldPaths = new HashMap<FieldPath, Object>();
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            if (splitOnDots) {
                fieldPaths.put(FieldPath.fromDotSeparatedString(entry.getKey()), entry.getValue());
                continue;
            }
            fieldPaths.put(FieldPath.of(entry.getKey()), entry.getValue());
        }
        return fieldPaths;
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields) {
        return this.performUpdate(documentReference, UpdateBuilder.convertToFieldPaths(fields, true), Precondition.exists(true));
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields, Precondition precondition) {
        Preconditions.checkArgument((!Boolean.FALSE.equals(precondition.getExists()) ? 1 : 0) != 0, (Object)"Precondition 'exists' cannot have the value 'false' for update() calls.");
        return this.performUpdate(documentReference, UpdateBuilder.convertToFieldPaths(fields, true), precondition);
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        return this.performUpdate(documentReference, Precondition.exists(true), FieldPath.fromDotSeparatedString(field), value, moreFieldsAndValues);
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        return this.performUpdate(documentReference, Precondition.exists(true), fieldPath, value, moreFieldsAndValues);
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull Precondition precondition, @Nonnull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        Preconditions.checkArgument((!Boolean.FALSE.equals(precondition.getExists()) ? 1 : 0) != 0, (Object)"Precondition 'exists' cannot have the value 'false' for update() calls.");
        return this.performUpdate(documentReference, precondition, FieldPath.fromDotSeparatedString(field), value, moreFieldsAndValues);
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull Precondition precondition, @Nonnull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        Preconditions.checkArgument((!Boolean.FALSE.equals(precondition.getExists()) ? 1 : 0) != 0, (Object)"Precondition 'exists' cannot have the value 'false' for update() calls.");
        return this.performUpdate(documentReference, precondition, fieldPath, value, moreFieldsAndValues);
    }

    private T performUpdate(@Nonnull DocumentReference documentReference, @Nonnull Precondition precondition, @Nonnull FieldPath fieldPath, @Nullable Object value, Object[] moreFieldsAndValues) {
        Object data = CustomClassMapper.convertToPlainJavaTypes(value);
        HashMap<FieldPath, Object> fields = new HashMap<FieldPath, Object>();
        fields.put(fieldPath, data);
        Preconditions.checkArgument((moreFieldsAndValues.length % 2 == 0 ? 1 : 0) != 0, (Object)"moreFieldsAndValues must be key-value pairs.");
        for (int i = 0; i < moreFieldsAndValues.length; i += 2) {
            FieldPath currentPath;
            Object objectPath = moreFieldsAndValues[i];
            Object objectValue = moreFieldsAndValues[i + 1];
            if (objectPath instanceof String) {
                currentPath = FieldPath.fromDotSeparatedString((String)objectPath);
            } else if (objectPath instanceof FieldPath) {
                currentPath = (FieldPath)objectPath;
            } else {
                throw new IllegalArgumentException("Field '" + objectPath + "' is not of type String or Field Path.");
            }
            if (fields.containsKey(currentPath)) {
                throw new IllegalArgumentException("Field value for field '" + objectPath + "' was specified multiple times.");
            }
            fields.put(currentPath, objectValue);
        }
        return this.performUpdate(documentReference, fields, precondition);
    }

    private T performUpdate(@Nonnull DocumentReference documentReference, final @Nonnull Map<FieldPath, Object> fields, @Nonnull Precondition precondition) {
        Preconditions.checkArgument((!fields.isEmpty() ? 1 : 0) != 0, (Object)"Data for update() cannot be empty.");
        Tracing.getTracer().getCurrentSpan().addAnnotation("CloudFirestoreOperation.UpdateDocument");
        Map<String, Object> deconstructedMap = UpdateBuilder.expandObject(fields);
        DocumentSnapshot documentSnapshot = DocumentSnapshot.fromObject(this.firestore, documentReference, deconstructedMap, new UserDataConverter.EncodingOptions(){

            @Override
            public boolean allowDelete(FieldPath fieldPath) {
                return fields.containsKey(fieldPath);
            }

            @Override
            public boolean allowTransform() {
                return true;
            }
        });
        DocumentTransform documentTransform = DocumentTransform.fromFieldPathMap(documentReference, fields);
        TreeSet fieldPaths = fields.keySet().stream().filter(Predicates.not(documentTransform.getFields()::contains)).collect(Collectors.toCollection(TreeSet::new));
        FieldMask fieldMask = new FieldMask(fieldPaths);
        Write.Builder write = documentSnapshot.toPb();
        write.setCurrentDocument(precondition.toPb());
        write.setUpdateMask(fieldMask.toPb());
        if (!documentTransform.isEmpty()) {
            write.addAllUpdateTransforms(documentTransform.toPb());
        }
        return this.addWrite(documentReference, write);
    }

    @Nonnull
    public T delete(@Nonnull DocumentReference documentReference, @Nonnull Precondition precondition) {
        return this.performDelete(documentReference, precondition);
    }

    @Nonnull
    public T delete(@Nonnull DocumentReference documentReference) {
        return this.performDelete(documentReference, Precondition.NONE);
    }

    private T performDelete(@Nonnull DocumentReference documentReference, @Nonnull Precondition precondition) {
        Tracing.getTracer().getCurrentSpan().addAnnotation("CloudFirestoreOperation.DeleteDocument");
        Write.Builder write = Write.newBuilder().setDelete(documentReference.getName());
        if (!precondition.isEmpty()) {
            write.setCurrentDocument(precondition.toPb());
        }
        return this.addWrite(documentReference, write);
    }

    ApiFuture<List<WriteResult>> commit(@Nullable ByteString transactionId) {
        this.committed = true;
        CommitRequest request = this.buildCommitRequest(transactionId);
        Tracing.getTracer().getCurrentSpan().addAnnotation("CloudFirestoreOperation.Commit", (Map)ImmutableMap.of((Object)"numDocuments", (Object)AttributeValue.longAttributeValue((long)request.getWritesCount())));
        ApiFuture<CommitResponse> response = this.firestore.sendRequest(request, this.firestore.getClient().commitCallable());
        return ApiFutures.transform(response, commitResponse -> {
            Timestamp commitTime = commitResponse.getCommitTime();
            return commitResponse.getWriteResultsList().stream().map(writeResult -> WriteResult.fromProto(writeResult, commitTime)).collect(Collectors.toList());
        }, (Executor)MoreExecutors.directExecutor());
    }

    private CommitRequest buildCommitRequest(ByteString transactionId) {
        CommitRequest.Builder builder = CommitRequest.newBuilder();
        builder.setDatabase(this.firestore.getDatabaseName());
        this.forEachWrite(arg_0 -> ((CommitRequest.Builder)builder).addWrites(arg_0));
        if (transactionId != null) {
            builder.setTransaction(transactionId);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEmpty() {
        List<WriteOperation> list = this.writes;
        synchronized (list) {
            return this.writes.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forEachWrite(Consumer<Write> consumer) {
        List<WriteOperation> list = this.writes;
        synchronized (list) {
            for (WriteOperation writeOperation : this.writes) {
                consumer.accept(writeOperation.write);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMutationsSize() {
        List<WriteOperation> list = this.writes;
        synchronized (list) {
            return this.writes.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String writesAsString;
        List<WriteOperation> list = this.writes;
        synchronized (list) {
            writesAsString = this.writes.toString();
        }
        return String.format("%s{writes=%s, committed=%s}", this.getClass().getSimpleName(), writesAsString, this.committed);
    }

    static final class WriteOperation {
        final Write write;
        final DocumentReference documentReference;

        WriteOperation(DocumentReference documentReference, Write write) {
            this.documentReference = documentReference;
            this.write = write;
        }

        public String toString() {
            return String.format("WriteOperation{write=%s, doc=%s}", this.write, this.documentReference);
        }
    }
}

