/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiAsyncFunction;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.BatchWriteResult;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.UpdateBuilder;
import com.google.cloud.firestore.WriteResult;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firestore.v1.BatchWriteRequest;
import com.google.firestore.v1.BatchWriteResponse;
import com.google.rpc.Status;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Tracing;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;

class BulkCommitBatch
extends UpdateBuilder<ApiFuture<WriteResult>> {
    private BatchState state = BatchState.OPEN;
    private final List<SettableApiFuture<BatchWriteResult>> pendingOperations = new ArrayList<SettableApiFuture<BatchWriteResult>>();
    private final Set<DocumentReference> documents = new CopyOnWriteArraySet<DocumentReference>();
    private final int maxBatchSize;

    BulkCommitBatch(FirestoreImpl firestore, int maxBatchSize) {
        super(firestore);
        this.maxBatchSize = maxBatchSize;
    }

    @Override
    boolean isCommitted() {
        return this.state == BatchState.SENT;
    }

    @Override
    ApiFuture<WriteResult> wrapResult(DocumentReference documentReference) {
        return this.processLastOperation(documentReference);
    }

    ApiFuture<List<BatchWriteResult>> bulkCommit() {
        Tracing.getTracer().getCurrentSpan().addAnnotation("CloudFirestoreOperation.BatchWrite", (Map)ImmutableMap.of((Object)"numDocuments", (Object)AttributeValue.longAttributeValue((long)this.getWrites().size())));
        Preconditions.checkState((boolean)this.isReadyToSend(), (Object)"The batch should be marked as READY_TO_SEND before committing");
        this.state = BatchState.SENT;
        BatchWriteRequest.Builder request = BatchWriteRequest.newBuilder();
        request.setDatabase(this.firestore.getDatabaseName());
        for (UpdateBuilder.WriteOperation writeOperation : this.getWrites()) {
            request.addWrites(writeOperation.write);
        }
        ApiFuture<BatchWriteResponse> response = this.firestore.sendRequest(request.build(), this.firestore.getClient().batchWriteCallable());
        return ApiFutures.transform(response, (ApiFunction)new ApiFunction<BatchWriteResponse, List<BatchWriteResult>>(){

            public List<BatchWriteResult> apply(BatchWriteResponse batchWriteResponse) {
                List writeResults = batchWriteResponse.getWriteResultsList();
                List statuses = batchWriteResponse.getStatusList();
                ArrayList<BatchWriteResult> result = new ArrayList<BatchWriteResult>();
                for (int i = 0; i < writeResults.size(); ++i) {
                    com.google.firestore.v1.WriteResult writeResult = (com.google.firestore.v1.WriteResult)writeResults.get(i);
                    Status status = (Status)statuses.get(i);
                    io.grpc.Status code = io.grpc.Status.fromCodeValue((int)status.getCode());
                    Timestamp updateTime = null;
                    FirestoreException exception = null;
                    if (code == io.grpc.Status.OK) {
                        updateTime = Timestamp.fromProto((com.google.protobuf.Timestamp)writeResult.getUpdateTime());
                    } else {
                        exception = FirestoreException.forServerRejection(code, status.getMessage(), new Object[0]);
                    }
                    result.add(new BatchWriteResult(updateTime, (Exception)((Object)exception)));
                }
                return result;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    int getPendingOperationCount() {
        return this.pendingOperations.size();
    }

    ApiFuture<WriteResult> processLastOperation(DocumentReference documentReference) {
        Preconditions.checkState((!this.documents.contains(documentReference) ? 1 : 0) != 0, (Object)"Batch should not contain writes to the same document");
        this.documents.add(documentReference);
        Preconditions.checkState((this.state == BatchState.OPEN ? 1 : 0) != 0, (Object)"Batch should be OPEN when adding writes");
        SettableApiFuture resultFuture = SettableApiFuture.create();
        this.pendingOperations.add((SettableApiFuture<BatchWriteResult>)resultFuture);
        if (this.getPendingOperationCount() == this.maxBatchSize) {
            this.state = BatchState.READY_TO_SEND;
        }
        return ApiFutures.transformAsync((ApiFuture)resultFuture, (ApiAsyncFunction)new ApiAsyncFunction<BatchWriteResult, WriteResult>(){

            public ApiFuture<WriteResult> apply(BatchWriteResult batchWriteResult) throws Exception {
                if (batchWriteResult.getException() == null) {
                    return ApiFutures.immediateFuture((Object)new WriteResult(batchWriteResult.getWriteTime()));
                }
                throw batchWriteResult.getException();
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    void processResults(List<BatchWriteResult> results) {
        for (int i = 0; i < results.size(); ++i) {
            SettableApiFuture<BatchWriteResult> resultFuture = this.pendingOperations.get(i);
            BatchWriteResult result = results.get(i);
            if (result.getException() == null) {
                resultFuture.set((Object)result);
                continue;
            }
            resultFuture.setException((Throwable)result.getException());
        }
    }

    void markReadyToSend() {
        if (this.state == BatchState.OPEN) {
            this.state = BatchState.READY_TO_SEND;
        }
    }

    boolean isOpen() {
        return this.state == BatchState.OPEN;
    }

    boolean isReadyToSend() {
        return this.state == BatchState.READY_TO_SEND;
    }

    boolean has(DocumentReference documentReference) {
        return this.documents.contains(documentReference);
    }

    static enum BatchState {
        OPEN,
        READY_TO_SEND,
        SENT;

    }
}

