/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.v1.FirestoreAdminSettings;
import com.google.cloud.firestore.v1.stub.FirestoreAdminStub;
import com.google.cloud.firestore.v1.stub.FirestoreAdminStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firestore.admin.v1.CreateIndexRequest;
import com.google.firestore.admin.v1.DatabaseName;
import com.google.firestore.admin.v1.DeleteIndexRequest;
import com.google.firestore.admin.v1.ExportDocumentsRequest;
import com.google.firestore.admin.v1.Field;
import com.google.firestore.admin.v1.FieldName;
import com.google.firestore.admin.v1.GetFieldRequest;
import com.google.firestore.admin.v1.GetIndexRequest;
import com.google.firestore.admin.v1.ImportDocumentsRequest;
import com.google.firestore.admin.v1.Index;
import com.google.firestore.admin.v1.IndexName;
import com.google.firestore.admin.v1.ListFieldsRequest;
import com.google.firestore.admin.v1.ListFieldsResponse;
import com.google.firestore.admin.v1.ListIndexesRequest;
import com.google.firestore.admin.v1.ListIndexesResponse;
import com.google.firestore.admin.v1.UpdateFieldRequest;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class FirestoreAdminClient
implements BackgroundResource {
    private final FirestoreAdminSettings settings;
    private final FirestoreAdminStub stub;

    public static final FirestoreAdminClient create() throws IOException {
        return FirestoreAdminClient.create(FirestoreAdminSettings.newBuilder().build());
    }

    public static final FirestoreAdminClient create(FirestoreAdminSettings settings) throws IOException {
        return new FirestoreAdminClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final FirestoreAdminClient create(FirestoreAdminStub stub) {
        return new FirestoreAdminClient(stub);
    }

    protected FirestoreAdminClient(FirestoreAdminSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FirestoreAdminStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected FirestoreAdminClient(FirestoreAdminStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final FirestoreAdminSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public FirestoreAdminStub getStub() {
        return this.stub;
    }

    public final Operation createIndex(String parent, Index index) {
        CreateIndexRequest request = CreateIndexRequest.newBuilder().setParent(parent).setIndex(index).build();
        return this.createIndex(request);
    }

    public final Operation createIndex(CreateIndexRequest request) {
        return (Operation)this.createIndexCallable().call((Object)request);
    }

    public final UnaryCallable<CreateIndexRequest, Operation> createIndexCallable() {
        return this.stub.createIndexCallable();
    }

    public final ListIndexesPagedResponse listIndexes(String parent) {
        ListIndexesRequest request = ListIndexesRequest.newBuilder().setParent(parent).build();
        return this.listIndexes(request);
    }

    public final ListIndexesPagedResponse listIndexes(ListIndexesRequest request) {
        return (ListIndexesPagedResponse)((Object)this.listIndexesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListIndexesRequest, ListIndexesPagedResponse> listIndexesPagedCallable() {
        return this.stub.listIndexesPagedCallable();
    }

    public final UnaryCallable<ListIndexesRequest, ListIndexesResponse> listIndexesCallable() {
        return this.stub.listIndexesCallable();
    }

    public final Index getIndex(IndexName name) {
        GetIndexRequest request = GetIndexRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getIndex(request);
    }

    public final Index getIndex(String name) {
        GetIndexRequest request = GetIndexRequest.newBuilder().setName(name).build();
        return this.getIndex(request);
    }

    public final Index getIndex(GetIndexRequest request) {
        return (Index)this.getIndexCallable().call((Object)request);
    }

    public final UnaryCallable<GetIndexRequest, Index> getIndexCallable() {
        return this.stub.getIndexCallable();
    }

    public final void deleteIndex(IndexName name) {
        DeleteIndexRequest request = DeleteIndexRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteIndex(request);
    }

    public final void deleteIndex(String name) {
        DeleteIndexRequest request = DeleteIndexRequest.newBuilder().setName(name).build();
        this.deleteIndex(request);
    }

    public final void deleteIndex(DeleteIndexRequest request) {
        this.deleteIndexCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteIndexRequest, Empty> deleteIndexCallable() {
        return this.stub.deleteIndexCallable();
    }

    public final Operation importDocuments(DatabaseName name) {
        ImportDocumentsRequest request = ImportDocumentsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.importDocuments(request);
    }

    public final Operation importDocuments(String name) {
        ImportDocumentsRequest request = ImportDocumentsRequest.newBuilder().setName(name).build();
        return this.importDocuments(request);
    }

    public final Operation importDocuments(ImportDocumentsRequest request) {
        return (Operation)this.importDocumentsCallable().call((Object)request);
    }

    public final UnaryCallable<ImportDocumentsRequest, Operation> importDocumentsCallable() {
        return this.stub.importDocumentsCallable();
    }

    public final Operation exportDocuments(DatabaseName name) {
        ExportDocumentsRequest request = ExportDocumentsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.exportDocuments(request);
    }

    public final Operation exportDocuments(String name) {
        ExportDocumentsRequest request = ExportDocumentsRequest.newBuilder().setName(name).build();
        return this.exportDocuments(request);
    }

    public final Operation exportDocuments(ExportDocumentsRequest request) {
        return (Operation)this.exportDocumentsCallable().call((Object)request);
    }

    public final UnaryCallable<ExportDocumentsRequest, Operation> exportDocumentsCallable() {
        return this.stub.exportDocumentsCallable();
    }

    public final Field getField(FieldName name) {
        GetFieldRequest request = GetFieldRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getField(request);
    }

    public final Field getField(String name) {
        GetFieldRequest request = GetFieldRequest.newBuilder().setName(name).build();
        return this.getField(request);
    }

    public final Field getField(GetFieldRequest request) {
        return (Field)this.getFieldCallable().call((Object)request);
    }

    public final UnaryCallable<GetFieldRequest, Field> getFieldCallable() {
        return this.stub.getFieldCallable();
    }

    public final ListFieldsPagedResponse listFields(String parent) {
        ListFieldsRequest request = ListFieldsRequest.newBuilder().setParent(parent).build();
        return this.listFields(request);
    }

    public final ListFieldsPagedResponse listFields(ListFieldsRequest request) {
        return (ListFieldsPagedResponse)((Object)this.listFieldsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFieldsRequest, ListFieldsPagedResponse> listFieldsPagedCallable() {
        return this.stub.listFieldsPagedCallable();
    }

    public final UnaryCallable<ListFieldsRequest, ListFieldsResponse> listFieldsCallable() {
        return this.stub.listFieldsCallable();
    }

    public final Operation updateField(Field field) {
        UpdateFieldRequest request = UpdateFieldRequest.newBuilder().setField(field).build();
        return this.updateField(request);
    }

    public final Operation updateField(UpdateFieldRequest request) {
        return (Operation)this.updateFieldCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateFieldRequest, Operation> updateFieldCallable() {
        return this.stub.updateFieldCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFieldsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFieldsRequest, ListFieldsResponse, Field, ListFieldsPage, ListFieldsFixedSizeCollection> {
        private ListFieldsFixedSizeCollection(List<ListFieldsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFieldsFixedSizeCollection createEmptyCollection() {
            return new ListFieldsFixedSizeCollection(null, 0);
        }

        protected ListFieldsFixedSizeCollection createCollection(List<ListFieldsPage> pages, int collectionSize) {
            return new ListFieldsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFieldsPage
    extends AbstractPage<ListFieldsRequest, ListFieldsResponse, Field, ListFieldsPage> {
        private ListFieldsPage(PageContext<ListFieldsRequest, ListFieldsResponse, Field> context, ListFieldsResponse response) {
            super(context, (Object)response);
        }

        private static ListFieldsPage createEmptyPage() {
            return new ListFieldsPage(null, null);
        }

        protected ListFieldsPage createPage(PageContext<ListFieldsRequest, ListFieldsResponse, Field> context, ListFieldsResponse response) {
            return new ListFieldsPage(context, response);
        }

        public ApiFuture<ListFieldsPage> createPageAsync(PageContext<ListFieldsRequest, ListFieldsResponse, Field> context, ApiFuture<ListFieldsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFieldsPagedResponse
    extends AbstractPagedListResponse<ListFieldsRequest, ListFieldsResponse, Field, ListFieldsPage, ListFieldsFixedSizeCollection> {
        public static ApiFuture<ListFieldsPagedResponse> createAsync(PageContext<ListFieldsRequest, ListFieldsResponse, Field> context, ApiFuture<ListFieldsResponse> futureResponse) {
            ApiFuture<ListFieldsPage> futurePage = ListFieldsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListFieldsPage, ListFieldsPagedResponse>(){

                public ListFieldsPagedResponse apply(ListFieldsPage input) {
                    return new ListFieldsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListFieldsPagedResponse(ListFieldsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFieldsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListIndexesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListIndexesRequest, ListIndexesResponse, Index, ListIndexesPage, ListIndexesFixedSizeCollection> {
        private ListIndexesFixedSizeCollection(List<ListIndexesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListIndexesFixedSizeCollection createEmptyCollection() {
            return new ListIndexesFixedSizeCollection(null, 0);
        }

        protected ListIndexesFixedSizeCollection createCollection(List<ListIndexesPage> pages, int collectionSize) {
            return new ListIndexesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListIndexesPage
    extends AbstractPage<ListIndexesRequest, ListIndexesResponse, Index, ListIndexesPage> {
        private ListIndexesPage(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ListIndexesResponse response) {
            super(context, (Object)response);
        }

        private static ListIndexesPage createEmptyPage() {
            return new ListIndexesPage(null, null);
        }

        protected ListIndexesPage createPage(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ListIndexesResponse response) {
            return new ListIndexesPage(context, response);
        }

        public ApiFuture<ListIndexesPage> createPageAsync(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ApiFuture<ListIndexesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListIndexesPagedResponse
    extends AbstractPagedListResponse<ListIndexesRequest, ListIndexesResponse, Index, ListIndexesPage, ListIndexesFixedSizeCollection> {
        public static ApiFuture<ListIndexesPagedResponse> createAsync(PageContext<ListIndexesRequest, ListIndexesResponse, Index> context, ApiFuture<ListIndexesResponse> futureResponse) {
            ApiFuture<ListIndexesPage> futurePage = ListIndexesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListIndexesPage, ListIndexesPagedResponse>(){

                public ListIndexesPagedResponse apply(ListIndexesPage input) {
                    return new ListIndexesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListIndexesPagedResponse(ListIndexesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListIndexesFixedSizeCollection.createEmptyCollection());
        }
    }
}

