/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.firestore.v1beta1.FirestoreSettings;
import com.google.cloud.firestore.v1beta1.PagedResponseWrappers;
import com.google.cloud.firestore.v1beta1.stub.FirestoreStub;
import com.google.cloud.firestore.v1beta1.stub.FirestoreStubSettings;
import com.google.firestore.v1beta1.BatchGetDocumentsRequest;
import com.google.firestore.v1beta1.BatchGetDocumentsResponse;
import com.google.firestore.v1beta1.BeginTransactionRequest;
import com.google.firestore.v1beta1.BeginTransactionResponse;
import com.google.firestore.v1beta1.CommitRequest;
import com.google.firestore.v1beta1.CommitResponse;
import com.google.firestore.v1beta1.CreateDocumentRequest;
import com.google.firestore.v1beta1.DeleteDocumentRequest;
import com.google.firestore.v1beta1.Document;
import com.google.firestore.v1beta1.DocumentMask;
import com.google.firestore.v1beta1.GetDocumentRequest;
import com.google.firestore.v1beta1.ListCollectionIdsRequest;
import com.google.firestore.v1beta1.ListCollectionIdsResponse;
import com.google.firestore.v1beta1.ListDocumentsRequest;
import com.google.firestore.v1beta1.ListDocumentsResponse;
import com.google.firestore.v1beta1.ListenRequest;
import com.google.firestore.v1beta1.ListenResponse;
import com.google.firestore.v1beta1.RollbackRequest;
import com.google.firestore.v1beta1.RunQueryRequest;
import com.google.firestore.v1beta1.RunQueryResponse;
import com.google.firestore.v1beta1.UpdateDocumentRequest;
import com.google.firestore.v1beta1.Write;
import com.google.firestore.v1beta1.WriteRequest;
import com.google.firestore.v1beta1.WriteResponse;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class FirestoreClient
implements BackgroundResource {
    private final FirestoreSettings settings;
    private final FirestoreStub stub;
    private static final PathTemplate DATABASE_ROOT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/databases/{database}");
    private static final PathTemplate DOCUMENT_ROOT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/databases/{database}/documents");
    private static final PathTemplate DOCUMENT_PATH_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/databases/{database}/documents/{document_path=**}");
    private static final PathTemplate ANY_PATH_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/databases/{database}/documents/{document}/{any_path=**}");

    public static final String formatDatabaseRootName(String project, String database) {
        return DATABASE_ROOT_PATH_TEMPLATE.instantiate(new String[]{"project", project, "database", database});
    }

    public static final String formatDocumentRootName(String project, String database) {
        return DOCUMENT_ROOT_PATH_TEMPLATE.instantiate(new String[]{"project", project, "database", database});
    }

    public static final String formatDocumentPathName(String project, String database, String documentPath) {
        return DOCUMENT_PATH_PATH_TEMPLATE.instantiate(new String[]{"project", project, "database", database, "document_path", documentPath});
    }

    public static final String formatAnyPathName(String project, String database, String document, String anyPath) {
        return ANY_PATH_PATH_TEMPLATE.instantiate(new String[]{"project", project, "database", database, "document", document, "any_path", anyPath});
    }

    public static final String parseProjectFromDatabaseRootName(String databaseRootName) {
        return DATABASE_ROOT_PATH_TEMPLATE.parse(databaseRootName).get((Object)"project");
    }

    public static final String parseDatabaseFromDatabaseRootName(String databaseRootName) {
        return DATABASE_ROOT_PATH_TEMPLATE.parse(databaseRootName).get((Object)"database");
    }

    public static final String parseProjectFromDocumentRootName(String documentRootName) {
        return DOCUMENT_ROOT_PATH_TEMPLATE.parse(documentRootName).get((Object)"project");
    }

    public static final String parseDatabaseFromDocumentRootName(String documentRootName) {
        return DOCUMENT_ROOT_PATH_TEMPLATE.parse(documentRootName).get((Object)"database");
    }

    public static final String parseProjectFromDocumentPathName(String documentPathName) {
        return DOCUMENT_PATH_PATH_TEMPLATE.parse(documentPathName).get((Object)"project");
    }

    public static final String parseDatabaseFromDocumentPathName(String documentPathName) {
        return DOCUMENT_PATH_PATH_TEMPLATE.parse(documentPathName).get((Object)"database");
    }

    public static final String parseDocumentPathFromDocumentPathName(String documentPathName) {
        return DOCUMENT_PATH_PATH_TEMPLATE.parse(documentPathName).get((Object)"document_path");
    }

    public static final String parseProjectFromAnyPathName(String anyPathName) {
        return ANY_PATH_PATH_TEMPLATE.parse(anyPathName).get((Object)"project");
    }

    public static final String parseDatabaseFromAnyPathName(String anyPathName) {
        return ANY_PATH_PATH_TEMPLATE.parse(anyPathName).get((Object)"database");
    }

    public static final String parseDocumentFromAnyPathName(String anyPathName) {
        return ANY_PATH_PATH_TEMPLATE.parse(anyPathName).get((Object)"document");
    }

    public static final String parseAnyPathFromAnyPathName(String anyPathName) {
        return ANY_PATH_PATH_TEMPLATE.parse(anyPathName).get((Object)"any_path");
    }

    public static final FirestoreClient create() throws IOException {
        return FirestoreClient.create(FirestoreSettings.newBuilder().build());
    }

    public static final FirestoreClient create(FirestoreSettings settings) throws IOException {
        return new FirestoreClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final FirestoreClient create(FirestoreStub stub) {
        return new FirestoreClient(stub);
    }

    protected FirestoreClient(FirestoreSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FirestoreStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected FirestoreClient(FirestoreStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final FirestoreSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public FirestoreStub getStub() {
        return this.stub;
    }

    public final Document getDocument(GetDocumentRequest request) {
        return (Document)this.getDocumentCallable().call((Object)request);
    }

    public final UnaryCallable<GetDocumentRequest, Document> getDocumentCallable() {
        return this.stub.getDocumentCallable();
    }

    public final PagedResponseWrappers.ListDocumentsPagedResponse listDocuments(ListDocumentsRequest request) {
        return (PagedResponseWrappers.ListDocumentsPagedResponse)((Object)this.listDocumentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDocumentsRequest, PagedResponseWrappers.ListDocumentsPagedResponse> listDocumentsPagedCallable() {
        return this.stub.listDocumentsPagedCallable();
    }

    public final UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> listDocumentsCallable() {
        return this.stub.listDocumentsCallable();
    }

    public final Document createDocument(CreateDocumentRequest request) {
        return (Document)this.createDocumentCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDocumentRequest, Document> createDocumentCallable() {
        return this.stub.createDocumentCallable();
    }

    public final Document updateDocument(Document document, DocumentMask updateMask) {
        UpdateDocumentRequest request = UpdateDocumentRequest.newBuilder().setDocument(document).setUpdateMask(updateMask).build();
        return this.updateDocument(request);
    }

    public final Document updateDocument(UpdateDocumentRequest request) {
        return (Document)this.updateDocumentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDocumentRequest, Document> updateDocumentCallable() {
        return this.stub.updateDocumentCallable();
    }

    public final void deleteDocument(String name) {
        ANY_PATH_PATH_TEMPLATE.validate(name, "deleteDocument");
        DeleteDocumentRequest request = DeleteDocumentRequest.newBuilder().setName(name).build();
        this.deleteDocument(request);
    }

    public final void deleteDocument(DeleteDocumentRequest request) {
        this.deleteDocumentCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDocumentRequest, Empty> deleteDocumentCallable() {
        return this.stub.deleteDocumentCallable();
    }

    public final ServerStreamingCallable<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsCallable() {
        return this.stub.batchGetDocumentsCallable();
    }

    public final BeginTransactionResponse beginTransaction(String database) {
        DATABASE_ROOT_PATH_TEMPLATE.validate(database, "beginTransaction");
        BeginTransactionRequest request = BeginTransactionRequest.newBuilder().setDatabase(database).build();
        return this.beginTransaction(request);
    }

    public final BeginTransactionResponse beginTransaction(BeginTransactionRequest request) {
        return (BeginTransactionResponse)this.beginTransactionCallable().call((Object)request);
    }

    public final UnaryCallable<BeginTransactionRequest, BeginTransactionResponse> beginTransactionCallable() {
        return this.stub.beginTransactionCallable();
    }

    public final CommitResponse commit(String database, List<Write> writes) {
        DATABASE_ROOT_PATH_TEMPLATE.validate(database, "commit");
        CommitRequest request = CommitRequest.newBuilder().setDatabase(database).addAllWrites(writes).build();
        return this.commit(request);
    }

    public final CommitResponse commit(CommitRequest request) {
        return (CommitResponse)this.commitCallable().call((Object)request);
    }

    public final UnaryCallable<CommitRequest, CommitResponse> commitCallable() {
        return this.stub.commitCallable();
    }

    public final void rollback(String database, ByteString transaction) {
        DATABASE_ROOT_PATH_TEMPLATE.validate(database, "rollback");
        RollbackRequest request = RollbackRequest.newBuilder().setDatabase(database).setTransaction(transaction).build();
        this.rollback(request);
    }

    public final void rollback(RollbackRequest request) {
        this.rollbackCallable().call((Object)request);
    }

    public final UnaryCallable<RollbackRequest, Empty> rollbackCallable() {
        return this.stub.rollbackCallable();
    }

    public final ServerStreamingCallable<RunQueryRequest, RunQueryResponse> runQueryCallable() {
        return this.stub.runQueryCallable();
    }

    public final BidiStreamingCallable<WriteRequest, WriteResponse> writeCallable() {
        return this.stub.writeCallable();
    }

    public final BidiStreamingCallable<ListenRequest, ListenResponse> listenCallable() {
        return this.stub.listenCallable();
    }

    public final PagedResponseWrappers.ListCollectionIdsPagedResponse listCollectionIds(String parent) {
        ANY_PATH_PATH_TEMPLATE.validate(parent, "listCollectionIds");
        ListCollectionIdsRequest request = ListCollectionIdsRequest.newBuilder().setParent(parent).build();
        return this.listCollectionIds(request);
    }

    public final PagedResponseWrappers.ListCollectionIdsPagedResponse listCollectionIds(ListCollectionIdsRequest request) {
        return (PagedResponseWrappers.ListCollectionIdsPagedResponse)((Object)this.listCollectionIdsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCollectionIdsRequest, PagedResponseWrappers.ListCollectionIdsPagedResponse> listCollectionIdsPagedCallable() {
        return this.stub.listCollectionIdsPagedCallable();
    }

    public final UnaryCallable<ListCollectionIdsRequest, ListCollectionIdsResponse> listCollectionIdsCallable() {
        return this.stub.listCollectionIdsCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

