/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FieldValue;
import com.google.cloud.firestore.FirestoreException;
import com.google.firestore.v1beta1.DocumentTransform;
import com.google.firestore.v1beta1.Write;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class DocumentTransform {
    private DocumentReference documentReference;
    private final List<DocumentTransform.FieldTransform> transforms;

    private DocumentTransform(DocumentReference documentReference, List<DocumentTransform.FieldTransform> transforms) {
        this.documentReference = documentReference;
        this.transforms = transforms;
    }

    static DocumentTransform fromFieldPathMap(DocumentReference documentReference, Map<FieldPath, Object> values) {
        ArrayList<DocumentTransform.FieldTransform> transforms = new ArrayList<DocumentTransform.FieldTransform>();
        for (Map.Entry<FieldPath, Object> entry : values.entrySet()) {
            FieldPath path = entry.getKey();
            Object value = entry.getValue();
            if (value == FieldValue.SERVER_TIMESTAMP_SENTINEL) {
                DocumentTransform.FieldTransform.Builder fieldTransform = DocumentTransform.FieldTransform.newBuilder();
                fieldTransform.setFieldPath(path.getEncodedPath());
                fieldTransform.setSetToServerValue(DocumentTransform.FieldTransform.ServerValue.REQUEST_TIME);
                transforms.add(fieldTransform.build());
                continue;
            }
            if (value instanceof Map) {
                transforms.addAll(DocumentTransform.extractFromMap((Map)value, path, true));
                continue;
            }
            if (!(entry.getValue() instanceof List)) continue;
            DocumentTransform.extractFromArray((List)entry.getValue(), path);
        }
        return new DocumentTransform(documentReference, transforms);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<DocumentTransform.FieldTransform> extractFromMap(Map<String, Object> values, FieldPath path, boolean allowTransforms) {
        ArrayList<DocumentTransform.FieldTransform> transforms = new ArrayList<DocumentTransform.FieldTransform>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            Object value = entry.getValue();
            path = path.append(FieldPath.of(entry.getKey()));
            if (value == FieldValue.SERVER_TIMESTAMP_SENTINEL) {
                if (!allowTransforms) throw FirestoreException.invalidState("Server timestamps are not supported as Array values.", new Object[0]);
                DocumentTransform.FieldTransform.Builder fieldTransform = DocumentTransform.FieldTransform.newBuilder();
                fieldTransform.setFieldPath(path.getEncodedPath());
                fieldTransform.setSetToServerValue(DocumentTransform.FieldTransform.ServerValue.REQUEST_TIME);
                transforms.add(fieldTransform.build());
            } else if (value instanceof Map) {
                transforms.addAll(DocumentTransform.extractFromMap((Map)value, path, allowTransforms));
            } else if (entry.getValue() instanceof List) {
                DocumentTransform.extractFromArray((List)entry.getValue(), path);
            }
            path = (FieldPath)path.getParent();
        }
        return transforms;
    }

    private static List<DocumentTransform.FieldTransform> extractFromArray(List<Object> values, FieldPath path) {
        ArrayList<DocumentTransform.FieldTransform> transforms = new ArrayList<DocumentTransform.FieldTransform>();
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            path = path.append(FieldPath.of(Integer.toString(i)));
            if (value == FieldValue.SERVER_TIMESTAMP_SENTINEL) {
                throw FirestoreException.invalidState("Server timestamps are not supported as Array values.", new Object[0]);
            }
            if (value instanceof Map) {
                transforms.addAll(DocumentTransform.extractFromMap((Map)value, path, false));
            } else if (value instanceof List) {
                DocumentTransform.extractFromArray((List)value, path);
            }
            path = (FieldPath)path.getParent();
        }
        return transforms;
    }

    boolean isEmpty() {
        return this.transforms.isEmpty();
    }

    Write toPb() {
        Write.Builder write = Write.newBuilder();
        DocumentTransform.Builder transform = write.getTransformBuilder();
        transform.addAllFieldTransforms(this.transforms);
        transform.setDocument(this.documentReference.getName());
        return write.build();
    }
}

