/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.cloud.firestore.CustomClassMapper;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.cloud.firestore.ResourcePath;
import com.google.common.base.Preconditions;
import com.google.firestore.v1beta1.Cursor;
import com.google.firestore.v1beta1.Document;
import com.google.firestore.v1beta1.RunQueryRequest;
import com.google.firestore.v1beta1.RunQueryResponse;
import com.google.firestore.v1beta1.StructuredQuery;
import com.google.firestore.v1beta1.Value;
import com.google.protobuf.ByteString;
import com.google.protobuf.Int32Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Instant;

public class Query {
    final ResourcePath path;
    final FirestoreImpl firestore;
    final QueryOptions options;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        return Objects.equals(this.path, query.path) && Objects.equals(this.firestore, query.firestore) && Objects.equals(this.options, query.options);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.firestore, this.options);
    }

    Query(FirestoreImpl firestore, ResourcePath path) {
        this(firestore, path, new QueryOptions());
    }

    private Query(FirestoreImpl firestore, ResourcePath path, QueryOptions queryOptions) {
        Preconditions.checkArgument((boolean)path.isCollection(), (Object)"Invalid path specified. Path should point to a collection");
        this.firestore = firestore;
        this.path = path;
        this.options = queryOptions;
    }

    @Nonnull
    public Firestore getFirestore() {
        return this.firestore;
    }

    private static boolean isUnaryComparison(@Nullable Object value) {
        return value == null || value.equals(Double.NaN) || value.equals(Float.valueOf(Float.NaN));
    }

    private StructuredQuery.Filter createFieldFilter(FieldPath fieldPath, StructuredQuery.FieldFilter.Operator operator, Object value) {
        Preconditions.checkState((!Query.isUnaryComparison(value) ? 1 : 0) != 0, (Object)"Firestore only support equals comparisons with Null and NaN");
        StructuredQuery.Filter.Builder result = StructuredQuery.Filter.newBuilder();
        Object sanitizedObject = CustomClassMapper.serialize(value);
        Value encodedValue = FirestoreImpl.encodeValue(sanitizedObject);
        if (encodedValue == null) {
            throw FirestoreException.invalidState("Cannot use Firestore Sentinels in FieldFilter", new Object[0]);
        }
        result.getFieldFilterBuilder().setField(StructuredQuery.FieldReference.newBuilder().setFieldPath(fieldPath.getEncodedPath())).setValue(encodedValue).setOp(operator);
        return result.build();
    }

    private StructuredQuery.Filter createUnaryFilter(FieldPath fieldPath, Object value) {
        Preconditions.checkState((boolean)Query.isUnaryComparison(value));
        StructuredQuery.Filter.Builder result = StructuredQuery.Filter.newBuilder();
        result.getUnaryFilterBuilder().setField(StructuredQuery.FieldReference.newBuilder().setFieldPath(fieldPath.getEncodedPath())).setOp(value == null ? StructuredQuery.UnaryFilter.Operator.IS_NULL : StructuredQuery.UnaryFilter.Operator.IS_NAN);
        return result.build();
    }

    private StructuredQuery.Order createFieldOrder(FieldPath fieldPath, Direction direction) {
        StructuredQuery.Order.Builder result = StructuredQuery.Order.newBuilder();
        result.setField(StructuredQuery.FieldReference.newBuilder().setFieldPath(fieldPath.getEncodedPath()));
        result.setDirection(direction.getDirection());
        return result.build();
    }

    private Cursor createCursor(Object[] fieldValues, boolean before) {
        Cursor.Builder result = Cursor.newBuilder();
        Preconditions.checkState((fieldValues.length <= this.options.fieldOrders.size() ? 1 : 0) != 0, (Object)"Too many cursor values specified. The specified values must match the orderBy() constraints of the query.");
        for (int i = 0; i < fieldValues.length; ++i) {
            Object sanitizedValue;
            if (((StructuredQuery.Order)this.options.fieldOrders.get(i)).getField().getFieldPath().equals(FieldPath.DOCUMENT_ID.getEncodedPath())) {
                Preconditions.checkArgument((boolean)(fieldValues[i] instanceof String), (String)"Argument at index %d must be a String", (int)i);
                sanitizedValue = new DocumentReference(this.firestore, (ResourcePath)this.path.append((String)fieldValues[i]));
            } else {
                sanitizedValue = CustomClassMapper.serialize(fieldValues[i]);
            }
            Value encodedValue = FirestoreImpl.encodeValue(sanitizedValue);
            if (encodedValue == null) {
                throw FirestoreException.invalidState("Cannot use Firestore Sentinels in Cursor", new Object[0]);
            }
            result.addValues(encodedValue);
        }
        result.setBefore(before);
        return result.build();
    }

    @Nonnull
    public Query whereEqualTo(@Nonnull String field, @Nullable Object value) {
        return this.whereEqualTo(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public Query whereEqualTo(@Nonnull FieldPath fieldPath, @Nullable Object value) {
        QueryOptions newOptions = new QueryOptions(this.options);
        if (Query.isUnaryComparison(value)) {
            newOptions.fieldFilters.add(this.createUnaryFilter(fieldPath, value));
        } else {
            newOptions.fieldFilters.add(this.createFieldFilter(fieldPath, StructuredQuery.FieldFilter.Operator.EQUAL, value));
        }
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query whereLessThan(@Nonnull String field, @Nonnull Object value) {
        return this.whereLessThan(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public Query whereLessThan(@Nonnull FieldPath fieldPath, @Nonnull Object value) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.fieldFilters.add(this.createFieldFilter(fieldPath, StructuredQuery.FieldFilter.Operator.LESS_THAN, value));
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query whereLessThanOrEqualTo(@Nonnull String field, @Nonnull Object value) {
        return this.whereLessThanOrEqualTo(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public Query whereLessThanOrEqualTo(@Nonnull FieldPath fieldPath, @Nonnull Object value) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.fieldFilters.add(this.createFieldFilter(fieldPath, StructuredQuery.FieldFilter.Operator.LESS_THAN_OR_EQUAL, value));
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query whereGreaterThan(@Nonnull String field, @Nonnull Object value) {
        return this.whereGreaterThan(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public Query whereGreaterThan(@Nonnull FieldPath fieldPath, @Nonnull Object value) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.fieldFilters.add(this.createFieldFilter(fieldPath, StructuredQuery.FieldFilter.Operator.GREATER_THAN, value));
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query whereGreaterThanOrEqualTo(@Nonnull String field, @Nonnull Object value) {
        return this.whereGreaterThanOrEqualTo(FieldPath.fromDotSeparatedString(field), value);
    }

    @Nonnull
    public Query whereGreaterThanOrEqualTo(@Nonnull FieldPath fieldPath, @Nonnull Object value) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.fieldFilters.add(this.createFieldFilter(fieldPath, StructuredQuery.FieldFilter.Operator.GREATER_THAN_OR_EQUAL, value));
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query orderBy(@Nonnull String field) {
        return this.orderBy(FieldPath.fromDotSeparatedString(field), Direction.ASCENDING);
    }

    @Nonnull
    public Query orderBy(@Nonnull FieldPath fieldPath) {
        return this.orderBy(fieldPath, Direction.ASCENDING);
    }

    @Nonnull
    public Query orderBy(@Nonnull String field, @Nonnull Direction direction) {
        return this.orderBy(FieldPath.fromDotSeparatedString(field), direction);
    }

    @Nonnull
    public Query orderBy(@Nonnull FieldPath fieldPath, @Nonnull Direction direction) {
        Preconditions.checkState((this.options.startCursor == null && this.options.endCursor == null ? 1 : 0) != 0, (Object)"Cannot specify an orderBy() constraint after calling startAt(), startAfter(), endBefore() or endAt().");
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.fieldOrders.add(this.createFieldOrder(fieldPath, direction));
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query limit(int limit) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.limit = limit;
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query offset(int offset) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.offset = offset;
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query startAt(Object ... fieldValues) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.startCursor = this.createCursor(fieldValues, true);
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query select(String ... fields) {
        FieldPath[] fieldPaths = new FieldPath[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldPaths[i] = FieldPath.fromDotSeparatedString(fields[i]);
        }
        return this.select(fieldPaths);
    }

    @Nonnull
    public Query select(FieldPath ... fieldPaths) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.fieldProjections = new ArrayList();
        if (fieldPaths.length == 0) {
            fieldPaths = new FieldPath[]{FieldPath.DOCUMENT_ID};
        }
        for (FieldPath path : fieldPaths) {
            StructuredQuery.FieldReference fieldReference = StructuredQuery.FieldReference.newBuilder().setFieldPath(path.getEncodedPath()).build();
            newOptions.fieldProjections.add(fieldReference);
        }
        return new Query(this.firestore, this.path, newOptions);
    }

    public Query startAfter(Object ... fieldValues) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.startCursor = this.createCursor(fieldValues, false);
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query endBefore(Object ... fieldValues) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.endCursor = this.createCursor(fieldValues, true);
        return new Query(this.firestore, this.path, newOptions);
    }

    @Nonnull
    public Query endAt(Object ... fieldValues) {
        QueryOptions newOptions = new QueryOptions(this.options);
        newOptions.endCursor = this.createCursor(fieldValues, false);
        return new Query(this.firestore, this.path, newOptions);
    }

    private StructuredQuery.Builder buildQuery() {
        StructuredQuery.Builder structuredQuery = StructuredQuery.newBuilder();
        structuredQuery.addFrom(StructuredQuery.CollectionSelector.newBuilder().setCollectionId(this.path.getId()));
        if (!this.options.fieldFilters.isEmpty()) {
            StructuredQuery.Filter.Builder filter = StructuredQuery.Filter.newBuilder();
            StructuredQuery.CompositeFilter.Builder compositeFilter = StructuredQuery.CompositeFilter.newBuilder();
            compositeFilter.setOp(StructuredQuery.CompositeFilter.Operator.AND);
            compositeFilter.addAllFilters((Iterable)this.options.fieldFilters);
            filter.setCompositeFilter(compositeFilter.build());
            structuredQuery.setWhere(filter.build());
        }
        if (!this.options.fieldOrders.isEmpty()) {
            structuredQuery.addAllOrderBy((Iterable)this.options.fieldOrders);
        }
        if (!this.options.fieldProjections.isEmpty()) {
            structuredQuery.getSelectBuilder().addAllFields((Iterable)this.options.fieldProjections);
        }
        if (this.options.limit != -1) {
            structuredQuery.setLimit(Int32Value.newBuilder().setValue(this.options.limit));
        }
        if (this.options.offset != -1) {
            structuredQuery.setOffset(this.options.offset);
        }
        if (this.options.startCursor != null) {
            structuredQuery.setStartAt(this.options.startCursor);
        }
        if (this.options.endCursor != null) {
            structuredQuery.setEndAt(this.options.endCursor);
        }
        return structuredQuery;
    }

    public void stream(final @Nonnull ApiStreamObserver<DocumentSnapshot> responseObserver) {
        this.stream(new QuerySnapshotObserver(){

            public void onNext(DocumentSnapshot documentSnapshot) {
                responseObserver.onNext((Object)documentSnapshot);
            }

            public void onError(Throwable throwable) {
                responseObserver.onError(throwable);
            }

            public void onCompleted() {
                responseObserver.onCompleted();
            }
        }, null);
    }

    private void stream(final QuerySnapshotObserver documentObserver, @Nullable ByteString transactionId) {
        RunQueryRequest.Builder request = RunQueryRequest.newBuilder();
        request.setStructuredQuery(this.buildQuery()).setParent(((ResourcePath)this.path.getParent()).toString());
        if (transactionId != null) {
            request.setTransaction(transactionId);
        }
        ApiStreamObserver<RunQueryResponse> observer = new ApiStreamObserver<RunQueryResponse>(){
            Instant readTime;

            public void onNext(RunQueryResponse response) {
                if (response.hasDocument()) {
                    Document document = response.getDocument();
                    DocumentSnapshot documentSnapshot = DocumentSnapshot.fromDocument(Query.this.firestore, response.getReadTime(), document);
                    documentObserver.onNext(documentSnapshot);
                }
                if (this.readTime == null) {
                    this.readTime = Instant.ofEpochSecond((long)response.getReadTime().getSeconds(), (long)response.getReadTime().getNanos());
                }
            }

            public void onError(Throwable throwable) {
                documentObserver.onError(throwable);
            }

            public void onCompleted() {
                documentObserver.onCompleted(this.readTime);
            }
        };
        this.firestore.streamRequest(request.build(), observer, this.firestore.getClient().runQueryCallable());
    }

    @Nonnull
    public ApiFuture<QuerySnapshot> get() {
        return this.get(null);
    }

    ApiFuture<QuerySnapshot> get(@Nullable ByteString transactionId) {
        final SettableApiFuture result = SettableApiFuture.create();
        this.stream(new QuerySnapshotObserver(){
            List<DocumentSnapshot> documentSnapshots = new ArrayList<DocumentSnapshot>();

            public void onNext(DocumentSnapshot documentSnapshot) {
                this.documentSnapshots.add(documentSnapshot);
            }

            public void onError(Throwable throwable) {
                result.setException(throwable);
            }

            public void onCompleted() {
                QuerySnapshot querySnapshot = new QuerySnapshot(Query.this, this.getReadTime(), this.documentSnapshots);
                result.set((Object)querySnapshot);
            }
        }, transactionId);
        return result;
    }

    private static abstract class QuerySnapshotObserver
    implements ApiStreamObserver<DocumentSnapshot> {
        private Instant readTime;

        private QuerySnapshotObserver() {
        }

        void onCompleted(Instant readTime) {
            this.readTime = readTime;
            this.onCompleted();
        }

        Instant getReadTime() {
            return this.readTime;
        }
    }

    private static class QueryOptions {
        private int limit;
        private int offset;
        private Cursor startCursor;
        private Cursor endCursor;
        private List<StructuredQuery.Filter> fieldFilters;
        private List<StructuredQuery.Order> fieldOrders;
        private List<StructuredQuery.FieldReference> fieldProjections;

        QueryOptions() {
            this.limit = -1;
            this.offset = -1;
            this.fieldFilters = new ArrayList<StructuredQuery.Filter>();
            this.fieldOrders = new ArrayList<StructuredQuery.Order>();
            this.fieldProjections = new ArrayList<StructuredQuery.FieldReference>();
        }

        QueryOptions(QueryOptions options) {
            this.limit = options.limit;
            this.offset = options.offset;
            this.startCursor = options.startCursor;
            this.endCursor = options.endCursor;
            this.fieldFilters = new ArrayList<StructuredQuery.Filter>(options.fieldFilters);
            this.fieldOrders = new ArrayList<StructuredQuery.Order>(options.fieldOrders);
            this.fieldProjections = options.fieldProjections;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryOptions that = (QueryOptions)o;
            if (this.limit != that.limit) {
                return false;
            }
            if (this.offset != that.offset) {
                return false;
            }
            if (this.startCursor != null ? !this.startCursor.equals((Object)that.startCursor) : that.startCursor != null) {
                return false;
            }
            if (this.endCursor != null ? !this.endCursor.equals((Object)that.endCursor) : that.endCursor != null) {
                return false;
            }
            if (!this.fieldFilters.equals(that.fieldFilters)) {
                return false;
            }
            if (!this.fieldOrders.equals(that.fieldOrders)) {
                return false;
            }
            return this.fieldProjections.equals(that.fieldProjections);
        }

        public int hashCode() {
            int result = this.limit;
            result = 31 * result + this.offset;
            result = 31 * result + (this.startCursor != null ? this.startCursor.hashCode() : 0);
            result = 31 * result + (this.endCursor != null ? this.endCursor.hashCode() : 0);
            result = 31 * result + this.fieldFilters.hashCode();
            result = 31 * result + this.fieldOrders.hashCode();
            result = 31 * result + this.fieldProjections.hashCode();
            return result;
        }
    }

    public static enum Direction {
        ASCENDING(StructuredQuery.Direction.ASCENDING),
        DESCENDING(StructuredQuery.Direction.DESCENDING);

        private final StructuredQuery.Direction direction;

        private Direction(StructuredQuery.Direction direction) {
            this.direction = direction;
        }

        StructuredQuery.Direction getDirection() {
            return this.direction;
        }
    }
}

