/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.firestore.CustomClassMapper;
import com.google.cloud.firestore.DocumentMask;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.DocumentTransform;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.Precondition;
import com.google.cloud.firestore.SetOptions;
import com.google.cloud.firestore.WriteResult;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.firestore.v1beta1.CommitRequest;
import com.google.firestore.v1beta1.CommitResponse;
import com.google.firestore.v1beta1.Write;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class UpdateBuilder<T extends UpdateBuilder> {
    FirestoreImpl firestore;
    private List<Write> writes;

    UpdateBuilder(FirestoreImpl firestore) {
        this.firestore = firestore;
        this.writes = new ArrayList<Write>();
    }

    private static Map<String, Object> expandObject(Map<FieldPath, Object> data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<FieldPath, Object> entrySet : data.entrySet()) {
            ImmutableList<String> segments = entrySet.getKey().getSegments();
            Object value = entrySet.getValue();
            Map<String, Object> currentMap = result;
            for (int i = 0; i < segments.size(); ++i) {
                if (i == segments.size() - 1) {
                    currentMap.put((String)segments.get(i), value);
                    continue;
                }
                if (!currentMap.containsKey(segments.get(i))) {
                    currentMap.put((String)segments.get(i), new HashMap());
                }
                currentMap = (Map)currentMap.get(segments.get(i));
            }
        }
        return result;
    }

    @Nonnull
    public T create(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields) {
        return this.performCreate(documentReference, fields);
    }

    private T performCreate(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields) {
        DocumentSnapshot documentSnapshot = DocumentSnapshot.fromObject(this.firestore, documentReference, fields);
        Write.Builder write = Write.newBuilder();
        write.setUpdate(documentSnapshot.toPb());
        write.getCurrentDocumentBuilder().setExists(false);
        this.writes.add(write.build());
        DocumentTransform transform = DocumentTransform.fromFieldPathMap(documentReference, this.convertToFieldPaths(fields, false));
        if (!transform.isEmpty()) {
            this.writes.add(transform.toPb());
        }
        return (T)this;
    }

    @Nonnull
    public T create(@Nonnull DocumentReference documentReference, @Nonnull Object pojo) {
        Object data = CustomClassMapper.convertToPlainJavaTypes(pojo);
        if (!(data instanceof Map)) {
            FirestoreException.invalidState("Can't set a document's data to an array or primitive", new Object[0]);
        }
        return this.performCreate(documentReference, (Map)data);
    }

    @Nonnull
    public T set(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields) {
        return this.set(documentReference, fields, SetOptions.OVERWRITE);
    }

    @Nonnull
    public T set(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields, @Nonnull SetOptions options) {
        return this.performSet(documentReference, fields, options);
    }

    @Nonnull
    public T set(@Nonnull DocumentReference documentReference, @Nonnull Object pojo) {
        return this.set(documentReference, pojo, SetOptions.OVERWRITE);
    }

    @Nonnull
    public T set(@Nonnull DocumentReference documentReference, @Nonnull Object pojo, @Nonnull SetOptions options) {
        Object data = CustomClassMapper.convertToPlainJavaTypes(pojo);
        if (!(data instanceof Map)) {
            throw new IllegalArgumentException("Can't set a document's data to an array or primitive");
        }
        return this.performSet(documentReference, (Map)data, options);
    }

    private T performSet(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields, @Nonnull SetOptions options) {
        Map<FieldPath, Object> documentData = options.getFieldMask() != null ? this.applyFieldMask(fields, options.getFieldMask(), FieldPath.empty()) : this.convertToFieldPaths(fields, false);
        DocumentSnapshot document = DocumentSnapshot.fromObject(this.firestore, documentReference, UpdateBuilder.expandObject(documentData));
        Write.Builder write = Write.newBuilder();
        write.setUpdate(document.toPb());
        if (options.isMerge()) {
            DocumentMask documentMask = options.getFieldMask() != null ? new DocumentMask(options.getFieldMask()) : DocumentMask.fromObject(fields);
            write.setUpdateMask(documentMask.toPb());
        }
        this.writes.add(write.build());
        DocumentTransform transform = DocumentTransform.fromFieldPathMap(documentReference, documentData);
        if (!transform.isEmpty()) {
            this.writes.add(transform.toPb());
        }
        return (T)this;
    }

    private Map<FieldPath, Object> applyFieldMask(Map<String, Object> fields, List<FieldPath> fieldMask, FieldPath root) {
        HashMap<FieldPath, Object> filteredMap = new HashMap<FieldPath, Object>();
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            FieldPath currentField = root.append(FieldPath.of(entry.getKey()));
            if (fieldMask.contains(currentField)) {
                filteredMap.put(currentField, entry.getValue());
                continue;
            }
            if (!(entry.getValue() instanceof Map)) continue;
            filteredMap.putAll(this.applyFieldMask((Map)entry.getValue(), fieldMask, currentField));
        }
        return filteredMap;
    }

    private Map<FieldPath, Object> convertToFieldPaths(@Nonnull Map<String, Object> fields, boolean splitOnDots) {
        HashMap<FieldPath, Object> fieldPaths = new HashMap<FieldPath, Object>();
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            if (splitOnDots) {
                fieldPaths.put(FieldPath.fromDotSeparatedString(entry.getKey()), entry.getValue());
                continue;
            }
            fieldPaths.put(FieldPath.of(entry.getKey()), entry.getValue());
        }
        return fieldPaths;
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields) {
        return this.update(documentReference, fields, Precondition.exists(true));
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull Map<String, Object> fields, Precondition options) {
        return this.performUpdate(documentReference, this.convertToFieldPaths(fields, true), options);
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        return this.update(documentReference, Precondition.exists(true), field, value, moreFieldsAndValues);
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        return this.update(documentReference, Precondition.exists(true), fieldPath, value, moreFieldsAndValues);
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull Precondition options, @Nonnull String field, @Nullable Object value, Object ... moreFieldsAndValues) {
        return this.update(documentReference, options, FieldPath.fromDotSeparatedString(field), value, moreFieldsAndValues);
    }

    @Nonnull
    public T update(@Nonnull DocumentReference documentReference, @Nonnull Precondition options, @Nonnull FieldPath fieldPath, @Nullable Object value, Object ... moreFieldsAndValues) {
        HashMap<FieldPath, Object> fields = new HashMap<FieldPath, Object>();
        fields.put(fieldPath, value);
        Preconditions.checkArgument((moreFieldsAndValues.length % 2 == 0 ? 1 : 0) != 0, (Object)"moreFieldsAndValues must be key-value pairs.");
        for (int i = 0; i < moreFieldsAndValues.length; i += 2) {
            Object objectPath = moreFieldsAndValues[i];
            Object objectValue = moreFieldsAndValues[i + 1];
            if (objectPath instanceof String) {
                fields.put(FieldPath.fromDotSeparatedString((String)objectPath), objectValue);
                continue;
            }
            if (objectPath instanceof FieldPath) {
                fields.put((FieldPath)objectPath, objectValue);
                continue;
            }
            throw new IllegalArgumentException("Field '" + objectPath + "' is not of type String or Field Path.");
        }
        return this.performUpdate(documentReference, fields, options);
    }

    private T performUpdate(@Nonnull DocumentReference documentReference, @Nonnull Map<FieldPath, Object> fields, Precondition options) {
        Map<String, Object> deconstructedMap = UpdateBuilder.expandObject(fields);
        DocumentSnapshot document = DocumentSnapshot.fromObject(this.firestore, documentReference, deconstructedMap);
        DocumentMask documentMask = new DocumentMask(fields.keySet());
        Write.Builder write = Write.newBuilder();
        write.setUpdate(document.toPb());
        write.setCurrentDocument(options.toPb());
        write.setUpdateMask(documentMask.toPb());
        this.writes.add(write.build());
        DocumentTransform transform = DocumentTransform.fromFieldPathMap(documentReference, fields);
        if (!transform.isEmpty()) {
            this.writes.add(transform.toPb());
        }
        return (T)this;
    }

    @Nonnull
    public T delete(@Nonnull DocumentReference documentReference, @Nonnull Precondition precondition) {
        return this.performDelete(documentReference, precondition);
    }

    @Nonnull
    public T delete(@Nonnull DocumentReference documentReference) {
        return this.performDelete(documentReference, Precondition.NONE);
    }

    private T performDelete(@Nonnull DocumentReference documentReference, @Nonnull Precondition precondition) {
        Write.Builder writeBuilder = Write.newBuilder();
        writeBuilder.setDelete(documentReference.getPath());
        writeBuilder.setCurrentDocument(precondition.toPb());
        this.writes.add(writeBuilder.build());
        return (T)this;
    }

    ApiFuture<List<WriteResult>> commit(@Nullable ByteString transactionId) {
        CommitRequest.Builder request = CommitRequest.newBuilder();
        request.setDatabase(this.firestore.getDatabaseName());
        request.addAllWrites(this.writes);
        if (transactionId != null) {
            request.setTransaction(transactionId);
        }
        ApiFuture<CommitResponse> response = this.firestore.sendRequest(request.build(), this.firestore.getClient().commitCallable());
        return ApiFutures.transform(response, (ApiFunction)new ApiFunction<CommitResponse, List<WriteResult>>(){

            public List<WriteResult> apply(CommitResponse commitResponse) {
                List writeResults = commitResponse.getWriteResultsList();
                ArrayList<WriteResult> writeResultList = new ArrayList<WriteResult>();
                for (com.google.firestore.v1beta1.WriteResult writeResult : writeResults) {
                    writeResultList.add(WriteResult.fromProto(writeResult, commitResponse.getCommitTime()));
                }
                return writeResultList;
            }
        });
    }

    boolean isEmpty() {
        return this.writes.isEmpty();
    }
}

