/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.common.base.Preconditions;
import com.google.type.LatLng;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GeoPoint
implements Serializable {
    private static final long serialVersionUID = 7871890086202168339L;
    private final double latitude;
    private final double longitude;

    public GeoPoint(double latitude, double longitude) {
        Preconditions.checkArgument((latitude >= -90.0 && latitude <= 90.0 ? 1 : 0) != 0, (Object)"Latitude must be in the range of [-90, 90] degrees");
        Preconditions.checkArgument((longitude >= -180.0 && longitude <= 180.0 ? 1 : 0) != 0, (Object)"Longitude must be in the range of [-180, 180] degrees");
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    LatLng toProto() {
        LatLng.Builder latLngBuilder = LatLng.newBuilder();
        latLngBuilder.setLatitude(this.latitude);
        latLngBuilder.setLongitude(this.longitude);
        return latLngBuilder.build();
    }

    @Nonnull
    public String toString() {
        double d = this.latitude;
        double d2 = this.longitude;
        return new StringBuilder(82).append("GeoPoint { latitude=").append(d).append(", longitude=").append(d2).append(" }").toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoPoint geoPoint = (GeoPoint)o;
        return Double.compare(geoPoint.latitude, this.latitude) == 0 && Double.compare(geoPoint.longitude, this.longitude) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude);
    }
}

