/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.filestore.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.common.OperationMetadata;
import com.google.cloud.filestore.v1beta1.Backup;
import com.google.cloud.filestore.v1beta1.BackupName;
import com.google.cloud.filestore.v1beta1.CloudFilestoreManagerSettings;
import com.google.cloud.filestore.v1beta1.CreateBackupRequest;
import com.google.cloud.filestore.v1beta1.CreateInstanceRequest;
import com.google.cloud.filestore.v1beta1.DeleteBackupRequest;
import com.google.cloud.filestore.v1beta1.DeleteInstanceRequest;
import com.google.cloud.filestore.v1beta1.GetBackupRequest;
import com.google.cloud.filestore.v1beta1.GetInstanceRequest;
import com.google.cloud.filestore.v1beta1.Instance;
import com.google.cloud.filestore.v1beta1.InstanceName;
import com.google.cloud.filestore.v1beta1.ListBackupsRequest;
import com.google.cloud.filestore.v1beta1.ListBackupsResponse;
import com.google.cloud.filestore.v1beta1.ListInstancesRequest;
import com.google.cloud.filestore.v1beta1.ListInstancesResponse;
import com.google.cloud.filestore.v1beta1.LocationName;
import com.google.cloud.filestore.v1beta1.RestoreInstanceRequest;
import com.google.cloud.filestore.v1beta1.UpdateBackupRequest;
import com.google.cloud.filestore.v1beta1.UpdateInstanceRequest;
import com.google.cloud.filestore.v1beta1.stub.CloudFilestoreManagerStub;
import com.google.cloud.filestore.v1beta1.stub.CloudFilestoreManagerStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class CloudFilestoreManagerClient
implements BackgroundResource {
    private final CloudFilestoreManagerSettings settings;
    private final CloudFilestoreManagerStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final CloudFilestoreManagerClient create() throws IOException {
        return CloudFilestoreManagerClient.create(CloudFilestoreManagerSettings.newBuilder().build());
    }

    public static final CloudFilestoreManagerClient create(CloudFilestoreManagerSettings settings) throws IOException {
        return new CloudFilestoreManagerClient(settings);
    }

    public static final CloudFilestoreManagerClient create(CloudFilestoreManagerStub stub) {
        return new CloudFilestoreManagerClient(stub);
    }

    protected CloudFilestoreManagerClient(CloudFilestoreManagerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudFilestoreManagerStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected CloudFilestoreManagerClient(CloudFilestoreManagerStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final CloudFilestoreManagerSettings getSettings() {
        return this.settings;
    }

    public CloudFilestoreManagerStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListInstancesPagedResponse listInstances(LocationName parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(String parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(ListInstancesRequest request) {
        return (ListInstancesPagedResponse)((Object)this.listInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.stub.listInstancesPagedCallable();
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.stub.listInstancesCallable();
    }

    public final Instance getInstance(InstanceName name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(String name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(GetInstanceRequest request) {
        return (Instance)this.getInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.stub.getInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(LocationName parent, Instance instance, String instanceId) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInstance(instance).setInstanceId(instanceId).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(String parent, Instance instance, String instanceId) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent).setInstance(instance).setInstanceId(instanceId).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(CreateInstanceRequest request) {
        return this.createInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable() {
        return this.stub.createInstanceOperationCallable();
    }

    public final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.stub.createInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> updateInstanceAsync(Instance instance, FieldMask updateMask) {
        UpdateInstanceRequest request = UpdateInstanceRequest.newBuilder().setInstance(instance).setUpdateMask(updateMask).build();
        return this.updateInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> updateInstanceAsync(UpdateInstanceRequest request) {
        return this.updateInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable() {
        return this.stub.updateInstanceOperationCallable();
    }

    public final UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable() {
        return this.stub.updateInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> restoreInstanceAsync(RestoreInstanceRequest request) {
        return this.restoreInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestoreInstanceRequest, Instance, OperationMetadata> restoreInstanceOperationCallable() {
        return this.stub.restoreInstanceOperationCallable();
    }

    public final UnaryCallable<RestoreInstanceRequest, Operation> restoreInstanceCallable() {
        return this.stub.restoreInstanceCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(InstanceName name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteInstanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(String name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name).build();
        return this.deleteInstanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(DeleteInstanceRequest request) {
        return this.deleteInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable() {
        return this.stub.deleteInstanceOperationCallable();
    }

    public final UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable() {
        return this.stub.deleteInstanceCallable();
    }

    public final ListBackupsPagedResponse listBackups(LocationName parent) {
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBackups(request);
    }

    public final ListBackupsPagedResponse listBackups(String parent) {
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(parent).build();
        return this.listBackups(request);
    }

    public final ListBackupsPagedResponse listBackups(ListBackupsRequest request) {
        return (ListBackupsPagedResponse)((Object)this.listBackupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBackupsRequest, ListBackupsPagedResponse> listBackupsPagedCallable() {
        return this.stub.listBackupsPagedCallable();
    }

    public final UnaryCallable<ListBackupsRequest, ListBackupsResponse> listBackupsCallable() {
        return this.stub.listBackupsCallable();
    }

    public final Backup getBackup(BackupName name) {
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBackup(request);
    }

    public final Backup getBackup(String name) {
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(name).build();
        return this.getBackup(request);
    }

    public final Backup getBackup(GetBackupRequest request) {
        return (Backup)this.getBackupCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackupRequest, Backup> getBackupCallable() {
        return this.stub.getBackupCallable();
    }

    public final OperationFuture<Backup, OperationMetadata> createBackupAsync(LocationName parent, Backup backup, String backupId) {
        CreateBackupRequest request = CreateBackupRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBackup(backup).setBackupId(backupId).build();
        return this.createBackupAsync(request);
    }

    public final OperationFuture<Backup, OperationMetadata> createBackupAsync(String parent, Backup backup, String backupId) {
        CreateBackupRequest request = CreateBackupRequest.newBuilder().setParent(parent).setBackup(backup).setBackupId(backupId).build();
        return this.createBackupAsync(request);
    }

    public final OperationFuture<Backup, OperationMetadata> createBackupAsync(CreateBackupRequest request) {
        return this.createBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationCallable() {
        return this.stub.createBackupOperationCallable();
    }

    public final UnaryCallable<CreateBackupRequest, Operation> createBackupCallable() {
        return this.stub.createBackupCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupAsync(BackupName name) {
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteBackupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupAsync(String name) {
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(name).build();
        return this.deleteBackupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupAsync(DeleteBackupRequest request) {
        return this.deleteBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationCallable() {
        return this.stub.deleteBackupOperationCallable();
    }

    public final UnaryCallable<DeleteBackupRequest, Operation> deleteBackupCallable() {
        return this.stub.deleteBackupCallable();
    }

    public final OperationFuture<Backup, OperationMetadata> updateBackupAsync(Backup backup, FieldMask updateMask) {
        UpdateBackupRequest request = UpdateBackupRequest.newBuilder().setBackup(backup).setUpdateMask(updateMask).build();
        return this.updateBackupAsync(request);
    }

    public final OperationFuture<Backup, OperationMetadata> updateBackupAsync(UpdateBackupRequest request) {
        return this.updateBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateBackupRequest, Backup, OperationMetadata> updateBackupOperationCallable() {
        return this.stub.updateBackupOperationCallable();
    }

    public final UnaryCallable<UpdateBackupRequest, Operation> updateBackupCallable() {
        return this.stub.updateBackupCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListBackupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage, ListBackupsFixedSizeCollection> {
        private ListBackupsFixedSizeCollection(List<ListBackupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBackupsFixedSizeCollection createEmptyCollection() {
            return new ListBackupsFixedSizeCollection(null, 0);
        }

        protected ListBackupsFixedSizeCollection createCollection(List<ListBackupsPage> pages, int collectionSize) {
            return new ListBackupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBackupsPage
    extends AbstractPage<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage> {
        private ListBackupsPage(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ListBackupsResponse response) {
            super(context, (Object)response);
        }

        private static ListBackupsPage createEmptyPage() {
            return new ListBackupsPage(null, null);
        }

        protected ListBackupsPage createPage(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ListBackupsResponse response) {
            return new ListBackupsPage(context, response);
        }

        public ApiFuture<ListBackupsPage> createPageAsync(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ApiFuture<ListBackupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBackupsPagedResponse
    extends AbstractPagedListResponse<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage, ListBackupsFixedSizeCollection> {
        public static ApiFuture<ListBackupsPagedResponse> createAsync(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ApiFuture<ListBackupsResponse> futureResponse) {
            ApiFuture<ListBackupsPage> futurePage = ListBackupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBackupsPagedResponse((ListBackupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBackupsPagedResponse(ListBackupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBackupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        private ListInstancesFixedSizeCollection(List<ListInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesFixedSizeCollection createEmptyCollection() {
            return new ListInstancesFixedSizeCollection(null, 0);
        }

        protected ListInstancesFixedSizeCollection createCollection(List<ListInstancesPage> pages, int collectionSize) {
            return new ListInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesPage
    extends AbstractPage<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage> {
        private ListInstancesPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            super(context, (Object)response);
        }

        private static ListInstancesPage createEmptyPage() {
            return new ListInstancesPage(null, null);
        }

        protected ListInstancesPage createPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            return new ListInstancesPage(context, response);
        }

        public ApiFuture<ListInstancesPage> createPageAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesPagedResponse
    extends AbstractPagedListResponse<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        public static ApiFuture<ListInstancesPagedResponse> createAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            ApiFuture<ListInstancesPage> futurePage = ListInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInstancesPagedResponse((ListInstancesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancesPagedResponse(ListInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesFixedSizeCollection.createEmptyCollection());
        }
    }
}

