/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.eventarc.v1.Channel;
import com.google.cloud.eventarc.v1.ChannelConnection;
import com.google.cloud.eventarc.v1.CreateChannelConnectionRequest;
import com.google.cloud.eventarc.v1.CreateChannelRequest;
import com.google.cloud.eventarc.v1.CreateTriggerRequest;
import com.google.cloud.eventarc.v1.DeleteChannelConnectionRequest;
import com.google.cloud.eventarc.v1.DeleteChannelRequest;
import com.google.cloud.eventarc.v1.DeleteTriggerRequest;
import com.google.cloud.eventarc.v1.EventarcClient;
import com.google.cloud.eventarc.v1.GetChannelConnectionRequest;
import com.google.cloud.eventarc.v1.GetChannelRequest;
import com.google.cloud.eventarc.v1.GetProviderRequest;
import com.google.cloud.eventarc.v1.GetTriggerRequest;
import com.google.cloud.eventarc.v1.ListChannelConnectionsRequest;
import com.google.cloud.eventarc.v1.ListChannelConnectionsResponse;
import com.google.cloud.eventarc.v1.ListChannelsRequest;
import com.google.cloud.eventarc.v1.ListChannelsResponse;
import com.google.cloud.eventarc.v1.ListProvidersRequest;
import com.google.cloud.eventarc.v1.ListProvidersResponse;
import com.google.cloud.eventarc.v1.ListTriggersRequest;
import com.google.cloud.eventarc.v1.ListTriggersResponse;
import com.google.cloud.eventarc.v1.OperationMetadata;
import com.google.cloud.eventarc.v1.Provider;
import com.google.cloud.eventarc.v1.Trigger;
import com.google.cloud.eventarc.v1.UpdateChannelRequest;
import com.google.cloud.eventarc.v1.UpdateTriggerRequest;
import com.google.cloud.eventarc.v1.stub.EventarcStub;
import com.google.cloud.eventarc.v1.stub.EventarcStubSettings;
import com.google.cloud.eventarc.v1.stub.HttpJsonEventarcCallableFactory;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonEventarcStub
extends EventarcStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Channel.getDescriptor()).add(OperationMetadata.getDescriptor()).add(Trigger.getDescriptor()).add(ChannelConnection.getDescriptor()).build();
    private static final ApiMethodDescriptor<GetTriggerRequest, Trigger> getTriggerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.eventarc.v1.Eventarc/GetTrigger").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/triggers/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Trigger.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListTriggersRequest, ListTriggersResponse> listTriggersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.eventarc.v1.Eventarc/ListTriggers").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/triggers", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListTriggersResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateTriggerRequest, Operation> createTriggerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.eventarc.v1.Eventarc/CreateTrigger").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/triggers", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "triggerId", (Object)request.getTriggerId());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("trigger", (Message)request.getTrigger())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateTriggerRequest, Operation> updateTriggerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.eventarc.v1.Eventarc/UpdateTrigger").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{trigger.name=projects/*/locations/*/triggers/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "trigger.name", (Object)request.getTrigger().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowMissing", (Object)request.getAllowMissing());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("trigger", (Message)request.getTrigger())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteTriggerRequest, Operation> deleteTriggerMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.eventarc.v1.Eventarc/DeleteTrigger").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/triggers/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowMissing", (Object)request.getAllowMissing());
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetChannelRequest, Channel> getChannelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.eventarc.v1.Eventarc/GetChannel").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/channels/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Channel.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListChannelsRequest, ListChannelsResponse> listChannelsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.eventarc.v1.Eventarc/ListChannels").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/channels", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListChannelsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateChannelRequest, Operation> createChannelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.eventarc.v1.Eventarc/CreateChannel").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/channels", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "channelId", (Object)request.getChannelId());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("channel", (Message)request.getChannel())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateChannelRequest, Operation> updateChannelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.eventarc.v1.Eventarc/UpdateChannel").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{channel.name=projects/*/locations/*/channels/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "channel.name", (Object)request.getChannel().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("channel", (Message)request.getChannel())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteChannelRequest, Operation> deleteChannelMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.eventarc.v1.Eventarc/DeleteChannel").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/channels/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetProviderRequest, Provider> getProviderMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.eventarc.v1.Eventarc/GetProvider").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/providers/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Provider.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListProvidersRequest, ListProvidersResponse> listProvidersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.eventarc.v1.Eventarc/ListProviders").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/providers", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListProvidersResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetChannelConnectionRequest, ChannelConnection> getChannelConnectionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.eventarc.v1.Eventarc/GetChannelConnection").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/channelConnections/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ChannelConnection.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListChannelConnectionsRequest, ListChannelConnectionsResponse> listChannelConnectionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.eventarc.v1.Eventarc/ListChannelConnections").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/channelConnections", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListChannelConnectionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateChannelConnectionRequest, Operation> createChannelConnectionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.eventarc.v1.Eventarc/CreateChannelConnection").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/channelConnections", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "channelConnectionId", (Object)request.getChannelConnectionId());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("channelConnection", (Message)request.getChannelConnection())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteChannelConnectionRequest, Operation> deleteChannelConnectionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.eventarc.v1.Eventarc/DeleteChannelConnection").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/channelConnections/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<GetTriggerRequest, Trigger> getTriggerCallable;
    private final UnaryCallable<ListTriggersRequest, ListTriggersResponse> listTriggersCallable;
    private final UnaryCallable<ListTriggersRequest, EventarcClient.ListTriggersPagedResponse> listTriggersPagedCallable;
    private final UnaryCallable<CreateTriggerRequest, Operation> createTriggerCallable;
    private final OperationCallable<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationCallable;
    private final UnaryCallable<UpdateTriggerRequest, Operation> updateTriggerCallable;
    private final OperationCallable<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationCallable;
    private final UnaryCallable<DeleteTriggerRequest, Operation> deleteTriggerCallable;
    private final OperationCallable<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationCallable;
    private final UnaryCallable<GetChannelRequest, Channel> getChannelCallable;
    private final UnaryCallable<ListChannelsRequest, ListChannelsResponse> listChannelsCallable;
    private final UnaryCallable<ListChannelsRequest, EventarcClient.ListChannelsPagedResponse> listChannelsPagedCallable;
    private final UnaryCallable<CreateChannelRequest, Operation> createChannelCallable;
    private final OperationCallable<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationCallable;
    private final UnaryCallable<UpdateChannelRequest, Operation> updateChannelCallable;
    private final OperationCallable<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationCallable;
    private final UnaryCallable<DeleteChannelRequest, Operation> deleteChannelCallable;
    private final OperationCallable<DeleteChannelRequest, Channel, OperationMetadata> deleteChannelOperationCallable;
    private final UnaryCallable<GetProviderRequest, Provider> getProviderCallable;
    private final UnaryCallable<ListProvidersRequest, ListProvidersResponse> listProvidersCallable;
    private final UnaryCallable<ListProvidersRequest, EventarcClient.ListProvidersPagedResponse> listProvidersPagedCallable;
    private final UnaryCallable<GetChannelConnectionRequest, ChannelConnection> getChannelConnectionCallable;
    private final UnaryCallable<ListChannelConnectionsRequest, ListChannelConnectionsResponse> listChannelConnectionsCallable;
    private final UnaryCallable<ListChannelConnectionsRequest, EventarcClient.ListChannelConnectionsPagedResponse> listChannelConnectionsPagedCallable;
    private final UnaryCallable<CreateChannelConnectionRequest, Operation> createChannelConnectionCallable;
    private final OperationCallable<CreateChannelConnectionRequest, ChannelConnection, OperationMetadata> createChannelConnectionOperationCallable;
    private final UnaryCallable<DeleteChannelConnectionRequest, Operation> deleteChannelConnectionCallable;
    private final OperationCallable<DeleteChannelConnectionRequest, ChannelConnection, OperationMetadata> deleteChannelConnectionOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonEventarcStub create(EventarcStubSettings settings) throws IOException {
        return new HttpJsonEventarcStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonEventarcStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonEventarcStub(EventarcStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonEventarcStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonEventarcStub(EventarcStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonEventarcStub(EventarcStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonEventarcCallableFactory());
    }

    protected HttpJsonEventarcStub(EventarcStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings getTriggerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getTriggerMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listTriggersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listTriggersMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createTriggerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createTriggerMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateTriggerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateTriggerMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteTriggerTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteTriggerMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getChannelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getChannelMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listChannelsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listChannelsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createChannelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createChannelMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateChannelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateChannelMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteChannelTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteChannelMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getProviderTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getProviderMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listProvidersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listProvidersMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getChannelConnectionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getChannelConnectionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listChannelConnectionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listChannelConnectionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createChannelConnectionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createChannelConnectionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteChannelConnectionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteChannelConnectionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.getTriggerCallable = callableFactory.createUnaryCallable(getTriggerTransportSettings, settings.getTriggerSettings(), clientContext);
        this.listTriggersCallable = callableFactory.createUnaryCallable(listTriggersTransportSettings, settings.listTriggersSettings(), clientContext);
        this.listTriggersPagedCallable = callableFactory.createPagedCallable(listTriggersTransportSettings, settings.listTriggersSettings(), clientContext);
        this.createTriggerCallable = callableFactory.createUnaryCallable(createTriggerTransportSettings, settings.createTriggerSettings(), clientContext);
        this.createTriggerOperationCallable = callableFactory.createOperationCallable(createTriggerTransportSettings, settings.createTriggerOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateTriggerCallable = callableFactory.createUnaryCallable(updateTriggerTransportSettings, settings.updateTriggerSettings(), clientContext);
        this.updateTriggerOperationCallable = callableFactory.createOperationCallable(updateTriggerTransportSettings, settings.updateTriggerOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteTriggerCallable = callableFactory.createUnaryCallable(deleteTriggerTransportSettings, settings.deleteTriggerSettings(), clientContext);
        this.deleteTriggerOperationCallable = callableFactory.createOperationCallable(deleteTriggerTransportSettings, settings.deleteTriggerOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getChannelCallable = callableFactory.createUnaryCallable(getChannelTransportSettings, settings.getChannelSettings(), clientContext);
        this.listChannelsCallable = callableFactory.createUnaryCallable(listChannelsTransportSettings, settings.listChannelsSettings(), clientContext);
        this.listChannelsPagedCallable = callableFactory.createPagedCallable(listChannelsTransportSettings, settings.listChannelsSettings(), clientContext);
        this.createChannelCallable = callableFactory.createUnaryCallable(createChannelTransportSettings, settings.createChannelSettings(), clientContext);
        this.createChannelOperationCallable = callableFactory.createOperationCallable(createChannelTransportSettings, settings.createChannelOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateChannelCallable = callableFactory.createUnaryCallable(updateChannelTransportSettings, settings.updateChannelSettings(), clientContext);
        this.updateChannelOperationCallable = callableFactory.createOperationCallable(updateChannelTransportSettings, settings.updateChannelOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteChannelCallable = callableFactory.createUnaryCallable(deleteChannelTransportSettings, settings.deleteChannelSettings(), clientContext);
        this.deleteChannelOperationCallable = callableFactory.createOperationCallable(deleteChannelTransportSettings, settings.deleteChannelOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getProviderCallable = callableFactory.createUnaryCallable(getProviderTransportSettings, settings.getProviderSettings(), clientContext);
        this.listProvidersCallable = callableFactory.createUnaryCallable(listProvidersTransportSettings, settings.listProvidersSettings(), clientContext);
        this.listProvidersPagedCallable = callableFactory.createPagedCallable(listProvidersTransportSettings, settings.listProvidersSettings(), clientContext);
        this.getChannelConnectionCallable = callableFactory.createUnaryCallable(getChannelConnectionTransportSettings, settings.getChannelConnectionSettings(), clientContext);
        this.listChannelConnectionsCallable = callableFactory.createUnaryCallable(listChannelConnectionsTransportSettings, settings.listChannelConnectionsSettings(), clientContext);
        this.listChannelConnectionsPagedCallable = callableFactory.createPagedCallable(listChannelConnectionsTransportSettings, settings.listChannelConnectionsSettings(), clientContext);
        this.createChannelConnectionCallable = callableFactory.createUnaryCallable(createChannelConnectionTransportSettings, settings.createChannelConnectionSettings(), clientContext);
        this.createChannelConnectionOperationCallable = callableFactory.createOperationCallable(createChannelConnectionTransportSettings, settings.createChannelConnectionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteChannelConnectionCallable = callableFactory.createUnaryCallable(deleteChannelConnectionTransportSettings, settings.deleteChannelConnectionSettings(), clientContext);
        this.deleteChannelConnectionOperationCallable = callableFactory.createOperationCallable(deleteChannelConnectionTransportSettings, settings.deleteChannelConnectionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getTriggerMethodDescriptor);
        methodDescriptors.add(listTriggersMethodDescriptor);
        methodDescriptors.add(createTriggerMethodDescriptor);
        methodDescriptors.add(updateTriggerMethodDescriptor);
        methodDescriptors.add(deleteTriggerMethodDescriptor);
        methodDescriptors.add(getChannelMethodDescriptor);
        methodDescriptors.add(listChannelsMethodDescriptor);
        methodDescriptors.add(createChannelMethodDescriptor);
        methodDescriptors.add(updateChannelMethodDescriptor);
        methodDescriptors.add(deleteChannelMethodDescriptor);
        methodDescriptors.add(getProviderMethodDescriptor);
        methodDescriptors.add(listProvidersMethodDescriptor);
        methodDescriptors.add(getChannelConnectionMethodDescriptor);
        methodDescriptors.add(listChannelConnectionsMethodDescriptor);
        methodDescriptors.add(createChannelConnectionMethodDescriptor);
        methodDescriptors.add(deleteChannelConnectionMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<GetTriggerRequest, Trigger> getTriggerCallable() {
        return this.getTriggerCallable;
    }

    @Override
    public UnaryCallable<ListTriggersRequest, ListTriggersResponse> listTriggersCallable() {
        return this.listTriggersCallable;
    }

    @Override
    public UnaryCallable<ListTriggersRequest, EventarcClient.ListTriggersPagedResponse> listTriggersPagedCallable() {
        return this.listTriggersPagedCallable;
    }

    @Override
    public UnaryCallable<CreateTriggerRequest, Operation> createTriggerCallable() {
        return this.createTriggerCallable;
    }

    @Override
    public OperationCallable<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationCallable() {
        return this.createTriggerOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateTriggerRequest, Operation> updateTriggerCallable() {
        return this.updateTriggerCallable;
    }

    @Override
    public OperationCallable<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationCallable() {
        return this.updateTriggerOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteTriggerRequest, Operation> deleteTriggerCallable() {
        return this.deleteTriggerCallable;
    }

    @Override
    public OperationCallable<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationCallable() {
        return this.deleteTriggerOperationCallable;
    }

    @Override
    public UnaryCallable<GetChannelRequest, Channel> getChannelCallable() {
        return this.getChannelCallable;
    }

    @Override
    public UnaryCallable<ListChannelsRequest, ListChannelsResponse> listChannelsCallable() {
        return this.listChannelsCallable;
    }

    @Override
    public UnaryCallable<ListChannelsRequest, EventarcClient.ListChannelsPagedResponse> listChannelsPagedCallable() {
        return this.listChannelsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateChannelRequest, Operation> createChannelCallable() {
        return this.createChannelCallable;
    }

    @Override
    public OperationCallable<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationCallable() {
        return this.createChannelOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateChannelRequest, Operation> updateChannelCallable() {
        return this.updateChannelCallable;
    }

    @Override
    public OperationCallable<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationCallable() {
        return this.updateChannelOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteChannelRequest, Operation> deleteChannelCallable() {
        return this.deleteChannelCallable;
    }

    @Override
    public OperationCallable<DeleteChannelRequest, Channel, OperationMetadata> deleteChannelOperationCallable() {
        return this.deleteChannelOperationCallable;
    }

    @Override
    public UnaryCallable<GetProviderRequest, Provider> getProviderCallable() {
        return this.getProviderCallable;
    }

    @Override
    public UnaryCallable<ListProvidersRequest, ListProvidersResponse> listProvidersCallable() {
        return this.listProvidersCallable;
    }

    @Override
    public UnaryCallable<ListProvidersRequest, EventarcClient.ListProvidersPagedResponse> listProvidersPagedCallable() {
        return this.listProvidersPagedCallable;
    }

    @Override
    public UnaryCallable<GetChannelConnectionRequest, ChannelConnection> getChannelConnectionCallable() {
        return this.getChannelConnectionCallable;
    }

    @Override
    public UnaryCallable<ListChannelConnectionsRequest, ListChannelConnectionsResponse> listChannelConnectionsCallable() {
        return this.listChannelConnectionsCallable;
    }

    @Override
    public UnaryCallable<ListChannelConnectionsRequest, EventarcClient.ListChannelConnectionsPagedResponse> listChannelConnectionsPagedCallable() {
        return this.listChannelConnectionsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateChannelConnectionRequest, Operation> createChannelConnectionCallable() {
        return this.createChannelConnectionCallable;
    }

    @Override
    public OperationCallable<CreateChannelConnectionRequest, ChannelConnection, OperationMetadata> createChannelConnectionOperationCallable() {
        return this.createChannelConnectionOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteChannelConnectionRequest, Operation> deleteChannelConnectionCallable() {
        return this.deleteChannelConnectionCallable;
    }

    @Override
    public OperationCallable<DeleteChannelConnectionRequest, ChannelConnection, OperationMetadata> deleteChannelConnectionOperationCallable() {
        return this.deleteChannelConnectionOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

