/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.eventarc.v1.Channel;
import com.google.cloud.eventarc.v1.ChannelConnection;
import com.google.cloud.eventarc.v1.ChannelConnectionName;
import com.google.cloud.eventarc.v1.ChannelName;
import com.google.cloud.eventarc.v1.CreateChannelConnectionRequest;
import com.google.cloud.eventarc.v1.CreateChannelRequest;
import com.google.cloud.eventarc.v1.CreateTriggerRequest;
import com.google.cloud.eventarc.v1.DeleteChannelConnectionRequest;
import com.google.cloud.eventarc.v1.DeleteChannelRequest;
import com.google.cloud.eventarc.v1.DeleteTriggerRequest;
import com.google.cloud.eventarc.v1.EventarcSettings;
import com.google.cloud.eventarc.v1.GetChannelConnectionRequest;
import com.google.cloud.eventarc.v1.GetChannelRequest;
import com.google.cloud.eventarc.v1.GetProviderRequest;
import com.google.cloud.eventarc.v1.GetTriggerRequest;
import com.google.cloud.eventarc.v1.ListChannelConnectionsRequest;
import com.google.cloud.eventarc.v1.ListChannelConnectionsResponse;
import com.google.cloud.eventarc.v1.ListChannelsRequest;
import com.google.cloud.eventarc.v1.ListChannelsResponse;
import com.google.cloud.eventarc.v1.ListProvidersRequest;
import com.google.cloud.eventarc.v1.ListProvidersResponse;
import com.google.cloud.eventarc.v1.ListTriggersRequest;
import com.google.cloud.eventarc.v1.ListTriggersResponse;
import com.google.cloud.eventarc.v1.LocationName;
import com.google.cloud.eventarc.v1.OperationMetadata;
import com.google.cloud.eventarc.v1.Provider;
import com.google.cloud.eventarc.v1.ProviderName;
import com.google.cloud.eventarc.v1.Trigger;
import com.google.cloud.eventarc.v1.TriggerName;
import com.google.cloud.eventarc.v1.UpdateChannelRequest;
import com.google.cloud.eventarc.v1.UpdateTriggerRequest;
import com.google.cloud.eventarc.v1.stub.EventarcStub;
import com.google.cloud.eventarc.v1.stub.EventarcStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class EventarcClient
implements BackgroundResource {
    private final EventarcSettings settings;
    private final EventarcStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final EventarcClient create() throws IOException {
        return EventarcClient.create(EventarcSettings.newBuilder().build());
    }

    public static final EventarcClient create(EventarcSettings settings) throws IOException {
        return new EventarcClient(settings);
    }

    public static final EventarcClient create(EventarcStub stub) {
        return new EventarcClient(stub);
    }

    protected EventarcClient(EventarcSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EventarcStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected EventarcClient(EventarcStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final EventarcSettings getSettings() {
        return this.settings;
    }

    public EventarcStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final Trigger getTrigger(TriggerName name) {
        GetTriggerRequest request = GetTriggerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTrigger(request);
    }

    public final Trigger getTrigger(String name) {
        GetTriggerRequest request = GetTriggerRequest.newBuilder().setName(name).build();
        return this.getTrigger(request);
    }

    public final Trigger getTrigger(GetTriggerRequest request) {
        return (Trigger)this.getTriggerCallable().call((Object)request);
    }

    public final UnaryCallable<GetTriggerRequest, Trigger> getTriggerCallable() {
        return this.stub.getTriggerCallable();
    }

    public final ListTriggersPagedResponse listTriggers(LocationName parent) {
        ListTriggersRequest request = ListTriggersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTriggers(request);
    }

    public final ListTriggersPagedResponse listTriggers(String parent) {
        ListTriggersRequest request = ListTriggersRequest.newBuilder().setParent(parent).build();
        return this.listTriggers(request);
    }

    public final ListTriggersPagedResponse listTriggers(ListTriggersRequest request) {
        return (ListTriggersPagedResponse)((Object)this.listTriggersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTriggersRequest, ListTriggersPagedResponse> listTriggersPagedCallable() {
        return this.stub.listTriggersPagedCallable();
    }

    public final UnaryCallable<ListTriggersRequest, ListTriggersResponse> listTriggersCallable() {
        return this.stub.listTriggersCallable();
    }

    public final OperationFuture<Trigger, OperationMetadata> createTriggerAsync(LocationName parent, Trigger trigger, String triggerId) {
        CreateTriggerRequest request = CreateTriggerRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTrigger(trigger).setTriggerId(triggerId).build();
        return this.createTriggerAsync(request);
    }

    public final OperationFuture<Trigger, OperationMetadata> createTriggerAsync(String parent, Trigger trigger, String triggerId) {
        CreateTriggerRequest request = CreateTriggerRequest.newBuilder().setParent(parent).setTrigger(trigger).setTriggerId(triggerId).build();
        return this.createTriggerAsync(request);
    }

    public final OperationFuture<Trigger, OperationMetadata> createTriggerAsync(CreateTriggerRequest request) {
        return this.createTriggerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationCallable() {
        return this.stub.createTriggerOperationCallable();
    }

    public final UnaryCallable<CreateTriggerRequest, Operation> createTriggerCallable() {
        return this.stub.createTriggerCallable();
    }

    public final OperationFuture<Trigger, OperationMetadata> updateTriggerAsync(Trigger trigger, FieldMask updateMask, boolean allowMissing) {
        UpdateTriggerRequest request = UpdateTriggerRequest.newBuilder().setTrigger(trigger).setUpdateMask(updateMask).setAllowMissing(allowMissing).build();
        return this.updateTriggerAsync(request);
    }

    public final OperationFuture<Trigger, OperationMetadata> updateTriggerAsync(UpdateTriggerRequest request) {
        return this.updateTriggerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationCallable() {
        return this.stub.updateTriggerOperationCallable();
    }

    public final UnaryCallable<UpdateTriggerRequest, Operation> updateTriggerCallable() {
        return this.stub.updateTriggerCallable();
    }

    public final OperationFuture<Trigger, OperationMetadata> deleteTriggerAsync(TriggerName name, boolean allowMissing) {
        DeleteTriggerRequest request = DeleteTriggerRequest.newBuilder().setName(name == null ? null : name.toString()).setAllowMissing(allowMissing).build();
        return this.deleteTriggerAsync(request);
    }

    public final OperationFuture<Trigger, OperationMetadata> deleteTriggerAsync(String name, boolean allowMissing) {
        DeleteTriggerRequest request = DeleteTriggerRequest.newBuilder().setName(name).setAllowMissing(allowMissing).build();
        return this.deleteTriggerAsync(request);
    }

    public final OperationFuture<Trigger, OperationMetadata> deleteTriggerAsync(DeleteTriggerRequest request) {
        return this.deleteTriggerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationCallable() {
        return this.stub.deleteTriggerOperationCallable();
    }

    public final UnaryCallable<DeleteTriggerRequest, Operation> deleteTriggerCallable() {
        return this.stub.deleteTriggerCallable();
    }

    public final Channel getChannel(ChannelName name) {
        GetChannelRequest request = GetChannelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getChannel(request);
    }

    public final Channel getChannel(String name) {
        GetChannelRequest request = GetChannelRequest.newBuilder().setName(name).build();
        return this.getChannel(request);
    }

    public final Channel getChannel(GetChannelRequest request) {
        return (Channel)this.getChannelCallable().call((Object)request);
    }

    public final UnaryCallable<GetChannelRequest, Channel> getChannelCallable() {
        return this.stub.getChannelCallable();
    }

    public final ListChannelsPagedResponse listChannels(LocationName parent) {
        ListChannelsRequest request = ListChannelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listChannels(request);
    }

    public final ListChannelsPagedResponse listChannels(String parent) {
        ListChannelsRequest request = ListChannelsRequest.newBuilder().setParent(parent).build();
        return this.listChannels(request);
    }

    public final ListChannelsPagedResponse listChannels(ListChannelsRequest request) {
        return (ListChannelsPagedResponse)((Object)this.listChannelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListChannelsRequest, ListChannelsPagedResponse> listChannelsPagedCallable() {
        return this.stub.listChannelsPagedCallable();
    }

    public final UnaryCallable<ListChannelsRequest, ListChannelsResponse> listChannelsCallable() {
        return this.stub.listChannelsCallable();
    }

    public final OperationFuture<Channel, OperationMetadata> createChannelAsync(LocationName parent, Channel channel, String channelId) {
        CreateChannelRequest request = CreateChannelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setChannel(channel).setChannelId(channelId).build();
        return this.createChannelAsync(request);
    }

    public final OperationFuture<Channel, OperationMetadata> createChannelAsync(String parent, Channel channel, String channelId) {
        CreateChannelRequest request = CreateChannelRequest.newBuilder().setParent(parent).setChannel(channel).setChannelId(channelId).build();
        return this.createChannelAsync(request);
    }

    public final OperationFuture<Channel, OperationMetadata> createChannelAsync(CreateChannelRequest request) {
        return this.createChannelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationCallable() {
        return this.stub.createChannelOperationCallable();
    }

    public final UnaryCallable<CreateChannelRequest, Operation> createChannelCallable() {
        return this.stub.createChannelCallable();
    }

    public final OperationFuture<Channel, OperationMetadata> updateChannelAsync(Channel channel, FieldMask updateMask) {
        UpdateChannelRequest request = UpdateChannelRequest.newBuilder().setChannel(channel).setUpdateMask(updateMask).build();
        return this.updateChannelAsync(request);
    }

    public final OperationFuture<Channel, OperationMetadata> updateChannelAsync(UpdateChannelRequest request) {
        return this.updateChannelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationCallable() {
        return this.stub.updateChannelOperationCallable();
    }

    public final UnaryCallable<UpdateChannelRequest, Operation> updateChannelCallable() {
        return this.stub.updateChannelCallable();
    }

    public final OperationFuture<Channel, OperationMetadata> deleteChannelAsync(ChannelName name) {
        DeleteChannelRequest request = DeleteChannelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteChannelAsync(request);
    }

    public final OperationFuture<Channel, OperationMetadata> deleteChannelAsync(String name) {
        DeleteChannelRequest request = DeleteChannelRequest.newBuilder().setName(name).build();
        return this.deleteChannelAsync(request);
    }

    public final OperationFuture<Channel, OperationMetadata> deleteChannelAsync(DeleteChannelRequest request) {
        return this.deleteChannelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteChannelRequest, Channel, OperationMetadata> deleteChannelOperationCallable() {
        return this.stub.deleteChannelOperationCallable();
    }

    public final UnaryCallable<DeleteChannelRequest, Operation> deleteChannelCallable() {
        return this.stub.deleteChannelCallable();
    }

    public final Provider getProvider(ProviderName name) {
        GetProviderRequest request = GetProviderRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProvider(request);
    }

    public final Provider getProvider(String name) {
        GetProviderRequest request = GetProviderRequest.newBuilder().setName(name).build();
        return this.getProvider(request);
    }

    public final Provider getProvider(GetProviderRequest request) {
        return (Provider)this.getProviderCallable().call((Object)request);
    }

    public final UnaryCallable<GetProviderRequest, Provider> getProviderCallable() {
        return this.stub.getProviderCallable();
    }

    public final ListProvidersPagedResponse listProviders(LocationName parent) {
        ListProvidersRequest request = ListProvidersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listProviders(request);
    }

    public final ListProvidersPagedResponse listProviders(String parent) {
        ListProvidersRequest request = ListProvidersRequest.newBuilder().setParent(parent).build();
        return this.listProviders(request);
    }

    public final ListProvidersPagedResponse listProviders(ListProvidersRequest request) {
        return (ListProvidersPagedResponse)((Object)this.listProvidersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProvidersRequest, ListProvidersPagedResponse> listProvidersPagedCallable() {
        return this.stub.listProvidersPagedCallable();
    }

    public final UnaryCallable<ListProvidersRequest, ListProvidersResponse> listProvidersCallable() {
        return this.stub.listProvidersCallable();
    }

    public final ChannelConnection getChannelConnection(ChannelConnectionName name) {
        GetChannelConnectionRequest request = GetChannelConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getChannelConnection(request);
    }

    public final ChannelConnection getChannelConnection(String name) {
        GetChannelConnectionRequest request = GetChannelConnectionRequest.newBuilder().setName(name).build();
        return this.getChannelConnection(request);
    }

    public final ChannelConnection getChannelConnection(GetChannelConnectionRequest request) {
        return (ChannelConnection)this.getChannelConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<GetChannelConnectionRequest, ChannelConnection> getChannelConnectionCallable() {
        return this.stub.getChannelConnectionCallable();
    }

    public final ListChannelConnectionsPagedResponse listChannelConnections(LocationName parent) {
        ListChannelConnectionsRequest request = ListChannelConnectionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listChannelConnections(request);
    }

    public final ListChannelConnectionsPagedResponse listChannelConnections(String parent) {
        ListChannelConnectionsRequest request = ListChannelConnectionsRequest.newBuilder().setParent(parent).build();
        return this.listChannelConnections(request);
    }

    public final ListChannelConnectionsPagedResponse listChannelConnections(ListChannelConnectionsRequest request) {
        return (ListChannelConnectionsPagedResponse)((Object)this.listChannelConnectionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListChannelConnectionsRequest, ListChannelConnectionsPagedResponse> listChannelConnectionsPagedCallable() {
        return this.stub.listChannelConnectionsPagedCallable();
    }

    public final UnaryCallable<ListChannelConnectionsRequest, ListChannelConnectionsResponse> listChannelConnectionsCallable() {
        return this.stub.listChannelConnectionsCallable();
    }

    public final OperationFuture<ChannelConnection, OperationMetadata> createChannelConnectionAsync(LocationName parent, ChannelConnection channelConnection, String channelConnectionId) {
        CreateChannelConnectionRequest request = CreateChannelConnectionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setChannelConnection(channelConnection).setChannelConnectionId(channelConnectionId).build();
        return this.createChannelConnectionAsync(request);
    }

    public final OperationFuture<ChannelConnection, OperationMetadata> createChannelConnectionAsync(String parent, ChannelConnection channelConnection, String channelConnectionId) {
        CreateChannelConnectionRequest request = CreateChannelConnectionRequest.newBuilder().setParent(parent).setChannelConnection(channelConnection).setChannelConnectionId(channelConnectionId).build();
        return this.createChannelConnectionAsync(request);
    }

    public final OperationFuture<ChannelConnection, OperationMetadata> createChannelConnectionAsync(CreateChannelConnectionRequest request) {
        return this.createChannelConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateChannelConnectionRequest, ChannelConnection, OperationMetadata> createChannelConnectionOperationCallable() {
        return this.stub.createChannelConnectionOperationCallable();
    }

    public final UnaryCallable<CreateChannelConnectionRequest, Operation> createChannelConnectionCallable() {
        return this.stub.createChannelConnectionCallable();
    }

    public final OperationFuture<ChannelConnection, OperationMetadata> deleteChannelConnectionAsync(ChannelConnectionName name) {
        DeleteChannelConnectionRequest request = DeleteChannelConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteChannelConnectionAsync(request);
    }

    public final OperationFuture<ChannelConnection, OperationMetadata> deleteChannelConnectionAsync(String name) {
        DeleteChannelConnectionRequest request = DeleteChannelConnectionRequest.newBuilder().setName(name).build();
        return this.deleteChannelConnectionAsync(request);
    }

    public final OperationFuture<ChannelConnection, OperationMetadata> deleteChannelConnectionAsync(DeleteChannelConnectionRequest request) {
        return this.deleteChannelConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteChannelConnectionRequest, ChannelConnection, OperationMetadata> deleteChannelConnectionOperationCallable() {
        return this.stub.deleteChannelConnectionOperationCallable();
    }

    public final UnaryCallable<DeleteChannelConnectionRequest, Operation> deleteChannelConnectionCallable() {
        return this.stub.deleteChannelConnectionCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListChannelConnectionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection, ListChannelConnectionsPage, ListChannelConnectionsFixedSizeCollection> {
        private ListChannelConnectionsFixedSizeCollection(List<ListChannelConnectionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListChannelConnectionsFixedSizeCollection createEmptyCollection() {
            return new ListChannelConnectionsFixedSizeCollection(null, 0);
        }

        protected ListChannelConnectionsFixedSizeCollection createCollection(List<ListChannelConnectionsPage> pages, int collectionSize) {
            return new ListChannelConnectionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListChannelConnectionsPage
    extends AbstractPage<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection, ListChannelConnectionsPage> {
        private ListChannelConnectionsPage(PageContext<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection> context, ListChannelConnectionsResponse response) {
            super(context, (Object)response);
        }

        private static ListChannelConnectionsPage createEmptyPage() {
            return new ListChannelConnectionsPage(null, null);
        }

        protected ListChannelConnectionsPage createPage(PageContext<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection> context, ListChannelConnectionsResponse response) {
            return new ListChannelConnectionsPage(context, response);
        }

        public ApiFuture<ListChannelConnectionsPage> createPageAsync(PageContext<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection> context, ApiFuture<ListChannelConnectionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListChannelConnectionsPagedResponse
    extends AbstractPagedListResponse<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection, ListChannelConnectionsPage, ListChannelConnectionsFixedSizeCollection> {
        public static ApiFuture<ListChannelConnectionsPagedResponse> createAsync(PageContext<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection> context, ApiFuture<ListChannelConnectionsResponse> futureResponse) {
            ApiFuture<ListChannelConnectionsPage> futurePage = ListChannelConnectionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListChannelConnectionsPagedResponse((ListChannelConnectionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListChannelConnectionsPagedResponse(ListChannelConnectionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListChannelConnectionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListProvidersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProvidersRequest, ListProvidersResponse, Provider, ListProvidersPage, ListProvidersFixedSizeCollection> {
        private ListProvidersFixedSizeCollection(List<ListProvidersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProvidersFixedSizeCollection createEmptyCollection() {
            return new ListProvidersFixedSizeCollection(null, 0);
        }

        protected ListProvidersFixedSizeCollection createCollection(List<ListProvidersPage> pages, int collectionSize) {
            return new ListProvidersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProvidersPage
    extends AbstractPage<ListProvidersRequest, ListProvidersResponse, Provider, ListProvidersPage> {
        private ListProvidersPage(PageContext<ListProvidersRequest, ListProvidersResponse, Provider> context, ListProvidersResponse response) {
            super(context, (Object)response);
        }

        private static ListProvidersPage createEmptyPage() {
            return new ListProvidersPage(null, null);
        }

        protected ListProvidersPage createPage(PageContext<ListProvidersRequest, ListProvidersResponse, Provider> context, ListProvidersResponse response) {
            return new ListProvidersPage(context, response);
        }

        public ApiFuture<ListProvidersPage> createPageAsync(PageContext<ListProvidersRequest, ListProvidersResponse, Provider> context, ApiFuture<ListProvidersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProvidersPagedResponse
    extends AbstractPagedListResponse<ListProvidersRequest, ListProvidersResponse, Provider, ListProvidersPage, ListProvidersFixedSizeCollection> {
        public static ApiFuture<ListProvidersPagedResponse> createAsync(PageContext<ListProvidersRequest, ListProvidersResponse, Provider> context, ApiFuture<ListProvidersResponse> futureResponse) {
            ApiFuture<ListProvidersPage> futurePage = ListProvidersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListProvidersPagedResponse((ListProvidersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListProvidersPagedResponse(ListProvidersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProvidersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListChannelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListChannelsRequest, ListChannelsResponse, Channel, ListChannelsPage, ListChannelsFixedSizeCollection> {
        private ListChannelsFixedSizeCollection(List<ListChannelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListChannelsFixedSizeCollection createEmptyCollection() {
            return new ListChannelsFixedSizeCollection(null, 0);
        }

        protected ListChannelsFixedSizeCollection createCollection(List<ListChannelsPage> pages, int collectionSize) {
            return new ListChannelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListChannelsPage
    extends AbstractPage<ListChannelsRequest, ListChannelsResponse, Channel, ListChannelsPage> {
        private ListChannelsPage(PageContext<ListChannelsRequest, ListChannelsResponse, Channel> context, ListChannelsResponse response) {
            super(context, (Object)response);
        }

        private static ListChannelsPage createEmptyPage() {
            return new ListChannelsPage(null, null);
        }

        protected ListChannelsPage createPage(PageContext<ListChannelsRequest, ListChannelsResponse, Channel> context, ListChannelsResponse response) {
            return new ListChannelsPage(context, response);
        }

        public ApiFuture<ListChannelsPage> createPageAsync(PageContext<ListChannelsRequest, ListChannelsResponse, Channel> context, ApiFuture<ListChannelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListChannelsPagedResponse
    extends AbstractPagedListResponse<ListChannelsRequest, ListChannelsResponse, Channel, ListChannelsPage, ListChannelsFixedSizeCollection> {
        public static ApiFuture<ListChannelsPagedResponse> createAsync(PageContext<ListChannelsRequest, ListChannelsResponse, Channel> context, ApiFuture<ListChannelsResponse> futureResponse) {
            ApiFuture<ListChannelsPage> futurePage = ListChannelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListChannelsPagedResponse((ListChannelsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListChannelsPagedResponse(ListChannelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListChannelsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTriggersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTriggersRequest, ListTriggersResponse, Trigger, ListTriggersPage, ListTriggersFixedSizeCollection> {
        private ListTriggersFixedSizeCollection(List<ListTriggersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTriggersFixedSizeCollection createEmptyCollection() {
            return new ListTriggersFixedSizeCollection(null, 0);
        }

        protected ListTriggersFixedSizeCollection createCollection(List<ListTriggersPage> pages, int collectionSize) {
            return new ListTriggersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTriggersPage
    extends AbstractPage<ListTriggersRequest, ListTriggersResponse, Trigger, ListTriggersPage> {
        private ListTriggersPage(PageContext<ListTriggersRequest, ListTriggersResponse, Trigger> context, ListTriggersResponse response) {
            super(context, (Object)response);
        }

        private static ListTriggersPage createEmptyPage() {
            return new ListTriggersPage(null, null);
        }

        protected ListTriggersPage createPage(PageContext<ListTriggersRequest, ListTriggersResponse, Trigger> context, ListTriggersResponse response) {
            return new ListTriggersPage(context, response);
        }

        public ApiFuture<ListTriggersPage> createPageAsync(PageContext<ListTriggersRequest, ListTriggersResponse, Trigger> context, ApiFuture<ListTriggersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTriggersPagedResponse
    extends AbstractPagedListResponse<ListTriggersRequest, ListTriggersResponse, Trigger, ListTriggersPage, ListTriggersFixedSizeCollection> {
        public static ApiFuture<ListTriggersPagedResponse> createAsync(PageContext<ListTriggersRequest, ListTriggersResponse, Trigger> context, ApiFuture<ListTriggersResponse> futureResponse) {
            ApiFuture<ListTriggersPage> futurePage = ListTriggersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTriggersPagedResponse((ListTriggersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTriggersPagedResponse(ListTriggersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTriggersFixedSizeCollection.createEmptyCollection());
        }
    }
}

