/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.errorreporting.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.errorreporting.v1beta1.ErrorStatsServiceClient;
import com.google.cloud.errorreporting.v1beta1.stub.ErrorStatsServiceStub;
import com.google.cloud.errorreporting.v1beta1.stub.GrpcErrorStatsServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.devtools.clouderrorreporting.v1beta1.DeleteEventsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.DeleteEventsResponse;
import com.google.devtools.clouderrorreporting.v1beta1.ErrorEvent;
import com.google.devtools.clouderrorreporting.v1beta1.ErrorGroupStats;
import com.google.devtools.clouderrorreporting.v1beta1.ListEventsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.ListEventsResponse;
import com.google.devtools.clouderrorreporting.v1beta1.ListGroupStatsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.ListGroupStatsResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ErrorStatsServiceStubSettings
extends StubSettings<ErrorStatsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListGroupStatsRequest, ListGroupStatsResponse, ErrorStatsServiceClient.ListGroupStatsPagedResponse> listGroupStatsSettings;
    private final PagedCallSettings<ListEventsRequest, ListEventsResponse, ErrorStatsServiceClient.ListEventsPagedResponse> listEventsSettings;
    private final UnaryCallSettings<DeleteEventsRequest, DeleteEventsResponse> deleteEventsSettings;
    private static final PagedListDescriptor<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats> LIST_GROUP_STATS_PAGE_STR_DESC = new PagedListDescriptor<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats>(){

        public String emptyToken() {
            return "";
        }

        public ListGroupStatsRequest injectToken(ListGroupStatsRequest payload, String token) {
            return ListGroupStatsRequest.newBuilder((ListGroupStatsRequest)payload).setPageToken(token).build();
        }

        public ListGroupStatsRequest injectPageSize(ListGroupStatsRequest payload, int pageSize) {
            return ListGroupStatsRequest.newBuilder((ListGroupStatsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGroupStatsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGroupStatsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ErrorGroupStats> extractResources(ListGroupStatsResponse payload) {
            return payload.getErrorGroupStatsList() != null ? payload.getErrorGroupStatsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListEventsRequest, ListEventsResponse, ErrorEvent> LIST_EVENTS_PAGE_STR_DESC = new PagedListDescriptor<ListEventsRequest, ListEventsResponse, ErrorEvent>(){

        public String emptyToken() {
            return "";
        }

        public ListEventsRequest injectToken(ListEventsRequest payload, String token) {
            return ListEventsRequest.newBuilder((ListEventsRequest)payload).setPageToken(token).build();
        }

        public ListEventsRequest injectPageSize(ListEventsRequest payload, int pageSize) {
            return ListEventsRequest.newBuilder((ListEventsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEventsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEventsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ErrorEvent> extractResources(ListEventsResponse payload) {
            return payload.getErrorEventsList() != null ? payload.getErrorEventsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListGroupStatsRequest, ListGroupStatsResponse, ErrorStatsServiceClient.ListGroupStatsPagedResponse> LIST_GROUP_STATS_PAGE_STR_FACT = new PagedListResponseFactory<ListGroupStatsRequest, ListGroupStatsResponse, ErrorStatsServiceClient.ListGroupStatsPagedResponse>(){

        public ApiFuture<ErrorStatsServiceClient.ListGroupStatsPagedResponse> getFuturePagedResponse(UnaryCallable<ListGroupStatsRequest, ListGroupStatsResponse> callable, ListGroupStatsRequest request, ApiCallContext context, ApiFuture<ListGroupStatsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GROUP_STATS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ErrorStatsServiceClient.ListGroupStatsPagedResponse.createAsync((PageContext<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListEventsRequest, ListEventsResponse, ErrorStatsServiceClient.ListEventsPagedResponse> LIST_EVENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEventsRequest, ListEventsResponse, ErrorStatsServiceClient.ListEventsPagedResponse>(){

        public ApiFuture<ErrorStatsServiceClient.ListEventsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEventsRequest, ListEventsResponse> callable, ListEventsRequest request, ApiCallContext context, ApiFuture<ListEventsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EVENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ErrorStatsServiceClient.ListEventsPagedResponse.createAsync((PageContext<ListEventsRequest, ListEventsResponse, ErrorEvent>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListGroupStatsRequest, ListGroupStatsResponse, ErrorStatsServiceClient.ListGroupStatsPagedResponse> listGroupStatsSettings() {
        return this.listGroupStatsSettings;
    }

    public PagedCallSettings<ListEventsRequest, ListEventsResponse, ErrorStatsServiceClient.ListEventsPagedResponse> listEventsSettings() {
        return this.listEventsSettings;
    }

    public UnaryCallSettings<DeleteEventsRequest, DeleteEventsResponse> deleteEventsSettings() {
        return this.deleteEventsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ErrorStatsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcErrorStatsServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "clouderrorreporting.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ErrorStatsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ErrorStatsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ErrorStatsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listGroupStatsSettings = settingsBuilder.listGroupStatsSettings().build();
        this.listEventsSettings = settingsBuilder.listEventsSettings().build();
        this.deleteEventsSettings = settingsBuilder.deleteEventsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ErrorStatsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListGroupStatsRequest, ListGroupStatsResponse, ErrorStatsServiceClient.ListGroupStatsPagedResponse> listGroupStatsSettings;
        private final PagedCallSettings.Builder<ListEventsRequest, ListEventsResponse, ErrorStatsServiceClient.ListEventsPagedResponse> listEventsSettings;
        private final UnaryCallSettings.Builder<DeleteEventsRequest, DeleteEventsResponse> deleteEventsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listGroupStatsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GROUP_STATS_PAGE_STR_FACT);
            this.listEventsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EVENTS_PAGE_STR_FACT);
            this.deleteEventsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGroupStatsSettings, this.listEventsSettings, this.deleteEventsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ErrorStatsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ErrorStatsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ErrorStatsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ErrorStatsServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listGroupStatsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listEventsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteEventsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(ErrorStatsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listGroupStatsSettings = settings.listGroupStatsSettings.toBuilder();
            this.listEventsSettings = settings.listEventsSettings.toBuilder();
            this.deleteEventsSettings = settings.deleteEventsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGroupStatsSettings, this.listEventsSettings, this.deleteEventsSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListGroupStatsRequest, ListGroupStatsResponse, ErrorStatsServiceClient.ListGroupStatsPagedResponse> listGroupStatsSettings() {
            return this.listGroupStatsSettings;
        }

        public PagedCallSettings.Builder<ListEventsRequest, ListEventsResponse, ErrorStatsServiceClient.ListEventsPagedResponse> listEventsSettings() {
            return this.listEventsSettings;
        }

        public UnaryCallSettings.Builder<DeleteEventsRequest, DeleteEventsResponse> deleteEventsSettings() {
            return this.deleteEventsSettings;
        }

        public ErrorStatsServiceStubSettings build() throws IOException {
            return new ErrorStatsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

