/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.errorreporting.spi.v1beta1;

import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.api.gax.protobuf.PathTemplate;
import com.google.cloud.errorreporting.spi.v1beta1.ErrorGroupServiceSettings;
import com.google.devtools.clouderrorreporting.v1beta1.ErrorGroup;
import com.google.devtools.clouderrorreporting.v1beta1.GetGroupRequest;
import com.google.devtools.clouderrorreporting.v1beta1.UpdateGroupRequest;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class ErrorGroupServiceApi
implements AutoCloseable {
    private final ErrorGroupServiceSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<GetGroupRequest, ErrorGroup> getGroupCallable;
    private final UnaryCallable<UpdateGroupRequest, ErrorGroup> updateGroupCallable;
    private static final PathTemplate GROUP_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/groups/{group}");
    private static final PathTemplate PROJECT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}");

    public static final String formatGroupName(String project, String group) {
        return GROUP_PATH_TEMPLATE.instantiate(new String[]{"project", project, "group", group});
    }

    public static final String formatProjectName(String project) {
        return PROJECT_PATH_TEMPLATE.instantiate(new String[]{"project", project});
    }

    public static final String parseProjectFromGroupName(String groupName) {
        return GROUP_PATH_TEMPLATE.parse(groupName).get((Object)"project");
    }

    public static final String parseGroupFromGroupName(String groupName) {
        return GROUP_PATH_TEMPLATE.parse(groupName).get((Object)"group");
    }

    public static final String parseProjectFromProjectName(String projectName) {
        return PROJECT_PATH_TEMPLATE.parse(projectName).get((Object)"project");
    }

    public static final ErrorGroupServiceApi create() throws IOException {
        return ErrorGroupServiceApi.create(ErrorGroupServiceSettings.defaultBuilder().build());
    }

    public static final ErrorGroupServiceApi create(ErrorGroupServiceSettings settings) throws IOException {
        return new ErrorGroupServiceApi(settings);
    }

    protected ErrorGroupServiceApi(ErrorGroupServiceSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        this.getGroupCallable = UnaryCallable.create(settings.getGroupSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.updateGroupCallable = UnaryCallable.create(settings.updateGroupSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ErrorGroupServiceApi.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ErrorGroupServiceApi.this.executor.shutdown();
                }
            });
        }
    }

    public final ErrorGroupServiceSettings getSettings() {
        return this.settings;
    }

    public final ErrorGroup getGroup(String groupName) {
        GROUP_PATH_TEMPLATE.validate(groupName, "getGroup");
        GetGroupRequest request = GetGroupRequest.newBuilder().setGroupName(groupName).build();
        return this.getGroup(request);
    }

    private final ErrorGroup getGroup(GetGroupRequest request) {
        return (ErrorGroup)this.getGroupCallable().call((Object)request);
    }

    public final UnaryCallable<GetGroupRequest, ErrorGroup> getGroupCallable() {
        return this.getGroupCallable;
    }

    public final ErrorGroup updateGroup(ErrorGroup group) {
        UpdateGroupRequest request = UpdateGroupRequest.newBuilder().setGroup(group).build();
        return this.updateGroup(request);
    }

    private final ErrorGroup updateGroup(UpdateGroupRequest request) {
        return (ErrorGroup)this.updateGroupCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateGroupRequest, ErrorGroup> updateGroupCallable() {
        return this.updateGroupCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

