/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.errorreporting.spi.v1beta1;

import com.google.api.gax.core.ConnectionSettings;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.PagedCallSettings;
import com.google.api.gax.grpc.PagedListDescriptor;
import com.google.api.gax.grpc.PagedListResponseFactory;
import com.google.api.gax.grpc.ServiceApiSettings;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.auth.Credentials;
import com.google.cloud.errorreporting.spi.v1beta1.PagedResponseWrappers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.devtools.clouderrorreporting.v1beta1.DeleteEventsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.DeleteEventsResponse;
import com.google.devtools.clouderrorreporting.v1beta1.ErrorEvent;
import com.google.devtools.clouderrorreporting.v1beta1.ErrorGroupStats;
import com.google.devtools.clouderrorreporting.v1beta1.ErrorStatsServiceGrpc;
import com.google.devtools.clouderrorreporting.v1beta1.ListEventsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.ListEventsResponse;
import com.google.devtools.clouderrorreporting.v1beta1.ListGroupStatsRequest;
import com.google.devtools.clouderrorreporting.v1beta1.ListGroupStatsResponse;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.Duration;

public class ErrorStatsServiceSettings
extends ServiceApiSettings {
    private static final String DEFAULT_SERVICE_ADDRESS = "clouderrorreporting.googleapis.com";
    private static final int DEFAULT_SERVICE_PORT = 443;
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListGroupStatsRequest, ListGroupStatsResponse, PagedResponseWrappers.ListGroupStatsPagedResponse> listGroupStatsSettings;
    private final PagedCallSettings<ListEventsRequest, ListEventsResponse, PagedResponseWrappers.ListEventsPagedResponse> listEventsSettings;
    private final SimpleCallSettings<DeleteEventsRequest, DeleteEventsResponse> deleteEventsSettings;
    private static final PagedListDescriptor<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats> LIST_GROUP_STATS_PAGE_STR_DESC = new PagedListDescriptor<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats>(){

        public Object emptyToken() {
            return "";
        }

        public ListGroupStatsRequest injectToken(ListGroupStatsRequest payload, Object token) {
            return ListGroupStatsRequest.newBuilder((ListGroupStatsRequest)payload).setPageToken((String)token).build();
        }

        public ListGroupStatsRequest injectPageSize(ListGroupStatsRequest payload, int pageSize) {
            return ListGroupStatsRequest.newBuilder((ListGroupStatsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGroupStatsRequest payload) {
            return payload.getPageSize();
        }

        public Object extractNextToken(ListGroupStatsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ErrorGroupStats> extractResources(ListGroupStatsResponse payload) {
            return payload.getErrorGroupStatsList();
        }
    };
    private static final PagedListDescriptor<ListEventsRequest, ListEventsResponse, ErrorEvent> LIST_EVENTS_PAGE_STR_DESC = new PagedListDescriptor<ListEventsRequest, ListEventsResponse, ErrorEvent>(){

        public Object emptyToken() {
            return "";
        }

        public ListEventsRequest injectToken(ListEventsRequest payload, Object token) {
            return ListEventsRequest.newBuilder((ListEventsRequest)payload).setPageToken((String)token).build();
        }

        public ListEventsRequest injectPageSize(ListEventsRequest payload, int pageSize) {
            return ListEventsRequest.newBuilder((ListEventsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEventsRequest payload) {
            return payload.getPageSize();
        }

        public Object extractNextToken(ListEventsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ErrorEvent> extractResources(ListEventsResponse payload) {
            return payload.getErrorEventsList();
        }
    };
    private static final PagedListResponseFactory<ListGroupStatsRequest, ListGroupStatsResponse, PagedResponseWrappers.ListGroupStatsPagedResponse> LIST_GROUP_STATS_PAGE_STR_FACT = new PagedListResponseFactory<ListGroupStatsRequest, ListGroupStatsResponse, PagedResponseWrappers.ListGroupStatsPagedResponse>(){

        public PagedResponseWrappers.ListGroupStatsPagedResponse createPagedListResponse(UnaryCallable<ListGroupStatsRequest, ListGroupStatsResponse> callable, ListGroupStatsRequest request, CallContext context) {
            return new PagedResponseWrappers.ListGroupStatsPagedResponse(callable, (PagedListDescriptor<ListGroupStatsRequest, ListGroupStatsResponse, ErrorGroupStats>)LIST_GROUP_STATS_PAGE_STR_DESC, request, context);
        }
    };
    private static final PagedListResponseFactory<ListEventsRequest, ListEventsResponse, PagedResponseWrappers.ListEventsPagedResponse> LIST_EVENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEventsRequest, ListEventsResponse, PagedResponseWrappers.ListEventsPagedResponse>(){

        public PagedResponseWrappers.ListEventsPagedResponse createPagedListResponse(UnaryCallable<ListEventsRequest, ListEventsResponse> callable, ListEventsRequest request, CallContext context) {
            return new PagedResponseWrappers.ListEventsPagedResponse(callable, (PagedListDescriptor<ListEventsRequest, ListEventsResponse, ErrorEvent>)LIST_EVENTS_PAGE_STR_DESC, request, context);
        }
    };

    public PagedCallSettings<ListGroupStatsRequest, ListGroupStatsResponse, PagedResponseWrappers.ListGroupStatsPagedResponse> listGroupStatsSettings() {
        return this.listGroupStatsSettings;
    }

    public PagedCallSettings<ListEventsRequest, ListEventsResponse, PagedResponseWrappers.ListEventsPagedResponse> listEventsSettings() {
        return this.listEventsSettings;
    }

    public SimpleCallSettings<DeleteEventsRequest, DeleteEventsResponse> deleteEventsSettings() {
        return this.deleteEventsSettings;
    }

    public static String getDefaultServiceAddress() {
        return DEFAULT_SERVICE_ADDRESS;
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static ImmutableList<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ErrorStatsServiceSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getChannelProvider(), settingsBuilder.getExecutorProvider(), settingsBuilder.getGeneratorName(), settingsBuilder.getGeneratorVersion(), settingsBuilder.getClientLibName(), settingsBuilder.getClientLibVersion());
        this.listGroupStatsSettings = settingsBuilder.listGroupStatsSettings().build();
        this.listEventsSettings = settingsBuilder.listEventsSettings().build();
        this.deleteEventsSettings = settingsBuilder.deleteEventsSettings().build();
    }

    public static class Builder
    extends ServiceApiSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListGroupStatsRequest, ListGroupStatsResponse, PagedResponseWrappers.ListGroupStatsPagedResponse> listGroupStatsSettings;
        private final PagedCallSettings.Builder<ListEventsRequest, ListEventsResponse, PagedResponseWrappers.ListEventsPagedResponse> listEventsSettings;
        private final SimpleCallSettings.Builder<DeleteEventsRequest, DeleteEventsResponse> deleteEventsSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(Builder.s_getDefaultConnectionSettingsBuilder().build());
            this.listGroupStatsSettings = PagedCallSettings.newBuilder((MethodDescriptor)ErrorStatsServiceGrpc.METHOD_LIST_GROUP_STATS, (PagedListResponseFactory)LIST_GROUP_STATS_PAGE_STR_FACT);
            this.listEventsSettings = PagedCallSettings.newBuilder((MethodDescriptor)ErrorStatsServiceGrpc.METHOD_LIST_EVENTS, (PagedListResponseFactory)LIST_EVENTS_PAGE_STR_FACT);
            this.deleteEventsSettings = SimpleCallSettings.newBuilder((MethodDescriptor)ErrorStatsServiceGrpc.METHOD_DELETE_EVENTS);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGroupStatsSettings, this.listEventsSettings, this.deleteEventsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.listGroupStatsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listEventsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteEventsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(ErrorStatsServiceSettings settings) {
            super((ServiceApiSettings)settings);
            this.listGroupStatsSettings = settings.listGroupStatsSettings.toBuilder();
            this.listEventsSettings = settings.listEventsSettings.toBuilder();
            this.deleteEventsSettings = settings.deleteEventsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGroupStatsSettings, this.listEventsSettings, this.deleteEventsSettings);
        }

        private static ConnectionSettings.Builder s_getDefaultConnectionSettingsBuilder() {
            return ConnectionSettings.newBuilder().setServiceAddress(ErrorStatsServiceSettings.DEFAULT_SERVICE_ADDRESS).setPort(443).provideCredentialsWith((List)DEFAULT_SERVICE_SCOPES);
        }

        protected ConnectionSettings.Builder getDefaultConnectionSettingsBuilder() {
            return Builder.s_getDefaultConnectionSettingsBuilder();
        }

        public Builder provideExecutorWith(ScheduledExecutorService executor, boolean shouldAutoClose) {
            super.provideExecutorWith(executor, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ManagedChannel channel, boolean shouldAutoClose) {
            super.provideChannelWith(channel, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ConnectionSettings settings) {
            super.provideChannelWith(settings);
            return this;
        }

        public Builder provideChannelWith(Credentials credentials) {
            super.provideChannelWith(credentials);
            return this;
        }

        public Builder provideChannelWith(List<String> scopes) {
            super.provideChannelWith(scopes);
            return this;
        }

        public Builder setGeneratorHeader(String name, String version) {
            super.setGeneratorHeader(name, version);
            return this;
        }

        public Builder setClientLibHeader(String name, String version) {
            super.setClientLibHeader(name, version);
            return this;
        }

        public Builder applyToAllApiMethods(UnaryCallSettings.Builder apiCallSettings) throws Exception {
            super.applyToAllApiMethods(this.unaryMethodSettingsBuilders, apiCallSettings);
            return this;
        }

        public PagedCallSettings.Builder<ListGroupStatsRequest, ListGroupStatsResponse, PagedResponseWrappers.ListGroupStatsPagedResponse> listGroupStatsSettings() {
            return this.listGroupStatsSettings;
        }

        public PagedCallSettings.Builder<ListEventsRequest, ListEventsResponse, PagedResponseWrappers.ListEventsPagedResponse> listEventsSettings() {
            return this.listEventsSettings;
        }

        public SimpleCallSettings.Builder<DeleteEventsRequest, DeleteEventsResponse> deleteEventsSettings() {
            return this.deleteEventsSettings;
        }

        public ErrorStatsServiceSettings build() throws IOException {
            return new ErrorStatsServiceSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.millis((long)60000L)).setInitialRpcTimeout(Duration.millis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.millis((long)20000L)).setTotalTimeout(Duration.millis((long)600000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

